import cvisual

# Code to provide special initialization for a display object, and overloaded properties.

class display( cvisual.display):
	def __init__( self, **keywords):
		cvisual.display.__init__(self)
		keys = keywords.keys()
		keys.sort()
		for kw in keys:
			self.__setattr__(kw, keywords[kw])
		# Solves chicken-and-egg problem with initialization.
		# See Display::Display() in display.cpp.
		self.select(self)
	center = property( cvisual.display._get_center, cvisual.display._set_center, None)
	up = property( cvisual.display._get_up, cvisual.display._set_up, None)
	forward = property(cvisual.display._get_forward, cvisual.display._set_forward, None)
	range = property(cvisual.display._get_range, cvisual.display._set_range, None)
	scale = property(cvisual.display._get_scale, cvisual.display._set_scale, None)
	exit = property(None, cvisual.display.exit_on_close, None)
	
