// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "frame.h"
#include <boost/python/class.hpp>
#include <boost/python/return_internal_reference.hpp>
#include "rotate.h"

namespace visual {

void 
frame::glRender( rView& view) 
{
	// doesn't render directly
}

vector 
frame::getScale() 
{	
	return vector(1,1,1);
}

tmatrix 
frame::getChildTransform() 
{
	updateCache();
	if (parent)
		return tmatrix(mwt, parent->getChildTransform());
	else
		return mwt;
}

boost::python::list
frame::get_objects()
{
	boost::python::list ret;
	if (!display)
		return ret;
		
	Cache::read_lock L( display->list_mutex);
	
	std::list<boost::shared_ptr<DisplayObject> >::iterator i;
	boost::shared_ptr<DisplayObject> strong_this( weak_this);
	
	for ( i = display->objects.begin(); i != display->objects.end(); i++) {
		boost::shared_ptr<DisplayObject> tmp = *i;
		while ( tmp->getParent()) {
			// Recursively search to include all objects in subframes
			if ( strong_this == tmp->getParent()) {
				ret.append( tmp->getObject());
				break;
			}
			tmp = tmp->getParent();
		}
	}
	return ret;
}

void
frame_init_type()
{
	using namespace boost::python;
	
	// Note that a frame object inherits from primitive, but does not use some of its
	//   parents properties.  So, only the appropriate ones are exported.
	class_<frame, bases<DisplayObject>, boost::shared_ptr<frame> >( "frame")
		.def( init<const frame&>())
		.add_property( "objects", &frame::get_objects)
		.def( "_set_pos", &frame::set_pos)
		.def( "_get_pos", &frame::get_pos, return_internal_reference<>())
			.add_property( "x", &frame::get_x, &frame::set_x)
			.add_property( "y", &frame::get_y, &frame::set_y)
			.add_property( "z", &frame::get_z, &frame::set_z)
		.def( "_get_axis", &frame::get_axis, return_internal_reference<>())
		.def( "_set_axis", &frame::set_axis)
		.def( "_set_up", &frame::set_up)
		.def( "_get_up", &frame::get_up, return_internal_reference<>())
		.def( "rotate", raw_function( py_rotate<frame>, 2))
		;
}

} // !namespace visual
