/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "colorlabel.h"

#include <QPixmap>

ColorLabel::ColorLabel(QWidget *parent, QColor color)
 : QLabel(parent)
{
  setColor(color);
}
//\*****************************************************************************
void ColorLabel::setColor(const QColor & color)
{
  QPixmap pix(size());
  m_color = color;
  pix.fill(color);
  setScaledContents(true);
  setPixmap(pix);
}
//\*****************************************************************************
