/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessibleeditabletextadaptor.h"
#include "accessibleobject.h"

#include <qaccessible.h>
#include <qaccessible2.h>

AccessibleEditableTextAdaptor::AccessibleEditableTextAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    setAutoRelaySignals(true);
}

AccessibleEditableTextAdaptor::~AccessibleEditableTextAdaptor()
{
}

static inline QAccessibleEditableTextInterface *textInterface(QObject *parent)
{
    return static_cast<AccessibleObject *>(parent)->accessibleInterface()->editableTextInterface();
}

void AccessibleEditableTextAdaptor::copyText(int startOffset, int endOffset)
{
    textInterface(parent())->copyText(startOffset, endOffset);
}

void AccessibleEditableTextAdaptor::cutText(int startOffset, int endOffset)
{
    textInterface(parent())->cutText(startOffset, endOffset);
}

void AccessibleEditableTextAdaptor::deleteText(int startOffset, int endOffset)
{
    textInterface(parent())->deleteText(startOffset, endOffset);
}

void AccessibleEditableTextAdaptor::insertText(int offset, const QString &in)
{
    textInterface(parent())->insertText(offset, in);
}

void AccessibleEditableTextAdaptor::pasteText(int offset)
{
    textInterface(parent())->pasteText(offset);
}

void AccessibleEditableTextAdaptor::replaceText(int startOffset, int endOffset, const QString &in)
{
    textInterface(parent())->replaceText(startOffset, endOffset, in);
}

void AccessibleEditableTextAdaptor::setAttributes(int startOffset, int endOffset,
                                                  const QString &attributes)
{
    textInterface(parent())->setAttributes(startOffset, endOffset, attributes);
}

