/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessibletableadaptor.h"
#include "accessibleobject.h"

#include <qaccessible2.h>

AccessibleTableAdaptor::AccessibleTableAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    setAutoRelaySignals(true);
}

AccessibleTableAdaptor::~AccessibleTableAdaptor()
{
}

static inline QAccessibleTableInterface *tableInterface(QObject *parent)
{
    return static_cast<AccessibleObject *>(parent)->accessibleInterface()->tableInterface();
}

QDBusObjectPath AccessibleTableAdaptor::accessibleAt(int row, int column)
{
    tableInterface(parent())->accessibleAt(row, column);
    return QDBusObjectPath(); // TODO
}

QDBusObjectPath AccessibleTableAdaptor::caption()
{
    tableInterface(parent())->caption();
    return QDBusObjectPath(); // TODO
}

int AccessibleTableAdaptor::childIndex(int rowIndex, int columnIndex)
{
    return tableInterface(parent())->childIndex(rowIndex, columnIndex);
}

QString AccessibleTableAdaptor::columnDescription(int column)
{
    return tableInterface(parent())->columnDescription(column);
}

int AccessibleTableAdaptor::columnExtentAt(int row, int column)
{
    return tableInterface(parent())->columnSpan(row, column);
}

QDBusObjectPath AccessibleTableAdaptor::columnHeader()
{
    tableInterface(parent())->columnHeader();
    return QDBusObjectPath(); // TODO
}

int AccessibleTableAdaptor::columnIndex(int childIndex)
{
    return tableInterface(parent())->columnIndex(childIndex);
}

bool AccessibleTableAdaptor::isColumnSelected(int column)
{
    return tableInterface(parent())->isColumnSelected(column);
}

bool AccessibleTableAdaptor::isRowSelected(int row)
{
    return tableInterface(parent())->isRowSelected(row);
}

bool AccessibleTableAdaptor::isSelected(int row, int column)
{
    return tableInterface(parent())->isSelected(row, column);
}

int AccessibleTableAdaptor::nColumns()
{
    return tableInterface(parent())->columnCount();
}

int AccessibleTableAdaptor::nRows()
{
    return tableInterface(parent())->rowCount();
}

int AccessibleTableAdaptor::nSelectedColumns()
{
    return tableInterface(parent())->selectedColumnCount();
}

int AccessibleTableAdaptor::nSelectedRows()
{
    return tableInterface(parent())->selectedRowCount();
}

QString AccessibleTableAdaptor::rowDescription(int row)
{
    return tableInterface(parent())->rowDescription(row);
}

int AccessibleTableAdaptor::rowExtentAt(int row, int column)
{
    return tableInterface(parent())->rowSpan(row, column);
}

QDBusObjectPath AccessibleTableAdaptor::rowHeader()
{
    tableInterface(parent())->rowHeader();
    return QDBusObjectPath(); // TODO
}

int AccessibleTableAdaptor::rowIndex(int childIndex)
{
    return tableInterface(parent())->rowIndex(childIndex);
}

void AccessibleTableAdaptor::selectColumn(int column)
{
    tableInterface(parent())->selectColumn(column);
}

void AccessibleTableAdaptor::selectRow(int row)
{
    tableInterface(parent())->selectRow(row);
}

int AccessibleTableAdaptor::selectedColumns(int maxColumns, QList<int> &columns)
{
    return tableInterface(parent())->selectedColumns(maxColumns, &columns);
}

int AccessibleTableAdaptor::selectedRows(int maxRows, QList<int> &rows)
{
    return tableInterface(parent())->selectedRows(maxRows, &rows);
}

QDBusObjectPath AccessibleTableAdaptor::summary()
{
    tableInterface(parent())->summary();
    return QDBusObjectPath(); // TODO
}

void AccessibleTableAdaptor::unselectColumn(int column)
{
    tableInterface(parent())->unselectColumn(column);
}

void AccessibleTableAdaptor::unselectRow(int row)
{
    tableInterface(parent())->unselectRow(row);
}

