/*
 *  about.cc
 *
 *  Copyright (C) 1998, 1999  Jiann-Ching Liu
 */


#include "qe_config.h"
#include "filebuffer.h"
#include "colors.h"
#include "keymap.h"
#include <stdlib.h>

int
filebuffer::cmd_about (void)
{
  WINDOW *
    abwin;
  char *
    qe_v = (char *) malloc (20);

  abwin = newwin (13, 59, 7, 10);

  setattr (abwin, ATTRIBUTE_about_box_border);
//  if (filebuffer::is_big5()) {
//	box(abwin, '|', '-');
//  } else {
//	box(abwin, 0, 0);
//  }

  sprintf (qe_v, "%s %s", _("QE Version"), QE_VERSION);

  box (abwin, 0, 0);

  int
    i = 0;

  setattr (abwin, ATTRIBUTE_about_box_text);
  mvwprintw (abwin, ++i, 1, " %-55s ", "");
  mvwprintw (abwin, ++i, 1, " %-20s%-35s ", qe_v, _("Copyright (c) 1998-2001"));
  mvwprintw (abwin, ++i, 1, " %-55s ", "");
  mvwprintw (abwin, ++i, 1, " %-55s ",
	     _("Author: Jiann-Ching Liu <center5@cc.ncu.edu.tw>"));
  mvwprintw (abwin, ++i, 1, " %-55s ",
	     "http://www.cc.ncu.edu.tw/~center5/product/qe/");
  mvwprintw (abwin, ++i, 1, " %-55s ", "");
  mvwprintw (abwin, ++i, 1, " %-55s ",
	     _("I18N/L10N by Kun-Chung Hsieh <linuxer@coventive.com>"));
  mvwprintw (abwin, ++i, 1, " %-55s ",
	     "http://www.geocities.com/linux4tw/");
  mvwprintw (abwin, ++i, 1, " %-55s ", "");
  mvwprintw (abwin, ++i, 1, " %-55s ", _("patch: Lechee.Lai"));
  mvwprintw (abwin, ++i, 1, " %-55s ", "");
  wmove (abwin, i, 1);

  touchwin (abwin);
  wrefresh (abwin);

  while (1)
    {
      switch (wgetch (win))
	{
	case ' ':
	case 'q':
	case 'Q':
	case KEY_ESC:
	case KEY_RETURN:
	case KEY_ENTER:
	case KEY_LINEFEED:
	  delwin (abwin);
	  touchwin (win);
	  wrefresh (win);
	  return 1;

	}
    }
  return 0;
}

int
filebuffer::cmd_help (void)
{
  return cmd_edit (DEFAULT_PROFILE_DIR "/qe.hlp", 1);
}

int
filebuffer::cmd_pro (void)
{
  return cmd_edit (DEFAULT_PROFILE_DIR "/qe.pro", 1);
}
