/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/

#ifndef CGARMINDBTRACK_H
#define CGARMINDBTRACK_H

#include <QObject>
#include <QTabWidget>
#include <QPointer>
#include <QPolygon>
#include <QMap>

#include <IDevice.h>

class CGarminTrack;
class CToolViewTrack;
class CToolViewTrackInfo;
class CToolViewTrackProfile;
class QSplitter;
class CGpx;

class CGarminDBTrack : public QObject
{
    Q_OBJECT
        public:
        CGarminDBTrack(QTabWidget * parent, QSplitter * splitter);
        virtual ~CGarminDBTrack();

        void gainFocus();

        /// get access to track dictionary
        QMap<QString,CGarminTrack*>& getTracks(){return tracks;}

        /// receive tracks from device
        void downloadTracks();
        /// load tracks from GPX file
        void loadGPX(CGpx& gpx);
        /// save tracks to GPX file
        void saveGPX(CGpx& gpx);

        /// clear track list
        void clear();
        /// highlight a track by it's key
        void highlightTrack(const QString& key);
        /// get highlighted track
        /**
            <b>WARNING</b> The object referenced by the returned
            pointer might be subject to destruction at any time.
            Thus you must use it temporarily or store it by a
            QPointer object.

            @return A pointer to the current highlighted track or 0.
        */
        CGarminTrack* highlightedTrack();

        /// get / create a track of given name
        CGarminTrack* getTrack(const QString& key);

        /// remove track from list
        void removeTrack(const QString& key);
        /// remove several tracks from list
        void removeTracks(const QStringList& keys);

        /// show information stored in current selected track
        void showTrackInfo();

        /// get iterator access to track point list
        QMap<QString,CGarminTrack*>::iterator begin(){return tracks.begin();}
        /// get iterator access to track point list
        QMap<QString,CGarminTrack*>::iterator end(){return tracks.end();}

        /// combine selected tracks
        void combine();

        /// split selected track at given index
        void split(quint32 idx);

        signals:
        /// emitted each time the track list changed
        void sigTrackListChanged();

    protected slots:
        void slotTrackChanged();

    protected:
        /// pointer to toolview tab widget
        QPointer<QTabWidget> tab;
        /// tool view widget to display database information
        CToolViewTrack * toolview;

        CToolViewTrackInfo * trackinfo;
        CToolViewTrackProfile * trackprofile;

        /// the track data base
        QMap<QString,CGarminTrack*> tracks;

};
#endif                           //CGARMINDBTRACK_H
