#ifndef MAPDATA_H
#define MAPDATA_H

#include <qwidget.h>
#include <qptrlist.h>
#include <alsa/asoundlib.h>
#include "seqdriver.h"
#include "midimap.h"
#include "mapwidget.h"

class MapData : public QWidget  {
    
  Q_OBJECT

  private:
    QPtrList<MidiMap> midiMapList;
    QPtrList<MapWidget> mapWidgetList;
    int portCount;

  public:
    SeqDriver *seqDriver;

  public:
    MapData(QWidget* parent=0, const char *name=0);
    ~MapData();
    void registerPorts(int num);
    int getPortCount();
    void addMidiMap(MidiMap *midiMap);
    void addMapWidget(MapWidget *mapWidget);
    void removeMidiMap(MidiMap *midiMap);
    void removeMapWidget(MapWidget *mapWidget);
    int midiMapCount();
    int mapWidgetCount();
    MidiMap *midiMap(int index);
    MapWidget *mapWidget(int index);
};
                              
#endif
