// command.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef COMMAND_H
#define COMMAND_H

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qdialog.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>

#include "proc.h"
#include "misc.h"
		   
int find_command(QString s);
void add_default_command();

class CommandButton : public QToolButton
{
	Q_OBJECT
	public:
		CommandButton(QWidget *parent,QString name):QToolButton(parent)
		{
			cname=name;
		}; 
		QString cname;	

	protected slots:
		void	exec_command();
		
};


class Command {
	public:
		Command(QString n, QString cmd,bool toolbar=false);
		~Command();			
		void call(Procinfo *p);
		bool IsNeedProc(); 
		
		CommandButton *toolbutton;

		QString name;			// appears in the menu
		QString cmdline;		// may contain variables (%p etc)
		int menu;			// index in menu
		bool toolbar;
		bool popup;
};


//class CommandDialog : public QWidget
class CommandDialog : public QDialog
{
    Q_OBJECT
public:
    CommandDialog();

signals:
    void command_change();

protected slots:
    void new_cmd();
    void add_new();
    void del_current();
    void set_buttons(int);
    void set_select( QListBoxItem * );
    void event_name_midified(const QString &new_name);
    void event_cmd_modified();
    void event_toolbar_checked(bool);
private:
    QListBox *lb;
    QPushButton *new0,*add, *del, *edit,*button_ok;
    QLineEdit *name, *cmdline;
    QCheckBox *qcheck1;
    QCheckBox *qcheck2;
};

#endif // COMMAND_H

