/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qpx_transport.h>
#include <qpx_mmc.h>

#include "media_check_generic.h"

int c2calc(unsigned char* buf, unsigned int lba, unsigned char sects){
	const unsigned int sect_data = 2352;
	const unsigned int sect_err  = 294;
	const unsigned int sect_size = sect_data + sect_err;

	unsigned int c2errs = 0;
	unsigned int s, offs, i,ii, se;


	for (s=0; s<sects; s++) {
		se = 0;
		offs = s*sect_size + sect_data;
/*
		printf("\n\n** Sector %d error data:\n", lba+s);
		for (i=0; i<sect_err; i++) {
			if (!(i%16)) printf("\n");
			printf(" %02X", buf[offs+i]);
		}
		printf("\n");
*/
		for (i=0; i<sect_err; i++) {
			for(ii=0; ii<8; ii++)
				if ((buf[offs+i] >> ii) & 0x01 ) {
					if (!se) printf("C2 in sector %7d, first error in byte %4d ", lba+s, i*8+ii);
					se++;
				}
		}
		if (se) printf(", %4d C2\n",se);
		c2errs += se;
	}
	return c2errs;
}

int c2_do_one_interval(drive_info* drive, int* lba, int* BLER,
	int* E11, int* E21, int* E31, int* E12, int* E22, int* E32)
{
	int i;
	unsigned char interval = 75;
	unsigned char block = 15;
	*E22 = 0;
	for (i=0; i<(interval/block); i++) {
		read_cd(drive, *lba+i*block, block, 0xFA);
/*		unsigned int  ii;
		for (ii=0; ii<(2646*block); ii++) {
			if (!(ii%16)) printf("\n");
			printf(" %02X", drive->rd_buf[ii]);
		}
		printf("\n");
		*E22 += c2calc(drive->rd_buf, *lba, block);
*/
	}
	*BLER = 0;
	*E11 = 0;
	*E21 = 0;
	*E31 = 0;
	*E12 = 0;
	*E32 = 0;
	*lba += interval;
	return 0;
}

int generic_c2_start(drive_info* drive){
	spinup(drive, 1);
	seek(drive, 0);
	return 0;
}

int generic_dummy(drive_info* drive){
	drive->err = 0;
	return 0;
}

scan_commands commands_list_generic = {
	generic_c2_start, 	c2_do_one_interval,	generic_dummy,
	NULL,			NULL,			NULL,
	NULL,			NULL,			NULL,
	NULL,			NULL,			NULL,
	NULL,			NULL,			NULL,
	NULL,			NULL,			NULL,
};

scan_commands commands_generic()  { return commands_list_generic; }
