/***************************************************************************
                          doublearray2d.cpp  -  description
                             -------------------
    begin                : Thu Dec 12 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "doublearray2d.h"

#include <qapplication.h>

DoubleArray2D::DoubleArray2D(int dimx,int dimy)
{
  mDimX = dimx;
  mDimY = dimy;
  mArray.resize(dimy * dimx);
  for(unsigned int i=0;i<mArray.size();i++)
    mArray[i] = 0.0;
}
DoubleArray2D::DoubleArray2D()
{
  mDimX = 0;
  mDimY = 0;
  mArray.resize(0);
}
DoubleArray2D::~DoubleArray2D()
{
}
void DoubleArray2D::resize(int dimx,int dimy)
{
  mDimX = dimx;
  mDimY = dimy;
  mArray.resize(dimy * dimx);
  for(unsigned int i=0;i<mArray.size();i++)
    mArray[i] = 0.0;
}
double DoubleArray2D::at(int x, int y )
{
//  qDebug("DoubleArray2D::at");
  if((x + y * mDimX) < (mDimX * mDimY))
    return mArray[x + y * mDimX];
  else
    qDebug("DoubleArray2D::at out of bounds");
  return 0.0;
}
void DoubleArray2D::set(int x, int y, double val)
{
//  qDebug("DoubleArray2D::set");
  if((x + y * mDimX) < (mDimX * mDimY))
    mArray[x + y * mDimX] = val;
  else
    qDebug("set out of bounds");
}

void DoubleArray2D::add(int x, int y, double val)
{
//  qDebug("DoubleArray2D::add");
  if((x + y * mDimX) < (mDimX * mDimY))
    mArray[x + y * mDimX] += val;
  else
    qDebug("DoubleArray2D::add out of bounds");
}

void DoubleArray2D::multiply(int x, int y, double val)
{
//  qDebug("DoubleArray2D::add");
  if((x + y * mDimX) < (mDimX * mDimY))
    mArray[x + y * mDimX] *= val;
  else
    qDebug("DoubleArray2D::multiply out of bounds");
}

void DoubleArray2D::sub(int x, int y, double val)
{
//  qDebug("DoubleArray2D::sub");
  if((x + y * mDimX) < (mDimX * mDimY))
    mArray[x + y * mDimX] -= val;
  else
    qDebug("DoubleArray2D::sub out of bounds");
}

int DoubleArray2D::cols()
{
  return mDimX;
}

int DoubleArray2D::rows()
{
  return mDimY;
}
int DoubleArray2D::x()
{
  return mDimX;
}

int DoubleArray2D::y()
{
  return mDimY;
}
/** Multiply the array with another array; return a pointer
    to the result allocated with new, or a NULL pointer, if an error occurred.
    The multiplication is only possible, if both array have the same dimension.
*/
DoubleArray2D DoubleArray2D::operator=(DoubleArray2D a)
{
  // Multiply two matrices: AxB=C
  int xdim_a = a.cols();
  int ydim_a = a.rows();

  resize(xdim_a,ydim_a);
  mArray = a.array();
  return *this;
}/** No descriptions */
QArray <double> DoubleArray2D::array()
{
  return mArray;
}
/** No descriptions */
void DoubleArray2D::detach()
{
  mArray.detach();
}
