/***************************************************************************
                          qscanner.h  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by mh
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCANNER_H
#define QSCANNER_H

extern "C"
{
#include <sane/sane.h>
}

#include <qarray.h>
#include <qdom.h>
#include <qmap.h>
#include <qobject.h>
#include <qstringlist.h>
#include <qstrlist.h>

class QPixmap;
class QImage;
class QSaneOption;
class QString;
class QProgressDialog;
class PreviewWidget;
/** The QScanner class is mainly designed to access the SANE API
  * from within a Qt C++ program.
  * @author mh
  */

class QScanner : public QObject
{
Q_OBJECT
public:
	QScanner();
	~QScanner();
  static void qis_authorization(SANE_String_Const resource,
                       SANE_Char username[SANE_MAX_USERNAME_LEN],
                       SANE_Char password[SANE_MAX_PASSWORD_LEN]);  /**  */
  bool getDeviceList(bool local_only);
  /**  */
  bool isOptionSettable(int num);
  /**Returns the number of options for the device, including
    * option 0.
    */
  int optionCount();
  /** Returns true if the scanner was opened successfully,
    * otherwise false
    */
  bool isOpen();
  /**Set the device name. openDevice() must be called afterwards.
    */
  void setDeviceName(SANE_String_Const dev_name);
  /**Opens the device. Returns true, if the action
    * was successfull, otherwise false is returned.
    * Use saneStatus() to get the exact error.
    */
  bool openDevice();
  /** Return a QString if option num exists and is of
    * type SANE_TYPE_STRING, otherwise QString::null is returned.
    */
  QString saneStringValue(int num);
  /**Return the value of option number num if the option exists and
    * is of type SANE_BOOL, SANE_INT or SANE_FIXED. Otherwise
    * INT_MIN is returned.
    */
  int saneWordValue(int num);
  /**Return the value of option number num if the option exists and
    * is of type SANE_INT or SANE_FIXED with an option size >
    * sizeof(SANE_Word>.
    */
  QArray<SANE_Word> saneWordArray(int num);
  /**Return an array wich hold the possible values for this option if the
    * option exists and is has a constraint_type SANE_CONSTRYINT_WORD_LIST.
    * Otherwise an empty array is returned
    */
  QArray<SANE_Word> saneWordList(int num);
  /**  */
  SANE_Value_Type getOptionType(int num);
  /**  */
  void exitScanner();
  /**  */
  SANE_String_Const name(int num);
  /**  */
  SANE_String_Const vendor(int num);
  /**  */
  SANE_String_Const model(int num);
  /**  */
  SANE_String_Const type(int num);
  /**Returns the number of available devices.
    */
  int deviceCount();
  /**Initialises the scanner with a call to sane_init(). If this action
    * was successfull, true is returned, otherwise false.
    * Call saneStatus() to get the exact error.
    * Use isInit() to see, whether Sane is initialized already.
    */
  bool initScanner();
  /**Returns true, if the device eas successfully initialised,
    * otherwise false.
    */
  bool isInit();
  /**Returns the SANE_Constraint_Type for option number num.
    */
  SANE_Constraint_Type getConstraintType(int num);
  /**Returns the name of option number num.
    */
  SANE_String_Const getOptionName(int num);
  /**Returns true if option number num is active, otherwise false.
    */
  bool isOptionActive(int num);
  /**Returns the title of option number num.
    */
  QString getOptionTitle(int num);
  /** Returns the number of the last option in the group
    * specified by num.
    */
  int lastGroupItem(int num);
  /** Returns the number of the first option in the group
    * specified by num.
    */
  int firstGroupItem(int num);
  /** Returns the number of groups. A backend may decide to place
    * related options in groups.
    */
  int getGroupCount();
  /**Checks whether there are active
    * items in the specified group
    */
  bool groupHasActiveItems(int num);
  /**Returns the number of items in the specified
    * group
    */
  int itemsInGroup(int num);
  /**Returns the range quant if the option descriptor of option number
  * num has a SANE_Constraint_Type of SANE_Range attached.
  * Legal values for this option can be calculated like:
  * <p><code>optvalue = k*q + minvalue</code>,</p>
  * where k is a non-negative integer value such that
  * <p><code>optvalue<=maxvalue</code>.</p>
  * A return value of 0 means, that all values between minvalue and
  * maxvalue are valid.
  * INT_MIN is returned if this option doesn't have a SANE_Range
  * attached.
  */
  SANE_Word getRangeQuant(int num);
  /**Returns the minimum range if the option descriptor of option number
  * num has a SANE_Constraint_Type of SANE_Range attached.
  * Otherwise INT_MIN is returned.
  */
  SANE_Word getRangeMin(int num);
  /**Returns the maximum range if the option descriptor of option number
  * num has a SANE_Constraint_Type of SANE_Range attached.
  * Otherwise INT_MIN is returned.
  */
  SANE_Word getRangeMax(int num);
  /** Returns the unit of the option specified by num. */
  SANE_Unit getUnit(int num);
  /**Returns string list item number item of option number num if
    * the option has a SANE_CONSTRAINT_STRING_LIST attached,
    * otherwise NULL.  */
  SANE_String_Const getStringListItem(int num, int item);
  /**Returns a string list option number num if
    * the option has a SANE_CONSTRAINT_STRING_LIST attached,
    * otherwise an empty list is returned.  */
  QStringList getStringList(int option);
  /**  */
  QStrList getStrList(int option);
  /**Returns the title of the group specified by num
    */
  QString getGroupTitle(int num);
  /**Returns true if there is an settable bry-option.*/
  bool isBrySettable();
  /**Returns true if there is an settable brx-option.*/
  bool isBrxSettable();
  /**Returns true if there is an settable tly-option.*/
  bool isTlySettable();
  /**Returns true if there is an settable tlx-option.*/
  bool isTlxSettable();
  /**Returns the number of the tly-option.*/
  int getTlyOption();
  /**Returns the number of the tlx-option.  */
  int getTlxOption();
  /**Returns the number of the bry-option.  */
  int getBryOption();
  /**Returns the number of the brx-option.  */
  int getBrxOption();
  /**Set the option specified by num. v is a pointer to an
    * approbiate datatype for this option. */
  SANE_Status setOption(int num,void* v,bool automatic = false);
  /**Call this function to cancel the currently pending operation of
    * the device immediately or as quickly as possible.
    */
  void cancel();
  /**Read image data from the device. Argument buf is a pointer to
    * a memory area that can hold maxlen bytes at least. Argument
    * len holds the number of bytes actually read if the call to read()
    * succeeded, otherwise 0.
    */
  SANE_Status read(SANE_Byte* buf,SANE_Int maxlen,SANE_Int* len);
  /**This method initiates aquisition of an image from the device.
    */
  SANE_Status start();
  /**Returns the number of the preview option or 0 if
	 there is no preview option. */
  int previewOption();
  /**  */
  int resolutionOption();
  /**  */
  void enablePreviewOption(bool b);
  /**  */
  void setPreviewResolution(int res);
  /**Sets the preview scan area.*/
  void setPreviewScanArea(double tlx,double tly,double brx,double bry);
  /** Return the description for option number num.*/
  QString getOptionDescription(int num);
  /**Scans the image with the currently specified options,
    * and save it in PNM format under the filename given by file  */
  SANE_Status scanImage(QString file,QWidget* parent=0,PreviewWidget* preview_widget=0);
  /**Set the io mode to non blocking io if b is true and if non
    * blocking io is supported by the device. Otherwise blocking
    * io is used. */
  void setIOMode(bool b);
  /**Returns the number of options that are not placed
    * inside groups.
    */
  int nonGroupOptionCount();
  /**Scans an image preview.
    * The scan area is set to the maximum values and a
    * resolution around 50 dpi is chosen. The preview image is saved
    * in PNM format under the filename given by argument path.
    */
  SANE_Status scanPreview(QString path,QWidget* parent=0,double tlx=0.0,
                          double tly=0.0,double brx=1.0,double bry=1.0,int res=50);
  /**  */
  SANE_Status getParameters(SANE_Parameters* par);
  /** Creates an QImage from the file specified by
    * path. If path is empty, the QImage is created
    * from the last temporary file created during the
    * last scan. Returns NULL if the image creation fails.
    * The caller is responsible for the deletion of the image.*/
  QImage* createImage(QString path = "");
  /** Creates an QPixmap from the file specified by
    * path. If path is empty, the QPixmap is created
    * from the last temporary file created during the
    * last scan. Returns NULL if the pixmap creation fails.
    * The caller is responsible for the deletion of the pixmap.*/
  QPixmap* createPixmap(QString path = "");
  /**  */
  void enableReloadSignal(bool status);
  /** Returns an info string which contains information
about pixel size, colormode and byte size.
This string can be used to inform the user about the
current settings. */
  QString imageInfo();
  /**  */
  int yResolution();
  /**  */
  int xResolution();
  /**  */
  int yResolutionDpi();
  /**  */
  int xResolutionDpi();
  /**  */
  int pixelHeight();
  /**  */
  int pixelWidth();
  /**  */
  void close();
  /**  */
  bool appCancel();
  /**  */
  void setAppCancel(bool app);
  /**  */
  bool cancelled();
  /** Returns true, if SANE_CAP_AUTOMATIC is
set for option num. This means, that the backend
is able to choose an option value automatically. */
  bool automaticOption(int num);
  /**  */
  QString saneReadOnly(int num);
  /**  */
  bool isReadOnly(int num);
  /**  */
  void setOptionsByName(QMap <QString,QString> omap);
  /**Returns the name of the selected device.
    */
  QString name();
  /**Returns the vendor of the selected device.
    */
  QString vendor();
  /**Returns the type of the selected device.
    */
  QString type();
  /**Returns the model of the selected device.
    */
  QString model();
  /**  */
  SANE_Status saneStatus();
  /**Appends the currently active and settable options to a QDomElement
  */
  void settingsDomElement(QDomDocument doc,QDomElement domel);
  /** No descriptions */
  int optionSize(int num);
  /** No descriptions */
  double imageInfoMB();
  /** No descriptions */
  QString deviceSettingsName();
  /** No descriptions */
  void setType(QString type);
  /** No descriptions */
  void setModel(QString model);
  /** No descriptions */
  void setVendor(QString vendor);
  /** Indicates, whether an option descriptor changed. */
  bool optionDescriptorChanged(QSaneOption* sane_option);
  /** No descriptions */
  const SANE_Range* saneRange(int num);
  /** */
  static bool msAuthorizationCancelled;
private: // Private attributes
  /** set to true if the call to sane_init was
successfull */
  bool mInitOk;
  const SANE_Device** mpDeviceList;
  bool mEmitSignals;
  /**  */
  bool mOpenOk;
  /**  */
  QString mDeviceName;
  QString mDeviceVendor;
  QString mDeviceType;
  QString mDeviceModel;
  /**  */
  SANE_Handle mDeviceHandle;
  /** */
	int mDeviceCnt;
  /**The number of options is guaranteed to be valid between calls to sane_open()
     and sane_close(). We only have to query the number of options once after a call
     to sane_open. */
	int mOptionNumber;
  /**  */
  QString mTempFilePath;
  /**  */
  SANE_Bool mNonBlockingIo;
  /**  */
  bool mAppCancel;
  /**  */
  SANE_Status mSaneStatus;
  /**  */
  bool mCancelled;
  /**  */
  QProgressDialog* mpProgress;
private://methods
  /**  */
  QString createPNMHeader(SANE_Frame format,int lines,int ppl,int depth,
                          int resx,int resy);
  /**  */
  int optionNumberByName(QString name);
  /**  */
  int yResolutionOption();
  /**  */
  int xResolutionOption();
signals: // Signals
  /**  */
  void signalReloadOptions();
  /**  */
  void signalInfoInexact(int);
  /**  */
  void signalReloadParams();
};

#endif
