   /***************************************************************************
                          qwordarrayoption.cpp  -  description
                             -------------------
    begin                : Mon Oct 30 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qdoublespinbox.h"
#include "qwordarrayoption.h"
#include "qcurvewidget.h"

#include <math.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpointarray.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qvalidator.h>
#include <qwmatrix.h>
#include <sane/saneopts.h>

QWordArrayOption::QWordArrayOption(QString title,QWidget *parent,
                                   SANE_Value_Type type,const char *name )
                 :QSaneOption(title,parent,name)
{
  mOldGamma = -1.0;//invalid gamma value
  mValueType = type;
  initWidget();
  createCurveWidget();
}
QWordArrayOption::~QWordArrayOption(){
}
/**  */
void QWordArrayOption::slotShowOption()
{
  if(mpArrayWidget->isMinimized())
    mpArrayWidget->hide();
  if(mpArrayWidget->isHidden())
    mpArrayWidget->show();
  else
    mpArrayWidget->raise();
  mpCurveCombo->setFocus();
}
/**  */
void QWordArrayOption::initWidget()
{
	QGridLayout* qgl = new QGridLayout(this,1,3);
  qgl->setSpacing(4);
  qgl->setMargin(4);
  mpTitleLabel = new QLabel(optionTitle(),this);
	mpShowButton = new QPushButton(tr("Adjust..."),this);
  connect(mpShowButton,SIGNAL(clicked()),this,SLOT(slotShowOption()));
//create pixmap
  assignPixmap();
	qgl->addWidget(pixmapWidget(),0,0);
	qgl->addWidget(mpTitleLabel,0,1);
	qgl->addWidget(mpShowButton,0,2);
	qgl->setColStretch(1,1);
	qgl->activate();
}
/**  */
QArray<SANE_Word> QWordArrayOption::getValue()
{
  return mDataArray;
}
void QWordArrayOption::setRange(int min, int max)
{
  mMaxVal = max;
  mMinVal = min;
}
/**  */
void QWordArrayOption::setQuant(int min)
{
  mQuant = min;
}
/**  */
void QWordArrayOption::setValue(QArray<SANE_Word> array)
{
  mDataArray.resize(0);
  mDataArray = array.copy();
  setCurve();
}
/**  */
void QWordArrayOption::setCurve()
{
//Here we do the following:
//- copy the data in a QmPointArray
//- map the QmPointArray to 256 * 256
//- create a QmPointArray with a size of 256
  QWMatrix matrix;
  double m11;
  double m22;
  unsigned int z;
  int x;
  int i;

  QPointArray qpa(mDataArray.size());
  QPointArray qpa2;

  for(z=0;z<qpa.size();z++) qpa.setPoint(z,z,mDataArray[z]);
  m11 = 256.0/double(mDataArray.size());
  m22 = 256.0/double(mMaxVal);

  matrix.setMatrix(m11,0.0,0.0,m22,0.0,0.0);
  qpa = matrix.map(qpa);
  qpa2.resize(256);

  x=-1;
  for(i=0;i<256;i++)
  {
    for(z=0;z<qpa.size();z++)
    {
      if(qpa.point(z).x() == i)
      {
        x = qpa.point(z).x();
        qpa2.setPoint(i,i,qpa.point(z).y());
        break;
      }
    }
  }
  mOldGamma = -1.0;
  mpCurveWidget->setDataArray(qpa2);
//  mpCurveCombo->setCurrentItem(1);
//  slotCurveCombo(1);
//  mpCurveWidget->slotChangeCurveType(1);
}
/**  */
void QWordArrayOption::calcDataArray()
{
  double topval;
  double val;
  double s;
  int gval;
  unsigned int i;
  QString qs;

//Here we do the following:
//- map the data from a 256*256 QmPointArray
//to a QArray
  QWMatrix matrix;
  double m11;
  double m22;
  int z;

  if(mpCurveCombo->currentItem() == 0)//gamma curve
  {
    if(mValueType == SANE_TYPE_INT)
      topval = double(mMaxVal);
    else
      topval = SANE_UNFIX(mMaxVal);
    s = topval/pow(topval,1.0/mGamma);
    for(i=0;i<mDataArray.size();i++)
    {
      val = double(i)*topval/double(mDataArray.size());
      if(val>topval) val = topval;
      if(mValueType == SANE_TYPE_INT)
        gval = int(pow(val,1.0/mGamma)*s);
      else
        gval = SANE_FIX(pow(val,1.0/mGamma)*s);
      mDataArray[i] = gval;
    }
  }
  else
  {
  //get the actual values stored in QWordArrays member
  //mPointArray
    QPointArray qpa;
    qpa = mpCurveWidget->pointArray().copy();

    m11 = double(mDataArray.size())/256.0;
    m22 = double(mMaxVal)/256.0;

    matrix.setMatrix(m11,0.0,0.0,m22,0.0,0.0);
    //map to the real values
    qpa = matrix.map(qpa);

    for(i=0;i<255;i++)
    {
      for(z=qpa.point(i).x();z<=qpa.point(i+1).x();z++)
      {
        mDataArray[z] = qpa.point(i).y();
      }
    }
  }
}
/**  */
void QWordArrayOption::createCurveWidget()
{
  mpArrayWidget = new QWidget(this,"",WType_Modal | WStyle_Title |
                                    WStyle_DialogBorder |
                                    WStyle_SysMenu | WStyle_Customize);
  mpArrayWidget->setCaption(optionTitle());
  QGridLayout* mainlayout = new QGridLayout(mpArrayWidget,4,2);
  QLabel* label = new QLabel(mpArrayWidget);
  label->setText(mpTitleLabel->text());
  mpCurveWidget = new QCurveWidget(mpArrayWidget);
  mpCurveWidget->setFixedHeight(266);
  mpCurveWidget->setFixedWidth(266);
  mpCurveWidget->setBackgroundColor(QColor(255,255,255));

  QHBox* qhb1 = new QHBox(mpArrayWidget);
  new QLabel(tr("Curve type:"),qhb1);
  mpCurveCombo = new QComboBox(qhb1);
  mpCurveCombo->insertItem(tr("Gamma"));
  mpCurveCombo->insertItem(tr("Free"));
  mpCurveCombo->insertItem(tr("Line segments"));
  mpCurveCombo->insertItem(tr("Interpolated"));

  QHBox* qhb2 = new QHBox(mpArrayWidget);
  new QLabel(tr("Gamma:"),qhb2);
  mpGammaSpin = new QDoubleSpinBox(qhb2);
  QDoubleValidator* vali = new QDoubleValidator(0.01,4.0,2,mpGammaSpin);
  mpGammaSpin->setValidator(vali);
  mpGammaSpin->setMaxValue(400);
  mpGammaSpin->setMinValue(1);
  mpGammaSpin->setValue(100);
  mGamma = 1.0;

  QHBox* qhb3 = new QHBox(mpArrayWidget);
  mpSetButton = new QPushButton(tr("&Set"),qhb3);
  mpResetButton = new QPushButton(tr("&Reset"),qhb3);
  mpCloseButton = new QPushButton(tr("&Close"),qhb3);

  mainlayout->setSpacing(5);
  mainlayout->setMargin(5);
  mainlayout->addWidget(label,0,0);
  mainlayout->addWidget(mpCurveWidget,1,0);
  mainlayout->addWidget(qhb1,2,0);
  mainlayout->addWidget(qhb2,3,0);
  mainlayout->addWidget(qhb3,4,0);
  mainlayout->activate();
  mpArrayWidget->setFixedSize(mpArrayWidget->sizeHint());
  connect(mpCurveCombo,SIGNAL(activated(int)),
          mpCurveWidget,SLOT(slotChangeCurveType(int)));
  connect(mpCurveCombo,SIGNAL(activated(int)),
          this,SLOT(slotCurveCombo(int)));
  connect(mpGammaSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotGammaValue(int)));
  connect(mpCloseButton,SIGNAL(clicked()),
          mpArrayWidget,SLOT(close()));
  connect(mpResetButton,SIGNAL(clicked()),this,SLOT(slotReset()));
  connect(mpSetButton,SIGNAL(clicked()),this,SLOT(slotSet()));
  mpCurveCombo->setCurrentItem(1);
  mpCurveWidget->slotChangeCurveType(1);
  mpGammaSpin->setEnabled(false);
}
/**  */
void QWordArrayOption::slotReset()
{
  mpCurveWidget->reset();
  if(mOldGamma > -1.0)//gamma
  {
    mpCurveCombo->setCurrentItem(0);
    slotCurveCombo(0);
    mGamma = mOldGamma;
    mpGammaSpin->setValue(int(mGamma*100.0));
  }
  else
  {
    mpCurveCombo->setCurrentItem(1);
    slotCurveCombo(1);
  }
}
/**  */
void QWordArrayOption::slotSet()
{
  mpCurveWidget->set();
  calcDataArray();
  if(mpCurveCombo->currentItem() == 0)//gamma curve
  {
    mOldGamma = mGamma;
  }
  else
  {
    mOldGamma = -1.0;//invalid gamma
  }
  slotEmitOptionChanged();
}
QPointArray QWordArrayOption::pointArray()
{
  return mPointArray;
}/**  */
void QWordArrayOption::closeCurveWidget()
{
  mpArrayWidget->close();
}
/**  */
void QWordArrayOption::slotGammaValue(int value)
{
  mGamma = double(value)/100.0;
  mpCurveWidget->setGamma(mGamma);
}
/**  */
void QWordArrayOption::slotCurveCombo(int index)
{
  if(index == 0)
  {
    mpGammaSpin->setEnabled(true);
    mpGammaSpin->setFocus();
    mpGammaSpin->selectAll();
  }
  else
  {
    mpGammaSpin->setEnabled(false);
  }
}
