/***************************************************************************
                          qwordcombooption.cpp  -  description
                             -------------------
    begin                : Tue Nov 19 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#include "qwordcombooption.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qfontmetrics.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qwidget.h>

QWordComboOption::QWordComboOption(QString title,QWidget * parent,
                                   SANE_Value_Type type,const char * name)
                 :QSaneOption(title,parent,name)
{	
  mSaneValueType = type;
	initWidget();
}
QWordComboOption::~QWordComboOption()
{
}
/**  */
void QWordComboOption::initWidget()
{
	QGridLayout* qgl = new QGridLayout(this,2,3);
	mpTitleLabel = new QLabel(optionTitle(),this);
  QHBox* hbox1 = new QHBox(this);
	mpSelectionCombo = new QComboBox(FALSE,hbox1);
  mpSelectionCombo->setFocusPolicy(StrongFocus);//should get focus after clicking
  connect(mpSelectionCombo,SIGNAL(activated(int)),
          this,SLOT(slotValueChanged(int)));
  mpAutoCheckBox = new QCheckBox(tr("Automatic"),hbox1);
  hbox1->setStretchFactor(mpSelectionCombo,1);
  hbox1->setSpacing(6);
  mpAutoCheckBox->hide();
//create pixmap
  assignPixmap();
	qgl->addMultiCellWidget(pixmapWidget(),0,1,0,0);

	qgl->addWidget(mpTitleLabel,0,2);
	qgl->addWidget(hbox1,1,2);
  qgl->addColSpacing(1,5);
	qgl->setColStretch(0,0);
	qgl->setColStretch(1,0);
	qgl->setColStretch(2,1);
	qgl->activate();
  connect(mpAutoCheckBox,SIGNAL(toggled(bool)),this,SLOT(slotAutoMode(bool)));
}
/**  */
void QWordComboOption::appendArray(QArray <SANE_Word> qa)
{
  unsigned int i;
  int val;
  QString qs;
  mValueArray = qa;
  for(i=0;i<mValueArray.size();i++)
  {
    val = mValueArray[i];
    if(mSaneValueType == SANE_TYPE_FIXED)
      qs.sprintf("%.2f",SANE_UNFIX(val));
    else
      qs.sprintf("%d",int(val));
    mpSelectionCombo->insertItem(qs,-1);
  }
}
/**  */
SANE_Value_Type QWordComboOption::getSaneType()
{
	return mSaneValueType;
}
/**  */
SANE_Word QWordComboOption::getCurrentValue()
{
	return mValueArray[mpSelectionCombo->currentItem()];
}
/**  */
void QWordComboOption::setValue(SANE_Word val)
{
  unsigned int i;
  for(i=0;i<mValueArray.size();i++)
  {
    if(val == mValueArray[i])
    {
      mpSelectionCombo->setCurrentItem(i);
      return;
    }
  }
}
/**  */
void QWordComboOption::slotValueChanged(int)
{
  slotEmitOptionChanged();
}
/**  */
void QWordComboOption::enableAutomatic(bool b)
{
  mAutomatic =b;
  if(b)
    mpAutoCheckBox->show();
  else
    mpAutoCheckBox->hide();
}
/**  */
bool QWordComboOption::automatic()
{
  return mAutomatic;
}
/**Turn automatic mode on or off.  */
void QWordComboOption::slotAutoMode(bool automode)
{
  mAutomatic = automode;
  if(automode)
    mpSelectionCombo->setEnabled(false);
  else
    mpSelectionCombo->setEnabled(true);
  emit signalAutomatic(optionNumber(),automode);
}
