#! /bin/sh

PATH=/sbin:/bin/:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/readahead
NAME=readahead
EARLYFILES=/etc/readahead/earlyfiles

test -x $DAEMON || exit 0

. /lib/lsb/init-functions

set -e

case "$1" in
        start|restart|force-reload)
                log_begin_msg "Reading essential files..."
                $DAEMON `cat $EARLYFILES` &
                log_end_msg 0
                ;;
        stop)
                ;;
        *)
                log_success_msg "Usage: $0 {start|stop|restart|force-reload}" >&2
                ;;
esac

exit 0
