/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2005: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 31/May/2005                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int value;

  locale_init();
  
  if (argc == 2)
    {
      value = get_attribute_nr(argv[1]);
      printf("%i\n", value);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s attribute_name\n"), argv[0]);
      exit(1);
    }
    
  exit(0);
}
