/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2005: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 31/May/2005                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/pm_getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

char * progname;

  void use(int exit_code)
      {
        char name[80];
        char pars[160];
        char * key = (void *) 0;
        int i;

        printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
        printf(gettext("Use: %s [flags] call args\n"), progname);
        printf(gettext(" -N ta = transaction number (default = value of RSBAC_TA, if set, or 0)\n"));
        printf(gettext("call = one of the following calls, args = call dependent\n"));
        for (i=0;i<18;i++)
          {
            get_pm_function_type_name(name,i);
            get_pm_function_param(pars,i);
            printf("%s \t%s\n",name,pars);
          }
        printf(gettext("-- press return --"));
        scanf("%c", key);
        for (i=18;i<PF_none;i++)
          {
            get_pm_function_type_name(name,i);
            get_pm_function_param(pars,i);
            printf("%s \t%s\n",name,pars);
          }
        exit(exit_code);
      }

  void use_ct(int exit_code)
      {
        char name[80];
        char pars[160];
        char * key = (void *) 0;
        int i;

        printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
        printf(gettext("Use: %s [flags] create_ticket ticket-nr valid-secs call args\n"), progname);
        printf(gettext("  -N ta = transaction number\n"));
        printf(gettext("call = one of the following calls, args = call dependent\n"));
        for (i=0;i<15;i++)
          {
            get_pm_tkt_function_type_name(name,i);
            get_pm_tkt_function_param(pars,i);
            printf("%s \t%s\n",name,pars);
          }
        printf(gettext("-- press return --"));
        scanf("%c", key);
        for (i=15;i<PTF_none;i++)
          {
            get_pm_tkt_function_type_name(name,i);
            get_pm_tkt_function_param(pars,i);
            printf("%s \t%s\n",name,pars);
          }
        exit(exit_code);
      }


int main(int argc, char ** argv)
{
  int res = 0;
  int i;
  enum rsbac_pm_function_type_t function;
  union rsbac_pm_function_param_t param;
  rsbac_pm_tkt_id_t ticket=0;
  struct rsbac_pm_purpose_list_item_t * pp_list_p;
  struct rsbac_pm_purpose_list_item_t * pp_list_tmp_p;
  rsbac_list_ta_number_t ta_number = 0;

  locale_init();
  {
    char * env = getenv("RSBAC_TA");

    if(env)
      ta_number = strtoul(env,0,0);
  }

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'N':
                if(argc > 2)
                  {
                    ta_number = strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  {
                    fprintf(stderr, gettext("%s: missing transaction number value for parameter %c\n"), progname, *pos);
                    exit(1);
                  }
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }


  if (argc >= 2)
    {
      function = get_pm_function_type_nr(argv[1]);
      if(function == PF_none)
        {
          printf(gettext("\n%s: invalid pm function %s!\n\n"), progname, argv[1]);
          use(1);
        }
      printf(gettext("%s: requesting pm-call %s (No. %i)\n"), progname,argv[1],function);
      
      switch(function)
        {
          case PF_add_na:
            if(argc < 7)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_na.task = strtol(argv[3],0,10);
            if(!strcmp(argv[4],"IPC"))
              param.add_na.object_class = RSBAC_PM_IPC_OBJECT_CLASS_ID;
            else
              if(!strcmp(argv[4],"DEV"))
                param.add_na.object_class = RSBAC_PM_DEV_OBJECT_CLASS_ID;
              else
                if(!strcmp(argv[4],"NIL"))
                  param.add_na.object_class = 0;
                else
                  param.add_na.object_class = strtol(argv[4],0,10);
            param.add_na.tp = strtol(argv[5],0,10);
            param.add_na.accesses = strtol(argv[6],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_na:
            if(argc < 7)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_na.task = strtol(argv[3],0,10);
            if(!strcmp(argv[4],"IPC"))
              param.add_na.object_class = RSBAC_PM_IPC_OBJECT_CLASS_ID;
            else
              if(!strcmp(argv[4],"DEV"))
                param.add_na.object_class = RSBAC_PM_DEV_OBJECT_CLASS_ID;
              else
                if(!strcmp(argv[4],"NIL"))
                  param.add_na.object_class = 0;
                else
                  param.add_na.object_class = strtol(argv[4],0,10);
            param.delete_na.tp = strtol(argv[5],0,10);
            param.delete_na.accesses = strtol(argv[6],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_add_task:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_task.id = strtol(argv[3],0,10);
            param.add_task.purpose = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_task:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_task.id = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_add_object_class:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_object_class.id = strtol(argv[3],0,10);
            if(argc > 4)
              {
                /* creating list of purposes */
                if(!(pp_list_p = (struct rsbac_pm_purpose_list_item_t *)
                       malloc(sizeof(*pp_list_p)) ))
                  {
                    printf(gettext("%s: Could not allocate list memory!"), progname);
                    exit(1);
                  }
  
                param.add_object_class.pp_list_p = pp_list_p;
                pp_list_p->id = strtol(argv[4],0,10);
                for(i=5;i<argc;i++)
                  {
                    if(!(pp_list_tmp_p = (struct rsbac_pm_purpose_list_item_t *)
                           malloc(sizeof(*pp_list_tmp_p)) ))
                      {
                        printf(gettext("%s: Could not allocate list memory!"), progname);
                      }
                    pp_list_tmp_p->id = strtol(argv[i],0,10);
                    pp_list_p->next = pp_list_tmp_p;
                    pp_list_p = pp_list_tmp_p;
                  }
                pp_list_p->next = NULL;
              }
            else
              param.add_object_class.pp_list_p = NULL;
            res = rsbac_pm(ta_number, function, &param, ticket);
            if(argc > 4)
              {
                /* clean up */
                pp_list_p = param.add_object_class.pp_list_p;
                while(pp_list_p)
                  {
                    pp_list_tmp_p = pp_list_p->next;
                    free(pp_list_p);
                    pp_list_p = pp_list_tmp_p;
                  }
              }
            /* ready */
            break;
            
          case PF_delete_object_class:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_object_class.id = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_add_authorized_tp:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_authorized_tp.task = strtol(argv[3],0,10);
            param.add_authorized_tp.tp = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_authorized_tp:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_authorized_tp.task = strtol(argv[3],0,10);
            param.delete_authorized_tp.tp = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_add_consent:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_consent.filename = argv[3];
            param.add_consent.purpose = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_consent:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_consent.filename = argv[3];
            param.delete_consent.purpose = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_add_purpose:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_purpose.id = strtol(argv[3],0,10);
            param.add_purpose.def_class = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_purpose:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_purpose.id = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_add_responsible_user:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_responsible_user.user = strtol(argv[3],0,10);
            param.add_responsible_user.task = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_responsible_user:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_responsible_user.user = strtol(argv[3],0,10);
            param.delete_responsible_user.task = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_user_aci:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_user_aci.id = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_set_role:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.set_role.user = strtol(argv[3],0,10);
            if((param.set_role.role = get_pm_role_nr(argv[4])) == PR_none)
              param.set_role.role = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_set_object_class:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.set_object_class.filename = argv[3];
            param.set_object_class.object_class = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_switch_pm:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.switch_pm.value = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;

          case PF_switch_auth:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.switch_auth.value = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;

          case PF_set_device_object_type:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.set_device_object_type.filename = argv[3];
            if((param.set_device_object_type.object_type = get_pm_object_type_nr(argv[4])) == PO_none)
              param.set_device_object_type.object_type = strtol(argv[4],0,10);
            param.set_device_object_type.object_class = RSBAC_PM_DEV_OBJECT_CLASS_ID;
            if(argc > 5)
              {
                if(!strcmp(argv[5],"IPC"))
                  param.set_device_object_type.object_class = RSBAC_PM_IPC_OBJECT_CLASS_ID;
                else
                  if(!strcmp(argv[5],"DEV"))
                    param.set_device_object_type.object_class = RSBAC_PM_DEV_OBJECT_CLASS_ID;
                  else
                    if(!strcmp(argv[5],"NIL"))
                      param.set_device_object_type.object_class = 0;
                    else
                      param.set_device_object_type.object_class = strtol(argv[5],0,10);
              }
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;

          case PF_set_auth_may_setuid:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.set_auth_may_setuid.filename = argv[3];
            param.set_auth_may_setuid.value = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;

          case PF_set_auth_may_set_cap:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.set_auth_may_set_cap.filename = argv[3];
            param.set_auth_may_set_cap.value = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;

/********/

          case PF_add_authorized_task:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.add_authorized_task.user = strtol(argv[3],0,10);
            param.add_authorized_task.task = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_authorized_task:
            if(argc < 5)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = strtol(argv[2],0,10);
            param.delete_authorized_task.user = strtol(argv[3],0,10);
            param.delete_authorized_task.task = strtol(argv[4],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
/********/

          case PF_create_tp:
            if(argc < 3)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = 0;
            param.create_tp.id = strtol(argv[2],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_delete_tp:
            if(argc < 3)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = 0;
            param.delete_tp.id = strtol(argv[2],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          case PF_set_tp:
            if(argc < 4)
              {
                printf(gettext("Too few arguments: argc is %i\n"), argc);
                use(1);
              }
            ticket = 0;
            param.set_tp.filename = argv[2];
            param.set_tp.tp = strtol(argv[3],0,10);
            res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
/********/

          case PF_create_ticket:
            if(argc < 6)
              {
                printf(gettext("\nToo few arguments: argc is %i\n"), argc);
                use_ct(1);
              }
            param.create_ticket.id = strtol(argv[2],0,10);
            param.create_ticket.valid_for = strtol(argv[3],0,10);
            param.create_ticket.function_type = get_pm_tkt_function_type_nr(argv[4]);
            switch(param.create_ticket.function_type)
              {
                case PF_add_na:
                  if(argc < 9)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_na.task
                   = strtol(argv[5],0,10);
                  if(!strcmp(argv[6],"IPC"))
                    param.create_ticket.function_param.add_na.object_class
                     = RSBAC_PM_IPC_OBJECT_CLASS_ID;
                  else
                    if(!strcmp(argv[6],"DEV"))
                      param.create_ticket.function_param.add_na.object_class
                       = RSBAC_PM_DEV_OBJECT_CLASS_ID;
                    else
                      if(!strcmp(argv[6],"NIL"))
                        param.create_ticket.function_param.add_na.object_class
                         = 0;
                      else
                        param.create_ticket.function_param.add_na.object_class
                         = strtol(argv[6],0,10);
                  param.create_ticket.function_param.add_na.tp
                   = strtol(argv[7],0,10);
                  param.create_ticket.function_param.add_na.accesses
                   = strtol(argv[8],0,10);
                  break;

                case PF_delete_na:
                  if(argc < 9)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_na.task
                   = strtol(argv[5],0,10);
                  if(!strcmp(argv[6],"IPC"))
                    param.create_ticket.function_param.delete_na.object_class
                     = RSBAC_PM_IPC_OBJECT_CLASS_ID;
                  else
                    if(!strcmp(argv[6],"DEV"))
                      param.create_ticket.function_param.delete_na.object_class
                       = RSBAC_PM_DEV_OBJECT_CLASS_ID;
                    else
                      if(!strcmp(argv[6],"NIL"))
                        param.create_ticket.function_param.delete_na.object_class
                         = 0;
                      else
                        param.create_ticket.function_param.delete_na.object_class
                         = strtol(argv[6],0,10);
                  param.create_ticket.function_param.delete_na.tp
                   = strtol(argv[7],0,10);
                  param.create_ticket.function_param.delete_na.accesses
                   = strtol(argv[8],0,10);
                  break;

                case PF_add_task:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_task.id
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.add_task.purpose
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_task:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_task.id
                   = strtol(argv[5],0,10);
                  break;

                case PF_add_object_class:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_object_class.id
                   = strtol(argv[5],0,10);
                  if(argc > 6)
                    {
                      /* creating list of purposes */
                      if(!(pp_list_p = (struct rsbac_pm_purpose_list_item_t *)
                             malloc(sizeof(*pp_list_p)) ))
                        {
                          printf(gettext("%s: Could not allocate list memory!"), progname);
                          exit(1);
                        }

                      param.create_ticket.function_param.add_object_class.pp_list_p = pp_list_p;
                      pp_list_p->id = strtol(argv[6],0,10);
                      for(i=7;i<argc;i++)
                        {
                          if(!(pp_list_tmp_p = (struct rsbac_pm_purpose_list_item_t *)
                                 malloc(sizeof(*pp_list_tmp_p)) ))
                            {
                              printf(gettext("%s: Could not allocate list memory!"), progname);
                            }
                          pp_list_tmp_p->id = strtol(argv[i],0,10);
                          pp_list_p->next = pp_list_tmp_p;
                          pp_list_p = pp_list_tmp_p;
                        }
                      pp_list_p->next = NULL;
                    }
                  else
                    param.create_ticket.function_param.add_object_class.pp_list_p = NULL;
                  /* calling sys_rsbac_pm */
                  res = rsbac_pm(ta_number, function, &param, ticket);
                  if(argc > 6)
                    {
                      /* clean up */
                      pp_list_p = param.create_ticket.function_param.add_object_class.pp_list_p;
                      while(pp_list_p)
                        {
                          pp_list_tmp_p = pp_list_p->next;
                          free(pp_list_p);
                          pp_list_p = pp_list_tmp_p;
                        }
                    }
                  break;

                case PF_delete_object_class:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_object_class.id
                   = strtol(argv[5],0,10);
                  break;

                case PF_add_authorized_tp:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_authorized_tp.task
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.add_authorized_tp.tp
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_authorized_tp:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_authorized_tp.task
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.delete_authorized_tp.tp
                   = strtol(argv[6],0,10);
                  break;

                case PF_add_consent:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_consent.filename
                   = argv[5];
                  param.create_ticket.function_param.add_consent.purpose
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_consent:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_consent.filename
                   = argv[5];
                  param.create_ticket.function_param.delete_consent.purpose
                   = strtol(argv[6],0,10);
                  break;

                case PF_add_purpose:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_purpose.id
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.add_purpose.def_class
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_purpose:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_purpose.id
                   = strtol(argv[5],0,10);
                  break;

                case PF_add_responsible_user:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_responsible_user.user
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.add_responsible_user.task
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_responsible_user:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_responsible_user.user
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.delete_responsible_user.task
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_user_aci:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_user_aci.id
                   = strtol(argv[5],0,10);
                  break;

                case PF_set_role:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.set_role.user
                   = strtol(argv[5],0,10);
                  if((param.create_ticket.function_param.set_role.role
                      = get_pm_role_nr(argv[6])) == PR_none)
                    param.create_ticket.function_param.set_role.role
                        = strtol(argv[6],0,10);
                  break;

                case PF_set_object_class:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.set_object_class.filename
                   = argv[5];
                  param.create_ticket.function_param.set_object_class.object_class
                   = strtol(argv[6],0,10);
                  break;

                case PF_switch_pm:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.switch_pm.value
                   = strtol(argv[5],0,10);
                  break;

                case PF_switch_auth:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.switch_auth.value
                   = strtol(argv[5],0,10);
                  break;

                case PF_set_device_object_type:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.set_device_object_type.filename
                   = argv[5];
                  if((param.create_ticket.function_param.set_device_object_type.object_type = get_pm_object_type_nr(argv[6])) == PO_none)
                    param.create_ticket.function_param.set_device_object_type.object_type = strtol(argv[6],0,10);
                  param.create_ticket.function_param.set_device_object_type.object_class
                    = RSBAC_PM_DEV_OBJECT_CLASS_ID;
                  if(argc > 7)
                    {
                      if(!strcmp(argv[7],"IPC"))
                        param.create_ticket.function_param.set_device_object_type.object_class
                          = RSBAC_PM_IPC_OBJECT_CLASS_ID;
                      else
                        if(!strcmp(argv[7],"DEV"))
                          param.create_ticket.function_param.set_device_object_type.object_class
                            = RSBAC_PM_DEV_OBJECT_CLASS_ID;
                        else
                          if(!strcmp(argv[7],"NIL"))
                            param.create_ticket.function_param.set_device_object_type.object_class
                              = 0;
                          else
                            param.create_ticket.function_param.set_device_object_type.object_class
                              = strtol(argv[7],0,10);
                    }
                  break;

                case PF_set_auth_may_setuid:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.set_auth_may_setuid.filename
                   = argv[5];
                  param.create_ticket.function_param.set_auth_may_setuid.value
                   = strtol(argv[6],0,10);
                  break;

                case PF_set_auth_may_set_cap:
                  if(argc < 6)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.set_auth_may_set_cap.filename
                   = argv[5];
                  param.create_ticket.function_param.set_auth_may_set_cap.value
                   = strtol(argv[6],0,10);
                  break;

                /**********/

                case PF_add_authorized_task:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.add_authorized_task.user
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.add_authorized_task.task
                   = strtol(argv[6],0,10);
                  break;

                case PF_delete_authorized_task:
                  if(argc < 7)
                    {
                      printf(gettext("Too few arguments: argc is %i\n"), argc);
                      use_ct(1);
                    }
                  param.create_ticket.function_param.delete_authorized_task.user
                   = strtol(argv[5],0,10);
                  param.create_ticket.function_param.delete_authorized_task.task
                   = strtol(argv[6],0,10);
                  break;

                default:
                  use_ct(1);
              }
            if(param.create_ticket.function_type != PF_add_object_class)
              res = rsbac_pm(ta_number, function, &param, ticket);
            break;
            
          default:
              use(1);
        }
      error_exit(res);
    }
  else
    {
      use(0);
    }
    
  return (res);
}

