/* common header for syslogd
 * Copyright 2007 Rainer Gerhards and Adiscon GmbH.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * A copy of the GPL can be found in the file "COPYING" in this distribution.
 */
#ifndef	SYSLOGD_H_INCLUDED
#define	SYSLOGD_H_INCLUDED 1

#include "syslogd-types.h"
#include "objomsr.h"

#ifdef USE_NETZIP
#include <unistd.h>
#include <zlib.h>
/* config param: minimum message size to try compression. The smaller
 * the message, the less likely is any compression gain. We check for
 * gain before we submit the message. But to do so we still need to
 * do the (costly) compress() call. The following setting sets a size
 * for which no call to compress() is done at all. This may result in
 * a few more bytes being transmited but better overall performance.
 * Note: I have not yet checked the minimum UDP packet size. It might be
 * that we do not save anything by compressing very small messages, because
 * UDP might need to pad ;)
 * rgerhards, 2006-11-30
 */
#define	MIN_SIZE_FOR_COMPRESS	60
#endif

#define	MAXLINE		2048		/* maximum line length */

/* Flags to logmsg().
 */
#define INTERNAL_MSG	0x001	/* msg generated by logmsgInternal() --> special handling */
#define SYNC_FILE	0x002	/* do fsync on file after printing */
#define ADDDATE		0x004	/* add a date to the message */
#define MARK		0x008	/* this message is a mark */

void dbgprintf(char *, ...);
void logerror(char *type);
void logerrorSz(char *type, char *errMsg);
void logerrorInt(char *type, int iErr);

void printchopped(char *hname, char *msg, int len, int fd, int iSourceType);
void freeAllSockets(int **socks);
int isAllowedSender(struct AllowedSenders *pAllowRoot, struct sockaddr *pFrom, const char *pszFromHost);
void getCurrTime(struct syslogTime *t);
int formatTimestampToMySQL(struct syslogTime *ts, char* pDst, size_t iLenDst);
int formatTimestamp3339(struct syslogTime *ts, char* pBuf, size_t iLenBuf);
int formatTimestamp3164(struct syslogTime *ts, char* pBuf, size_t iLenBuf);
void untty(void);
rsRetVal cflineParseTemplateName(uchar** pp, omodStringRequest_t *pOMSR, int iEntry, int iTplOpts, uchar *dfltTplName);
rsRetVal cflineParseFileName(uchar* p, uchar *pFileName, omodStringRequest_t *pOMSR, int iEntry, int iTplOpts);
int getSubString(uchar **ppSrc,  char *pDst, size_t DstSize, char cSep);

extern int glblHadMemShortage; /* indicates if we had memory shortage some time during the run */
extern syslogCODE rs_prioritynames[];
extern syslogCODE rs_facilitynames[];
extern char LocalHostName[];
extern int family;
extern int NoHops;
extern int *finet;
extern int send_to_all;
extern int option_DisallowWarning;
extern int Debug;
extern char**LocalHosts;
extern int DisableDNS;
extern char **StripDomains;
extern char *LocalDomain;
extern int bDropMalPTRMsgs;
extern struct AllowedSenders *pAllowedSenders_TCP;
extern char	ctty[];

#endif /* #ifndef SYSLOGD_H_INCLUDED */
