#include "rbgst.h"

VALUE cGstMiniObject;

typedef struct {
  GstMiniObject *instance;
  const RGObjClassInfo *cinfo;
} gstminiobject_holder;

static void 
gst_miniobject_mark(gstminiobject_holder *holder) {
  if (holder->instance && holder->cinfo && holder->cinfo->mark) {
    holder->cinfo->mark(holder->instance);
  }
}

static void 
gst_miniobject_free(gstminiobject_holder *holder) {
  if (holder->instance) {
    if (holder->cinfo && holder->cinfo->free) 
      holder->cinfo->free(holder->instance);

    gst_mini_object_unref(holder->instance);
  }
  free(holder);
}


static VALUE
gst_miniobject_allocate(VALUE klass) {
  gstminiobject_holder *holder;
  VALUE result;
  const RGObjClassInfo* cinfo = CLASS2CINFO(klass);

  if (G_TYPE_IS_ABSTRACT(cinfo->gtype))
    rb_raise(rb_eTypeError, "abstract class");

  result = Data_Make_Struct(klass, gstminiobject_holder,
                            gst_miniobject_mark,
                            gst_miniobject_free,
                            holder);
  holder->instance = NULL;
  holder->cinfo = NULL;

  return result;
}

static VALUE 
gst_miniobject_get_superclass(void) {
  return rb_cObject;
}

static void
gst_miniobject_initialize(VALUE self, gpointer miniobj) {
  gstminiobject_holder *holder;

  Data_Get_Struct(self, gstminiobject_holder, holder); 
  gst_mini_object_ref(GST_MINI_OBJECT(miniobj));

  holder->instance = miniobj;
  holder->cinfo = GTYPE2CINFO(G_TYPE_FROM_INSTANCE(miniobj));
}

static void
gst_miniobject_rvalue2gvalue(VALUE val, GValue *result) {
  gst_value_set_mini_object(result, NIL_P(val) ? NULL : RVAL2GOBJ(val));
}

static gpointer
gst_miniobject_robj2instance(VALUE val) {
  gstminiobject_holder *holder;

  Data_Get_Struct(val, gstminiobject_holder, holder);

  if (!holder->instance) {
    rb_raise(rb_eTypeError, "uninitialized Gst::Miniobject");
  }
  return holder->instance;
}

static VALUE 
gst_miniobject_instance2robj(gpointer obj) {
  VALUE result;
    
  result = gst_miniobject_allocate(GTYPE2CLASS(G_TYPE_FROM_INSTANCE(obj)));
  gst_miniobject_initialize(result, obj);
  return result;
}

static VALUE
gst_miniobject_gvalue2rvalue(const GValue *value) {
  gpointer data =  gst_value_get_mini_object(value);
  if (data == NULL) {
    return Qnil;
  }
  return gst_miniobject_instance2robj(data);
}

static VALUE
gst_miniobject_clone(VALUE self) {
  rb_raise(rb_eTypeError, "can't clone %s", rb_class2name(CLASS_OF(self)));
}

static VALUE
gst_miniobject_get_gtype(VALUE self)
{
  return rbgobj_gtype_new(G_TYPE_FROM_INSTANCE(RVAL2GOBJ(self)));
}

static VALUE
gst_miniobject_flags(VALUE self) {
  return GFLAGS2RVAL(RGST_MINI_OBJECT(self), GST_TYPE_MINI_OBJECT_FLAGS);
}

static RGFundamental miniobject_fundamental = {
 0,          /* GType type; */
 gst_miniobject_get_superclass, /* VALUE (*get_superclass)(void); */
 NULL,                          /* void (*type_init_hook)(VALUE); */
 gst_miniobject_rvalue2gvalue,  /* void (*rvalue2gvalue)(VALUE val, GValue *result); */
 gst_miniobject_gvalue2rvalue,  /* VALUE (*gvalue2rvalue)(const GValue *); */
 gst_miniobject_initialize,     /* void (*initialize)(VALUE, gpointer); */
 gst_miniobject_robj2instance,  /* gpointer (*robj2instance)(VALUE); */
 gst_miniobject_instance2robj   /* VALUE (*instance2robj)(gpointer); */
};

void
Init_gst_miniobject()
{
  miniobject_fundamental.type = GST_TYPE_MINI_OBJECT;

  G_DEF_FUNDAMENTAL(&miniobject_fundamental);
  cGstMiniObject = G_DEF_CLASS(GST_TYPE_MINI_OBJECT, "MiniObject", mGst);

  rb_define_alloc_func(cGstMiniObject, gst_miniobject_allocate);
  rb_define_method(cGstMiniObject, "gtype", gst_miniobject_get_gtype, 0);
  rb_define_method(cGstMiniObject, "clone", gst_miniobject_clone, 0);
  rb_define_method(cGstMiniObject, "flags", gst_miniobject_flags, 0);

  G_DEF_CLASS(GST_TYPE_MINI_OBJECT_FLAGS, "Flags", cGstMiniObject);
  G_DEF_CONSTANTS(cGstMiniObject, 
    GST_TYPE_MINI_OBJECT_FLAGS, "GST_MINI_OBJECT_");
}
