/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : LineStyleBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Draw.h"
#include "Line_dlg.h"
#define LINESTYLEBOX
#include "LineStyleBox.h"



/*
 * ------------------------------------------------------------------
 * ドローイングエリア
 * "expose (再描画)" イベントハンドラ
 */
gint ls_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	gint w, h;
	
	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;
	
	/* 背景 */
	PenSet(ls_gc, 1, 0x0000);
	gdk_draw_rectangle (widget->window, ls_gc, TRUE, 0, 0, w, h);
	
	/* 現在の線種を表示 */
	PenSet_with_back(ls_gc, NowStyle, NowColor, sagcad_color.Back);
	gdk_draw_line(widget->window, ls_gc, 0, h/2, w, h/2);
	
	return FALSE;
}



/*
 * ------------------------------------------------------------------
 * ドローイングエリア
 * "button_press (クリック)" イベントハンドラ
 */
gint ls_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	int style;
	long color;
	GdkRectangle update_rect;
	
	style = NowStyle;
	color = NowColor;
	
	/* 左ボタン */
	if (event->button == 1) {
		Line_set_dlg(&style, &color);
		
		NowStyle = style;
		NowColor = color;
		
		update_rect.x = 0;
		update_rect.y = 0;
		/* ドローイングアレアの大きさ取得 */
		update_rect.width = widget->allocation.width;
		update_rect.height = widget->allocation.height;
		gtk_widget_queue_draw_area(widget, update_rect.x, update_rect.y, update_rect.width, update_rect.y);
		
		/* 現在の線種を表示 */
		PenSet_with_back(ls_gc, NowStyle, NowColor, sagcad_color.Back);
		gdk_draw_line(widget->window, ls_gc, 0, update_rect.height/2, update_rect.width, update_rect.height/2);
	}
	return TRUE;
}



/*
 * ------------------------------------------------------------------
 * ドローイングエリアの生成
 */
GtkWidget *create_line_style_box(void)
{
	GtkWidget *line_style_box;

  /** ドローイングエリア生成 **/
  line_style_box = gtk_drawing_area_new();
  /** ドローイングエリアのサイズ設定 **/
  gtk_widget_set_size_request(GTK_WIDGET(line_style_box), 100, 18);
  
  /** "expose_event"イベントハンドラ設定 **/
  g_signal_connect(G_OBJECT(line_style_box), "expose_event",
			 G_CALLBACK(ls_expose_event), NULL);
  /** "button_press_event"イベントハンドラ設定 **/
  g_signal_connect(G_OBJECT(line_style_box), "button_press_event",
			 G_CALLBACK(ls_button_press_event), NULL);
  /** イベントマスク設定 **/
  gtk_widget_set_events(line_style_box, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

  return line_style_box;
}



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : LineStyleBox.c
 * ====================================================================
 */
