/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TurnDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/19
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __TURNDLG_H__
#define __TURNDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _TURN_DLG
{
	gint value;
	gdouble x_pos;				/* 原点Ｘ */
	gdouble y_pos;				/* 原点Ｙ */
	gdouble angle;				/* 角度 */
	gint repeats;				/* 回数 */

	GtkWidget *x_pos_entry;
	GtkWidget *y_pos_entry;
	GtkWidget *angle_entry;
	GtkWidget *repeats_entry;
	GtkWidget *parent;			
	GtkWidget *dialog;			
};
typedef struct _TURN_DLG TURN_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _TURNDLG_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _TURNDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* コピー【移動/複写】設定 */
gint TurnDialog(TURN_DLG *turn_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __TURNDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TurnDlg.h
 * ====================================================================
 */
