/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : sagcad.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <libintl.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <locale.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#define _SAGCAD_
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_insert.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#include "etc.h"
#include "culcfunc.h"
#include "global.h"
#include "toolbar.h"
#include "DrawArea.h"
#include "LineStyleBox.h"
#include "Draw.h"
#include "Mouse.h"
#include "MsgBox.h"
#include "Command.h"
#include "sgy.h"
#include "DXF_read.h"
#include "InputBox.h"
#include "sagcad.h"


/* -------------------------------------------------------------------
 * アプリケーションの終了
 * 
 */
void file_quit_cmd_callback(gpointer callback_data, guint callback_action, GtkWidget *widget)
{	
	gtk_main_quit(); 
}



/* -------------------------------------------------------------------
 * ウインドウ閉じろイベント
 * 
 */
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	int Ret;


	if (Undo_index != 0) {
		//                                                                    1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!"), _("Does it save?"), "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return TRUE;
		}
	}

	ending();

#ifdef DEBUG
	g_print("sagcad : delete_event\n");
#endif

	return(FALSE); 
}



/* -------------------------------------------------------------------
 * キーが押されたイベント
 * 
 */
static gint key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
//	g_print("sagcad.c : key_press_event : time:%d  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			 event->time, event->state, event->keyval, event->length, event->string);


	if (OnlyOne_mode == 210) {
		/* Enter */
		if (event->keyval == 0xff0d || event->keyval == 0xff8d) {
			OnlyOne (1);
			UpDate();
			return TRUE;
		}
		/* ESC */
		else if (event->keyval == 0xff1b) {
			if (OnlyOne_mode != 0) {
				OnlyOne (0);
				UpDate();
			}
			else {
				cmd_cancel();
			}
				return TRUE;
		}
		/* SPACE */
		else if (event->keyval == 0x20) {
			OnlyOne (2);
//			UpDate();
			UpDate_widget(drawing_area);
//			MouseRet_OnlyOne(drawing_area, 1, 0, 0);
			return TRUE;
		}
	}
	if(event->keyval == 0xff52) MoveUp();			/* ↑ */
	if(event->keyval == 0xff54) MoveDown();			/* ↓ */
	if(event->keyval == 0xff53) MoveRight();		/* ← */
	if(event->keyval == 0xff51) MoveLeft();			/* → */
	
	if(event->keyval == 0xffab) ZoomUp();			/* + */
	if(event->keyval == 0xffad) ZoomDown();			/* - */

	if(event->keyval == 0xff1b) cmd_all_cancel();	/* ESC */

//	if(event->keyval == 0x20) cmd_all_cancel();		/* SPACE */
//	if(event->keyval == 0xff0d) cmd_all_cancel();	/* Enter */
	if(event->keyval == 0xffff) cmd_delete();	    /* Delete */
//	if(event->keyval == 0xff50) cmd_all_cancel();	/* Home */
//	if(event->keyval == 0xff08) cmd_all_cancel();	/* BackSpace */
//	if(event->keyval == 0xff57) cmd_all_cancel();	/* End */
//	if(event->keyval == 0xff63) cmd_all_cancel();	/* Insert */
	if(event->keyval == 0xff55) ZoomUp();	        /* PageUp */
	if(event->keyval == 0xff56) ZoomDown();	        /* PageDown */

//	if(event->keyval == 0x61) cmd_select_chain();	/* a */
//	if(event->keyval == 0x62) cmd_select_chain2();	/* b */
//	if(event->keyval == 0x63) cmd_select_color();	/* c */
	if(event->keyval == 0x74) test();				/* t */

	return TRUE; 
}



/* -------------------------------------------------------------------
 * ウインドウ閉じろイベント
 * 
 */
static void destroy(GtkWidget *widget, gpointer data)
{		
#ifdef DEBUG
	g_print("sagcad : destroy\n");
#endif
	gtk_main_quit(); 
}



/* -------------------------------------------------------------------
 * main 関数
 * 
 * 
 */
int main(int argc, char *argv[])
{
//#define TEST_HANDLE_BOX

#ifdef TEST_HANDLE_BOX
	GtkWidget *handle_toolbar;
	GtkWidget *handle_textbar;
	GtkWidget *handle_statusbar;
#endif

	char str[64], str2[64], msg[256];
	GtkWidget *vbox;
	GtkWidget *toolbar;
	GtkWidget *text_hbox;
	GtkWidget *separator;
	GtkWidget *mag_box;
	GtkWidget *layer_box;
	GtkWidget *filletR_box;
	GtkWidget *length_box;
	GtkWidget *scroll_pitch_box;
//	GtkWidget *hbox;//work_hbox;
	GtkWidget *toolbarY;

	//GtkWidget *image;
	//GdkPixmap *pixmap;
	//GdkBitmap *mask;
//	GdkCursor *cursor;

	int debug = 0;


#ifdef DEBUG
	debug = 1;
#endif



	/* ---------------------------------------------------------------
	 * GTK+ の初期設定
	 */
	/* ロケール設定 */
	gtk_set_locale();
	/* 引数の処理 */
	gtk_init( &argc, &argv );
	/* rc ファイルを読み込み */
	gtk_rc_parse( "./gtkrc" );

	/* Set default icon */
	if (g_file_test ("./sagcad.png", G_FILE_TEST_IS_REGULAR | G_FILE_TEST_IS_SYMLINK)) {
		g_print("sagcad.c : main() : sagcad.png OK！\n");
		gtk_window_set_default_icon_from_file ("./sagcad.png", NULL);
	}



	/* ---------------------------------------------------------------
	 * メッセージの国際化の準備 
	 */
#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);
#endif

	//g_print("LOCALEDIR = %s", LOCALEDIR);


	BeforeStr[0] = '\0';

	/* ---------------------------------------------------------------
	 * SagCAD を起動する前の準備 
	 */
	/* 外部変数の初期化 */
	sagcad_global_init();
	/* 設定ファイルを読み込む */
	ConfigRead();
	/* 初期メッセージ */
	starting();

	DeleteMemoryDebugLog();
	DeleteOneShotLog();



	/* -------------------------
	 * メインウインドウの生成 
	 * -------------------------
	 */
	MainWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_resizable(GTK_WINDOW(MainWindow), TRUE);
	//gtk_container_set_border_width(GTK_CONTAINER(MainWindow), 2);
	SetTitle("Untitled.sgy");

	/* ウィンドウの表示位置設定 */
	if (sagcad_system.WinMode > 0) {
		gtk_window_move(GTK_WINDOW(MainWindow), 
					sagcad_system.win_x_pos, sagcad_system.win_y_pos);
		//g_print("window position = (%d,%d)\n", 
		//			sagcad_system.win_x_pos, sagcad_system.win_y_pos);
	}
	/* ウィンドウサイズ設定 */
	gtk_window_resize(GTK_WINDOW(MainWindow), sagcad_system.win_width, sagcad_system.win_height);
	gtk_widget_show(MainWindow);
	
	/* ---------------------------------------------------------------
	 * シグナルのコールバックを設定
	 */ 
	/* "delete_event" のイベントハンドラ設定 */
	g_signal_connect(G_OBJECT(MainWindow), "delete_event",	
					   G_CALLBACK(delete_event), NULL);
	/* "destroy" のイベントハンドラ設定 */
	g_signal_connect(G_OBJECT(MainWindow), "destroy",
					   G_CALLBACK(destroy), NULL);
	/* "button_press_event" イベントハンドラ設定 */
	g_signal_connect(G_OBJECT(MainWindow), "key_press_event",
					   G_CALLBACK(key_press_event), NULL);

	/* メインウインドウを表示した後でないとダメ */
	font_open(sagcad_dimension.font_file);

	/* icon 作成 */
	//pixmap = gdk_pixmap_create_from_xpm_d(MainWindow->window, 
	//			 &mask, 
	//			 &MainWindow->style->bg[GTK_STATE_NORMAL],
	//			 (gchar **)sagcad_xpm);
	//image = gtk_image_new_from_pixmap(pixmap, mask);
	//gtk_window_set_default_icon(gtk_image_get_pixbuf(GTK_IMAGE(image)));

	/* vbox 生成 (縦に追加) */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(MainWindow), vbox);
	gtk_widget_show(vbox);

	/* ツールバーの生成  (OutMode1) */
	toolbar = create_hbox_toolbar(vbox);
	//gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);
	gtk_widget_show(toolbar);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);
	gtk_widget_show(separator);






	/* text_hbox 生成 (横に追加) */
	text_hbox = gtk_hbox_new(FALSE, 2);
	gtk_container_set_border_width(GTK_CONTAINER(text_hbox), 2);
	gtk_box_pack_start(GTK_BOX(vbox), text_hbox, FALSE, FALSE, 0);
	gtk_widget_show(text_hbox);





	/* 線ステータスバーの生成 */
	line_status = create_line_style_box();
	gtk_box_pack_start(GTK_BOX(text_hbox), line_status, FALSE, FALSE, 0);
	gtk_widget_show(line_status);

	/* 倍率表示ボックスの生成 */
	mag_box = gtk_button_new();
	gtk_widget_set_size_request(mag_box, 80, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_start(GTK_BOX(text_hbox), mag_box, FALSE, FALSE, 0);
	g_signal_connect( G_OBJECT(mag_box), "clicked", 
						G_CALLBACK(mag_box_click), NULL);
	gtk_widget_show(mag_box);

	/* 倍率表示ラベルの生成 */
	mag = gtk_label_new(" Mag 1 ");
	gtk_container_add(GTK_CONTAINER(mag_box), mag);
	gtk_widget_show(mag);
	
	/* レイヤー表示ボックスの生成 */
	layer_box = gtk_button_new();
	gtk_widget_set_size_request(layer_box, 160, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_start(GTK_BOX(text_hbox), layer_box, FALSE, FALSE, 0);
	g_signal_connect( G_OBJECT(layer_box), "clicked",	
						G_CALLBACK(cmd_LayerSet), NULL);
	gtk_widget_show(layer_box);
	
	/* レイヤー表示ラベルの生成 */
	layer = gtk_label_new("Layer-1 [ 1 ]");
	gtk_container_add(GTK_CONTAINER(layer_box), layer);
	gtk_widget_show(layer);
	
	/* Fillet 表示ボックスの生成 */
	filletR_box = gtk_button_new();
	gtk_widget_set_size_request(filletR_box, 80, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_start(GTK_BOX(text_hbox), filletR_box, FALSE, FALSE, 0);
	g_signal_connect( G_OBJECT(filletR_box), "clicked",	
						G_CALLBACK(fillet_box_click), NULL);
	gtk_widget_show(filletR_box);

	/* Fillet 表示ラベルの生成 */
	FloatOut6(str, sagcad_system.FilletRC, 0);
	sprintf(str2, " R %s ", str);
	fillet = gtk_label_new(str2);
	gtk_container_add(GTK_CONTAINER(filletR_box), fillet);
	gtk_widget_show(fillet);
				
	/* length 表示ボックスの生成 */
	length_box = gtk_button_new();
	gtk_widget_set_size_request(length_box, 80, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_start(GTK_BOX(text_hbox), length_box, FALSE, FALSE, 0);
	g_signal_connect( G_OBJECT(length_box), "clicked",	
						G_CALLBACK(length_box_click), NULL);
	gtk_widget_show(length_box);
	
	/* length 表示ラベルの生成 */
	FloatOut6(str, sagcad_system.Length, 0);
	sprintf(str2, " L %s ", str);
	length = gtk_label_new(str2);
	gtk_container_add(GTK_CONTAINER(length_box), length);
	gtk_widget_show(length);

	/* scroll_pitch 表示ボックスの生成 */
	scroll_pitch_box = gtk_button_new();
	gtk_widget_set_size_request(scroll_pitch_box, 80, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_start(GTK_BOX(text_hbox), scroll_pitch_box, FALSE, FALSE, 0);
	g_signal_connect( G_OBJECT(scroll_pitch_box), "clicked",	
						G_CALLBACK(scroll_pitch_box_click), NULL);
	gtk_widget_show(scroll_pitch_box);
	
	/* scroll_pitch 表示ラベルの生成 */
	FloatOut6(str, sagcad_system.ScrollPitch, 0);
	sprintf(str2, " SP %s ", str);
	scroll_pitch = gtk_label_new(str2);
	gtk_container_add(GTK_CONTAINER(scroll_pitch_box), scroll_pitch);
	gtk_widget_show(scroll_pitch);
	
	/* Mouse Y 表示ボックスの生成 */
	MouseY = gtk_label_new("y 0.000");
	gtk_widget_set_size_request(MouseY, 80, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_end(GTK_BOX(text_hbox), MouseY, FALSE, FALSE, 0);
	gtk_widget_show(MouseY);
	
	/* Mouse X 表示ボックスの生成 */
	MouseX = gtk_label_new("x 0.000");
	gtk_widget_set_size_request(MouseX, 80, TEXT_H_BOX_HEIGHT);
	gtk_box_pack_end(GTK_BOX(text_hbox), MouseX, FALSE, FALSE, 0);
	gtk_widget_show(MouseX);
	
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);
	gtk_widget_show(separator);
	
	/* work_hbox 生成 (横に追加) */
	work_hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), work_hbox, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(work_hbox), 2);
	gtk_widget_show(work_hbox);
	
	/* ツールバーの生成 */
	toolbarY = create_table_toolbar(work_hbox);
	gtk_widget_show(toolbarY);
	
	separator = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(work_hbox), separator, FALSE, FALSE, 2);
	gtk_widget_show(separator);
	
	/* ドローイングエリアの生成 */
	drawing_area = create_drawing_area();
	gtk_box_pack_start(GTK_BOX(work_hbox), drawing_area, TRUE, TRUE, 0);
	gtk_widget_show(drawing_area);
	/* -------------------------------------------------------------------------------
	   マウスカーソル作成 
	   GDK_CROSS  GDK_IRON_CROSS  [GDK_CROSSHAIR]  GDK_DIAMOND_CROSS  [GDK_TCROSS]
	 */
//	cursor = gdk_cursor_new(GDK_TCROSS);
//	gdk_window_set_cursor(drawing_area->window, cursor);





#ifdef TEST_HANDLE_BOX
	handle_statusbar = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(vbox), handle_statusbar, FALSE, FALSE, 0);
	gtk_widget_show(handle_statusbar);
#endif

	/* ステータスバーの生成 */
	statusbar = gtk_entry_new();
#ifdef TEST_HANDLE_BOX
	gtk_container_add(GTK_CONTAINER(handle_statusbar), statusbar);
#else
	gtk_box_pack_start(GTK_BOX(vbox), statusbar, FALSE, FALSE, 0);
	gtk_editable_set_editable(GTK_EDITABLE(statusbar), FALSE);
#endif
	gtk_widget_show(statusbar);





	/* -----------------------------
	 * 開始処理
	 */
	ReturnFunc = MouseRet_Non;



	/* GC作成 */
//	gc = create_gc(drawing_area);
	ls_gc = create_gc(line_status);

	/* コマンドラインのファイルを開く */
	if(argc == 2) {
		strcpy(NowFile, argv[1]);

		if (strstr(NowFile, ".sgy") != NULL || strstr(NowFile, ".SGY") != NULL) {
			sprintf(msg, "Reading SGY       ■□□□□□□");
			StatusMsg(msg);
			UpDate_widget(MainWindow);
			sgyFileOpen(NowFile);
		}
		else if(strstr(NowFile, ".dxf") != NULL || strstr(NowFile, ".DXF") != NULL) {
			sprintf(msg, "Reading DXF       ■□□□□□□");
			StatusMsg(msg);
			UpDate_widget(MainWindow);
			DxfFileOpen(NowFile, 0, 0);
		}

		SetTitle(g_locale_to_utf8(NowFile, -1, NULL, NULL, NULL));
	}
	else {
		/* ウインドウのタイトルを設定 */
		sprintf(NowFile, "%s/Untitled.sgy", sagcad_user.CadPath);
		SetTitle(NowFile);
	}
	/* -----------------------------
	 * メインイベントループ
	 */
	gtk_main ();


	/* -----------------------------
	 * 終了処理
	 */

	/* GC 開放 */
	delete_gc(gc);
//	delete_gc(ls_gc);


	/* メモリ開放 */
	if (debug > 0) g_print("\n--- < Memory Block Free start > ---\n");
	if (debug > 0) g_print("CAD Data Free ---> ");
	if (debug > 0) g_print("CAD Data [%d]\n", (int)cad_list_num(&cad_list_info));
	cad_list_all_free(&cad_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("DIMENSION Data Free ---> ");
	if (debug > 0) g_print("DIMENSION Data [%d]\n", (int)dimension_list_num(&dimension_list_info));
	dimension_list_all_free(&dimension_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("POLYLINE Data Free ---> ");
	if (debug > 0) g_print("POLYLINE Data [%d]\n", (int)polyline_list_num(&polyline_list_info));
	polyline_list_all_free(&polyline_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("ELLIPSE Data Free ---> ");
	if (debug > 0) g_print("ELLIPSE Data [%d]\n", (int)ellipse_list_num(&ellipse_list_info));
	ellipse_list_all_free(&ellipse_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("INSERT Data Free ---> ");
	if (debug > 0) g_print("INSERT Data [%d]\n", (int)insert_list_num(&insert_list_info));
	insert_list_all_free(&insert_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("BLOCK Data Free ---> ");
	if (debug > 0) g_print("BLOCK Data [%d]\n", (int)block_list_num(&block_list_info));
	block_list_all_free(&block_list_info);
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("UNDO Data Free ---> ");
	//g_print("UNDO Data [%d]\n", (int)undo_list_num());
	undo_list_all_free();
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("SELECT Data Free ---> ");
	select_list_all_free();
	if (debug > 0) g_print("OK !\n");

	if (debug > 0) g_print("FONT Data Free ---> ");
	//g_print("FONT Data [%d]\n", (int)font_list_num());
	font_list_all_free();
	if (debug > 0) g_print("OK !\n");
	if (debug > 0) g_print("--- < Memory Block Free end > ---\n\n");

	xdump();
	return 0;
}



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : sagcad.c
 * ====================================================================
 */





/* -------------------------------------------------------------------
 * タイトルを設定
 *	
 */
int SetTitle(char *FileName)
{
	char str[256];

	sprintf(str, " [ %s ] - %s Version ", FileName, Title);
	strcat(str, VERSION);
	gtk_window_set_title(GTK_WINDOW(MainWindow), str);
	return 1;
}





/* -------------------------------------------------------------------
 * スターティング　メッセージ
 * 
 */
int starting(void)
{
//	char *pt;

	g_print("\nSagCAD ");
	g_print(VERSION);
	g_print("\n");
	g_print("Copyright (C) 1998-2007 Sagiya Metal Mold Factory,Inc.\n");
	g_print("Yutaka Sagiya.\n");
	g_print("SagCAD comes with NO WARRANTY,\n");
	g_print("to the extent permitted by law.\n");
	g_print("You may redistribute copies of SagCAD\n");
	g_print("under the terms of the GNU General Public License.\n");
	g_print("For more information about these matters,\n");
	g_print("see the files named COPYING.\n\n");
	g_print("Report bugs to <kappa@a6s.highway.ne.jp>\n");

//#ifdef TEST
	g_print("Font Directry ->");
	g_print(FONTDIR);
	g_print("\n");

	g_print("Tool Directry ->");
	g_print(TOOLDIR);
	g_print("\n");

	g_print("Locale Directry ->");
	g_print(LOCALEDIR);
	g_print("\n");

	g_print("DOCUMENT Directry ->");
	g_print(DOCDIR);
	g_print("\n");
//#endif
	return 1;
}





/* -------------------------------------------------------------------
 * エンディング　メッセージ
 * 
 */
int ending(void)
{
	int x, y, width, height;

	gtk_window_get_size(GTK_WINDOW(MainWindow), &width, &height);
//	g_print("sagcad.c : delete_event() : Bar Size (%d, %d)   Window Size(%d,%d)\n", 
//			bar_x, bar_y, width, height);

	gtk_window_get_position(GTK_WINDOW(MainWindow), &x, &y);
//	g_print("sagcad.c : delete_event() : position (%d,%d)\n", x, y);

	if (sagcad_system.WinMode == 2) {
		sagcad_system.win_x_pos = x;
		sagcad_system.win_y_pos = y;
		sagcad_system.win_width = width;
		sagcad_system.win_height = height;
		
		if (sagcad_system.win_x_pos < 10) sagcad_system.win_x_pos = 0;
		if (sagcad_system.win_y_pos < 10) sagcad_system.win_y_pos = 0;
		
		g_print("ending() : %d, %d, %d, %d\n", 
					sagcad_system.win_x_pos, sagcad_system.win_y_pos, 
					sagcad_system.win_width, sagcad_system.win_height);
		
		ConfigWrite();
	}


	g_print("\nThanks to...\n");
	g_print("  Adviser         mosoku <f_mosoku@lycos.jp>\n");
	g_print("                  allentown <pulsar@sea.plala.or.jp>\n");	// Narita Koichi 
	g_print("                  0110110 <sora@tka.att.ne.jp>\n");		// Yoshihiro Horii 
	g_print("                  yamaguchi <yamaguchi@tac.tsukuba.ac.jp>\n");
	g_print("  Japanese Font   Yoshimune Kobayashi <cfg47520@syd.odn.ne.jp>\n");
	g_print("  German          Thomas Formella <thomas-formella@web.de>\n");
	g_print("  English         Doug Fortune <pentam@cncKITS.com>\n");
	g_print("                  Matt Kasdorf <kasdorfm@knightfire.com>\n");
	g_print("\n");

	return 1;
}



int StatusMsg(char *str)
{
	gtk_entry_set_text(GTK_ENTRY(statusbar), str);
	UpDate_widget(statusbar);
	return 1;
}

int StatusMsg_MouseX(char *str)
{
	set_label_text(MouseX, str);
	return 1;
}

int StatusMsg_MouseY(char *str)
{
	set_label_text(MouseY, str);
	return 1;
}



