#!/usr/bin/env ruby
#
# Samizdat publish message form
#
#   Copyright (c) 2002-2005  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

request do |session|
  session.access('post') or raise AuthError,
    sprintf(_('Your current access level (%s) does not allow to publish messages'), _(session.role))

  message = PublishMessage.new(session)

  if message.enough_fields?   # publish or preview message
    if session.has_key? 'confirm'
      location = message.publish
      session.redirect(location)   # redirect to published message
    else   # preview message
      message.preview_page
    end
  else   # edit message
    message.edit_page
  end
end
