 /* sane - Scanner Access Now Easy.
   Copyright (C) 2003 Johannes Hub (JohannesHub@foni.net)

   This file was initially copied from the hp3300 testools and adjusted to
   suit. Original copyright notice follows:

   Copyright (C) 2001 Bertrik Sikken (bertrik@zonnet.nl)

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an exutable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/*
    Concept for a backend for scanners based on the RT8891 chipset,
    such as HP4400C, HP4470C.
    Parts of this source were inspired by other backends.

    History:


    Version 0.12 13/10/03 third alpha, Backend name changed to HP_RTS
    Version 0.11 30/08/03 second alpha
    Version 0.10 19/07/03 first alpha
*/

/*
  This is the sanei_usb transfer method
*/

#ifdef SANEI_USB_SUPPORT

#include <stdio.h>     /* printf */

#include "../include/sane/sanei_usb.h"
#include "../sanei/sanei_usb.c"

#include "hp_rts_xfer.h"


#define USB_TYPE_VENDOR                 (0x02 << 5)
#define USB_RECIP_DEVICE                0x00
#define USB_DIR_OUT                     0
#define USB_DIR_IN                      0x80

/****************************************************************************/
static SANE_Int _SaneiUsbWriteControl(SANE_Int fd, SANE_Byte bValue,
                                  SANE_Byte *pabData, SANE_Int iSize){
/****************************************************************************/
  return(sanei_usb_control_msg(fd,
                        USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_DIR_OUT,
                        (iSize > 1) ? 0x04 : 0x0C,
                        bValue,
                        0,
                        iSize,
                        pabData));
}


/****************************************************************************/
static void _SaneiUsbReadControl(SANE_Int fd, SANE_Byte bValue,
            SANE_Byte *pabData, SANE_Int iSize){
/****************************************************************************/
  sanei_usb_control_msg(fd,
                        USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_DIR_IN,
                        (iSize > 1) ? 0x04 : 0x0C,
                        bValue,
                        0,
                        iSize,
                        pabData);
}


static TFnReportDevice *_pfnReportDevice;
static TScannerModel *_pModel;


/* callback for sanei_usb_attach_matching_devices */
/****************************************************************************/
static SANE_Status _AttachUsb(SANE_String_Const devname){
/****************************************************************************/
  SANE_Char szDeviceName[32];
#ifdef DEBUG
  DBG(DBG_MSG, "_AttachUsb: found %s\n", devname);
#endif
  sprintf(szDeviceName, devname);
  _pfnReportDevice( _pModel,szDeviceName);
/*  _pfnReportDevice( _pModel, (SANE_Char )devname);*/

  return SANE_STATUS_GOOD;
}

/****************************************************************************/
static SANE_Int UsbWriteBulk(SANE_Int fd, SANE_Byte reg, SANE_Byte *pabData,
                         SANE_Int iSize, SANE_Int wHeader){
/****************************************************************************/
  static SANE_Byte init[]={0x88,0,0x00,0x01};
  SANE_Char *request;     /* Compose a request string. */
  SANE_Int returncode;

  returncode = -1;
  if (fd == -1) {
    return(returncode);
  }

  if (!wHeader){
    request=malloc(iSize + 4);     /* Compose a request string. */
    init[1]=(SANE_Byte)reg;
    init[2]=(SANE_Byte)(iSize>>8); /* split count over these bytes.*/
    init[3]=(SANE_Byte)iSize;
    memcpy(request,init,4);        /* stick them together */
    memcpy(request+4,pabData,iSize);

/*  abSetup[4] = (iSize) & 0xFF;
  abSetup[5] = (iSize >> 8) & 0xFF;
*  _SaneiUsbWriteControl(fd, USB_SETUP, abSetup, 8);*/

/*    size = iSize;*/
    if (sanei_usb_write_bulk(fd, init,(size_t *) iSize) != SANE_STATUS_GOOD) {
#ifdef DEBUG
    DBG(DBG_ERR, "ERROR: Bulk write failed\n");
#endif
    } else returncode = 0;
    free(request);                  /* clean up */
  }else
  {
    if (sanei_usb_write_bulk(fd, init,(size_t *) iSize) != SANE_STATUS_GOOD) {
/*    write_usb(devLibUsb,0x02,(SANE_Char *)pabData,iSize,TIMEOUT);*/
#ifdef DEBUG
    DBG(DBG_ERR, "ERROR: Bulk write failed\n");
#endif
    } else returncode = 0;
  }
  return(returncode);
}


/****************************************************************************/
static SANE_Int UsbReadBulk(SANE_Int fd, SANE_Byte reg, SANE_Byte *pabData,
                        SANE_Int iSize, SANE_Int wWrite){
/****************************************************************************/
  static SANE_Byte init[]={0x80,0,0x00,0x01};
  size_t size;
  SANE_Int returncode;

  returncode = -1;
  size = 4;
  if (fd == -1) {
    return(returncode);
  }

  if (wWrite){
    init[1] = reg;
    init[2] = (iSize>>8) & 0xFF; /*split count over these bytes.*/
    init[3] = (iSize) & 0xFF;
    if (sanei_usb_write_bulk(fd, init,(size_t *) size) != SANE_STATUS_GOOD) {
      printf("ERROR: Bulk write failed\n"); }
  } else returncode = 0;
  size = iSize;
  if (sanei_usb_read_bulk(fd, pabData,(size_t *) size) != SANE_STATUS_GOOD) {
    printf("ERROR: Bulk read failed\n");
  } else returncode = 0;
  return(returncode);
}


/****************************************************************************/
static SANE_Int UsbInit(TFnReportDevice *pfnReportDevice){
/****************************************************************************/
  TScannerModel *pModels = ScannerModels;
  SANE_Int iVendor, iProduct;

  _pfnReportDevice = pfnReportDevice;
  iVendor = 0;
  iProduct = 0;
  sanei_usb_init();
  /* loop over all scanner models */
  while (pModels->pszName != NULL) {
#ifdef DEBUG
    printf( "Looking for %s...\n", pModels->pszName);
#endif
    _pModel = pModels;
    if (sanei_usb_find_devices((SANE_Int)pModels->iVendor,
      (SANE_Int)pModels->iProduct, _AttachUsb) != SANE_STATUS_GOOD) {
#ifdef DEBUG
      printf("Error invoking sanei_usb_find_devices");
#endif
      return(SANE_TRUE);
/*     break;*/
    }
    pModels++;
  }
  return(SANE_FALSE);
}


/****************************************************************************/
static SANE_Int UsbOpen(SANE_Char *pszName)
/****************************************************************************/
{
  SANE_Status status;
  SANE_Int fd;

  printf("Trying to open %s...\n", pszName);
/*  DBG(DBG_MSG, "Trying to open %s...\n", pszName);*/

  status = sanei_usb_open(pszName, &fd);
/*  status = sanei_usb_open(_szDevice, &fd);*/

  if (status != SANE_STATUS_GOOD) {
    printf("No device found %s...\n", pszName);
    return -1;
  }

  return fd;
}

/****************************************************************************/
static void UsbExit(SANE_Int fd)
/****************************************************************************/
{
  /* close usb device */
  if (fd != -1) {
    sanei_usb_close(fd);
  }
}


/****************************************************************************/
static SANE_Int UsbWriteReg(SANE_Int fd, SANE_Byte bReg, SANE_Byte bData)
/****************************************************************************/
{
  return(_SaneiUsbWriteControl(fd, bReg, &bData, 1));
}


/****************************************************************************/
static SANE_Int UsbReadReg(SANE_Int fd, SANE_Byte bReg, SANE_Byte *pbData)
/****************************************************************************/
{
  UsbReadBulk(fd,bReg,pbData,1,SANE_TRUE);
/*  _SaneiUsbReadControl(fd, bReg, pbData, 1);*/
  return(SANE_TRUE);
}


/****************************************************************************/
static SANE_Int
UsbReadBulk_all_regs(SANE_Int iHandle, SANE_Byte *pabData)
/****************************************************************************/
{
/*  SANE_Byte init[]={0x80,0,0x00,0xf4};
  usb_dev_handle *devLibUsb;

  if (iHandle < 0) {
    return;
  }

  devLibUsb = (usb_dev_handle *)iHandle;
  write_usb(devLibUsb,0x02,init        ,4  ,TIMEOUT);
  read_usb (devLibUsb,0x81,pabData     ,192,TIMEOUT);
  read_usb (devLibUsb,0x81,pabData+192 ,52 ,TIMEOUT);*/
}

/****************************************************************************/
XferModule SaneiUsbDev = {
/****************************************************************************/
    "Sanei_USB",
    UsbInit,
    UsbOpen,
    UsbExit,
    UsbWriteReg,
    UsbReadReg,
    UsbWriteBulk,
    UsbReadBulk,
    UsbReadBulk_all_regs
};

#endif /* SANEI_USB_SUPPORT */
