#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBaseCenterDialog {frame id width height} {
    global marker
    global ds9

    set w ".marker$id"
    set mb ".mb$id"

    # variables
    set marker($frame,$id,x) 0
    set marker($frame,$id,y) 0

    # base
    MarkerBaseDialog $frame $id $width $height

    # init
    MarkerBaseCenterMoveCB $frame $id

    # callbacks
    $frame marker $id callback move MarkerBaseCenterMoveCB $frame

    # Center
    label $w.ref.f.centerTitle -text "Center"
    entry $w.ref.f.centerX -textvariable marker($frame,$id,x) -width 13
    entry $w.ref.f.centerY -textvariable marker($frame,$id,y) -width 13
    label $w.ref.f.centerCoord -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,clabel)
    grid $w.ref.f.centerTitle $w.ref.f.centerX $w.ref.f.centerY \
	$w.ref.f.centerCoord -padx 4 -sticky w
}

proc MarkerBaseCenterClose {frame id} {
    $frame marker $id delete callback move MarkerBaseCenterMoveCB

    MarkerBaseClose $frame $id
}

proc MarkerBaseCenterApply {frame id} {
    global marker

    if {$marker($frame,$id,x) != {} &&
	$marker($frame,$id,y) != {}} {
	$frame marker $id move to \
	    $marker($frame,$id,system) $marker($frame,$id,sky) \
	    $marker($frame,$id,x) $marker($frame,$id,y)
    }

    MarkerBaseApply $frame $id
}

proc MarkerBaseCenterRotate {frame id} {
    global marker

    $frame marker $id angle $marker($frame,$id,angle) \
	$marker($frame,$id,system) $marker($frame,$id,sky)
}

# callbacks

proc MarkerBaseCenterMoveCB {frame id} {
    global marker

    set center [$frame get marker $id center \
		    $marker($frame,$id,system) $marker($frame,$id,sky) \
		    $marker($frame,$id,skyformat)]
    set marker($frame,$id,x) [lindex $center 0]
    set marker($frame,$id,y) [lindex $center 1]
}

proc MarkerBaseCenterRotateCB {frame id} {
    global marker

    set marker($frame,$id,angle) \
	[$frame get marker $id angle $marker($frame,$id,system) \
	     $marker($frame,$id,sky)]
}

