#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc RulerDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set s [$frame get marker $id ruler system]
    set marker($frame,$id,system) [lindex $s 0]
    set marker($frame,$id,sky) [lindex $s 1]
    set marker($frame,$id,dcoord) [lindex $s 2]
    set marker($frame,$id,dformat) [lindex $s 3]

    # base
    MarkerBaseLineDialog $frame $id 375 250

    # Axis Length
    label $w.dist.f.atitle -text "Axis Length"
    label $w.dist.f.x -relief groove -width 12  \
	-textvariable marker($frame,$id,distx)
    label $w.dist.f.y -relief groove -width 12  \
	-textvariable marker($frame,$id,disty)
    label $w.dist.f.format2 -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,dlabel)
    grid $w.dist.f.atitle $w.dist.f.x $w.dist.f.y $w.dist.f.format2 -row 2 \
	-padx 4 -pady 2 -sticky w
    grid $w.dist.f.format $w.dist.f.angformat -column 3
}

# actions

proc RulerClose {frame id} {
    MarkerBaseLineClose $frame $id
}

proc RulerApply {frame id} {
    global marker

    $frame marker $id ruler point \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,x) $marker($frame,$id,y) \
	$marker($frame,$id,x2) $marker($frame,$id,y2)

    MarkerBaseLineApply $frame $id
}

# callbacks

proc RulerCoordCB {frame id} {
    global marker

    MarkerBaseCoordCB $frame $id

    $frame marker $id ruler system \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,dcoord) $marker($frame,$id,dformat)

    RulerEditCB $frame $id
}

proc RulerEditCB {frame id} {
    global marker

    MarkerBaseLineEditCB $frame $id

    set d [$frame get marker $id ruler length \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
    set marker($frame,$id,dist) [lindex $d 0]
    set marker($frame,$id,distx) [lindex $d 1]
    set marker($frame,$id,disty) [lindex $d 2]

    set marker($frame,$id,angle) \
	[$frame get marker $id angle \
	     $marker($frame,$id,system) $marker($frame,$id,sky)]
}

proc RulerDistCB {frame id} {
    global marker

    MarkerBaseDistCB $frame $id

    $frame marker $id ruler system \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,dcoord) $marker($frame,$id,dformat)

    set d [$frame get marker $id ruler length \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
    set marker($frame,$id,dist) [lindex $d 0]
    set marker($frame,$id,distx) [lindex $d 1]
    set marker($frame,$id,disty) [lindex $d 2]
}


