/*
 *	Copyright (c) 1999-2003 Smithsonian Astrophysical Observatory
 */

#include <funtools.h>

#define BLANK "                                                                                "

extern char *optarg;
extern int optind;

#ifdef ANSI_FUNC
int 
main (int argc, char **argv)
#else
int
main(argc, argv)
     int argc;
     char **argv;
#endif
{
  int c;
  int i;
  int extno=0;
  int got;
  int doall=0;
  int dotype=0;
  int dolist=0;
  char *s, *t;
  char *ind;
  char *fmt="%.80s\n";
  char iname[SZ_LINE];
  char cname[SZ_LINE];
  Fun fun;

  /* exit on gio errors */
  if( !getenv("GERROR")  )
    setgerror(2);

  /* we want the args in the same order in which they arrived, and
     gnu getopt sometimes changes things without this */
  putenv("POSIXLY_CORRECT=true");

  /* process switch arguments */
  while ((c = getopt(argc, argv, "astL")) != -1){
    switch(c){
    case 'a':
      doall = 1;
      break;
    case 's':
      fmt = "%.79s\n";
      break;
    case 't':
      dotype = 1;
      fmt = "%.77s\n";
      break;
    case 'L':
      dolist = 1;
      break;
    }
  }

  /* check for required arguments */
  if( (argc - optind) != 1 ){
    fprintf(stderr, "usage: %s [-a] [-s] [-t] [-L] fname[ext]\n", argv[0]);
    exit(1);
  }

  /* input file name */
  strcpy(iname, argv[optind+0]);

  /* if we are doing all extensions, remove bracket specifcation from base */
  if( doall ){
    if( (ind=strchr(iname, '[')) || (ind=strchr(iname, ',')) ){
      *ind = '\0';
    }
  }

  /* set up the first extension */
  if( doall ){
    snprintf(cname, SZ_LINE, "%s[%d]", iname, extno);
    extno++;
  }
  else{
    strcpy(cname, iname);
  }

again:
  /* open the input FITS extension  */
  if( !(fun = FunOpen(cname, "r", NULL)) ){
    /* if we are doing all extension, an error means we are done */
    if( doall )
      return(0);
    /* not doing all, so if no extension was given, try primary */
    if( !strchr(iname, '[') && !strchr(iname, ',') ){
      snprintf(cname, SZ_LINE, "%s[0]", iname);
      if( !(fun = FunOpen(cname, "r", NULL)) )
	gerror(stderr, "can't FunOpen input file (or find extension): %s\n",
	       iname);
    }
    else{
      gerror(stderr, "can't FunOpen input file (or find extension): %s\n",
	     iname);
    }
  }


  if ( dolist ) {
      fprintf(stdout, "\n");
      fprintf(stdout, "FITSNAME\t%s\n", iname);
  } else {
      /* get extension name */
      if( (s=FunParamGets(fun, "EXTNAME", 0, NULL, &got)) ){
	  fprintf(stdout, "\t\tExtension: %s", s);
	  if( (t=FunParamGets(fun, "HDUNAME", 0, NULL, &got)) )
	      fprintf(stdout, "/%s", t);
	  fprintf(stdout, "\n\n");
	  if( s ) xfree(s);
	  if( t ) xfree(t);
      }
  }

  /* display cards */
  for(i=1; ;i++){
    if( (s = FunParamGets(fun, NULL, i, NULL, &got)) ){
      if( dolist ) {
	if( strncmp(s, "        ", 8) ) {
	  /* John did this -- its not my fault */
	  fprintf(stdout, "%8.8s\t%s\n", s,
		  (char *)ft_cardget((FITSCard)s));
	}
      } else {
	if( dotype )
	  fprintf(stdout, "%c ", got);
	fprintf(stdout, fmt, s);
      }
      xfree(s);
    }
    else{
      break;
    }
  }
  fflush(stdout);
  
  /* close file */
  FunClose(fun);

  /* if we are processing all extensions, go back for more */
  if( doall ){
    snprintf(cname, SZ_LINE, "%s[%d]", iname, extno);
    extno++;
    goto again;
  }

  return(0);
}
