/*
 *	Copyright (c) 1999-2003 Smithsonian Astrophysical Observatory
 */

#include <funtools.h>

extern char *optarg;
extern int optind;

#define FORCE_IMAGE -1

#ifdef ANSI_FUNC
int 
main (int argc, char **argv)
#else
int
main(argc, argv)
     int argc;
     char **argv;
#endif
{
  int c;
  int i;
  int args;
  int dim2;
  int type=0;
  int ibitpix=0;
  int doscale=1;
  char *mode=NULL;
  char *tmode=NULL;
  char *omode="w";
  char *iname;
  char *oname;
  char *buf=NULL;
  char tbuf[SZ_LINE];
  Fun fun, fun2;

  /* exit on gio errors */
  if( !getenv("GERROR")  )
    setgerror(2);

  /* process switch arguments */
  while ((c = getopt(argc, argv, "ai")) != -1){
    switch(c){
    case 'a':
      omode = "a";
    case 'i':
      type = FORCE_IMAGE;
      break;
    }
  }

  /* process arguments */
  args = argc - optind;
  if( args < 2 ){
    fprintf(stderr, "usage: %s [-a] iname oname [bitpix=n[,bscale=false]]\n",
	    argv[0]);
    exit(1);
  }
  iname = argv[optind+0];
  oname = argv[optind+1];
  if( args > 2 )
    mode = xstrdup(argv[optind+2]);

  /* open the input FITS file */
  if( !(fun = FunOpen(iname, "rc", NULL)) )
    gerror(stderr, "can't FunOpen input file (or find extension): %s\n",
	   iname);

  /* open the output FITS image, preparing to copy input params */
  if( !(fun2 = FunOpen(oname, omode, fun)) )
    gerror(stderr, "can't FunOpen output file: %s\n", oname);

  /* get required information from funtools structure */
  if( type != FORCE_IMAGE )
    FunInfoGet(fun, FUN_TYPE, &type, FUN_SECT_DIM2, &dim2,
	       FUN_SECT_BITPIX, &ibitpix, 0);

  switch(type){
  case FUN_IMAGE:
  case FUN_ARRAY:
    /* if input data is int */
    if( ibitpix >= 0 ){
      /* start by assuming we don't want to apply bscale ... */
      doscale = 0;
      if( mode && *mode ){
	tmode = xstrdup(mode);
	/* but if output data is float, we will apply bscale */
	if( _FunKeyword(tmode, "bitpix", NULL, tbuf, SZ_LINE) ){
	  if( (i=atoi(tbuf)) < 0 ){
	    /* apple bscale */
	    doscale=1;
	  }
	}
	if( tmode ) xfree(tmode);
      }
    }
    /* for float data, we apply bscale (won't actually happen) */
    else{
      doscale = 1;
    }
    if( !doscale ){
      if( mode && *mode ){
	mode = xrealloc(mode, strlen(mode)+SZ_LINE);
	strcat(mode, ",bscale=false");
      }
      else{
	mode = xstrdup("bscale=false");
      }
    }
    buf = NULL;
    for(i=1; i<=dim2; i++){
      /* extract and bin the data section into an image buffer */
      if( !(buf = FunImageRowGet(fun, buf, i, i, mode)) )
	gerror(stderr, "can't FunImageRowGet: %s\n", iname);
      /* write output image, updating the FITS header from the orig file */
      if( !FunImageRowPut(fun2, buf, i, i, 0, 0, 0, NULL) )
	gerror(stderr, "can't FunImageRowPut: %s\n", oname);
    }
    break;
 
  case FUN_TABLE:
  case FUN_EVENTS:
  case FORCE_IMAGE:
    /* extract and bin the data section into an image buffer */
    if( !(buf = FunImageGet(fun, NULL, mode)) )
      gerror(stderr, "can't FunImageGet: %s\n", iname);
    /* write the output image, updating the FITS header from the orig file */
    if( !FunImagePut(fun2, buf, 0, 0, 0, NULL) )
      gerror(stderr, "can't FunImagePut: %s\n", oname);
    break;
  }

  /* we can explicitly flush remaining extensions that need copying ... */
  FunFlush(fun2, "copy=remaining");

  /* ... since we already flushed, we can close files in any order */
  FunClose(fun);
  FunClose(fun2);

  /* free up space */
  if( buf ) xfree(buf);
  if( mode ) xfree(mode);

  return(0);
}
