// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colormap_h__
#define __colormap_h__

#include <iostream>
#include <fstream>
#include <sstream>
using namespace std;

#include "itt.h"

// ColorMapInfo

class ColorMapInfo {
protected:
  int id;
  char* name;
  char* fileName;
  ColorMapInfo* next;

public:
  ColorMapInfo();
  virtual ~ColorMapInfo();

  const char* getName() {return name;}
  int getID() {return id;}
  void setName(const char*);
  const char* getFileName() {return fileName;}
  void setFileName(const char*);
  
  ColorMapInfo* getNext() {return next;}
  void setNext(ColorMapInfo* c) {next = c;}

  virtual int load() =0;
  virtual int save(const char*) =0;
  virtual void setITT(ITT* t) {} // most colormaps do not use ITTs

  virtual unsigned char getRedChar(int, int) =0;
  virtual unsigned char getGreenChar(int, int) =0;
  virtual unsigned char getBlueChar(int, int) =0;

  virtual unsigned short getRedShrt(int, int) =0;
  virtual unsigned short getGreenShrt(int, int) =0;
  virtual unsigned short getBlueShrt(int, int) =0;
};

#endif

