// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __itt_h__
#define __itt_h__

#include <iostream>
#include <fstream>
using namespace std;

class ITT {
private:
  int id;
  char* name;
  char* fileName;
  ITT* next;
  int size;
  float* values;

public:
  ITT();
  ~ITT();

  float operator[](int);

  int getID() {return id;}
  const char* getName() {return name;}
  void setName(const char*);
  const char* getFileName() {return fileName;}
  void setFileName(const char*);
  int getSize() {return size;}
  
  ITT* getNext() {return next;}
  void setNext(ITT* c) {next = c;}

  int load();

  friend ostream& operator<<(ostream&, ITT&);
};

#endif

