// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "analysis.h"

FitsAnalysis::FitsAnalysis(FitsFile* src)
{
  primary_ = src->primary();
  managePrimary_ = 0;

  head_ = new FitsHead(*(src->head()));
  manageHead_ = 1;

  ext_ = src->ext();
  inherit_ = src->inherit();
  byteswap_ = 0;

  // change bitpix to float
  head_->setInteger("BITPIX", -32, "");
  head_->updateHDU();

  int width = head_->naxis(1);
  int height = head_->naxis(2);

  // alloc memory
  off_t size = width * height;
  data_ = new float[size];
  if (!data_)
    return;

  // clear memory
  memset(data_, '\0', size * sizeof(float));

  // made it this far, must be valid
  valid_ = 1;
}

FitsAnalysis::~FitsAnalysis()
{
  if (data_)
    delete (char*)data_;
}

