// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __line_h__
#define __line_h__

#include "baseline.h"

class Line : public BaseLine {
protected:
  int p1Arrow;
  int p2Arrow;

  void render(Drawable, const Matrix&, RenderMode);

public:
  Line(const Line&);
  Line(FrameBase* p, const Vector& ptr1,
       const Vector& ptr2,
       int a1, int a2,
       const char* clr, int wth, const char* fnt, const char* txt,
       unsigned short prop, const char* cmt, 
       const List<Tag>& tg, const List<CallBack>& cb);

  virtual Marker* dup() {return new Line(*this);}

  virtual void updateBBox();

  void ps(int);
  int isIn(const Vector&);

  void setArrows(int,int);
  int getP1Arrow() {return p1Arrow;}
  int getP2Arrow() {return p2Arrow;}

  virtual void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  virtual void listPost(ostream&, int, int);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
};

#endif
