use strict;

my $infile = "hmm.txt";
my $outfile = "SettingsPlayers";

sub pointSize
{
	my $result = "";
	my ($x, $y, $w, $h) = @_;
	my $factor = 1.5;

	$result .= "wxPoint((int) ";
	$result .= $x * $factor;
	$result .= ", (int) ";
	$result .= $y * $factor;
	$result .= ")";

	if (defined $w)
	{
		$result .= ", ";	
		$result .= "wxSize((int) ";	
		$result .= $w * $factor;
		$result .= ", (int) ";
		$result .= $h * $factor;
		$result .= ")";
	}
	return $result;
};

open (IN, $infile) || die;
my @filelines = <IN>;
close (IN);

my @controllines = ();
my $last = "";
foreach (@filelines)
{
	chomp;
	if (substr($_, 5, 1) eq " ")
	{
		$last .= $_;
	}
	else
	{
		push @controllines, $last if ($last ne "");
		$last = $_;
	}
}
push @controllines, $last if ($last ne "");


my @ids = ();
my @names = ();
open (OUT, ">$outfile.cpp") || die;
print OUT "// WARNING: This was autogenerated from a windows .rc file!!\n";
print OUT "// Do not edit directly\n\n";
print OUT "#include \"$outfile-def.cpp\"\n";
print OUT "\n";
print OUT "static void createControls(wxWindow *parent)\n{\n";
foreach (@controllines)
{
	my ($tmp, $control) = split(/\s+/);
	s/\s+$control\s+//;
	my @parts = split(/,/);
	for (my $i=0; $i<=$#parts; $i++)
	{
		$parts[$i] =~ s/^\s+//;
		$parts[$i] =~ s/\s+$//;
	}

	print $control."\n";
	if ($control eq "CONTROL")
	{
		if ($parts[3] =~ "BS_AUTOCHECKBOX")
		{
			push @ids, $parts[1];
			push @names, "wxCheckBox *$parts[1]_CTRL";
			print OUT "\t$parts[1]_CTRL = \n\t\tnew wxCheckBox(parent, $parts[1],\n\t\t$parts[0],\n\t\t";
			print OUT pointSize($parts[4], $parts[5]);
			print OUT ");\n";
		}
		elsif ($parts[3] =~ "BS_AUTORADIOBUTTON")
		{
			push @ids, $parts[1];
			push @names, "wxRadioButton *$parts[1]_CTRL";
			print OUT "\t$parts[1]_CTRL = \n\t\tnew wxRadioButton(parent, $parts[1],\n\t\t$parts[0],\n\t\t";
			print OUT pointSize($parts[4], $parts[5]);
			print OUT ");\n";
		}
		elsif ($parts[3] =~ "TBS_AUTOTICKS")
		{
			push @ids, $parts[1];
			push @names, "wxSlider *$parts[1]_CTRL";
			print OUT "\t$parts[1]_CTRL = \n\t\tnew wxSlider(parent, $parts[1],\n\t\t0,0,0,\n\t\t";
			print OUT pointSize($parts[4], $parts[5], $parts[6], $parts[7]);
			print OUT ",\n\t\twxSL_HORIZONTAL | wxSL_AUTOTICKS);\n";		

		}
		elsif ($parts[3] =~ "LVS_REPORT")
		{
			push @ids, $parts[1];
			push @names, "wxListCtrl *$parts[1]_CTRL";
			print OUT "\t$parts[1]_CTRL = \n\t\tnew wxListCtrl(parent, $parts[1],\n\t\t";
			print OUT pointSize($parts[4], $parts[5], $parts[6], $parts[7]);
			print OUT ",\n\t\twxLC_REPORT | wxLC_HRULES | wxLC_VRULES);\n";		

		}
		elsif ($parts[3] =~ "WS_BORDER")
		{
			push @ids, $parts[1];
			push @names, "wxGauge *$parts[1]_CTRL";
			print OUT "\t$parts[1]_CTRL = \n\t\tnew wxGauge(parent, $parts[1], 0,\n\t\t";
			print OUT pointSize($parts[4], $parts[5], $parts[6], $parts[7]);
			print OUT ");\n";		

		}
		else
		{
			print ">>$_<<\n";
			die ("Part: ".$parts[3]);
		}
	}
	elsif ($control eq "GROUPBOX")
	{
		print OUT "\tnew wxStaticBox(parent, -1,\n\t\t$parts[0],\n\t\t";
		print OUT pointSize($parts[2], $parts[3], $parts[4], $parts[5]);
		print OUT ");\n";
	}
	elsif ($control eq "LTEXT")
	{
		print OUT "\tnew wxStaticText(parent, -1,\n\t\t$parts[0],\n\t\t";
		print OUT pointSize($parts[2], $parts[3], $parts[4], $parts[5]);
		print OUT ");\n";
	}
	elsif ($control eq "COMBOBOX")
	{
		push @ids, $parts[0];
		push @names, "wxComboBox *$parts[0]_CTRL";
		print OUT "\t$parts[0]_CTRL = \n\t\tnew wxComboBox(parent, $parts[0],\n\t\t\"\",\n\t\t";
		print OUT pointSize($parts[1], $parts[2], $parts[3], $parts[4]);
		print OUT ",\n\t\t0, 0, wxCB_READONLY);\n";
	}
	elsif ($control eq "EDITTEXT")
	{
		push @ids, $parts[0];
		push @names, "wxTextCtrl *$parts[0]_CTRL";
		print OUT "\t$parts[0]_CTRL = \n\t\tnew wxTextCtrl(parent, $parts[0],\n\t\t\"\",\n\t\t";
		print OUT pointSize($parts[1], $parts[2], $parts[3], $parts[4]);
		print OUT ");\n";
	}
	elsif ($control eq "DEFPUSHBUTTON" or $control eq "PUSHBUTTON")
	{
		my $type = "wxButton";
		$type = "wxBitmapButton" if ($_ =~ /BS_BITMAP/);

		push @ids, $parts[1] if ($parts[1] ne "IDOK" and $parts[1] ne "IDCANCEL");
		push @names, "$type *$parts[1]_CTRL";	

		my $id = $parts[1];
		$id = "wxID_OK" if ($parts[1] eq "IDOK");
		$id = "wxID_CANCEL" if ($parts[1] eq "IDCANCEL");

		if ($_ !~ /BS_BITMAP/)
		{
			print OUT "\t$parts[1]_CTRL = \n\t\tnew $type(parent, $id,\n\t\t$parts[0],\n\t\t";
			print OUT pointSize($parts[2], $parts[3], $parts[4], $parts[5]);
			print OUT ");\n";	
		}
		else
		{
			print OUT "\twxBitmap map;\n";
			print OUT "\t$parts[1]_CTRL = \n\t\tnew $type(parent, $id,\n\t\tmap,\n\t\t";
			print OUT pointSize($parts[2], $parts[3], $parts[4], $parts[5]);
			print OUT ");\n";
		}
	}
	else
	{
		print ">>$_<<\n";
		die ("Control : ".$control);		
	}
}
print OUT "}\n\n";
close (OUT);

open (OUT, ">$outfile-def.cpp") || die;
print OUT "enum\n{\n";
for (my $i=0; $i<=$#ids; $i++)
{
	print OUT "\t".$ids[$i];
	print OUT " = 1" if ($i == 0);
	print OUT "," if ($i < $#ids);
	print OUT "\n";
}
print OUT "};\n\n";
foreach (@names)
{
	print OUT "static $_ = 0;\n";
}
close (OUT);
