/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/


#ifndef SRKMETAINFODIALOG_H
#define SRKMETAINFODIALOG_H

#include <string>

#include "srkmetainfodialogbase.h"

using namespace std;

class ISDRecordingMetaInfo;
class SRKPlatformComboBox;
class SRKCategoryComboBox;

class SRKMetaInfoDialog : public SRKMetaInfoDialogBase
{
  Q_OBJECT

  public:
    SRKMetaInfoDialog(ISDRecordingMetaInfo* metaInfo, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
    virtual ~SRKMetaInfoDialog();

public slots:

protected slots:
    virtual void platformChanged(const QString&, SRKPlatformComboBox*);
    virtual void categoryChanged(const QString&, SRKCategoryComboBox*);
    virtual void reject();
    virtual void accept();

protected:
    //-----DEFINITIONS-----
    enum WSErrorCodes {
	WS_CATEGORY_ERROR,
	WS_PLATFORM_ERROR
    };

    //-----METHODS-----
    void initPlatformCombos();
    void initCategoryCombos();
    void webserviceError(WSErrorCodes type, string errorString);

    //-----VARIABLES-----
    ISDRecordingMetaInfo* metaInfo;
};

#endif

