/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef SRKPLATFORMCOMBOBOX_H
#define SRKPLATFORMCOMBOBOX_H

/**
 * Combobox that is used in the SRKMetaInfoDialog class.
 * It displays the different platform-options, as fetched from the 
 * Instrudeo webservice. The combobox can have child-comboboxes,
 * so that they form a linked list of platform-choices.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <vector>

#include <kcombobox.h>

#include <libinstrudeo/isdwsplatform.h>

class SRKPlatformComboBox : public KComboBox
{
    Q_OBJECT
    
  public:
    //----CONSTRUCTORS-----
    SRKPlatformComboBox(QWidget* parent=0, const char* name=0);
    virtual ~SRKPlatformComboBox();
    
    //-----METHODS-----
    /**
     * Returns the child combobox of  this combobox.
     *
     * @return The child combobox or NULL if none is set.
     */
    SRKPlatformComboBox* getChildBox();

    /**
     * Sets the child combobox of this combobox.
     *
     * @param child The child combobox.
     */
    void setChildBox(SRKPlatformComboBox* child);

    /**
     * Deletes all child comboboxes, recursively.
     * This objects are destroyed and set to NULL.
     */
    void deleteChildBoxes();
    
    //Use following functions instead of "insertItem" & co.

    /**
     * Adds a platform to the combobox.
     * Use this instead of KComboBox::insertItem()
     *
     * @param c The new platform or NULL to add an empty choice.
     */
    void addChoice(ISDWSPlatform* c);

    /**
     * Removes the specified platform from this combobox.
     * If the platform isn't present, nothing happens.
     $ The platforms are matched by ID.
     * Use this instead of KComboBox::removeItem()
     *
     * @param c The platform to remove.
     */
    void removeChoice(ISDWSPlatform* c);
    
    /**
     * Returns the selected platform.
     * Use this instead of KComboBox::currentItem()
     *
     * @return The currently selected combobox. Can be NULL.
     */
    ISDWSPlatform* getCurrentSelection();

    /**
     * Sets the current selected platform.
     * If c isn't present, nothing happens.
     *
     * @param c The platform to select.
     */
    void setCurrentSelection(ISDWSPlatform* c);
    
  protected slots:
    void slotActivated(const QString&);
    
  signals:
    void activated(const QString&, SRKPlatformComboBox*);
    
  protected:
    SRKPlatformComboBox* childBox;
    /**
     * Note: this list must be kept synchronized with the items in the combobox.
     */
    vector<ISDWSPlatform*> platformList;
};

#endif
