
/*
 * Copyright (c) 1999-2006, Regents of the University of California
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *  Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 * 
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 
 *  Neither the name of the University of California, Berkeley nor the
 *  names of its contributors may be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * Automatically generated library file nsys

 * The drivers embedded in this file may be covered by a different
 * license.  Scroll down to see the license appearing before each
 * driver, or see sfront/src/lib/ directories for driver source file.

 */

#include "tree.h"



void makenet_sfront(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Sfront-specific network functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           receives RTP, RTCP, and SIP packets                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_newdata(void) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct sockaddr_in ipaddr;";
  z[lc++]="  unsigned long ssrc;";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  int len;";
  z[lc++]="  unsigned char packet[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned char digest[NSYS_MD5_LENGTH];";
  z[lc++]="  unsigned char sysbuff[NSYS_NETIN_SYSBUFF];";
  z[lc++]="  unsigned char * p, * pmax;";
  z[lc++]="  unsigned char  ptype;";
  z[lc++]="  unsigned short mlen;";
  z[lc++]="  unsigned char cmd, oldcmd;";
  z[lc++]="  unsigned char ndata = 0;";
  z[lc++]="  unsigned char vdata = 0;";
  z[lc++]="  unsigned int fromlen = sizeof(struct sockaddr);";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int has_ts, dsize, rtpcode, jcode, fec, sysidx, skip;";
  z[lc++]="  int nopacket = 1;";
  z[lc++]="  unsigned short status;";
  z[lc++]="  int fd = nsys_rtp_fd;";
  z[lc++]="";
  z[lc++]="  nsys_bufflen = nsys_buffcnt = 0;";
  z[lc++]="";
  z[lc++]="  nsys_netout_tstamp += ACYCLE;";
  z[lc++]="";
  z[lc++]="  if (nsys_netout_jsend_guard_time && ((--nsys_netout_jsend_guard_time) == 0))";
  z[lc++]="    nsys_netout_guard_tick();";
  z[lc++]=" ";
  z[lc++]="  while (1)";
  z[lc++]="    {";
  z[lc++]="      if ((len = recvfrom(fd, packet, NSYS_UDPMAXSIZE, 0, ";
  z[lc++]="			  (struct sockaddr *)&ipaddr, &fromlen)) <= 0)";
  z[lc++]="	{";
  z[lc++]="";
  z[lc++]="	  if ((errno == EAGAIN) && (fd == nsys_rtcp_fd))";
  z[lc++]="	    {";
  z[lc++]="	      if (nopacket && (time(NULL) > nsys_nexttime))";
  z[lc++]="		{";
  z[lc++]="		  nsys_netout_rtcptime();		  ";
  z[lc++]="		  if (nsys_powerup_mset)";
  z[lc++]="		    nsys_netin_clear_mset(nsys_buff, &nsys_bufflen, ";
  z[lc++]="					  NSYS_BUFFSIZE);";
  z[lc++]="		}";
  z[lc++]="	      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if ((errno == EAGAIN) && (fd == nsys_rtp_fd))";
  z[lc++]="	    {";
  z[lc++]="	      fd = nsys_rtcp_fd;";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  if (errno == EINTR)";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries: nsys_netin_newdata\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error reading Internet socket\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  /*****************/";
  z[lc++]="	  /* RTP fast path */";
  z[lc++]="	  /*****************/";
  z[lc++]="";
  z[lc++]="	  nopacket = 0;";
  z[lc++]="";
  z[lc++]="	  if ((fd == nsys_rtp_fd) && ";
  z[lc++]="	      (packet[NSYS_RTPLOC_BYTE1] == NSYS_RTPVAL_BYTE1))";
  z[lc++]="	    {	      ";
  z[lc++]="";
  z[lc++]="	      /*****************************************/";
  z[lc++]="	      /* parse top of header to extract fields */";
  z[lc++]="	      /*****************************************/";
  z[lc++]="";
  z[lc++]="	      if ((len < NSYS_RTPLEN_HDR) || (len <= NSYS_RTPSIZE_DIGEST))";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"Ignoring truncated RTP packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if ((packet[NSYS_RTPLOC_PTYPE] & NSYS_RTPVAL_CHKMARK) == 0)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"Marker bit not set, ignoring packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      ssrc = ntohl(*((unsigned long *)&(packet[NSYS_RTPLOC_SSRC])));";
  z[lc++]="	      ptype = packet[NSYS_RTPLOC_PTYPE] & NSYS_RTPVAL_CLRMARK;";
  z[lc++]="	      sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="	      ";
  z[lc++]="	      while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="		sptr = sptr->xtra;";
  z[lc++]="	      ";
  z[lc++]="	      if (!sptr)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"RTP packet from unknown source\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (((ipaddr.sin_addr.s_addr != sptr->rtp_addr->sin_addr.s_addr) ||";
  z[lc++]="		  (ipaddr.sin_port != sptr->rtp_addr->sin_port)) && ";
  z[lc++]="		  (sptr->alt_rtp_addr == NULL))";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"RTP packet from unknown IP/port\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /*********************/";
  z[lc++]="	      /* do authentication */";
  z[lc++]="	      /*********************/";
  z[lc++]="";
  z[lc++]="	      len -= NSYS_RTPSIZE_DIGEST;";
  z[lc++]="";
  z[lc++]="	      if (nsys_msession)";
  z[lc++]="		memcpy(&(packet[NSYS_RTPLOC_SSRC]), &nsys_myssrc_net, ";
  z[lc++]="		       sizeof(long));";
  z[lc++]="";
  z[lc++]="	      nsys_hmac_md5(packet, len, nsys_keydigest, digest);";
  z[lc++]="";
  z[lc++]="	      if (memcmp(&(packet[len]), digest, NSYS_RTPSIZE_DIGEST))";
  z[lc++]="		{		  ";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"Discarding unauthorized RTP packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /******************/";
  z[lc++]="	      /* process packet */";
  z[lc++]="	      /******************/";
  z[lc++]="";
  z[lc++]="	      if (ptype != sptr->ptype)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"RTP packet with incorrect ptype\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (sptr->alt_rtp_addr)";
  z[lc++]="		{";
  z[lc++]="		  if ((ipaddr.sin_addr.s_addr != nsys_sip_rtp_inet_addr) ||";
  z[lc++]="		      (ipaddr.sin_port != nsys_sip_rtp_sin_port))";
  z[lc++]="		    {";
  z[lc++]="		      /* normal case */";
  z[lc++]="";
  z[lc++]="		      memcpy(sptr->rtp_addr,&ipaddr,sizeof(struct sockaddr_in));";
  z[lc++]="		    }";
  z[lc++]="		  else";
  z[lc++]="		    {";
  z[lc++]="		      /* source-forge trick which may later be implemented */";
  z[lc++]="";
  z[lc++]="		      memcpy(sptr->rtp_addr, &(sptr->alt_rtp_addr), ";
  z[lc++]="			     sizeof(struct sockaddr_in));";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  free(sptr->alt_rtp_addr);";
  z[lc++]="		  sptr->alt_rtp_addr = NULL;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      rtpcode = nsys_netin_rtpstats(sptr, packet);";
  z[lc++]="";
  z[lc++]="	      if (rtpcode == NSYS_RTPCODE_SECURITY)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"Possible RTP replay attack\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if ((len -= NSYS_RTPLEN_HDR) == 0)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"RTP payload empty\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      p = packet + NSYS_RTPLEN_HDR;";
  z[lc++]="	      fec = (*p) & NSYS_SM_CHKJ;";
  z[lc++]="";
  z[lc++]="	      if ((rtpcode == NSYS_RTPCODE_DISCARD) && fec)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"Out of order RTP packet\");";
  z[lc++]="		  continue;        ";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if ((rtpcode != NSYS_RTPCODE_NORMAL) && fec)";
  z[lc++]="		{";
  z[lc++]="";
  z[lc++]="		  jcode = nsys_netin_journal_recovery(sptr, rtpcode, p, len,";
  z[lc++]="						      nsys_buff, &nsys_bufflen,";
  z[lc++]="						      NSYS_BUFFSIZE);";
  z[lc++]="		  if (jcode == NSYS_JOURNAL_CORRUPTED)";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, \"RTP journal corrupt\");";
  z[lc++]="		      continue;";
  z[lc++]="		    }";
  z[lc++]="		  if (jcode == NSYS_JOURNAL_FILLEDBUFF)";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, \"RTP journal too big\");";
  z[lc++]="		      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /* NSYS_JOURNAL_RECOVERED falls through */";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /****************/";
  z[lc++]="	      /* RTP payload  */";
  z[lc++]="	      /****************/";
  z[lc++]="";
  z[lc++]="	      mlen = (*p) & NSYS_SM_MLENMASK;";
  z[lc++]="	      has_ts = (*p) & NSYS_SM_CHKZ;";
  z[lc++]="";
  z[lc++]="	      if ((*(p++)) & NSYS_SM_CHKB)";
  z[lc++]="		{";
  z[lc++]="		  if (!(--len))";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, \"RTP MIDI header truncation\");";
  z[lc++]="		      continue;            ";
  z[lc++]="		    }";
  z[lc++]="		  mlen = (*(p++)) + (mlen << 8);";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (!mlen)";
  z[lc++]="		continue;            ";
  z[lc++]="";
  z[lc++]="	      if (mlen > (--len))";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"RTP MIDI section truncation\");";
  z[lc++]="		  continue;            ";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      oldcmd = cmd = 0;";
  z[lc++]="	      pmax = p + mlen;";
  z[lc++]="";
  z[lc++]="	      while (p < pmax)";
  z[lc++]="		{";
  z[lc++]="		  if ((NSYS_BUFFSIZE - nsys_bufflen) < 4)";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="				   \"RTP journal truncated MIDI commands\");";
  z[lc++]="		      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);	";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /************************************************/";
  z[lc++]="		  /* delta-time skip-over, null command skip-over */";
  z[lc++]="		  /************************************************/";
  z[lc++]="";
  z[lc++]="		  if (has_ts)";
  z[lc++]="		    {";
  z[lc++]="		      dsize = 0;";
  z[lc++]="";
  z[lc++]="		      while ((*(p++)) & NSYS_SM_DTIME)";
  z[lc++]="			{";
  z[lc++]="			  dsize++;";
  z[lc++]="			  if (p >= pmax)";
  z[lc++]="			    break;";
  z[lc++]="			}";
  z[lc++]="			";
  z[lc++]="		      if (dsize > 3)";
  z[lc++]="			{";
  z[lc++]="			  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="				       \"RTP MIDI delta-time syntax error\");";
  z[lc++]="			  break;            ";
  z[lc++]="			}";
  z[lc++]="		      ";
  z[lc++]="		      if (p >= pmax)";
  z[lc++]="			break;        /* null-command skip-over */";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  has_ts = 1;";
  z[lc++]="";
  z[lc++]="		  /*********************************************/";
  z[lc++]="		  /* running status and MIDI System skip-overs */";
  z[lc++]="		  /*********************************************/";
  z[lc++]="";
  z[lc++]="		  if ((*p) >= CSYS_MIDI_NOTEOFF)";
  z[lc++]="		    {";
  z[lc++]="		      oldcmd = cmd;";
  z[lc++]="		      if (((*p) != CSYS_MIDI_SYSTEM_SYSEX_START) &&";
  z[lc++]="			  ((*p) != CSYS_MIDI_SYSTEM_SYSEX_END))";
  z[lc++]="			cmd = (*(p++));";
  z[lc++]="		      else";
  z[lc++]="			{";
  z[lc++]="			  /* only parse unsegmented Sysex commands (for now) */";
  z[lc++]="			  ";
  z[lc++]="			  skip = ((*(p++)) != CSYS_MIDI_SYSTEM_SYSEX_START);";
  z[lc++]="";
  z[lc++]="			  if (!skip)";
  z[lc++]="			    {";
  z[lc++]="			      sysidx = 0;";
  z[lc++]="			      while ((p < pmax) &&";
  z[lc++]="				     (sysidx < NSYS_NETIN_SYSBUFF) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_SYSEX_START) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_SYSEX_END) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_UNUSED1) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="				sysbuff[sysidx++] = *(p++);";
  z[lc++]="			      ";
  z[lc++]="			      skip = (((*p) != CSYS_MIDI_SYSTEM_SYSEX_END) &&";
  z[lc++]="				      ((*p) != CSYS_MIDI_SYSTEM_UNUSED1) &&";
  z[lc++]="				      ((*p) != CSYS_MIDI_SYSTEM_UNUSED2));";
  z[lc++]="			      ";
  z[lc++]="			      if (!skip)";
  z[lc++]="				skip = nsys_sysex_parse(&cmd, &ndata, &vdata,";
  z[lc++]="							sysbuff, sysidx);";
  z[lc++]="			    }";
  z[lc++]="";
  z[lc++]="			  if (skip)";
  z[lc++]="			    {";
  z[lc++]="			      nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="					   \"unknown arbitrary-length \"";
  z[lc++]="					   \"System command in stream\");";
  z[lc++]="			      ";
  z[lc++]="			      cmd = 0;    /* cancel running status */";
  z[lc++]="";
  z[lc++]="			      while ((p < pmax) && ";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_SYSEX_START) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_SYSEX_END) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_UNUSED1) &&";
  z[lc++]="				     ((*p) != CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="				p++;";
  z[lc++]="			      ";
  z[lc++]="			      if (p < pmax)";
  z[lc++]="				p++;";
  z[lc++]="			      ";
  z[lc++]="			      continue;   /* process next command in list */";
  z[lc++]="			    }";
  z[lc++]="";
  z[lc++]="			  if (p < pmax)";
  z[lc++]="			    p++;         /* skip sysex terminator */";
  z[lc++]="			}";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  if (cmd == 0)";
  z[lc++]="		    {";
  z[lc++]="		      while ((p < pmax) && ((*p) < CSYS_MIDI_NOTEOFF))";
  z[lc++]="			p++;";
  z[lc++]="";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, \"RTP running status error\");";
  z[lc++]="		      continue;                     ";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /**************************************************/";
  z[lc++]="		  /* skip late NoteOn commands w/ non-zero velocity */";
  z[lc++]="		  /**************************************************/";
  z[lc++]="";
  z[lc++]="		  if ((sptr->ontime == 0) &&";
  z[lc++]="		      ((0xF0u & cmd) == CSYS_MIDI_NOTEON) && p[1])";
  z[lc++]="		    {";
  z[lc++]="		      p += 2;";
  z[lc++]="		      continue;";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /**********************************************/";
  z[lc++]="		  /* put new command in buffer, track its state */";
  z[lc++]="		  /**********************************************/";
  z[lc++]="";
  z[lc++]="		  nsys_buff[nsys_bufflen++] = cmd;";
  z[lc++]="";
  z[lc++]="		  if (((0xF0u & cmd) < CSYS_MIDI_SYSTEM) && (cmd >= CSYS_MIDI_NOTEOFF))";
  z[lc++]="		    {";
  z[lc++]="		      if (p < pmax)";
  z[lc++]="			nsys_buff[nsys_bufflen++] = (ndata = *(p++));";
  z[lc++]="		      if (((0xF0u & cmd) != CSYS_MIDI_PROGRAM) && ";
  z[lc++]="			  ((0xF0u & cmd) != CSYS_MIDI_CTOUCH) && (p < pmax))";
  z[lc++]="			nsys_buff[nsys_bufflen++] = (vdata = *(p++));";
  z[lc++]="		    }";
  z[lc++]="		  else";
  z[lc++]="		    {";
  z[lc++]="		      if (cmd >= CSYS_MIDI_SYSTEM)";
  z[lc++]="			{";
  z[lc++]="			  if ((cmd == CSYS_MIDI_SYSTEM_QFRAME) || ";
  z[lc++]="			      (cmd == CSYS_MIDI_SYSTEM_SONG_SELECT) ||";
  z[lc++]="			      (cmd == CSYS_MIDI_SYSTEM_SONG_PP))";
  z[lc++]="			    {";
  z[lc++]="			      if (p < pmax)";
  z[lc++]="				nsys_buff[nsys_bufflen++] = (ndata = *(p++));";
  z[lc++]="			      if ((cmd == CSYS_MIDI_SYSTEM_SONG_PP) && (p < pmax))";
  z[lc++]="				nsys_buff[nsys_bufflen++] = (vdata = *(p++));";
  z[lc++]="			    }";
  z[lc++]="";
  z[lc++]="			  if ((cmd == CSYS_MIDI_SYSTEM_UNUSED1) ||";
  z[lc++]="			      (cmd == CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="			    {";
  z[lc++]="			      ndata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="			      vdata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="";
  z[lc++]="			      if ((p < pmax) && ((*p) < CSYS_MIDI_NOTEOFF))";
  z[lc++]="				nsys_buff[nsys_bufflen++] = (ndata = *(p++));";
  z[lc++]="			      if ((p < pmax) && ((*p) < CSYS_MIDI_NOTEOFF))";
  z[lc++]="				nsys_buff[nsys_bufflen++] = (vdata = *(p++));";
  z[lc++]="";
  z[lc++]="			      while ((p < pmax) && ((*p) < CSYS_MIDI_NOTEOFF))";
  z[lc++]="				p++;";
  z[lc++]="			      if ((p < pmax) && ((*p) == CSYS_MIDI_SYSTEM_SYSEX_END))";
  z[lc++]="				p++;";
  z[lc++]="			    }";
  z[lc++]="			}";
  z[lc++]="		      else";
  z[lc++]="			switch(cmd) {";
  z[lc++]="			case CSYS_MIDI_GMRESET:";
  z[lc++]="			  nsys_buff[nsys_bufflen++] = ndata; ";
  z[lc++]="			  break;";
  z[lc++]="			case CSYS_MIDI_MVOLUME:";
  z[lc++]="			case CSYS_MIDI_MANUEX:";
  z[lc++]="			  nsys_buff[nsys_bufflen++] = ndata; ";
  z[lc++]="			  nsys_buff[nsys_bufflen++] = vdata; ";
  z[lc++]="			  break;";
  z[lc++]="			}";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  if (fec)";
  z[lc++]="		    nsys_netin_journal_trackstate(sptr, cmd, ndata, vdata);";
  z[lc++]="";
  z[lc++]="		  if (cmd >= CSYS_MIDI_SYSTEM_CLOCK)";
  z[lc++]="		    cmd = oldcmd;  /* real-time does not cancel running status */";
  z[lc++]="		  else";
  z[lc++]="		    if ((cmd >= CSYS_MIDI_SYSTEM) || (cmd < CSYS_MIDI_NOTEOFF))";
  z[lc++]="		      cmd = 0;   /* system common cancels running status */";
  z[lc++]="		  ";
  z[lc++]="		  nsys_buff[nsys_bufflen++] = sptr->mset;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /* if no room left for another MIDI command, leave */";
  z[lc++]="	      ";
  z[lc++]="	      if ((NSYS_BUFFSIZE - nsys_bufflen) < NSYS_SM_EXPANDMAX)";
  z[lc++]="		return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /***********************/";
  z[lc++]="	  /* handle RTCP packets */";
  z[lc++]="	  /***********************/";
  z[lc++]="";
  z[lc++]="	  if ((fd == nsys_rtcp_fd) && ";
  z[lc++]="	      (NSYS_RTCPVAL_BYTE1 == (packet[NSYS_RTCPLOC_BYTE1] ";
  z[lc++]="				      & NSYS_RTCPVAL_COOKIEMASK)))";
  z[lc++]="	    {";
  z[lc++]="	      if ((len -= NSYS_RTPSIZE_DIGEST) <= 0)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP packet truncated\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="	      ";
  z[lc++]="	      if (nsys_msession)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(&ssrc, &(packet[NSYS_RTCPLOC_SSRC]), sizeof(long));";
  z[lc++]="		  memcpy(&(packet[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, ";
  z[lc++]="			 sizeof(long));";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      nsys_hmac_md5(packet, len, nsys_keydigest, digest);";
  z[lc++]="";
  z[lc++]="	      if (memcmp(&(packet[len]), digest, NSYS_RTPSIZE_DIGEST))";
  z[lc++]="		{		  ";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"Discarding unauthorized RTCP packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (nsys_msession)";
  z[lc++]="		memcpy(&(packet[NSYS_RTCPLOC_SSRC]), &ssrc, sizeof(long));";
  z[lc++]="	      ";
  z[lc++]="	      sptr = nsys_netin_rtcp(packet, len, &ipaddr);";
  z[lc++]="";
  z[lc++]="	      if (nsys_feclevel)";
  z[lc++]="		nsys_netin_journal_trimstate(sptr);";
  z[lc++]="	";
  z[lc++]="	      if (nsys_powerup_mset)";
  z[lc++]="		{";
  z[lc++]="		  nsys_netin_clear_mset(nsys_buff, &nsys_bufflen,";
  z[lc++]="					NSYS_BUFFSIZE);";
  z[lc++]="		  if ((NSYS_BUFFSIZE - nsys_bufflen) < NSYS_SM_EXPANDMAX)";
  z[lc++]="		    return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="		}";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  /***********************/";
  z[lc++]="	  /* handle SIP packets  */";
  z[lc++]="	  /***********************/";
  z[lc++]="";
  z[lc++]="	  packet[len] = '\\0';  /* null-terminate string */";
  z[lc++]="";
  z[lc++]="	  if (sscanf((char *) packet, \"SIP/2.0 %hu\", &status) == 1)";
  z[lc++]="	    nsys_netin_reply(fd, &ipaddr, packet, status);";
  z[lc++]="	  else";
  z[lc++]="	    if (packet[NSYS_RTPLOC_BYTE1] == 'I')";
  z[lc++]="	      {";
  z[lc++]="		nsys_netin_invite(fd,  &ipaddr, packet);";
  z[lc++]="		if (nsys_powerup_mset)";
  z[lc++]="		  {";
  z[lc++]="		    nsys_netin_clear_mset(nsys_buff, &nsys_bufflen,";
  z[lc++]="					  NSYS_BUFFSIZE);";
  z[lc++]="		    if ((NSYS_BUFFSIZE - nsys_bufflen) < NSYS_SM_EXPANDMAX)";
  z[lc++]="		      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	}";
  z[lc++]="    } ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          returns the next network MIDI command               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_midievent(unsigned char * cmd, unsigned char * ndata,";
  z[lc++]="                    unsigned char * vdata, unsigned short * extchan)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *cmd = nsys_buff[nsys_buffcnt];";
  z[lc++]="";
  z[lc++]="  if (((*cmd) < CSYS_MIDI_SYSTEM) && ((*cmd) >= CSYS_MIDI_NOTEOFF))";
  z[lc++]="    {";
  z[lc++]="      *extchan = 0x0Fu & nsys_buff[nsys_buffcnt++];";
  z[lc++]="      *ndata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="";
  z[lc++]="      if ((((*cmd) & 0xF0u) != CSYS_MIDI_PROGRAM) && ";
  z[lc++]="	  (((*cmd) & 0xF0u) != CSYS_MIDI_CTOUCH))";
  z[lc++]="	*vdata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      *extchan = 0;";
  z[lc++]="      nsys_buffcnt++;  /* skip over command octet */";
  z[lc++]="";
  z[lc++]="      if ((*cmd) >= CSYS_MIDI_NOTEOFF)";
  z[lc++]="	{";
  z[lc++]="	  if ((*cmd) < CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	    {";
  z[lc++]="	      if (((*cmd) == CSYS_MIDI_SYSTEM_QFRAME) || ";
  z[lc++]="		  ((*cmd) == CSYS_MIDI_SYSTEM_SONG_SELECT) ||";
  z[lc++]="		  ((*cmd) == CSYS_MIDI_SYSTEM_SONG_PP))";
  z[lc++]="		*ndata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="	      ";
  z[lc++]="	      if ((*cmd) == CSYS_MIDI_SYSTEM_SONG_PP)";
  z[lc++]="		*vdata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="";
  z[lc++]="	      if ((*cmd == CSYS_MIDI_SYSTEM_UNUSED1) || ";
  z[lc++]="		  (*cmd == CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="		{";
  z[lc++]="		  /* logic: don't take mset octet */";
  z[lc++]="		  /*   assumes 0 <= mset <= 127   */";
  z[lc++]=" ";
  z[lc++]="		  if (((nsys_buffcnt + 1) < nsys_bufflen) && ";
  z[lc++]="		      !(nsys_buff[nsys_buffcnt + 1] & 0x80u))";
  z[lc++]="		    *ndata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="		  else";
  z[lc++]="		    *ndata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="";
  z[lc++]="		  if (((nsys_buffcnt + 1) < nsys_bufflen) && ";
  z[lc++]="		      !(nsys_buff[nsys_buffcnt + 1] & 0x80u))";
  z[lc++]="		    *vdata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="		  else";
  z[lc++]="		    *vdata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  *ndata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="	  if ((*cmd) != CSYS_MIDI_GMRESET)";
  z[lc++]="	    *vdata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *extchan += (NSYS_NETSTART - CSYS_MIDI_NUMCHAN + ";
  z[lc++]="	       (nsys_buff[nsys_buffcnt++] << 4));";
  z[lc++]="";
  z[lc++]="  return (nsys_buffcnt == nsys_bufflen) ? NSYS_DONE : NSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              detects special System Exclusive commands      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_sysex_parse(unsigned char * cmd, unsigned char *ndata,";
  z[lc++]="		     unsigned char * vdata, unsigned char * sysbuff, ";
  z[lc++]="		     int sysidx)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  switch (sysidx) {";
  z[lc++]="  case 4:   ";
  z[lc++]="    if ((sysbuff[0] == 0x7Eu) && (sysbuff[1] == 0x7Fu) && ";
  z[lc++]="	(sysbuff[2] == 0x09u) && ";
  z[lc++]="	((sysbuff[3] == 0x01u) || (sysbuff[3] == 0x02u)))";
  z[lc++]="      {";
  z[lc++]="	*cmd = CSYS_MIDI_GMRESET;";
  z[lc++]="	*ndata = sysbuff[3];";
  z[lc++]="	return 0;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 6:   ";
  z[lc++]="    if ((sysbuff[0] == 0x7Fu) && (sysbuff[1] == 0x7Fu) &&";
  z[lc++]="	(sysbuff[2] == 0x04u) && (sysbuff[3] == 0x01u) &&";
  z[lc++]="	(sysbuff[4] < 0x80u)  && (sysbuff[5] < 0x80u))";
  z[lc++]="      {";
  z[lc++]="	*cmd = CSYS_MIDI_MVOLUME;";
  z[lc++]="	*ndata = sysbuff[4];";
  z[lc++]="	*vdata = sysbuff[5];";
  z[lc++]="	return 0;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 8:   ";
  z[lc++]="    if ((sysbuff[0] == 0x43u) && (sysbuff[1] == 0x73u) &&";
  z[lc++]="	(sysbuff[2] == 0x7Fu) && (sysbuff[3] == 0x32u) &&";
  z[lc++]="	(sysbuff[4] == 0x11u) && (sysbuff[5] < 0x80u) &&";
  z[lc++]="	(sysbuff[6] < 0x80u) && (sysbuff[7] < 0x80u))";
  z[lc++]="      {";
  z[lc++]="	*cmd = CSYS_MIDI_MANUEX;";
  z[lc++]="	*ndata = sysbuff[6];";
  z[lc++]="	*vdata = sysbuff[7];";
  z[lc++]="	return 0;";
  z[lc++]="      }";
  z[lc++]="    break; ";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return 1;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    sends RTP packets                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_midisend(unsigned char cmd, unsigned char ndata,";
  z[lc++]="		  unsigned char vdata, unsigned short extchan)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int jsize = 0;";
  z[lc++]="  unsigned char size, cbyte;";
  z[lc++]="  unsigned long tstamp;";
  z[lc++]="  unsigned short seqnum;";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  struct sockaddr * addr;";
  z[lc++]="  int alt = 0;";
  z[lc++]="  int jstart, dstart;";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* MIDI preprocessing */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  if ((cbyte = cmd & 0xF0u) < CSYS_MIDI_SYSTEM)";
  z[lc++]="    {";
  z[lc++]="      if (cbyte >= CSYS_MIDI_NOTEOFF)";
  z[lc++]="	{";
  z[lc++]="	  if ((cbyte != CSYS_MIDI_PROGRAM) && (cbyte != CSYS_MIDI_CTOUCH))";
  z[lc++]="	    size = 3;";
  z[lc++]="	  else";
  z[lc++]="	    size = 2;";
  z[lc++]="	  cmd = cbyte | (((unsigned char)extchan) & 0x0Fu);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	switch (cmd) {";
  z[lc++]="	case CSYS_MIDI_MANUEX:";
  z[lc++]="	  size = 10;";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_MVOLUME:";
  z[lc++]="	  size = 8;";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_GMRESET:";
  z[lc++]="	  size = 6;";
  z[lc++]="	  break;";
  z[lc++]="	default:";
  z[lc++]="	  size = 0;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (cmd != CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	{";
  z[lc++]="	  if ((cmd != CSYS_MIDI_SYSTEM_QFRAME) && (cmd != CSYS_MIDI_SYSTEM_SONG_SELECT)";
  z[lc++]="	      && (cmd != CSYS_MIDI_SYSTEM_SONG_PP))";
  z[lc++]="	    {";
  z[lc++]="	      size = 1;";
  z[lc++]="";
  z[lc++]="	      if ((cmd == CSYS_MIDI_SYSTEM_UNUSED1) || (cmd == CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="		size = 1 + ((ndata != CSYS_MIDI_SYSTEM_SYSEX_END) + ";
  z[lc++]="			    (vdata != CSYS_MIDI_SYSTEM_SYSEX_END)) + 1;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    size = (cmd != CSYS_MIDI_SYSTEM_SONG_PP) ? 2 : 3;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{ ";
  z[lc++]="	  if (nsys_feclevel)";
  z[lc++]="	    nsys_netout_journal_addhistory(cmd, ndata, vdata);";
  z[lc++]="	  return;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (nsys_msession && ";
  z[lc++]="      ((cbyte == CSYS_MIDI_NOTEON) || (cbyte == CSYS_MIDI_NOTEOFF)) && ";
  z[lc++]="      ((ndata += NSYS_MSESSION_INTERVAL) > 0x7Fu))";
  z[lc++]="    ndata = 0x7Fu;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* leave if no receivers */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((sptr = nsys_srcroot) == NULL)";
  z[lc++]="    { ";
  z[lc++]="      if (nsys_feclevel)";
  z[lc++]="	nsys_netout_journal_addhistory(cmd, ndata, vdata);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* fill in RTP header */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLOC_PTYPE] = sptr->ptype | nsys_netout_markbit;";
  z[lc++]="";
  z[lc++]="  tstamp = htonl((unsigned long)(nsys_netout_tstamp));";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_TSTAMP]), &tstamp, sizeof(long));";
  z[lc++]="";
  z[lc++]="  nsys_netout_seqnum = ((nsys_netout_seqnum != NSYS_RTPSEQ_HIGHEST) ?";
  z[lc++]="			(nsys_netout_seqnum + 1) : 1); ";
  z[lc++]="  seqnum = htons((unsigned short)(nsys_netout_seqnum & 0x0000FFFF));";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_SEQNUM]), &seqnum, ";
  z[lc++]="	 sizeof(short));";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill in command section of payload */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLEN_HDR] = size | nsys_netout_sm_header;";
  z[lc++]="";
  z[lc++]="  if (cbyte >= CSYS_MIDI_NOTEOFF)";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 1] = cmd;";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 2] = ndata;";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 3] = vdata;";
  z[lc++]="";
  z[lc++]="      if ((cmd == CSYS_MIDI_SYSTEM_UNUSED1) || (cmd == CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="	nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + size] = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    switch (cmd) {";
  z[lc++]="    case CSYS_MIDI_MANUEX:";
  z[lc++]="      memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 1]),";
  z[lc++]="	     nsys_netout_sysconst_manuex, size);";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 8] = ndata;";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 9] = vdata;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_MVOLUME:";
  z[lc++]="      memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 1]),";
  z[lc++]="	     nsys_netout_sysconst_mvolume, size);";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 6] = ndata;";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 7] = vdata;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_GMRESET:";
  z[lc++]="      memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 1]),";
  z[lc++]="	     nsys_netout_sysconst_gmreset, size);";
  z[lc++]="      nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 5] = ndata;";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill in journal section of payload */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_feclevel)";
  z[lc++]="    {";
  z[lc++]="      jstart = NSYS_RTPLEN_HDR + 1 + size;";
  z[lc++]="      jsize = nsys_netin_journal_create(&(nsys_netout_rtp_packet[jstart]),";
  z[lc++]="					NSYS_UDPMAXSIZE - NSYS_MD5_LENGTH ";
  z[lc++]="					- jstart);";
  z[lc++]="      nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* add authentication signature */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  dstart = NSYS_RTPLEN_HDR + 1 + size + jsize;";
  z[lc++]="  nsys_hmac_md5(nsys_netout_rtp_packet, dstart, nsys_keydigest, ";
  z[lc++]="		&(nsys_netout_rtp_packet[dstart]));";
  z[lc++]="";
  z[lc++]="  /********************************************/";
  z[lc++]="  /* calculate packet size, update statistics */";
  z[lc++]="  /********************************************/";
  z[lc++]="";
  z[lc++]="  nsys_sent_this = 1;";
  z[lc++]="  nsys_sent_packets++;";
  z[lc++]="  nsys_sent_octets += (size + 1 + jsize + NSYS_RTPSIZE_DIGEST);";
  z[lc++]="  size += (NSYS_RTPLEN_HDR + 1 + jsize + NSYS_RTPSIZE_DIGEST);     ";
  z[lc++]="";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  /* if loss model is active, don't always send the packet */";
  z[lc++]="  /*********************************************************/";
  z[lc++]="";
  z[lc++]="  if (NSYS_LOSSMODEL == NSYS_LOSSMODEL_ON)";
  z[lc++]="    if (rand() > (int)((1.0F - NSYS_LOSSMODEL_LOSSRATE)*RAND_MAX))";
  z[lc++]="      return;";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* send packet to everyone */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      addr = (struct sockaddr *) (alt ? sptr->alt_rtp_addr : sptr->rtp_addr);";
  z[lc++]="";
  z[lc++]="      /* when multiple payload types supported, see if *p*[NSYS_RTPLOC_PTYPE] */";
  z[lc++]="      /* differs from (sptr->ptype | nsys_netout_markbit) and reauthenticate  */";
  z[lc++]="";
  z[lc++]="      if (sendto(nsys_rtp_fd, nsys_netout_rtp_packet, size, 0, addr, ";
  z[lc++]="		 sizeof(struct sockaddr)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    continue;";
  z[lc++]="	  ";
  z[lc++]="	  if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_netout_newdata\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (!(alt = ((!alt) && sptr->alt_rtp_addr)))";
  z[lc++]="	sptr = sptr->next;";
  z[lc++]="    } ";
  z[lc++]="  while (alt || (sptr != nsys_srcroot));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              called at the end of control processing         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_endcycle(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]=" if (nsys_netout_jsend_guard_send) ";
  z[lc++]="   nsys_midisend(CSYS_MIDI_NOOP, 0, 0, 0);";
  z[lc++]=" ";
  z[lc++]=" if (nsys_graceful_exit && !graceful_exit)";
  z[lc++]="   graceful_exit = 1;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end  Sfront-specific network functions */";
  z[lc++]="";
  printlib(lc);
}


void makenet_include(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- constants and externs";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="#";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* network include files */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET_INCLUDE";
  z[lc++]="";
  z[lc++]="#define NSYS_NET_INCLUDE";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="";
  z[lc++]="#include <stdio.h> ";
  z[lc++]="#include <stdlib.h> ";
  z[lc++]="#include <errno.h> ";
  z[lc++]="#include <string.h> ";
  z[lc++]="#include <ctype.h>";
  z[lc++]="#include \"net_local.h\"";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <sys/ioctl.h>";
  z[lc++]="#include <unistd.h> ";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <time.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="#include <sys/types.h> ";
  z[lc++]="#include <sys/socket.h>";
  z[lc++]="#include <netdb.h>";
  z[lc++]="#include <arpa/inet.h>";
  z[lc++]="#include <netinet/in.h> ";
  z[lc++]="#include <net/if.h>";
  z[lc++]="";
  z[lc++]="#if (defined(sun) || defined(__sun__))";
  z[lc++]="#include <sys/sockio.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                           Constants                                    */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/***********************/";
  z[lc++]="/* debug/warning flags */";
  z[lc++]="/***********************/";
  z[lc++]="";
  z[lc++]="#define NSYS_WARN_NONE     0    /* never warn about anything */";
  z[lc++]="#define NSYS_WARN_STANDARD 1    /* print connect messages    */";
  z[lc++]="#define NSYS_WARN_UNUSUAL  2    /* print unusual events      */";
  z[lc++]="";
  z[lc++]="#define NSYS_WARN   NSYS_WARN_UNUSUAL";
  z[lc++]="";
  z[lc++]="#define NSYS_JOURNAL_DEBUG_OFF 0";
  z[lc++]="#define NSYS_JOURNAL_DEBUG_ON 1";
  z[lc++]="";
  z[lc++]="#define NSYS_JOURNAL_DEBUG NSYS_JOURNAL_DEBUG_OFF";
  z[lc++]="";
  z[lc++]="#define NSYS_LATENOTES_DEBUG_OFF 0";
  z[lc++]="#define NSYS_LATENOTES_DEBUG_ON 1";
  z[lc++]="";
  z[lc++]="#define NSYS_LATENOTES_DEBUG NSYS_LATENOTES_DEBUG_OFF";
  z[lc++]="";
  z[lc++]="#define NSYS_LOSSMODEL_OFF       0";
  z[lc++]="#define NSYS_LOSSMODEL_ON        1";
  z[lc++]="";
  z[lc++]="#define NSYS_LOSSMODEL_LOSSRATE   0.2F      /* between 0.0F and 1.0F */";
  z[lc++]="#define NSYS_LOSSMODEL NSYS_LOSSMODEL_OFF";
  z[lc++]="";
  z[lc++]="#define NSYS_NETOUT_CHAPTERE_OFF   0        /* don't send Chapter E */";
  z[lc++]="#define NSYS_NETOUT_CHAPTERE_ON    1        /* send Chapter E       */";
  z[lc++]="";
  z[lc++]="#define NSYS_NETOUT_CHAPTERE_STATUS   NSYS_NETOUT_CHAPTERE_OFF";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* network constants */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="#define NSYS_MAXRETRY 256";
  z[lc++]="#define NSYS_DONE  0";
  z[lc++]="#define NSYS_ERROR 1";
  z[lc++]="";
  z[lc++]="#define NSYS_NONBLOCK 0";
  z[lc++]="#define NSYS_BLOCK    1";
  z[lc++]="";
  z[lc++]="#define NSYS_BUFFSIZE 5120";
  z[lc++]="";
  z[lc++]="/*****************************/";
  z[lc++]="/* default system parameters */";
  z[lc++]="/*****************************/";
  z[lc++]="";
  z[lc++]="#if defined(__APPLE__)          /* variable-length ifconf */";
  z[lc++]="#define NSYS_IFCONF_VARLEN 1";
  z[lc++]="#else";
  z[lc++]="#define NSYS_IFCONF_VARLEN 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef SO_BSDCOMPAT";
  z[lc++]="#define SO_BSDCOMPAT 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_MSETS";
  z[lc++]="#define NSYS_MSETS 5";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ACYCLE";
  z[lc++]="#define ACYCLE 42L";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ARATE";
  z[lc++]="#define ARATE 44100.0F";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef APPNAME";
  z[lc++]="#define APPNAME \"unknown\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef APPVERSION";
  z[lc++]="#define APPVERSION \"0.0\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NUMCHAN";
  z[lc++]="#define CSYS_MIDI_NUMCHAN  16";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NOOP";
  z[lc++]="#define CSYS_MIDI_NOOP     0x70u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_POWERUP";
  z[lc++]="#define CSYS_MIDI_POWERUP  0x73u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_TSTART  ";
  z[lc++]="#define CSYS_MIDI_TSTART   0x7Du";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_MANUEX  ";
  z[lc++]="#define CSYS_MIDI_MANUEX   0x7Du";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_MVOLUME  ";
  z[lc++]="#define CSYS_MIDI_MVOLUME  0x7Eu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_GMRESET  ";
  z[lc++]="#define CSYS_MIDI_GMRESET  0x7Fu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NOTEOFF";
  z[lc++]="#define CSYS_MIDI_NOTEOFF  0x80u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NOTEON ";
  z[lc++]="#define CSYS_MIDI_NOTEON   0x90u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_PTOUCH  ";
  z[lc++]="#define CSYS_MIDI_PTOUCH   0xA0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC  ";
  z[lc++]="#define CSYS_MIDI_CC       0xB0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_PROGRAM ";
  z[lc++]="#define CSYS_MIDI_PROGRAM  0xC0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CTOUCH ";
  z[lc++]="#define CSYS_MIDI_CTOUCH   0xD0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_WHEEL ";
  z[lc++]="#define CSYS_MIDI_WHEEL    0xE0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM";
  z[lc++]="#define CSYS_MIDI_SYSTEM   0xF0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_SYSEX_START";
  z[lc++]="#define CSYS_MIDI_SYSTEM_SYSEX_START  0xF0u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_QFRAME";
  z[lc++]="#define CSYS_MIDI_SYSTEM_QFRAME       0xF1u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_SONG_PP";
  z[lc++]="#define CSYS_MIDI_SYSTEM_SONG_PP      0xF2u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_SONG_SELECT";
  z[lc++]="#define CSYS_MIDI_SYSTEM_SONG_SELECT  0xF3u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_UNUSED1";
  z[lc++]="#define CSYS_MIDI_SYSTEM_UNUSED1      0xF4u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_UNUSED2";
  z[lc++]="#define CSYS_MIDI_SYSTEM_UNUSED2      0xF5u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_TUNE_REQUEST";
  z[lc++]="#define CSYS_MIDI_SYSTEM_TUNE_REQUEST 0xF6u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_SYSEX_END";
  z[lc++]="#define CSYS_MIDI_SYSTEM_SYSEX_END    0xF7u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_CLOCK";
  z[lc++]="#define CSYS_MIDI_SYSTEM_CLOCK        0xF8u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_TICK";
  z[lc++]="#define CSYS_MIDI_SYSTEM_TICK         0xF9u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_START";
  z[lc++]="#define CSYS_MIDI_SYSTEM_START        0xFAu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_CONTINUE";
  z[lc++]="#define CSYS_MIDI_SYSTEM_CONTINUE     0xFBu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_STOP";
  z[lc++]="#define CSYS_MIDI_SYSTEM_STOP         0xFCu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_UNUSED3";
  z[lc++]="#define CSYS_MIDI_SYSTEM_UNUSED3      0xFDu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_SENSE";
  z[lc++]="#define CSYS_MIDI_SYSTEM_SENSE        0xFEu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM_RESET";
  z[lc++]="#define CSYS_MIDI_SYSTEM_RESET        0xFFu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_BANKSELECT_MSB ";
  z[lc++]="#define CSYS_MIDI_CC_BANKSELECT_MSB  0x00u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_MODWHEEL_MSB";
  z[lc++]="#define CSYS_MIDI_CC_MODWHEEL_MSB    0x01u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_DATAENTRY_MSB";
  z[lc++]="#define CSYS_MIDI_CC_DATAENTRY_MSB   0x06u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_CHANVOLUME_MSB";
  z[lc++]="#define CSYS_MIDI_CC_CHANVOLUME_MSB  0x07u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_BANKSELECT_LSB ";
  z[lc++]="#define CSYS_MIDI_CC_BANKSELECT_LSB  0x20u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_DATAENTRY_LSB";
  z[lc++]="#define CSYS_MIDI_CC_DATAENTRY_LSB  0x26u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_SUSTAIN";
  z[lc++]="#define CSYS_MIDI_CC_SUSTAIN         0x40u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_PORTAMENTOSRC ";
  z[lc++]="#define CSYS_MIDI_CC_PORTAMENTOSRC   0x54u";
  z[lc++]="#endif";
  z[lc++]="    ";
  z[lc++]="#ifndef CSYS_MIDI_CC_DATAENTRYPLUS";
  z[lc++]="#define CSYS_MIDI_CC_DATAENTRYPLUS   0x60u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_DATAENTRYMINUS";
  z[lc++]="#define CSYS_MIDI_CC_DATAENTRYMINUS  0x61u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_NRPN_LSB";
  z[lc++]="#define CSYS_MIDI_CC_NRPN_LSB        0x62u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_NRPN_MSB";
  z[lc++]="#define CSYS_MIDI_CC_NRPN_MSB        0x63u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_RPN_LSB";
  z[lc++]="#define CSYS_MIDI_CC_RPN_LSB         0x64u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_RPN_MSB";
  z[lc++]="#define CSYS_MIDI_CC_RPN_MSB         0x65u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_ALLSOUNDOFF";
  z[lc++]="#define CSYS_MIDI_CC_ALLSOUNDOFF     0x78u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_RESETALLCONTROL";
  z[lc++]="#define CSYS_MIDI_CC_RESETALLCONTROL 0x79u";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_LOCALCONTROL";
  z[lc++]="#define CSYS_MIDI_CC_LOCALCONTROL    0x7Au";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_ALLNOTESOFF";
  z[lc++]="#define CSYS_MIDI_CC_ALLNOTESOFF     0x7Bu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_OMNI_OFF";
  z[lc++]="#define CSYS_MIDI_CC_OMNI_OFF        0x7Cu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_OMNI_ON";
  z[lc++]="#define CSYS_MIDI_CC_OMNI_ON         0x7Du";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_MONOMODE";
  z[lc++]="#define CSYS_MIDI_CC_MONOMODE        0x7Eu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_POLYMODE";
  z[lc++]="#define CSYS_MIDI_CC_POLYMODE        0x7Fu";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define CSYS_MIDI_RPN_NULL_MSB       0x7Fu";
  z[lc++]="#define CSYS_MIDI_RPN_NULL_LSB       0x7Fu";
  z[lc++]="#define CSYS_MIDI_NRPN_NULL_MSB      0x7Fu";
  z[lc++]="#define CSYS_MIDI_NRPN_NULL_LSB      0x7Fu";
  z[lc++]="";
  z[lc++]="#define CYS_MIDI_RPN_0_DEFAULT_MSB   0x02u ";
  z[lc++]="#define CYS_MIDI_RPN_0_DEFAULT_LSB   0x00u";
  z[lc++]="";
  z[lc++]="#define CYS_MIDI_RPN_1_DEFAULT_MSB  0x04u";
  z[lc++]="#define CYS_MIDI_RPN_1_DEFAULT_LSB  0x00u";
  z[lc++]="";
  z[lc++]="#define CYS_MIDI_RPN_2_DEFAULT_MSB  0x04u";
  z[lc++]="#define CYS_MIDI_RPN_2_DEFAULT_LSB  0x00u";
  z[lc++]="";
  z[lc++]="#define CSYS_MIDI_MANUEX_SIZE  10    /* size of Manufacturers sample Sysex */";
  z[lc++]="#define CSYS_MIDI_MVOLUME_SIZE  8    /* size of Master Volume Sysex        */";
  z[lc++]="#define CSYS_MIDI_GMRESET_SIZE  6    /* size of General MIDI Reset Sysex   */";
  z[lc++]="";
  z[lc++]="#define NSYS_NETIN_SYSBUFF  (CSYS_MIDI_MANUEX_SIZE - 2)";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP";
  z[lc++]="#define NSYS_DISPLAY_RTCP         0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_HDR";
  z[lc++]="#define NSYS_DISPLAY_RTCP_HDR     0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_SRINFO";
  z[lc++]="#define NSYS_DISPLAY_RTCP_SRINFO  0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_SDES ";
  z[lc++]="#define NSYS_DISPLAY_RTCP_SDES    0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_RRINFO";
  z[lc++]="#define NSYS_DISPLAY_RTCP_RRINFO  0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_RRTCOMP";
  z[lc++]="#define NSYS_DISPLAY_RTCP_RRTCOMP 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* rtp defines */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="/* SSRC hash table constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_HASHSIZE 32         /* table size */";
  z[lc++]="#define NSYS_HASHMASK 31         /* table mask */";
  z[lc++]="";
  z[lc++]="/* preferred value for bidirectional RTP port */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTP_PORT     5004";
  z[lc++]="#define NSYS_RTP_MAXPORT 65535";
  z[lc++]="";
  z[lc++]="/* Based on Ethernet default MTU of 1500 bytes */";
  z[lc++]="";
  z[lc++]="#define NSYS_UDPMAXSIZE 1472  ";
  z[lc++]="#define NSYS_RTPMAXSIZE 1460";
  z[lc++]="";
  z[lc++]="/* masks for combing usec and sec for srand() seed */";
  z[lc++]="";
  z[lc++]="#define NSYS_USECMASK   (0x000FFFFF)   ";
  z[lc++]="#define NSYS_SECMASK    (0xFFF00000)";
  z[lc++]="#define NSYS_SECSHIFT   20";
  z[lc++]="";
  z[lc++]="/* positions of interesting parts of RTP header */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPLOC_BYTE1   0";
  z[lc++]="#define NSYS_RTPLOC_PTYPE   1";
  z[lc++]="#define NSYS_RTPLOC_SEQNUM  2";
  z[lc++]="#define NSYS_RTPLOC_TSTAMP  4";
  z[lc++]="#define NSYS_RTPLOC_SSRC    8";
  z[lc++]="";
  z[lc++]="/* extended sequence number constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPSEQ_MAXDIFF  4000        /* max number of lost packets */";
  z[lc++]="#define NSYS_RTPSEQ_HIGHEST  0xFFFFFFFF  /* highest sequence number    */";
  z[lc++]="#define NSYS_RTPSEQ_LOWLIMIT 4095        /* lo edge of 16-bit sequence */";
  z[lc++]="#define NSYS_RTPSEQ_HILIMIT  61440       /* hi edge of 16-bit sequence */";
  z[lc++]="#define NSYS_RTPSEQ_EXMASK   0xFFFF0000  /* masks out extension        */";
  z[lc++]="#define NSYS_RTPSEQ_LOMASK   0x0000FFFF  /* masks out 16-bit seqnum    */";
  z[lc++]="#define NSYS_RTPSEQ_EXINCR   0x00010000  /* increments extension       */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPSEQ_MAXLOSS   8388607    /* max number of lost packets */";
  z[lc++]="#define NSYS_RTPSEQ_MINLOSS  -8388608    /* min number of lost packets */";
  z[lc++]="#define NSYS_RTPSEQ_FMASK    0x00FFFFFF  /* bit mask to add fraction   */";
  z[lc++]="#define NSYS_RTPSEQ_TSIGN    0x00800000  /* bit mask for sign-extend   */";
  z[lc++]="";
  z[lc++]="/* other RTP constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPVAL_BYTE1   0x80  /* V=2, P=X=CC=0   */";
  z[lc++]="#define NSYS_RTPVAL_SETMARK 0x80  /* | to set marker */";
  z[lc++]="#define NSYS_RTPVAL_CLRMARK 0x7F  /* & to clr marker */";
  z[lc++]="#define NSYS_RTPVAL_CHKMARK 0x80  /* & to chk marker */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPLEN_HDR  12";
  z[lc++]="";
  z[lc++]="/* condition codes for a new RTP packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPCODE_NORMAL   0   /* seqnum directly follows last packet */";
  z[lc++]="#define NSYS_RTPCODE_LOSTONE  1   /* one packet has been lost            */";
  z[lc++]="#define NSYS_RTPCODE_LOSTMANY 2   /* many packets have been lost         */";
  z[lc++]="#define NSYS_RTPCODE_DISCARD  3   /* too late to use, or duplicate       */";
  z[lc++]="#define NSYS_RTPCODE_SECURITY 4   /* possible replay attack, discard     */";
  z[lc++]="";
  z[lc++]="/* number of bytes of digest to append */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPSIZE_DIGEST   4";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* rtcp sizes */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="/* sizes of complete RTCP packets */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_BYE      8    /* BYE packet */";
  z[lc++]="#define NSYS_RTCPLEN_RREMPTY  8    /* RR with no  report    */";
  z[lc++]="#define NSYS_RTCPLEN_RR      32    /* RR with one report    */";
  z[lc++]="#define NSYS_RTCPLEN_SREMPTY 28    /* SR with no  reciept report */";
  z[lc++]="#define NSYS_RTCPLEN_SR      52    /* SR with one receipt report */";
  z[lc++]="#define NSYS_RTCPLEN_MINIMUM  8    /* the minimum packet size */";
  z[lc++]="";
  z[lc++]="/* sizes of RTCP headers */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_SRHDR    8";
  z[lc++]="#define NSYS_RTCPLEN_RRHDR    8";
  z[lc++]="#define NSYS_RTCPLEN_SDESHDR  4";
  z[lc++]="#define NSYS_RTCPLEN_BYEHDR   4";
  z[lc++]="";
  z[lc++]="/* sizes of RTCP segments */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_SENDER  20";
  z[lc++]="#define NSYS_RTCPLEN_REPORT  24";
  z[lc++]="";
  z[lc++]="/* sizes of SDES headers */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_SDES_CHUNKHDR  4";
  z[lc++]="#define NSYS_RTCPLEN_SDES_ITEMHDR   2";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* rtcp locations */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="/* interesting shared locations in RR/SR headers */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_BYTE1  0";
  z[lc++]="#define NSYS_RTCPLOC_PTYPE  1";
  z[lc++]="#define NSYS_RTCPLOC_LENGTH 2";
  z[lc++]="#define NSYS_RTCPLOC_SSRC   4";
  z[lc++]="";
  z[lc++]="/* locations of SR sender info */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_SR_NTPMSB  8";
  z[lc++]="#define NSYS_RTCPLOC_SR_NTPLSB 12";
  z[lc++]="#define NSYS_RTCPLOC_SR_TSTAMP 16";
  z[lc++]="#define NSYS_RTCPLOC_SR_PACKET 20";
  z[lc++]="#define NSYS_RTCPLOC_SR_OCTET  24";
  z[lc++]="";
  z[lc++]="/* interesting offsets into RR sender info */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_RR_SSRC       0";
  z[lc++]="#define NSYS_RTCPLOC_RR_FRACTLOSS  4";
  z[lc++]="#define NSYS_RTCPLOC_RR_NUMLOST    5";
  z[lc++]="#define NSYS_RTCPLOC_RR_HISEQ      8";
  z[lc++]="#define NSYS_RTCPLOC_RR_JITTER    12";
  z[lc++]="#define NSYS_RTCPLOC_RR_LASTSR    16";
  z[lc++]="#define NSYS_RTCPLOC_RR_DELAY     20";
  z[lc++]="";
  z[lc++]="/* interesting locations in an SDES packet ITEM */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_SDESITEM_TYPE   0";
  z[lc++]="#define NSYS_RTCPLOC_SDESITEM_LENGTH 1";
  z[lc++]="";
  z[lc++]="/* interesting locations in RTCP BYE packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_BYE_SSRC       4";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* rtcp values */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_BYTE1   0x80        /* V=2, P=XC=0   */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_COUNTMASK   0x1F    /* mask for RC value  */";
  z[lc++]="#define NSYS_RTCPVAL_COOKIEMASK  0xE0    /* mask for VP bits  */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_SR   0xC8    /* RTCP sender */";
  z[lc++]="#define NSYS_RTCPVAL_RR   0xC9    /* RTCP receiver */";
  z[lc++]="#define NSYS_RTCPVAL_SDES 0xCA    /* RTCP source desc */";
  z[lc++]="#define NSYS_RTCPVAL_BYE  0xCB    /* RTCP bye */";
  z[lc++]="#define NSYS_RTCPVAL_APP  0xCC    /* RTCP APP packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_SDES_CNAME   0x01  /* CNAME for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_NAME    0x02  /* NAME  for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_EMAIL   0x03  /* EMAIL for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_PHONE   0x04  /* PHONE for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_LOC     0x05  /* LOC for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_TOOL    0x06  /* TOOL for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_NOTE    0x07  /* NOTE for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_PRIV    0x08  /* PRIV for SDES */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_SDES_SIZE   9      /* number of SDES types */";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* rtcp control */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="/* RTCP and SIP INFO timer constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPTIME_INCR       5      /* 5 seconds between RTCP sends  */";
  z[lc++]="#define NSYS_RTCPTIME_SKIP       2      /* threshold for retransmit skip */";
  z[lc++]="#define NSYS_RTCPTIME_TIMEOUT   25      /* 25 second SSRC timeout        */";
  z[lc++]="#define NSYS_RTCPTIME_MLENGTH  300      /* 5 minute limit for msession   */";
  z[lc++]="#define NSYS_SIPINFO_TRIGGER     6      /* every 5 RTCP send a SIP INFO  */";
  z[lc++]="";
  z[lc++]="/* RTCP-monitored exceptions */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPEX_RTPSIP       1     /* no response on SIP RTP channel */";
  z[lc++]="#define NSYS_RTCPEX_RTPNEXT      2     /* skip RTP retransmission cycle  */";
  z[lc++]="#define NSYS_RTCPEX_RTCPSIP      4     /* no response on SIP RTP channel */";
  z[lc++]="#define NSYS_RTCPEX_RTCPNEXT     8     /* skip RTCP retransmission cycle */";
  z[lc++]="#define NSYS_RTCPEX_NULLROOT     16    /* if nsys_srcroot == NULL        */";
  z[lc++]="#define NSYS_RTCPEX_SRCDUPL      32    /* SSRC clash                     */";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* rtp-midi payload */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++*/";
  z[lc++]="/*  midi command payload */";
  z[lc++]="/*+++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_MLENMASK     15  /* minimal LEN field mask      */";
  z[lc++]="#define NSYS_SM_EXPANDMAX  4095  /* worst case buffer expansion */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_DTIME 128 /* & for continuing delta-time octet  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETB 128  /* | to set B header bit   */";
  z[lc++]="#define NSYS_SM_CLRB 127  /* & to clear B header bit */";
  z[lc++]="#define NSYS_SM_CHKB 128  /* & to check B header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETJ  64  /* | to set J header bit   */";
  z[lc++]="#define NSYS_SM_CLRJ 191  /* & to clear J header bit */";
  z[lc++]="#define NSYS_SM_CHKJ  64  /* & to check J header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETZ  32  /* | to set Z header bit   */";
  z[lc++]="#define NSYS_SM_CLRZ 223  /* & to clear Z header bit */";
  z[lc++]="#define NSYS_SM_CHKZ  32  /* & to check Z header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETP  16  /* | to set P header bit   */";
  z[lc++]="#define NSYS_SM_CLRP 239  /* & to clear P header bit */";
  z[lc++]="#define NSYS_SM_CHKP  16  /* & to check P header bit */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* recovery journal constants */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETS 128  /* | to set S header bit   */";
  z[lc++]="#define NSYS_SM_CLRS 127  /* & to clear S header bit */";
  z[lc++]="#define NSYS_SM_CHKS 128  /* & to check S header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETH 128  /* | to set H history bit   */";
  z[lc++]="#define NSYS_SM_CLRH 127  /* & to clear H history bit */";
  z[lc++]="#define NSYS_SM_CHKH 128  /* & to check H history bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SLISTLEN 128  /* maximum S list size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETHI 128    /* for MIDI data bytes */";
  z[lc++]="#define NSYS_SM_CLRHI 127  ";
  z[lc++]="#define NSYS_SM_CHKHI 128  ";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="/* recovery journal header */";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SIZE 3       /* journal header size */";
  z[lc++]="#define NSYS_SM_JH_LOC_FLAGS 0  /* byte 0: flags       */";
  z[lc++]="#define NSYS_SM_JH_LOC_CHECK 1  /* bytes 1-2: checkpoint packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_CHANMASK 0x0F  /* to mask channel number  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SETH  16  /* | to set H header bit   */";
  z[lc++]="#define NSYS_SM_JH_CLRH 239  /* & to clear A header bit */";
  z[lc++]="#define NSYS_SM_JH_CHKH  16  /* & to check H header bit   */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SETA  32  /* | to set A header bit   */";
  z[lc++]="#define NSYS_SM_JH_CLRA 223  /* & to clear A header bit */";
  z[lc++]="#define NSYS_SM_JH_CHKA  32  /* & to check A header bit   */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SETY  64  /* | to set Y header bit   */";
  z[lc++]="#define NSYS_SM_JH_CLRY 191  /* & to clear Y header bit */";
  z[lc++]="#define NSYS_SM_JH_CHKY  64  /* & to check Y header bit   */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++*/";
  z[lc++]="/* system journal header */";
  z[lc++]="/*+++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_SIZE       2  /* system journal header size */";
  z[lc++]="#define NSYS_SM_SH_LOC_FLAGS  0  /* octet 0: flags             */";
  z[lc++]="#define NSYS_SM_SH_LOC_LENLSB 1  /* octet 1: length lsb        */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_MSBMASK 0x03   /* to mask length msb         */";
  z[lc++]="#define NSYS_SM_SH_LSBMASK 0x00FF /* to mask length lsb         */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_SETD  64      /* | to set D header bit      */";
  z[lc++]="#define NSYS_SM_SH_CLRD 191      /* & to clear D header bit    */";
  z[lc++]="#define NSYS_SM_SH_CHKD  64      /* & to check D header bit    */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_SETV  32      /* | to set V header bit      */";
  z[lc++]="#define NSYS_SM_SH_CLRV 223      /* & to clear V header bit    */";
  z[lc++]="#define NSYS_SM_SH_CHKV  32      /* & to check V header bit    */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_SETQ  16      /* | to set Q header bit      */";
  z[lc++]="#define NSYS_SM_SH_CLRQ 239      /* & to clear Q header bit    */";
  z[lc++]="#define NSYS_SM_SH_CHKQ  16      /* & to check Q header bit    */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_SETF   8      /* | to set F header bit      */";
  z[lc++]="#define NSYS_SM_SH_CLRF 247      /* & to clear F header bit    */ ";
  z[lc++]="#define NSYS_SM_SH_CHKF   8      /* & to check F header bit    */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SH_SETX   4      /* | to set X header bit      */";
  z[lc++]="#define NSYS_SM_SH_CLRX 251      /* & to clear X header bit    */ ";
  z[lc++]="#define NSYS_SM_SH_CHKX   4      /* & to check X header bit    */ ";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++*/";
  z[lc++]="/* channel header */";
  z[lc++]="/*++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_SIZE 3       /* channel header size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_LOC_FLAGS 0   /* location of S bit & channel */";
  z[lc++]="#define NSYS_SM_CH_LOC_LEN   0   /* location of 10-bit length */";
  z[lc++]="#define NSYS_SM_CH_LOC_TOC   2   /* location of table of contents */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_SETH   4      /* | to set H header bit      */";
  z[lc++]="#define NSYS_SM_CH_CLRH 251      /* & to clear H header bit    */ ";
  z[lc++]="#define NSYS_SM_CH_CHKH   4      /* & to check H header bit    */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_CHANMASK 0x78   /* to extract channel number  */";
  z[lc++]="#define NSYS_SM_CH_LENMASK  0x03FF /* to extract channel length  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_CHANSHIFT 3     /* to align channel number */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETP 128    /* Program Change (0xC) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRP 127    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKP 128    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETC  64    /* Control Change (0xB) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRC 191    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKC  64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETM  32    /* Parameter System (part of 0xB) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRM 223    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKM  32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETW  16    /* Pitch Wheel (0xE) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRW 239    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKW  16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETN   8    /* NoteOff (0x8), NoteOn (0x9) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRN 247    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKN   8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETE   4    /* Note Command Extras (0x8, 0x9) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRE 251    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKE   4    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETT   2    /* Channel Aftertouch (0xD) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRT 253    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKT   2    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETA   1    /* Poly Aftertouch (0xA) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRA 254    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKA   1";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter P (program change) */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_SIZE 3               /* chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_LOC_PROGRAM 0       /* PROGRAM octet  */";
  z[lc++]="#define NSYS_SM_CP_LOC_BANKMSB 1       /* BANK-MSB octet */";
  z[lc++]="#define NSYS_SM_CP_LOC_BANKLSB 2       /* BANK-LSB octet */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_SETB 128             /* | to set B header bit   */";
  z[lc++]="#define NSYS_SM_CP_CLRB 127             /* & to clear B header bit */";
  z[lc++]="#define NSYS_SM_CP_CHKB 128             /* & to check B header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_SETX 128             /* | to set X header bit   */";
  z[lc++]="#define NSYS_SM_CP_CLRX 127             /* & to clear X header bit */";
  z[lc++]="#define NSYS_SM_CP_CHKX 128             /* & to check X header bit */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter C (control change) */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SIZE  257         /* maximum chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_LOC_LENGTH   0    /* LENGTH byte */";
  z[lc++]="#define NSYS_SM_CC_LOC_LOGSTART 1    /* start of controller logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_HDRSIZE 1         /* size of chapter c header */  ";
  z[lc++]="#define NSYS_SM_CC_LOGSIZE 2         /* size of each controller log */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_LOC_LNUM 0        /* CONTROLLER byte in each log  */";
  z[lc++]="#define NSYS_SM_CC_LOC_LVAL 1        /* VALUE/COUNT byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_ARRAYSIZE  128    /* size of controller state arrays */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SETA 128          /* | to set A log bit   */";
  z[lc++]="#define NSYS_SM_CC_CLRA 127          /* & to clear A log bit */";
  z[lc++]="#define NSYS_SM_CC_CHKA 128          /* & to check A log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SETT  64          /* | to set T log bit   */";
  z[lc++]="#define NSYS_SM_CC_CLRT 191          /* & to clear T log bit */";
  z[lc++]="#define NSYS_SM_CC_CHKT  64          /* & to check T log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_ALTMOD  0x3F       /* for updating ALT state */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter M (parameter change) */";
  z[lc++]="/*++++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="/* chapter M: header */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_LOC_HDR     0    /* header location        */";
  z[lc++]="#define NSYS_SM_CM_LOC_PENDING 2    /* pending field          */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDRSIZE     2   /* Chapter M header size    */  ";
  z[lc++]="#define NSYS_SM_CM_PENDINGSIZE 1   /* PENDING field size    */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_LENMASK 0x03FF  /* LENGTH header field mask */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDR_SETP  64    /* Pending header bit        */";
  z[lc++]="#define NSYS_SM_CM_HDR_CLRP 191    ";
  z[lc++]="#define NSYS_SM_CM_HDR_CHKP  64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDR_SETE  32    /* progress header bit      */";
  z[lc++]="#define NSYS_SM_CM_HDR_CLRE 223    ";
  z[lc++]="#define NSYS_SM_CM_HDR_CHKE  32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDR_SETU     16    /* ALL-RPN bit  */";
  z[lc++]="#define NSYS_SM_CM_HDR_CLRU    239    ";
  z[lc++]="#define NSYS_SM_CM_HDR_CHKU     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDR_SETW      8    /* ALL-NRPN bit */";
  z[lc++]="#define NSYS_SM_CM_HDR_CLRW    247    ";
  z[lc++]="#define NSYS_SM_CM_HDR_CHKW      8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDR_SETZ      4    /* PNUM-MSB == 0x00 bit*/";
  z[lc++]="#define NSYS_SM_CM_HDR_CLRZ    251    ";
  z[lc++]="#define NSYS_SM_CM_HDR_CHKZ      4    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_PENDING_SETQ 128  /* RPN/NRPN flag for PENDING */  ";
  z[lc++]="#define NSYS_SM_CM_PENDING_CLRQ 127    ";
  z[lc++]="#define NSYS_SM_CM_PENDING_CHKQ 128    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_LOC_LIST 0      /* list location in chapterl[] */";
  z[lc++]="";
  z[lc++]="/* Chapter M: parameter log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_LOGMAXSIZE   10  /* maximum size of a log    */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_LOC_PNUMLSB   0  ";
  z[lc++]="#define NSYS_SM_CM_LOC_PNUMMSB   1";
  z[lc++]="#define NSYS_SM_CM_LOC_TOC       2";
  z[lc++]="#define NSYS_SM_CM_LOC_INFOBITS  2";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_LOGHDRSIZE    3 /* parameter log header size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_SETQ        128     /* | to set Q log bit   */";
  z[lc++]="#define NSYS_SM_CM_CLRQ        127     /* & to clear Q log bit */";
  z[lc++]="#define NSYS_SM_CM_CHKQ        128     /* & to check Q log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_SETX        128     /* | to set X log bit   */";
  z[lc++]="#define NSYS_SM_CM_CLRX        127     /* & to clear X log bit */";
  z[lc++]="#define NSYS_SM_CM_CHKX        128     /* & to check X log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_BUTTON_SETG  128    /* | to set G log bit   */";
  z[lc++]="#define NSYS_SM_CM_BUTTON_CLRG  127    /* & to clear G log bit */";
  z[lc++]="#define NSYS_SM_CM_BUTTON_CHKG  128    /* & to check G log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_BUTTON_SETX  64     /* | to set X log bit   */";
  z[lc++]="#define NSYS_SM_CM_BUTTON_CLRX  191    /* & to clear X log bit */";
  z[lc++]="#define NSYS_SM_CM_BUTTON_CHKX  64     /* & to check X log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_BUTTON_SETR  64     /* | to set R log bit   */";
  z[lc++]="#define NSYS_SM_CM_BUTTON_CLRR  191    /* & to clear R log bit */";
  z[lc++]="#define NSYS_SM_CM_BUTTON_CHKR  64     /* & to check R log bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_COUNT_SIZE    1";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_ENTRYMSB_SIZE 1";
  z[lc++]="#define NSYS_SM_CM_ENTRYLSB_SIZE 1";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_ABUTTON_SIZE  2";
  z[lc++]="#define NSYS_SM_CM_CBUTTON_SIZE  2";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_BUTTON_LIMIT  0x3FFF   /* 16383 decimal */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_TOC_SETJ    128    /* ENTRY-MSB field */";
  z[lc++]="#define NSYS_SM_CM_TOC_CLRJ    127    ";
  z[lc++]="#define NSYS_SM_CM_TOC_CHKJ    128    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_TOC_SETK     64    /* ENTRY-LSB field */";
  z[lc++]="#define NSYS_SM_CM_TOC_CLRK    191    ";
  z[lc++]="#define NSYS_SM_CM_TOC_CHKK     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_TOC_SETL     32    /* A-BUTTON field */";
  z[lc++]="#define NSYS_SM_CM_TOC_CLRL    223    ";
  z[lc++]="#define NSYS_SM_CM_TOC_CHKL     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_TOC_SETM     16    /* C-BUTTON field */";
  z[lc++]="#define NSYS_SM_CM_TOC_CLRM    239    ";
  z[lc++]="#define NSYS_SM_CM_TOC_CHKM     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_TOC_SETN      8    /* COUNT field */";
  z[lc++]="#define NSYS_SM_CM_TOC_CLRN    247    ";
  z[lc++]="#define NSYS_SM_CM_TOC_CHKN      8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_INFO_SETT      4    /* Count-mode*/";
  z[lc++]="#define NSYS_SM_CM_INFO_CLRT    251    ";
  z[lc++]="#define NSYS_SM_CM_INFO_CHKT      4    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_INFO_SETV      2    /* Value-mode */";
  z[lc++]="#define NSYS_SM_CM_INFO_CLRV    253    ";
  z[lc++]="#define NSYS_SM_CM_INFO_CHKV      2    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_INFO_SETA      1    /* active-mode */";
  z[lc++]="#define NSYS_SM_CM_INFO_CLRA    254    ";
  z[lc++]="#define NSYS_SM_CM_INFO_CHKA      1";
  z[lc++]="";
  z[lc++]="/* Chapter M: implementation-specific */";
  z[lc++]="";
  z[lc++]="/* state machine */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_STATE_OFF           0 ";
  z[lc++]="#define NSYS_SM_CM_STATE_PENDING_RPN   1";
  z[lc++]="#define NSYS_SM_CM_STATE_PENDING_NRPN  2";
  z[lc++]="#define NSYS_SM_CM_STATE_RPN           3";
  z[lc++]="#define NSYS_SM_CM_STATE_NRPN          4";
  z[lc++]="";
  z[lc++]="/* transaction constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_TRANS_NONE          0";
  z[lc++]="#define NSYS_SM_CM_TRANS_NRPN          1";
  z[lc++]="#define NSYS_SM_CM_TRANS_RPN           2  /* transaction type         */";
  z[lc++]="#define NSYS_SM_CM_TRANS_NO_OPEN       4  /* do not open transaction  */";
  z[lc++]="#define NSYS_SM_CM_TRANS_NO_SET        8  /* do not set values        */";
  z[lc++]="#define NSYS_SM_CM_TRANS_NO_CLOSE     16  /* do not close transaction */";
  z[lc++]="";
  z[lc++]="/* size restrictions */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_HDRMAXSIZE          3  /* 2 octets w/o pending        */";
  z[lc++]="#define NSYS_SM_CM_LISTMAXSIZE        30  /* 3 10-octet logs             */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CM_ARRAYSIZE  3 /* 3 RPNs:                     */";
  z[lc++]="                                /* MSB=00 LSB=00 Pitch Bend    */";
  z[lc++]="                                /* MSB=00 LSB=01 Fine Tuning   */";
  z[lc++]="                                /* MSB=00 LSB=02 Coarse Tuning */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="/* chapter W (pitch wheel) */";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CW_SIZE 2           /* chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CW_LOC_FIRST 0      /* FIRST  byte */";
  z[lc++]="#define NSYS_SM_CW_LOC_SECOND 1     /* SECOND byte */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CW_SETD 128         /* | to set D header bit   */";
  z[lc++]="#define NSYS_SM_CW_CLRD 127         /* & to clear D header bit */";
  z[lc++]="#define NSYS_SM_CW_CHKD 128         /* & to check D header bit */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++*/";
  z[lc++]="/* chapter N (notes) */";
  z[lc++]="/*+++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_SIZE  258         /* maximum chapter size (front) */";
  z[lc++]="#define NSYS_SM_CB_SIZE   16         /* maximum bitfield size  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_LOC_LENGTH   0    /* LENGTH  byte */";
  z[lc++]="#define NSYS_SM_CN_LOC_LOWHIGH  1    /* LOWHIGH byte */";
  z[lc++]="#define NSYS_SM_CN_LOC_LOGSTART 2    /* start of note logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_LOWMASK   0xF0    /* mask for LOW  */";
  z[lc++]="#define NSYS_SM_CN_HIGHMASK  0x0F    /* mask for HIGH */";
  z[lc++]="#define NSYS_SM_CN_LOWSHIFT     4    /* shift align for LOW */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_HDRSIZE 2         /* size of chapter n header */  ";
  z[lc++]="#define NSYS_SM_CN_LOGSIZE 2         /* size of each note log    */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_LOC_NUM 0         /* note number byte in each log  */";
  z[lc++]="#define NSYS_SM_CN_LOC_VEL 1         /* velocity byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_SETB 128          /* | to set B header bit   */";
  z[lc++]="#define NSYS_SM_CN_CLRB 127          /* & to clear B header bit */";
  z[lc++]="#define NSYS_SM_CN_CHKB 128          /* & to check B header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_SETY 128          /* | to set Y header bit   */";
  z[lc++]="#define NSYS_SM_CN_CLRY 127          /* & to clear Y header bit */";
  z[lc++]="#define NSYS_SM_CN_CHKY 128          /* & to check Y header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_ARRAYSIZE  128    /* size of note state arrays */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_BFMIN        0    /* minimum bitfield value    */";
  z[lc++]="#define NSYS_SM_CN_BFMAX       15    /* maximum bitfield value    */";
  z[lc++]="#define NSYS_SM_CN_BFSHIFT      3    /* note to bitfield byte shift */";
  z[lc++]="#define NSYS_SM_CN_BFMASK    0x07    /* mask for bit position      */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_MAXDELAY  0.020F   /* lifetime of Y bit (seconds)  */";
  z[lc++]="#define NSYS_SM_CN_RECDELAY  0.10F    /* receiver test for Y lifetime */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="/* chapter E (note extras) */";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CE_SIZE    257        /* maximum size: header + ref logs */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CE_LOC_LENGTH   0    /* LENGTH byte */";
  z[lc++]="#define NSYS_SM_CE_LOC_LOGSTART 1    /* start of note logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CE_HDRSIZE 1         /* size of chapter E header */  ";
  z[lc++]="#define NSYS_SM_CE_LOGSIZE 2         /* size of each note log */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CE_LOC_NUM 0         /* NOTENUM byte in each log  */";
  z[lc++]="#define NSYS_SM_CE_LOC_COUNTVEL 1    /* COUNT/VEL byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CE_SETV 128          /* | to set V header bit   */";
  z[lc++]="#define NSYS_SM_CE_CLRV 127          /* & to clear V header bit */";
  z[lc++]="#define NSYS_SM_CE_CHKV 128          /* & to check V header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CE_ARRAYSIZE  128    /* size of note extra state arrays */";
  z[lc++]="#define NSYS_SM_CE_DEFREL      64    /* default release velocity value */";
  z[lc++]="#define NSYS_SM_CE_MAXCOUNT   127    /* maximum reference count */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter T (channel aftertouch) */";
  z[lc++]="/*++++++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CT_SIZE 1            /* chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CT_LOC_PRESSURE 0    /* PRESSURE byte */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++*/";
  z[lc++]="/* chapter A (poly touch) */";
  z[lc++]="/*++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_SIZE  257         /* maximum chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_LOC_LENGTH   0    /* LENGTH byte */";
  z[lc++]="#define NSYS_SM_CA_LOC_LOGSTART 1    /* start of note logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_HDRSIZE 1         /* size of chapter A header */  ";
  z[lc++]="#define NSYS_SM_CA_LOGSIZE 2         /* size of each note log */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_LOC_NUM 0         /* NOTENUM byte in each log  */";
  z[lc++]="#define NSYS_SM_CA_LOC_PRESSURE 1    /* PRESSURE byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_SETX 128          /* | to set X header bit   */";
  z[lc++]="#define NSYS_SM_CA_CLRX 127          /* & to clear X header bit */";
  z[lc++]="#define NSYS_SM_CA_CHKX 128          /* & to check X header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_ARRAYSIZE  128    /* size of ptouch state arrays */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="/* system journal chapters */";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter D (miscellaneous) */";
  z[lc++]="/*+++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_LOC_TOC      0    /* Table of Contents     */";
  z[lc++]="#define NSYS_SM_CD_LOC_LOGS     1    /* start of command logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_SIZE_TOC      1    /* TOC header size  */  ";
  z[lc++]="#define NSYS_SM_CD_SIZE_RESET    1    /* Reset field size */";
  z[lc++]="#define NSYS_SM_CD_SIZE_TUNE     1    /* Tune Request field size */  ";
  z[lc++]="#define NSYS_SM_CD_SIZE_SONG     1    /* Song Select field size */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_FRONT_MAXSIZE  4   /* maximum size (J = K = Y = Z = 0) */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETB     64    /* Reset field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRB    191    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKB     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETG     32    /* Tune Request field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRG    223    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKG     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETH     16    /* Song Select field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRH    239    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKH     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETJ      8    /* Common 0xF4 field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRJ    247    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKJ      8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETK      4    /* Common 0xF5 field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRK    251    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKK      4    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETY      2    /* Real-time 0xF9 field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRY    253    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKY      2    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_TOC_SETZ      1    /* Real-time 0xFD field */";
  z[lc++]="#define NSYS_SM_CD_TOC_CLRZ    254    ";
  z[lc++]="#define NSYS_SM_CD_TOC_CHKZ      1";
  z[lc++]="";
  z[lc++]="/*  undefined System Common log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_LOC_TOC     0   /* Table of Contents  */ ";
  z[lc++]="#define NSYS_SM_CD_COMMON_LOC_LENGTH  1   /* Log length         */  ";
  z[lc++]="#define NSYS_SM_CD_COMMON_LOC_FIELDS  2   /* Start of fields    */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_SIZE    1    /* TOC size         */  ";
  z[lc++]="#define NSYS_SM_CD_COMMON_LENGTH_SIZE 1    /* Log Length Size (+2 bits) */";
  z[lc++]="#define NSYS_SM_CD_COMMON_COUNT_SIZE  1    /* Count Field Size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_SETC     64    /* Count field */";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_CLRC    191    ";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_CHKC     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_SETV     32    /* Value field */";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_CLRV    223    ";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_CHKV     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_SETL     16    /* Legal field */";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_CLRL    239    ";
  z[lc++]="#define NSYS_SM_CD_COMMON_TOC_CHKL     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_DSZ_MASK    0x0C    /* bit-mask for DSZ field */";
  z[lc++]="#define NSYS_SM_CD_COMMON_LENMSB_MASK 0x03    /* bit-mask for LEN MSBs */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_COMMON_SIZE          5      /* implementation-specific */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*  undefined System Real-Time log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_REALTIME_LOC_TOC     0   /* Table of Contents  */ ";
  z[lc++]="#define NSYS_SM_CD_REALTIME_LOC_FIELDS  1   /* Start of fields    */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_SIZE    1   /* TOC size          */  ";
  z[lc++]="#define NSYS_SM_CD_REALTIME_COUNT_SIZE  1   /* Count field       */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_SETC     64    /* Count field */";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_CLRC    191    ";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_CHKC     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_SETL     32    /* Legal field */";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_CLRL    223    ";
  z[lc++]="#define NSYS_SM_CD_REALTIME_TOC_CHKL     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CD_REALTIME_LENGTH_MASK  0x1F  /* LENGTH bit-mask */";
  z[lc++]="#define NSYS_SM_CD_REALTIME_SIZE         2     /* implementation-specific  */ ";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter V (active sense)  */";
  z[lc++]="/*+++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CV_SIZE       1   /* chapter size         */";
  z[lc++]="#define NSYS_SM_CV_LOC_COUNT  0   /* COUNT field location */  ";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter Q (sequencer)     */";
  z[lc++]="/*+++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_LOC_HDR      0    /* chapter header            */";
  z[lc++]="#define NSYS_SM_CQ_LOC_FIELDS   1    /* start of sequencer fields */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_SIZE_HDR        1    /* chapter header size  */  ";
  z[lc++]="#define NSYS_SM_CQ_SIZE_CLOCK      2    /* CLOCK field size     */";
  z[lc++]="#define NSYS_SM_CQ_SIZE_TIMETOOLS  3    /* TIMETOOLS field size */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_MAXSIZE         3    /* maximum chapter size (if T = 0) */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_HDR_SETN     64     /* Start/Stop bit */";
  z[lc++]="#define NSYS_SM_CQ_HDR_CLRN    191    ";
  z[lc++]="#define NSYS_SM_CQ_HDR_CHKN     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_HDR_SETD     32     /* Download field */";
  z[lc++]="#define NSYS_SM_CQ_HDR_CLRD    223    ";
  z[lc++]="#define NSYS_SM_CQ_HDR_CHKD     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_HDR_SETC     16     /* CLOCK TOC bit */";
  z[lc++]="#define NSYS_SM_CQ_HDR_CLRC    239    ";
  z[lc++]="#define NSYS_SM_CQ_HDR_CHKC     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_HDR_SETT      8     /* TIMETOOLS TOC bit */";
  z[lc++]="#define NSYS_SM_CQ_HDR_CLRT    247    ";
  z[lc++]="#define NSYS_SM_CQ_HDR_CHKT      8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_TOP_MASK      0x07        /* TOP field bit-mask       */";
  z[lc++]="#define NSYS_SM_CQ_BOTTOM_MASK   0x0000FFFF  /* bottom 16-bits for CLOCK */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CQ_TIMETOOLS_SETB 128    /* TIMETOOLS B bit */";
  z[lc++]="#define NSYS_SM_CQ_TIMETOOLS_CLRB 127  ";
  z[lc++]="#define NSYS_SM_CQ_TIMETOOLS_CHKB 128  ";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter F (MIDI Time Code) */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_LOC_HDR         0    /* chapter header           */";
  z[lc++]="#define NSYS_SM_CF_LOC_FIELDS      1    /* start of timecode fields */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_SIZE_HDR        1    /* chapter header size      */  ";
  z[lc++]="#define NSYS_SM_CF_SIZE_COMPLETE   4    /* COMPLETE timestamp       */";
  z[lc++]="#define NSYS_SM_CF_SIZE_PARTIAL    4    /* PARTIAL timestamp        */  ";
  z[lc++]="#define NSYS_SM_CF_MAXSIZE         9    /* maximum chapter size     */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_HDR_SETC     64     /* COMPLETE field TOC bit */";
  z[lc++]="#define NSYS_SM_CF_HDR_CLRC    191    ";
  z[lc++]="#define NSYS_SM_CF_HDR_CHKC     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_HDR_SETP     32     /* PARTIAL field TOC bit */    ";
  z[lc++]="#define NSYS_SM_CF_HDR_CLRP    223    ";
  z[lc++]="#define NSYS_SM_CF_HDR_CHKP     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_HDR_SETQ     16    /* Quarter-Frame status bit */ ";
  z[lc++]="#define NSYS_SM_CF_HDR_CLRQ    239    ";
  z[lc++]="#define NSYS_SM_CF_HDR_CHKQ     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_HDR_SETD      8     /* tape direction status bit */";
  z[lc++]="#define NSYS_SM_CF_HDR_CLRD    247    ";
  z[lc++]="#define NSYS_SM_CF_HDR_CHKD      8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_POINT_MASK   0x07    /* mask POINT field bit-mask  */";
  z[lc++]="#define NSYS_SM_CF_POINT_CLR    0xF8    /* clear POINT field bit-mask */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_SIZE_MT         1    /* message-type size     */  ";
  z[lc++]="#define NSYS_SM_CF_SIZE_HR         1    /* hours FF size         */  ";
  z[lc++]="#define NSYS_SM_CF_SIZE_MN         1    /* minutes FF size       */  ";
  z[lc++]="#define NSYS_SM_CF_SIZE_SC         1    /* seconds FF size       */  ";
  z[lc++]="#define NSYS_SM_CF_SIZE_FR         1    /* frames FF size        */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_FF_LOC_HR       0    /* hours FF location     */";
  z[lc++]="#define NSYS_SM_CF_FF_LOC_MN       1    /* minutes FF location   */";
  z[lc++]="#define NSYS_SM_CF_FF_LOC_SC       2    /* seconds FF location   */";
  z[lc++]="#define NSYS_SM_CF_FF_LOC_FR       3    /* frames FF location    */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_FR_LSN   0   /* Frame LSN location     */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_FR_MSN   0   /* Frame MSN location     */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_SC_LSN   1   /* Seconds LSN location   */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_SC_MSN   1   /* Seconds MSN location   */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_MN_LSN   2   /* Minutes LSN location   */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_MN_MSN   2   /* Minutes MSN location   */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_HR_LSN   3   /* Hours LSN location     */";
  z[lc++]="#define NSYS_SM_CF_QF_LOC_HR_MSN   3   /* Hours MSN location     */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_IDNUM_MASK    0x70   /* MT ID # bit-mask      */";
  z[lc++]="#define NSYS_SM_CF_PAYLOAD_MASK  0x0F   /* MT PAYLOAD # bit-mask */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_EVEN_MASK  0xF0      /* mask even MTs */";
  z[lc++]="#define NSYS_SM_CF_EVEN_CLR   0x0F      /* clear even MTs */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_ODD_MASK   0x0F      /* mask odd MTs  */";
  z[lc++]="#define NSYS_SM_CF_ODD_CLR    0xF0      /* clear odd MTs */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_IDNUM_FR_LSN  0    /* Frame LSN ID Number     */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_FR_MSN  1    /* Frame MSN ID Number     */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_SC_LSN  2    /* Seconds LSN ID Number   */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_SC_MSN  3    /* Seconds MSN ID Number   */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_MN_LSN  4    /* Minutes LSN ID Number   */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_MN_MSN  5    /* Minutes MSN ID Number   */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_HR_LSN  6    /* Hours LSN ID Number     */";
  z[lc++]="#define NSYS_SM_CF_IDNUM_HR_MSN  7    /* Hours MSN ID Number     */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter X (System Exclusive) */";
  z[lc++]="/*++++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_LOC_HDR       0    /* chapter header      */";
  z[lc++]="#define NSYS_SM_CX_LOC_FIELDS    1    /* TCOUNT, COUNT, FIRST, DATA */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_SIZE_HDR      1    /* chapter header  */";
  z[lc++]="#define NSYS_SM_CX_SIZE_TCOUNT   1    /* TCOUNT field    */";
  z[lc++]="#define NSYS_SM_CX_SIZE_COUNT    1    /* COUNT field     */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_HDR_SETT     64    /* TCOUNT field TOC bit */";
  z[lc++]="#define NSYS_SM_CX_HDR_CLRT    191    ";
  z[lc++]="#define NSYS_SM_CX_HDR_CHKT     64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_HDR_SETC     32    /* COUNT field TOC bit */";
  z[lc++]="#define NSYS_SM_CX_HDR_CLRC    223    ";
  z[lc++]="#define NSYS_SM_CX_HDR_CHKC     32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_HDR_SETF     16    /* FIRST field TOC bit */";
  z[lc++]="#define NSYS_SM_CX_HDR_CLRF    239    ";
  z[lc++]="#define NSYS_SM_CX_HDR_CHKF     16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_HDR_SETD      8    /* DATA field TOC bit */";
  z[lc++]="#define NSYS_SM_CX_HDR_CLRD    247    ";
  z[lc++]="#define NSYS_SM_CX_HDR_CHKD      8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_HDR_SETL      4    /* list/recency bit */";
  z[lc++]="#define NSYS_SM_CX_HDR_CLRL    251    ";
  z[lc++]="#define NSYS_SM_CX_HDR_CHKL      4    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_STA_MASK   0x03    /* STA field bit-mask  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_STA_UNFINISHED  0x00    /* unfinished SysEx      */";
  z[lc++]="#define NSYS_SM_CX_STA_CANCELLED   0x01    /* cancelled SysEx       */";
  z[lc++]="#define NSYS_SM_CX_STA_DROPPEDF7   0x02    /* dropped-F7 SysEx      */";
  z[lc++]="#define NSYS_SM_CX_STA_NORMAL      0x03    /* normal finished SysEx */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_DATA_SETEND  0x80";
  z[lc++]="#define NSYS_SM_CX_DATA_CHKEND  0x80";
  z[lc++]="#define NSYS_SM_CX_DATA_CLREND  0x7F";
  z[lc++]="#define NSYS_SM_CX_DATA_MASK    0x7F";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_GMRESET_ONVAL   0x01    /* GM Reset on ndata value */";
  z[lc++]="#define NSYS_SM_CX_GMRESET_OFFVAL  0x02    /* GM Reset on ndata value */";
  z[lc++]="";
  z[lc++]="/* implementation specific */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_SIZE_GMRESET    6    /* log for GM Resets */";
  z[lc++]="#define NSYS_SM_CX_SIZE_MVOLUME    8    /* log for Master Volume */";
  z[lc++]="#define NSYS_SM_CX_SIZE_MAXLOG     8    /* maximum log size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CX_MAXSLOTS        3    /* at most, 3 logs in Chapter X */";
  z[lc++]="    ";
  z[lc++]="/*++++++++++++++++++++*/";
  z[lc++]="/* rtp-midi: receiver */";
  z[lc++]="/*++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="/* number of MIDI channels to pre-allocate per receiver */";
  z[lc++]="";
  z[lc++]="#define NSYS_RECVCHAN  2";
  z[lc++]="";
  z[lc++]="/* constants to handle flag bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_RV_SETF 128        /* | to set flag bit   */";
  z[lc++]="#define NSYS_SM_RV_CLRF 127        /* & to clear flag bit */";
  z[lc++]="#define NSYS_SM_RV_CHKF 128        /* & to check flag bit */";
  z[lc++]="";
  z[lc++]="/* return values for nsys_netin_journal_recovery() */";
  z[lc++]="";
  z[lc++]="#define NSYS_JOURNAL_RECOVERED  0   /* must be zero */";
  z[lc++]="#define NSYS_JOURNAL_FILLEDBUFF 1";
  z[lc++]="#define NSYS_JOURNAL_CORRUPTED  2";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++*/";
  z[lc++]="/* rtp-midi: sender */";
  z[lc++]="/*++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_GUARD_ONTIME     NSYS_SM_CN_MAXDELAY";
  z[lc++]="#define NSYS_SM_GUARD_MINTIME    0.25F";
  z[lc++]="#define NSYS_SM_GUARD_STDTIME    0.10F";
  z[lc++]="#define NSYS_SM_GUARD_MAXTIME    1.0F";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#define NSYS_SM_FEC_NONE     0";
  z[lc++]="#define NSYS_SM_FEC_NOGUARD  1";
  z[lc++]="#define NSYS_SM_FEC_MINIMAL  2  ";
  z[lc++]="#define NSYS_SM_FEC_STANDARD 3  ";
  z[lc++]="#define NSYS_SM_FEC_EXTRA    4  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_LATETIME        0.040F     /* maximum lateness */";
  z[lc++]="#define NSYS_SM_LATEWINDOW        3.5F     /* time window for reset */";
  z[lc++]="";
  z[lc++]="/*******/";
  z[lc++]="/* SIP */";
  z[lc++]="/*******/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_SIP_IP";
  z[lc++]="#define NSYS_SIP_IP          \"169.229.59.210\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_SIP_RTP_PORT";
  z[lc++]="#define NSYS_SIP_RTP_PORT    5060";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_SIP_RTCP_PORT";
  z[lc++]="#define NSYS_SIP_RTCP_PORT   5061";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define NSYS_HOSTNAMESIZE 256";
  z[lc++]="#define NSYS_SDPNATSIZE   128";
  z[lc++]="#define NSYS_CNAMESIZE     32";
  z[lc++]="";
  z[lc++]="#define NSYS_NETIN_SIPSTATE 0   /* SIP INVITE state machine states */";
  z[lc++]="#define NSYS_NETIN_SDPSTATE 1";
  z[lc++]="#define NSYS_NETIN_EOFSTATE 2";
  z[lc++]="#define NSYS_NETIN_ERRSTATE 3";
  z[lc++]="";
  z[lc++]="#define NSYS_SIP_RETRYMAX       5         /* max retry for initial connect */";
  z[lc++]="#define NSYS_SIP_AUTHRETRYMAX   4         /* max retry for authentication  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SIP_UNIXTONTP      2208988800UL /* add to UNIX time for NTP (s) */";
  z[lc++]=" ";
  z[lc++]="/********/";
  z[lc++]="/* SDP  */";
  z[lc++]="/********/";
  z[lc++]="";
  z[lc++]="/* number of supported payload types */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTP_PAYSIZE 1";
  z[lc++]="";
  z[lc++]="/* pindex values for payload types */";
  z[lc++]="";
  z[lc++]="#define NSYS_MPEG4_PINDEX  0";
  z[lc++]="#define NSYS_NATIVE_PINDEX 1";
  z[lc++]="";
  z[lc++]="/*******************/";
  z[lc++]="/* Crypto/Security */";
  z[lc++]="/*******************/";
  z[lc++]="";
  z[lc++]="#define NSYS_MD5_LENGTH     16   /* array size for an MD5 digest in binary */";
  z[lc++]="#define NSYS_MD5_ROUNDS  10000   /* number of MD5 passes for keydigest  */";
  z[lc++]="";
  z[lc++]="#define NSYS_BASE64_LENGTH  25   /* string size of a BASE64 MD5 digest     */";
  z[lc++]="#define NSYS_MKEY_LENGTH    32   /* length of random key for mirror        */";
  z[lc++]="";
  z[lc++]="#define NSYS_MAXLATETIME     5400   /* clocks no more than 90 minutes fast */";
  z[lc++]="#define NSYS_MAXSSESIONTIME 21600   /* session maxtime is 6 hours          */";
  z[lc++]="";
  z[lc++]="#define NSYS_MSESSION_NAME \"mirror\"  /* change if sfront hashes names  */";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_MSESSION_INTERVAL";
  z[lc++]="#define NSYS_MSESSION_INTERVAL  12   /* pitch shift for mirror         */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define NSYS_MSESSION_MAXRTP  9000   /* maximum RTP packets in session  */";
  z[lc++]="#define NSYS_MSESSION_MAXRTCP  200   /* maximum RTCP packets in session */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                           Variable externs                             */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: network */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern int nsys_rtp_fd;               /* fd for rtp           */";
  z[lc++]="extern int nsys_rtcp_fd;              /* fd for rtcp          */";
  z[lc++]="extern int nsys_max_fd;               /* fd for select        */";
  z[lc++]="";
  z[lc++]="extern unsigned short nsys_rtp_port;  /* actual rtp port      */ ";
  z[lc++]="extern unsigned short nsys_rtcp_port; /* actual rtcp port     */ ";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_rtp_cseq;   /* rtp cseq number      */";
  z[lc++]="extern unsigned long nsys_rtcp_cseq;  /* rtcp cseq number     */";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: packets */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_netout_rtp_packet[];  /* rtp packet out */";
  z[lc++]="";
  z[lc++]="/* rtcp packets and lengths */";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_netout_rtcp_packet_bye;";
  z[lc++]="extern unsigned char * nsys_netout_rtcp_packet_rrempty;";
  z[lc++]="extern unsigned char * nsys_netout_rtcp_packet_rr;";
  z[lc++]="extern unsigned char * nsys_netout_rtcp_packet_srempty;";
  z[lc++]="extern unsigned char * nsys_netout_rtcp_packet_sr;";
  z[lc++]="";
  z[lc++]="extern int nsys_netout_rtcp_len_bye;";
  z[lc++]="extern int nsys_netout_rtcp_len_rrempty;";
  z[lc++]="extern int nsys_netout_rtcp_len_rr;";
  z[lc++]="extern int nsys_netout_rtcp_len_srempty;";
  z[lc++]="extern int nsys_netout_rtcp_len_sr;";
  z[lc++]="";
  z[lc++]="extern char * nsys_sdes_typename[];            /* rtcp debug array */";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_netout_seqnum;  /* rtp output sequence number */";
  z[lc++]="extern unsigned long nsys_netout_tstamp;  /* rtp output timestamp */";
  z[lc++]="extern unsigned char nsys_netout_markbit; /* for setting markerbit */";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* rtp payload support  */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_payinfo {";
  z[lc++]="";
  z[lc++]="  int pindex;               /* index into nsys_payload_types  */";
  z[lc++]="  unsigned char ptype;      /* RTP payload number */";
  z[lc++]="  char name[32];            /* name of payload    */";
  z[lc++]="  int srate;                /* audio sample rate  */";
  z[lc++]="";
  z[lc++]="} nsys_payinfo;";
  z[lc++]="";
  z[lc++]="extern struct nsys_payinfo nsys_payload_types[];";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* rtcp state */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="extern int nsys_sent_last;    /* a packet was sent last RTCP period     */";
  z[lc++]="extern int nsys_sent_this;    /* a packet was sent this RTCP period     */";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_sent_packets;  /* number of packets sent */";
  z[lc++]="extern unsigned long nsys_sent_octets;   /* number of octets sent */";
  z[lc++]="";
  z[lc++]="extern time_t nsys_nexttime;  /* time for next RTCP check               */";
  z[lc++]="extern int nsys_rtcp_ex;      /* status flags to check at RTCP time     */";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* identification */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_myssrc;     /*  SSRC -- hostorder  */";
  z[lc++]="extern unsigned long nsys_myssrc_net; /*  SSRC -- netorder   */";
  z[lc++]="";
  z[lc++]="extern char * nsys_sessionname;";
  z[lc++]="extern char * nsys_sessionkey;";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_keydigest[];        /* digested key */";
  z[lc++]="extern unsigned char nsys_session_base64[];   /* signed session name */";
  z[lc++]="extern int nsys_msession;                     /* mirror session flag */";
  z[lc++]="extern int nsys_msessionmirror;               /* mirror in mirror session */";
  z[lc++]="";
  z[lc++]="extern int nsys_feclevel;";
  z[lc++]="extern int nsys_lateplay;";
  z[lc++]="extern float nsys_latetime;";
  z[lc++]="";
  z[lc++]="extern char nsys_clientname[];";
  z[lc++]="extern char nsys_clientip[];";
  z[lc++]="extern char * nsys_username;";
  z[lc++]="";
  z[lc++]="extern char nsys_cname[];";
  z[lc++]="extern unsigned char nsys_cname_len;";
  z[lc++]="";
  z[lc++]="extern int nsys_powerup_mset; ";
  z[lc++]="";
  z[lc++]="/***********/";
  z[lc++]="/* logging */";
  z[lc++]="/***********/";
  z[lc++]="";
  z[lc++]="extern int nsys_stderr_size;";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* MIDI input buffer */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_buff[];";
  z[lc++]="extern long nsys_bufflen;";
  z[lc++]="extern long nsys_buffcnt;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* rtp-midi: sender state */";
  z[lc++]="/*________________________*/";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* command section flags */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_netout_sm_header;";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* checkpoint management */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_netout_jsend_checkpoint_seqnum;  /* current checkpoint */";
  z[lc++]="extern unsigned long nsys_netout_jsend_checkpoint_changed; /* 1 if changed */";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* S-list management */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_netout_jsend_slist[];";
  z[lc++]="extern int nsys_netout_jsend_slist_size;";
  z[lc++]="";
  z[lc++]="/*******************************/";
  z[lc++]="/* guard journal state machine */";
  z[lc++]="/*******************************/";
  z[lc++]="";
  z[lc++]="extern int nsys_netout_jsend_guard_send;    /* flag variable: send guard packet */";
  z[lc++]="extern int nsys_netout_jsend_guard_time;    /* guard packet timer state */";
  z[lc++]="extern int nsys_netout_jsend_guard_next;    /* reload value for timer */";
  z[lc++]="extern int nsys_netout_jsend_guard_ontime;  /* minimum delay time for noteon */ ";
  z[lc++]="extern int nsys_netout_jsend_guard_mintime; /* minimum delay time for (!noteon) */";
  z[lc++]="extern int nsys_netout_jsend_guard_maxtime; /* maximum delay time */ ";
  z[lc++]="";
  z[lc++]="/***************************/";
  z[lc++]="/* recovery journal header */";
  z[lc++]="/***************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_netout_jsend_header[];    /* journal header */";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* channel journal record */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_netout_jsend_channel[];";
  z[lc++]="extern unsigned char nsys_netout_jsend_channel_size;";
  z[lc++]="";
  z[lc++]="/******************************************/";
  z[lc++]="/* structure holding sender channel state */";
  z[lc++]="/******************************************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_netout_jsend_state {";
  z[lc++]="";
  z[lc++]="  unsigned char  chan;  /* MIDI channel */";
  z[lc++]="  unsigned short clen;  /* first two bytes of cheader */";
  z[lc++]="";
  z[lc++]="  /* most recent MIDI commands, used for new source init */";
  z[lc++]="";
  z[lc++]="  unsigned char history_active;        /* flag for channel activity */";
  z[lc++]="  unsigned char history_cc_bank_msb;   /* current cc values */";
  z[lc++]="  unsigned char history_cc_bank_lsb;";
  z[lc++]="  unsigned char history_cc_modwheel;";
  z[lc++]="  unsigned char history_cc_volume;";
  z[lc++]="";
  z[lc++]="  unsigned char history_program;       /* last program change */";
  z[lc++]="  unsigned char history_program_bank_msb;";
  z[lc++]="  unsigned char history_program_bank_lsb;";
  z[lc++]="";
  z[lc++]="  /* sequence numbers -- 0 or highest seqnum */";
  z[lc++]="";
  z[lc++]="  unsigned long cheader_seqnum; ";
  z[lc++]="  unsigned long chapterp_seqnum;";
  z[lc++]="  unsigned long chapterc_seqnum;";
  z[lc++]="  unsigned long chapterc_seqarray[NSYS_SM_CC_ARRAYSIZE];";
  z[lc++]="  unsigned long chapterm_seqnum;";
  z[lc++]="  unsigned long chapterm_seqarray[NSYS_SM_CM_ARRAYSIZE];";
  z[lc++]="  unsigned long chapterm_dummy_seqnum;";
  z[lc++]="  unsigned long chapterw_seqnum;    ";
  z[lc++]="  unsigned long chaptern_seqnum;    ";
  z[lc++]="  unsigned long chaptern_seqarray[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptere_seqnum;";
  z[lc++]="  unsigned long chapterer_seqarray[NSYS_SM_CE_ARRAYSIZE];";
  z[lc++]="  unsigned long chapterev_seqarray[NSYS_SM_CE_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptert_seqnum;    ";
  z[lc++]="  unsigned long chaptera_seqnum;";
  z[lc++]="  unsigned long chaptera_seqarray[NSYS_SM_CA_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* sender state for chapter c */";
  z[lc++]="  ";
  z[lc++]="  unsigned long chapterc_logptr[NSYS_SM_CC_ARRAYSIZE];  /* log positions */";
  z[lc++]="  int chapterc_sset;                                    /* S bit indicators */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterc_sustain;                       /* ALT state holders */";
  z[lc++]="  unsigned char chapterc_allsound;                      ";
  z[lc++]="  unsigned char chapterc_rac;";
  z[lc++]="  unsigned char chapterc_allnotes;                    ";
  z[lc++]="  unsigned char chapterc_omni_off;                    ";
  z[lc++]="  unsigned char chapterc_omni_on;                    ";
  z[lc++]="  unsigned char chapterc_monomode;                    ";
  z[lc++]="  unsigned char chapterc_polymode;                    ";
  z[lc++]="";
  z[lc++]="  /* sender state for chapter m */";
  z[lc++]="  ";
  z[lc++]="  unsigned long chapterm_logptr[NSYS_SM_CM_ARRAYSIZE];  /* log positions    */";
  z[lc++]="  unsigned long chapterm_dummy_logptr;";
  z[lc++]="  int chapterm_sset;                                    /* S bit indicators */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterm_state;                         /* state machine    */";
  z[lc++]="  unsigned char chapterm_rpn_msb;";
  z[lc++]="  unsigned char chapterm_rpn_lsb;";
  z[lc++]="  unsigned char chapterm_nrpn_msb;";
  z[lc++]="  unsigned char chapterm_nrpn_lsb;";
  z[lc++]="";
  z[lc++]="  short chapterm_cbutton[NSYS_SM_CM_ARRAYSIZE];    /* C-active button count */";
  z[lc++]="";
  z[lc++]="  /* sender state for chapter n */";
  z[lc++]="  ";
  z[lc++]="  unsigned char chapterb_low;      ";
  z[lc++]="  unsigned char chapterb_high;   ";
  z[lc++]="  unsigned long chaptern_logptr[NSYS_SM_CN_ARRAYSIZE]; /* note log position */";
  z[lc++]="  unsigned long chaptern_timer[NSYS_SM_CN_ARRAYSIZE];  /* Y timer values */";
  z[lc++]="  unsigned long chaptern_timernum;                     /* number of values */";
  z[lc++]="  int chaptern_sset;                                   /* S bit indicators */";
  z[lc++]="";
  z[lc++]="  /* sender state for chapter e */";
  z[lc++]="  ";
  z[lc++]="  unsigned char chaptere_ref[NSYS_SM_CE_ARRAYSIZE];     /* reference count   */";
  z[lc++]="  unsigned long chapterer_logptr[NSYS_SM_CE_ARRAYSIZE];  /* ref log positions */";
  z[lc++]="  unsigned long chapterev_logptr[NSYS_SM_CE_ARRAYSIZE]; /* off vel positions */";
  z[lc++]="  int chaptere_sset;                                    /* S bit indicator */";
  z[lc++]="  ";
  z[lc++]="  /* sender state for chapter a */";
  z[lc++]="  ";
  z[lc++]="  unsigned long chaptera_logptr[NSYS_SM_CA_ARRAYSIZE];  /* log positions */";
  z[lc++]="  int chaptera_sset;                                    /* S bit indicators */";
  z[lc++]="  ";
  z[lc++]="  /* sizes for dynamic chapters */";
  z[lc++]="  ";
  z[lc++]="  int chapterc_size;  /* chapter c */";
  z[lc++]="  int chapterm_size;  /* chapter m -- header  */";
  z[lc++]="  int chapterl_size;  /* chapter m -- loglist */";
  z[lc++]="  int chaptern_size;  /* chapter n */";
  z[lc++]="  int chapterb_size;  /* chapter n - bitfields */";
  z[lc++]="  int chaptere_size;  /* chapter e - header + ref log array */";
  z[lc++]="  int chaptera_size;  /* chapter a */";
  z[lc++]="  ";
  z[lc++]="  /* holds current packet bytes */";
  z[lc++]="  ";
  z[lc++]="  unsigned char cheader[NSYS_SM_CH_SIZE];         /* chapter header */";
  z[lc++]="  unsigned char chapterp[NSYS_SM_CP_SIZE];        /* chapter p  */";
  z[lc++]="  unsigned char chapterc[NSYS_SM_CC_SIZE];        /* chapter c  */";
  z[lc++]="  unsigned char chapterm[NSYS_SM_CM_HDRMAXSIZE];  /* chapter m  */";
  z[lc++]="  unsigned char chapterl[NSYS_SM_CM_LISTMAXSIZE]; /* chapter m - loglist */";
  z[lc++]="  unsigned char chapterw[NSYS_SM_CW_SIZE];        /* chapter w  */";
  z[lc++]="  unsigned char chaptern[NSYS_SM_CN_SIZE];        /* chapter n  */";
  z[lc++]="  unsigned char chapterb[NSYS_SM_CB_SIZE];        /* chapter n - bfields */";
  z[lc++]="  unsigned char chaptere[NSYS_SM_CE_SIZE];        /* chapter e */";
  z[lc++]="  unsigned char chaptert[NSYS_SM_CT_SIZE];        /* chapter t  */";
  z[lc++]="  unsigned char chaptera[NSYS_SM_CA_SIZE];        /* chapter a  */";
  z[lc++]="  ";
  z[lc++]="} nsys_netout_jsend_state;";
  z[lc++]="";
  z[lc++]="extern nsys_netout_jsend_state nsys_netout_jsend[];";
  z[lc++]="";
  z[lc++]="/***********************************************/";
  z[lc++]="/* structure holding a chapter x stack element */";
  z[lc++]="/***********************************************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_netout_jsend_xstack_element {";
  z[lc++]="";
  z[lc++]="  int size;";
  z[lc++]="  int index;                                          /* stack position    */";
  z[lc++]="  unsigned long seqnum;";
  z[lc++]="  struct nsys_netout_jsend_xstack_element ** cmdptr;  /* command pointer   */";
  z[lc++]="";
  z[lc++]="  struct nsys_netout_jsend_xstack_element * next;";
  z[lc++]="";
  z[lc++]="  unsigned char log[NSYS_SM_CX_SIZE_MAXLOG];";
  z[lc++]="";
  z[lc++]="} nsys_netout_jsend_xstack_element;";
  z[lc++]="";
  z[lc++]="extern nsys_netout_jsend_xstack_element nsys_netout_jsend_xpile[]; /* element array */";
  z[lc++]="extern nsys_netout_jsend_xstack_element * nsys_netout_jsend_xstackfree; /* freelist */";
  z[lc++]="";
  z[lc++]="/*****************************************/";
  z[lc++]="/* structure holding sender system state */";
  z[lc++]="/*****************************************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_netout_jsend_system_state {";
  z[lc++]="  ";
  z[lc++]="  unsigned short slen;    /* value of LENGTH header field */";
  z[lc++]="";
  z[lc++]="  /* sequence numbers -- 0 or highest seqnum */";
  z[lc++]="";
  z[lc++]="  unsigned long sheader_seqnum; ";
  z[lc++]="  unsigned long chapterd_seqnum;";
  z[lc++]="  unsigned long chapterd_reset_seqnum;";
  z[lc++]="  unsigned long chapterd_tune_seqnum;";
  z[lc++]="  unsigned long chapterd_song_seqnum;";
  z[lc++]="  unsigned long chapterd_scj_seqnum;";
  z[lc++]="  unsigned long chapterd_sck_seqnum;";
  z[lc++]="  unsigned long chapterd_rty_seqnum;";
  z[lc++]="  unsigned long chapterd_rtz_seqnum;";
  z[lc++]="  unsigned long chapterv_seqnum;";
  z[lc++]="  unsigned long chapterq_seqnum;";
  z[lc++]="  unsigned long chapterf_seqnum;";
  z[lc++]="  unsigned long chapterfc_seqnum;";
  z[lc++]="  unsigned long chapterx_seqnum;";
  z[lc++]="";
  z[lc++]="  /* sizes for dynamic chapters */";
  z[lc++]="";
  z[lc++]="  int chapterd_front_size;";
  z[lc++]="  int chapterd_scj_size;";
  z[lc++]="  int chapterd_sck_size;";
  z[lc++]="  int chapterq_size; ";
  z[lc++]="  int chapterf_size; ";
  z[lc++]="";
  z[lc++]="  /* state for Chapter D (Simple System Commands) */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterd_reset;";
  z[lc++]="  unsigned char chapterd_tune;";
  z[lc++]="  unsigned char chapterd_song;";
  z[lc++]="";
  z[lc++]="  /* state for Chapter F (MIDI Time Code) */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterf_point;";
  z[lc++]="";
  z[lc++]="  /* state for Chapter X (SysEx) */";
  z[lc++]="";
  z[lc++]="  int chapterx_stacklen;          /* number of logs in stack            */";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_xstack_element * chapterx_gmreset_off;   /* points into stack */";
  z[lc++]="  nsys_netout_jsend_xstack_element * chapterx_gmreset_on; ";
  z[lc++]="  nsys_netout_jsend_xstack_element * chapterx_mvolume;  ";
  z[lc++]="";
  z[lc++]="  unsigned char chapterx_mvolume_count;      /* session history counts */";
  z[lc++]="  unsigned char chapterx_gmreset_off_count;  ";
  z[lc++]="  unsigned char chapterx_gmreset_on_count;   ";
  z[lc++]="";
  z[lc++]="  /* holds current packet bytes */";
  z[lc++]="  ";
  z[lc++]="  unsigned char sheader[NSYS_SM_SH_SIZE];                  /* chapter header */";
  z[lc++]="  unsigned char chapterd_front[NSYS_SM_CD_FRONT_MAXSIZE];  /* chapter d (front) */";
  z[lc++]="  unsigned char chapterd_scj[NSYS_SM_CD_COMMON_SIZE];      /* chapter d (common J) */";
  z[lc++]="  unsigned char chapterd_sck[NSYS_SM_CD_COMMON_SIZE];      /* chapter d (common K) */";
  z[lc++]="  unsigned char chapterd_rty[NSYS_SM_CD_REALTIME_SIZE];    /* chapter d (realtime Y) */";
  z[lc++]="  unsigned char chapterd_rtz[NSYS_SM_CD_REALTIME_SIZE];    /* chapter d (realtime Z) */";
  z[lc++]="  unsigned char chapterv[NSYS_SM_CV_SIZE];                 /*   chapter v    */";
  z[lc++]="  unsigned char chapterq[NSYS_SM_CQ_MAXSIZE];              /*   chapter q    */";
  z[lc++]="  unsigned char chapterf[NSYS_SM_CF_MAXSIZE];              /*   chapter f    */";
  z[lc++]="  nsys_netout_jsend_xstack_element * chapterx_stack[NSYS_SM_CX_MAXSLOTS]; /* ch x */";
  z[lc++]="";
  z[lc++]="} nsys_netout_jsend_system_state;";
  z[lc++]="";
  z[lc++]="extern nsys_netout_jsend_system_state nsys_netout_jsend_system;";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* structure holding receiver channel state */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_netout_jrecv_state {";
  z[lc++]="";
  z[lc++]="  /* chapter p */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterp_program;";
  z[lc++]="  unsigned char chapterp_bank_msb;";
  z[lc++]="  unsigned char chapterp_bank_lsb;";
  z[lc++]="";
  z[lc++]="  /* chapter c */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterc_value[NSYS_SM_CC_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* chapter m */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterm_value_lsb[NSYS_SM_CM_ARRAYSIZE];";
  z[lc++]="  unsigned char chapterm_value_msb[NSYS_SM_CM_ARRAYSIZE];";
  z[lc++]="  short chapterm_cbutton[NSYS_SM_CM_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  unsigned char chapterm_state;             /* state machine */";
  z[lc++]="  unsigned char chapterm_rpn_msb;";
  z[lc++]="  unsigned char chapterm_rpn_lsb;";
  z[lc++]="  unsigned char chapterm_nrpn_msb;";
  z[lc++]="  unsigned char chapterm_nrpn_lsb;";
  z[lc++]="";
  z[lc++]="  /* chapter w */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterw_first;";
  z[lc++]="  unsigned char chapterw_second;";
  z[lc++]="";
  z[lc++]="  /* chapter n */";
  z[lc++]="";
  z[lc++]="  unsigned char chaptern_ref[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned char chaptern_vel[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptern_tstamp[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptern_extseq[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* chapter t */";
  z[lc++]="";
  z[lc++]="  unsigned char chaptert_pressure;";
  z[lc++]="";
  z[lc++]="  /* chapter a */";
  z[lc++]="";
  z[lc++]="  unsigned char chaptera_pressure[NSYS_SM_CA_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* navigation */";
  z[lc++]="";
  z[lc++]="  unsigned char chan;";
  z[lc++]="  struct nsys_netout_jrecv_state * next;";
  z[lc++]="";
  z[lc++]="} nsys_netout_jrecv_state;";
  z[lc++]="";
  z[lc++]="extern nsys_netout_jrecv_state * nsys_recvfree;  /* channel free list */";
  z[lc++]="";
  z[lc++]="/*******************************************/";
  z[lc++]="/* structure holding receiver system state */";
  z[lc++]="/*******************************************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_netout_jrecv_system_state {";
  z[lc++]="";
  z[lc++]="  /* chapter d */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterd_reset;";
  z[lc++]="  unsigned char chapterd_tune;";
  z[lc++]="  unsigned char chapterd_song;";
  z[lc++]="  unsigned char chapterd_scj_count;";
  z[lc++]="  unsigned char chapterd_scj_data1;";
  z[lc++]="  unsigned char chapterd_scj_data2;";
  z[lc++]="  unsigned char chapterd_sck_count;";
  z[lc++]="  unsigned char chapterd_sck_data1;";
  z[lc++]="  unsigned char chapterd_sck_data2;";
  z[lc++]="  unsigned char chapterd_rty;";
  z[lc++]="  unsigned char chapterd_rtz;";
  z[lc++]="";
  z[lc++]="  /* chapter v */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterv_count;";
  z[lc++]="";
  z[lc++]="  /* chapter q */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterq_shadow[NSYS_SM_CQ_MAXSIZE];";
  z[lc++]="";
  z[lc++]="  /* chapter f */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterf_has_complete;";
  z[lc++]="  unsigned char chapterf_quarter;";
  z[lc++]="  unsigned char chapterf_has_partial;";
  z[lc++]="  unsigned char chapterf_direction;";
  z[lc++]="  unsigned char chapterf_point;";
  z[lc++]="";
  z[lc++]="  unsigned char chapterf_complete[NSYS_SM_CF_SIZE_COMPLETE];";
  z[lc++]="  unsigned char chapterf_partial[NSYS_SM_CF_SIZE_PARTIAL];";
  z[lc++]="";
  z[lc++]="  /* chapter x */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterx_gmreset;";
  z[lc++]="  unsigned char chapterx_gmreset_off_count;  ";
  z[lc++]="  unsigned char chapterx_gmreset_on_count;   ";
  z[lc++]="";
  z[lc++]="  unsigned char chapterx_mvolume_lsb;";
  z[lc++]="  unsigned char chapterx_mvolume_msb;";
  z[lc++]="";
  z[lc++]="  /* navigation */";
  z[lc++]="";
  z[lc++]="  struct nsys_netout_jrecv_system_state * next;";
  z[lc++]="";
  z[lc++]="} nsys_netout_jrecv_system_state;";
  z[lc++]="";
  z[lc++]="extern nsys_netout_jrecv_system_state * nsys_recvsysfree;  /* system free list */";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* supported SysEx commands */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_netout_sysconst_manuex[];";
  z[lc++]="extern unsigned char nsys_netout_sysconst_mvolume[];";
  z[lc++]="extern unsigned char nsys_netout_sysconst_gmreset[];";
  z[lc++]="";
  z[lc++]="/*******/";
  z[lc++]="/* SIP */";
  z[lc++]="/*******/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_rtp_invite[];";
  z[lc++]="extern unsigned char nsys_rtcp_invite[];";
  z[lc++]="";
  z[lc++]="extern int nsys_rtp_sipretry;                  /* sip server retry counter */";
  z[lc++]="extern int nsys_rtcp_sipretry;                 ";
  z[lc++]="";
  z[lc++]="extern int nsys_rtp_authretry;                 /* reauthorization counter  */";
  z[lc++]="extern int nsys_rtcp_authretry;";
  z[lc++]="";
  z[lc++]="extern struct sockaddr_in nsys_sip_rtp_addr;   /* current SIP RTP channel */";
  z[lc++]="extern char nsys_sip_rtp_ip[];";
  z[lc++]="extern unsigned long nsys_sip_rtp_inet_addr;";
  z[lc++]="extern unsigned short nsys_sip_rtp_port;";
  z[lc++]="extern unsigned short nsys_sip_rtp_sin_port;";
  z[lc++]="";
  z[lc++]="extern struct sockaddr_in nsys_sip_rtcp_addr;  /* current SIP RTCP channel */";
  z[lc++]="extern char nsys_sip_rtcp_ip[];";
  z[lc++]="extern unsigned long nsys_sip_rtcp_inet_addr;";
  z[lc++]="extern unsigned short nsys_sip_rtcp_port;";
  z[lc++]="extern unsigned short nsys_sip_rtcp_sin_port;";
  z[lc++]="";
  z[lc++]="extern int nsys_graceful_exit;                 /* requests termination    */";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_rtp_info[];          /* SIP INFO packets        */";
  z[lc++]="extern unsigned char nsys_rtcp_info[];";
  z[lc++]="";
  z[lc++]="extern int nsys_behind_nat;                    /* 1 if behind a nat        */";
  z[lc++]="extern int nsys_sipinfo_count;                 /* INFO sending timer       */";
  z[lc++]="extern int nsys_sipinfo_toggle;                /* RTP/RTCP toggle          */";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* SSRC stack  */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="typedef struct nsys_source {";
  z[lc++]="";
  z[lc++]="  /* information */";
  z[lc++]="";
  z[lc++]="  int mset;                           /* MIDI extchan set  */";
  z[lc++]="  unsigned long ssrc;                 /* RTP SSRC number   */";
  z[lc++]="  unsigned long birthtime;            /* Time SSRC was born (UNIX)    */";
  z[lc++]="";
  z[lc++]="  unsigned long siptime;              /* SIP INVITE sessiontime (UNIX)    */";
  z[lc++]="  struct sockaddr_in * sdp_addr;      /* IP/port in SDP packet, unchanged */";
  z[lc++]="";
  z[lc++]="  struct sockaddr_in * rtp_addr;      /* RTP IP/port of source */";
  z[lc++]="  struct sockaddr_in * alt_rtp_addr;  /* RTP IP/port of NATing */";
  z[lc++]="";
  z[lc++]="  struct sockaddr_in * rtcp_addr;     /* RTCP IP/port of source */";
  z[lc++]="  struct sockaddr_in * alt_rtcp_addr; /* RTCP IP/port of NATing */";
  z[lc++]=" ";
  z[lc++]="  unsigned char ptype;                /* payload type to send/recv */";
  z[lc++]="  int pindex;                         /* index into nsys_payload_types[]  */";
  z[lc++]="  int srate;                          /* SDP-assigned srate        */";
  z[lc++]="";
  z[lc++]="  /* navigation */";
  z[lc++]="";
  z[lc++]="  struct nsys_source * xtra;               /* if hash clashes */";
  z[lc++]="  struct nsys_source * prev;               /* doubly-linked list */";
  z[lc++]="  struct nsys_source * next;";
  z[lc++]="";
  z[lc++]="  /* reception statistics */";
  z[lc++]="";
  z[lc++]="  unsigned long received;             /* total num packets received   */";
  z[lc++]="  unsigned long received_prior;       /* total at last SR/RR          */";
  z[lc++]="  unsigned long expected_prior;       /* total expected at last SR/RR */";
  z[lc++]="";
  z[lc++]="  unsigned long base_seq;             /* initial extended seq num   */";
  z[lc++]="  unsigned long hi_lobits;            /* highest seq num low 16b    */";
  z[lc++]="  unsigned long hi_ext;               /* highest extended seq num   */";
  z[lc++]="";
  z[lc++]="  /* rtcp items */";
  z[lc++]="";
  z[lc++]="  int j_delta;                        /* state variable for jitter  */";
  z[lc++]="  unsigned long jitter;               /* current jitter value       */";
  z[lc++]="  unsigned char lsr[4];               /* last SR timestamp received */";
  z[lc++]="  struct timeval arrival;             /* arrival time of last SR    */";
  z[lc++]="  time_t expire_rtcp;                 /* time to expire ssrc entry  */";
  z[lc++]="  char * cname;                       /* canonical name             */";
  z[lc++]="  unsigned long rtcp_received;        /* for DoS detection          */";
  z[lc++]="";
  z[lc++]="  /* time model */";
  z[lc++]="";
  z[lc++]="  int ontime;                         /* flags on-time RTP packets   */    ";
  z[lc++]="  unsigned long tm_convert;           /* local/remote time offset    */";
  z[lc++]="  unsigned long tm_margin;            /* maximum lateness allowed    */";
  z[lc++]="  unsigned long tm_lateflag;          /* congestion detection flag   */";
  z[lc++]="  unsigned long tm_latetime;          /* tstamp of first late packet */";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  unsigned long tm_first;             /* temporary for printfs       */";
  z[lc++]="  FILE * tm_fd;                       /* file pointer for dat files  */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* journal items */";
  z[lc++]="";
  z[lc++]="  unsigned long last_hiseq_rec;       /* RTCP extended sequence number   */";
  z[lc++]="  unsigned long last_hiseq_ext;       /* local-adjusted RTCP ext seq num */";
  z[lc++]="";
  z[lc++]="  struct nsys_netout_jrecv_state";
  z[lc++]="  * jrecv[CSYS_MIDI_NUMCHAN];         /* reciever channel journal state */";
  z[lc++]="";
  z[lc++]="  nsys_netout_jrecv_system_state * jrecvsys;   /* receiver system state */";
  z[lc++]="  ";
  z[lc++]="} nsys_source;";
  z[lc++]="";
  z[lc++]="extern struct nsys_source * nsys_srcfree;       /* mset ssrc tokens */";
  z[lc++]="extern struct nsys_source * nsys_ssrc[];        /* SSRC hash table  */";
  z[lc++]="extern struct nsys_source * nsys_srcroot;       /* points into nsys_ssrc */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                              Macros                                    */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* error-checking */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="#define  NSYS_ERROR_RETURN(x) do {\\";
  z[lc++]="      nsys_stderr_size+=fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      nsys_stderr_size+=fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      return NSYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  NSYS_ERROR_TERMINATE(x) do {\\";
  z[lc++]="      nsys_stderr_size+=fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));\\";
  z[lc++]="      epr(0,NULL,NULL, \"Network error -- \" x );}  while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                        Function Externs                                */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* error checking */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="extern void epr(int linenum, char * filename, char * token, char * message);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_siplib.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern int nsys_initsip(void);";
  z[lc++]="extern void nsys_netin_reply(int fd, struct sockaddr_in * addr, ";
  z[lc++]="			     unsigned char * packet, unsigned short status);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_invite(int fd, struct sockaddr_in * addr, ";
  z[lc++]="			      unsigned char * packet);";
  z[lc++]="";
  z[lc++]="extern void nsys_createsip(int fd, char * method, unsigned char * sip,";
  z[lc++]="			   char * natline, char * nonce);";
  z[lc++]="extern void nsys_sendsip(int fd, struct sockaddr_in * addr, ";
  z[lc++]="			 unsigned char * sip); ";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_netin_readmethod(int fd, struct sockaddr_in * addr, ";
  z[lc++]="					     unsigned char * packet); ";
  z[lc++]="extern void nsys_netin_ack(int fd, unsigned char * reply, ";
  z[lc++]="			   unsigned long callid, unsigned long cseq);";
  z[lc++]="extern int nsys_netin_replyparse(int fd, unsigned char * packet, ";
  z[lc++]="				 char *nonce, char * natline, ";
  z[lc++]="				 unsigned long * callid, unsigned long * cseq);";
  z[lc++]="extern void nsys_netin_redirect(int fd, unsigned char * packet,";
  z[lc++]="				unsigned short status);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_sipaddr(int fd, char * ip, unsigned short port);";
  z[lc++]="extern int nsys_netin_siporigin(int fd, struct sockaddr_in * addr);";
  z[lc++]="extern int nsys_netin_make_marray(struct nsys_payinfo ** marray, char * media);";
  z[lc++]="extern int nsys_netin_set_marray(char * line, struct nsys_payinfo marray[],";
  z[lc++]="				 int mlen);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_payvalid(struct nsys_payinfo marray[], int mlen, int fd);";
  z[lc++]="extern void nsys_netin_payset(struct nsys_source * sptr, struct nsys_payinfo marray[],";
  z[lc++]="			      int mlen);";
  z[lc++]="extern int nsys_netin_noreplay(char * ip, unsigned short port, ";
  z[lc++]="			       unsigned long sdp_time);";
  z[lc++]="extern void nsys_sip_shutdown(void);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_rtplib.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern int nsys_setup(int block);";
  z[lc++]="extern void nsys_shutdown(void);";
  z[lc++]="";
  z[lc++]="extern nsys_source * nsys_netin_addsrc(int fd, long ssrc,";
  z[lc++]="				  char * ip, unsigned short port);";
  z[lc++]="extern int nsys_netin_rtpstats(nsys_source * sptr, unsigned char * packet);";
  z[lc++]="extern void  nsys_warning(int level, char * message);";
  z[lc++]="extern void nsys_terminate_error(char * message); ";
  z[lc++]="extern void nsys_status(nsys_source * sptr, char * message);";
  z[lc++]="extern int nsys_netin_ptypevalid(unsigned char ptype);";
  z[lc++]="extern void nsys_netin_ptypeset(struct nsys_source * sptr, unsigned char ptype);";
  z[lc++]="extern nsys_netout_jrecv_state * nsys_netin_newrecv(unsigned char chan);";
  z[lc++]="extern nsys_netout_jrecv_system_state * nsys_netin_newrecvsys(void);";
  z[lc++]="extern char * nsys_find_clientip(char * ip);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_rtcplib.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern nsys_source * nsys_netin_rtcp(unsigned char * packet, int len, ";
  z[lc++]="				struct sockaddr_in * ipaddr);";
  z[lc++]="extern int nsys_make_rtcp(void);";
  z[lc++]="extern int nsys_make_rtcpbye(void);";
  z[lc++]="extern void nsys_netout_rtcptime(void);";
  z[lc++]="extern void nsys_delete_ssrc(unsigned long ssrc, char * reason);";
  z[lc++]="extern nsys_source * nsys_harvest_ssrc(int fd, struct sockaddr_in * ipaddr);";
  z[lc++]="extern void nsys_late_windowcheck(nsys_source * sptr, unsigned long tstamp);";
  z[lc++]="extern char * nsys_netin_newcname(unsigned char * packet, int len);";
  z[lc++]="extern void nsys_netin_bye(unsigned char * packet, int len);";
  z[lc++]="extern int nsys_netout_excheck(void);";
  z[lc++]="extern void nsys_netout_keepalive(void);";
  z[lc++]="extern void nsys_netin_rtcp_display(unsigned char * packet, int len,";
  z[lc++]="				    struct timeval * now);";
  z[lc++]="extern void nsys_netout_rtcpreport(void);";
  z[lc++]="extern void nsys_netout_rtcpsend(unsigned char * p, int len);";
  z[lc++]="extern int nsys_netin_clear_mset(unsigned char * buff, long * fill,";
  z[lc++]="				 long size);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_rtcp_initpackets(void);";
  z[lc++]="extern void nsys_netout_rtcp_initrr(unsigned char * p, int len);";
  z[lc++]="extern void nsys_netout_rtcp_initsr(unsigned char * p, int len);";
  z[lc++]="extern void nsys_netout_rtcp_initsdes(unsigned char * p, int len);";
  z[lc++]="extern void nsys_netout_rtcp_initbye(unsigned char * p);";
  z[lc++]="extern void nsys_netin_rtcp_trunc(int sub);";
  z[lc++]="extern void nsys_netin_latenotes_open(nsys_source * sptr);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_sfront.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern int nsys_sysex_parse(unsigned char * cmd, unsigned char *ndata,";
  z[lc++]="			    unsigned char * vdata, unsigned char * sysbuf, ";
  z[lc++]="			    int sysidx);";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* net_jsend.c */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_create(unsigned char * packet, int len);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addstate(unsigned char cmd,";
  z[lc++]="					unsigned char ndata,";
  z[lc++]="					unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addhistory(unsigned char cmd,";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_journal_trimstate(nsys_source * lptr);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_midistate_init(void);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_guard_tick(void);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_changecheck(void);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addprogram(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addcontrol(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addparameter(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					     unsigned char ndata,";
  z[lc++]="					     unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addpwheel(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					  unsigned char ndata, ";
  z[lc++]="					  unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addnoteoff(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata, ";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addnoteon(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					  unsigned char ndata, ";
  z[lc++]="					  unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addnoteon_extras(nsys_netout_jsend_state * jsend, ";
  z[lc++]="						 unsigned char ndata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addnoteoff_extras(nsys_netout_jsend_state * jsend, ";
  z[lc++]="						  unsigned char ndata,";
  z[lc++]="						  unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addctouch(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					  unsigned char ndata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addptouch(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addsong(unsigned char ndata);";
  z[lc++]="extern void nsys_netout_journal_addtune(void);";
  z[lc++]="extern void nsys_netout_journal_addreset(void);";
  z[lc++]="extern void nsys_netout_journal_addsc(unsigned char cmd, unsigned char ndata,";
  z[lc++]="				      unsigned char vdata);";
  z[lc++]="extern void nsys_netout_journal_addrt(unsigned char cmd);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addsense(void);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addsequence(unsigned char cmd, unsigned char ndata,";
  z[lc++]="					    unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addtimecode(unsigned char ndata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_addsysex(unsigned char cmd, unsigned char ndata,";
  z[lc++]="					 unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimchapter(nsys_netout_jsend_state * jsend,";
  z[lc++]="					    int channel);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimprogram(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimallcontrol(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimpartcontrol(nsys_netout_jsend_state * jsend,";
  z[lc++]="						unsigned long minseq);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimallparams(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimpartparams(nsys_netout_jsend_state * jsend,";
  z[lc++]="					       unsigned long minseq);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimpwheel(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimallnote(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimpartnote(nsys_netout_jsend_state * jsend,";
  z[lc++]="					     unsigned long minseq);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimallextras(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimpartextras(nsys_netout_jsend_state * jsend,";
  z[lc++]="					       unsigned long minseq);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimctouch(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimallptouch(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimpartptouch(nsys_netout_jsend_state * jsend,";
  z[lc++]="						unsigned long minseq);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimsystem(void);";
  z[lc++]="extern void nsys_netout_journal_trimsimple(void);";
  z[lc++]="extern void nsys_netout_journal_trimreset(void);";
  z[lc++]="extern void nsys_netout_journal_trimtune(void);";
  z[lc++]="extern void nsys_netout_journal_trimsong(void);";
  z[lc++]="extern void nsys_netout_journal_trimscj(void);";
  z[lc++]="extern void nsys_netout_journal_trimsck(void);";
  z[lc++]="extern void nsys_netout_journal_trimrty(void);";
  z[lc++]="extern void nsys_netout_journal_trimrtz(void);";
  z[lc++]="extern void nsys_netout_journal_trimsense(void);";
  z[lc++]="extern void nsys_netout_journal_trimsequence(void);";
  z[lc++]="extern void nsys_netout_journal_trimtimecode(void);";
  z[lc++]="extern void nsys_netout_journal_trimparttimecode(void);";
  z[lc++]="extern void nsys_netout_journal_trimsysex(void);";
  z[lc++]="extern void nsys_netout_journal_trimpartsysex(unsigned long minseq);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_clear_nactive(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_clear_cactive(nsys_netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_clear_active(unsigned char cmd);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_clear_clog(nsys_netout_jsend_state * jsend,";
  z[lc++]="					   unsigned char number);";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* net_recv.c */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_recovery(nsys_source * sptr, int rtpcode, ";
  z[lc++]="				       unsigned char * packet, int numbytes,";
  z[lc++]="				       unsigned char * buff, long * fill,";
  z[lc++]="				       long size);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_journal_trackstate(nsys_source * sptr, unsigned char cmd,";
  z[lc++]="					  unsigned char ndata, ";
  z[lc++]="					  unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_addcmd_three(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="					   long * fill, long size,";
  z[lc++]="					   unsigned char cmd, unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_addcmd_two(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="					 long * fill, long size,";
  z[lc++]="					 unsigned char cmd, unsigned char ndata);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_addcmd_one(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="					 long * fill, long size, unsigned char cmd);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_trans(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="				long * fill, long size, unsigned char chan,";
  z[lc++]="				int flags, unsigned char msb_num, ";
  z[lc++]="				unsigned char lsb_num, unsigned char msb_val, ";
  z[lc++]="				unsigned char lsb_val);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_button_trans(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="					   long * fill, long size, ";
  z[lc++]="					   unsigned char chan, int flags,";
  z[lc++]="					   unsigned char msb_num, ";
  z[lc++]="					   unsigned char lsb_num, short count);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_journal_clear_active(unsigned char cmd);";
  z[lc++]="     ";
  z[lc++]="extern int nsys_netin_jrec_program(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				   nsys_netout_jrecv_state * jrecv,";
  z[lc++]="				   unsigned char * buff,  ";
  z[lc++]="				   long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_control(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				   nsys_netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="				   unsigned char many, unsigned char * buff, ";
  z[lc++]="				   long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_param(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				 nsys_netout_jrecv_state * jrecv, ";
  z[lc++]="				 short paramlen, unsigned char many, ";
  z[lc++]="				 unsigned char * buff, long * fill,";
  z[lc++]="				 long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_wheel(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				 nsys_netout_jrecv_state * jrecv,";
  z[lc++]="				 unsigned char * buff,  ";
  z[lc++]="				 long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_notelog(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				   nsys_netout_jrecv_state * jrecv, ";
  z[lc++]="				   unsigned char many,";
  z[lc++]="				   short loglen, unsigned char * checkptr,";
  z[lc++]="				   unsigned char * buff, ";
  z[lc++]="				   long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_bitfield(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				    nsys_netout_jrecv_state * jrecv, ";
  z[lc++]="				    unsigned char low, unsigned char high,";
  z[lc++]="				    unsigned char * buff, long * fill,";
  z[lc++]="				    long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_ctouch(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				  nsys_netout_jrecv_state * jrecv,";
  z[lc++]="				  unsigned char * buff,  ";
  z[lc++]="				  long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_ptouch(nsys_source * sptr, unsigned char * p,";
  z[lc++]="				  nsys_netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="				  unsigned char many, unsigned char * buff, ";
  z[lc++]="				  long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_reset(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="				 nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				 unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_tune(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="				nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_song(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="				nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_scj(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			       nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			       unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_sck(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			       nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			       unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_rty(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			       nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			       unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_rtz(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			       nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			       unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_sense(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="				 nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				 unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_sequence(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="				    nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				    unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_timecode(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="				    nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				    unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_sysex(nsys_source * sptr, unsigned char * ps, int syslen,";
  z[lc++]="				 nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				 unsigned char * buff, long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_track_timecode(nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="				      unsigned char ndata);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_crypto.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_md5(unsigned char * digest, unsigned char * text,";
  z[lc++]="				int len);";
  z[lc++]="";
  z[lc++]="extern char * nsys_hmac_md5(unsigned char* text, int text_len, ";
  z[lc++]="			    unsigned char * keydigest, unsigned char * digest);";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_digest_base64(unsigned char * output, ";
  z[lc++]="					  unsigned char * input);";
  z[lc++]="";
  z[lc++]="extern int nsys_digest_syntaxcheck(char * s);";
  z[lc++]="";
  z[lc++]="#endif /* NSYS_NET_INCLUDE */";
  z[lc++]="";
  z[lc++]="/* end Network library -- constants and externs */";
  z[lc++]="";
  printlib(lc);
}


void makenet_globals(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- global variables";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: network */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="int nsys_rtp_fd;                  /* fd for rtp           */";
  z[lc++]="int nsys_rtcp_fd;                 /* fd for rtcp          */";
  z[lc++]="int nsys_max_fd;                  /* fd for select        */";
  z[lc++]="";
  z[lc++]="unsigned short nsys_rtp_port;     /* actual rtp port     */ ";
  z[lc++]="unsigned short nsys_rtcp_port;    /* actual rtcp port    */ ";
  z[lc++]="";
  z[lc++]="unsigned long nsys_rtp_cseq;      /* rtp cseq number      */";
  z[lc++]="unsigned long nsys_rtcp_cseq;     /* rtcp cseq number     */";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: packets */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_rtp_packet[NSYS_UDPMAXSIZE];  /* rtp packet out */";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_netout_rtcp_packet_rrempty;";
  z[lc++]="unsigned char * nsys_netout_rtcp_packet_rr;";
  z[lc++]="unsigned char * nsys_netout_rtcp_packet_srempty;";
  z[lc++]="unsigned char * nsys_netout_rtcp_packet_sr;";
  z[lc++]="unsigned char * nsys_netout_rtcp_packet_bye;";
  z[lc++]="";
  z[lc++]="int nsys_netout_rtcp_len_rrempty;";
  z[lc++]="int nsys_netout_rtcp_len_rr;";
  z[lc++]="int nsys_netout_rtcp_len_srempty;";
  z[lc++]="int nsys_netout_rtcp_len_sr;";
  z[lc++]="int nsys_netout_rtcp_len_bye;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_rtcp_packet[NSYS_UDPMAXSIZE]; /* rtcp packet out */";
  z[lc++]="int nsys_netout_rtcp_size;                              /* rtcp packet size*/";
  z[lc++]="";
  z[lc++]="char * nsys_sdes_typename[NSYS_RTCPVAL_SDES_SIZE] = {  /* rtcp debug array */";
  z[lc++]="  \"ILLEGAL\", \"Cname\", \"Name\", \"Email\", \"Phone\", ";
  z[lc++]="  \"Loc\", \"Tool\", \"Note\", \"Priv\" };";
  z[lc++]="";
  z[lc++]="unsigned long nsys_netout_seqnum;  /* rtp output sequence number */";
  z[lc++]="unsigned long nsys_netout_tstamp;  /* rtp output timestamp */";
  z[lc++]="unsigned char nsys_netout_markbit; /* for setting markerbit */";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* rtp payload support  */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="#if 0";
  z[lc++]="/* when adding new codecs, follow this sample  */";
  z[lc++]="/* remember to increment NSYS_RTP_PAYSIZE, and */";
  z[lc++]="/* get ordering correct.                       */";
  z[lc++]="";
  z[lc++]="struct nsys_payinfo nsys_payload_types[NSYS_RTP_PAYSIZE] = ";
  z[lc++]="{ ";
  z[lc++]="  {NSYS_MPEG4_PINDEX,  96, \"mpeg4-generic\", (int)(ARATE + 0.5F)},";
  z[lc++]="  {NSYS_NATIVE_PINDEX, 97, \"rtp-midi\", (int)(ARATE + 0.5F)}";
  z[lc++]="};";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="struct nsys_payinfo nsys_payload_types[NSYS_RTP_PAYSIZE] = ";
  z[lc++]="{ ";
  z[lc++]="  {NSYS_MPEG4_PINDEX, 96, \"pre1-mpeg4-generic\", (int)(ARATE + 0.5F)}";
  z[lc++]="};";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* rtcp timer */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="int nsys_sent_last;       /* a packet was sent last RTCP period */";
  z[lc++]="int nsys_sent_this;       /* a packet was sent this RTCP period */";
  z[lc++]="";
  z[lc++]="unsigned long nsys_sent_packets;  /* number of packets sent */";
  z[lc++]="unsigned long nsys_sent_octets;   /* number of octets sent */";
  z[lc++]="";
  z[lc++]="time_t nsys_nexttime;     /* time for next RTCP check           */";
  z[lc++]="int nsys_rtcp_ex;         /* status flags to check at RTCP time */";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* identification */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="unsigned long nsys_myssrc;        /*  SSRC -- hostorder  */";
  z[lc++]="unsigned long nsys_myssrc_net;    /*  SSRC -- netorder   */";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="char * nsys_sessionname;   ";
  z[lc++]="char * nsys_sessionkey;   ";
  z[lc++]="int nsys_feclevel = NSYS_SM_FEC_STANDARD;";
  z[lc++]="int nsys_lateplay;";
  z[lc++]="float nsys_latetime = NSYS_SM_LATETIME;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="unsigned char nsys_keydigest[NSYS_MD5_LENGTH];";
  z[lc++]="unsigned char nsys_session_base64[NSYS_BASE64_LENGTH];";
  z[lc++]="int nsys_msession;";
  z[lc++]="int nsys_msessionmirror;";
  z[lc++]="";
  z[lc++]="char nsys_clientname[NSYS_HOSTNAMESIZE];";
  z[lc++]="char nsys_clientip[16];";
  z[lc++]="char * nsys_username;";
  z[lc++]="";
  z[lc++]="char nsys_cname[NSYS_CNAMESIZE];";
  z[lc++]="unsigned char nsys_cname_len;";
  z[lc++]="int nsys_powerup_mset; ";
  z[lc++]="";
  z[lc++]="/***********/";
  z[lc++]="/* logging */";
  z[lc++]="/***********/";
  z[lc++]="";
  z[lc++]="int nsys_stderr_size;";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* MIDI input buffer */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_buff[NSYS_BUFFSIZE];";
  z[lc++]="long nsys_bufflen;";
  z[lc++]="long nsys_buffcnt;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~*/";
  z[lc++]="/* rtp-midi  */";
  z[lc++]="/*___________*/";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* command section flags */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_sm_header;";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* checkpoint management */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="unsigned long nsys_netout_jsend_checkpoint_seqnum; /* current checkpoint */";
  z[lc++]="unsigned long nsys_netout_jsend_checkpoint_changed; /* 1 if changed */";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* S-list management */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_netout_jsend_slist[NSYS_SM_SLISTLEN];";
  z[lc++]="int nsys_netout_jsend_slist_size;";
  z[lc++]="";
  z[lc++]="/*******************************/";
  z[lc++]="/* guard journal state machine */";
  z[lc++]="/*******************************/";
  z[lc++]="";
  z[lc++]="int nsys_netout_jsend_guard_send;    /* flag variable: send a guard packet */";
  z[lc++]="int nsys_netout_jsend_guard_time;    /* guard packet timer state */";
  z[lc++]="int nsys_netout_jsend_guard_next;    /* reload value for timer */";
  z[lc++]="int nsys_netout_jsend_guard_ontime;  /* minimum delay time for noteon */ ";
  z[lc++]="int nsys_netout_jsend_guard_mintime; /* minimum delay time for (!noteon) */";
  z[lc++]="int nsys_netout_jsend_guard_maxtime; /* maximum delay time */ ";
  z[lc++]="";
  z[lc++]="/***************************/";
  z[lc++]="/* recovery journal header */";
  z[lc++]="/***************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_jsend_header[NSYS_SM_JH_SIZE];   /* journal header */";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* channel journal record */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_jsend_channel[CSYS_MIDI_NUMCHAN];";
  z[lc++]="unsigned char nsys_netout_jsend_channel_size;";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* sender channel state */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="nsys_netout_jsend_state nsys_netout_jsend[CSYS_MIDI_NUMCHAN];";
  z[lc++]="";
  z[lc++]="/***********************/";
  z[lc++]="/* sender system state */";
  z[lc++]="/***********************/";
  z[lc++]="";
  z[lc++]="nsys_netout_jsend_system_state nsys_netout_jsend_system;";
  z[lc++]="nsys_netout_jsend_xstack_element nsys_netout_jsend_xpile[NSYS_SM_CX_MAXSLOTS]; ";
  z[lc++]="nsys_netout_jsend_xstack_element * nsys_netout_jsend_xstackfree; ";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* receiver channel state */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="nsys_netout_jrecv_state * nsys_recvfree;  ";
  z[lc++]="nsys_netout_jrecv_system_state * nsys_recvsysfree;";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* supported SysEx commands */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_sysconst_manuex[CSYS_MIDI_MANUEX_SIZE] = {";
  z[lc++]="  0xF0, 0x43, 0x73, 0x7F, 0x32, 0x11, 0x00, 0x00, 0x00, 0xF7 };";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_sysconst_mvolume[CSYS_MIDI_MVOLUME_SIZE] = {";
  z[lc++]="  0xF0, 0x7F, 0x7F, 0x04, 0x01, 0x00, 0x00, 0xF7};";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_sysconst_gmreset[CSYS_MIDI_GMRESET_SIZE] = {";
  z[lc++]="  0xF0, 0x7E, 0x7F, 0x09, 0x00, 0xF7};";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*******/";
  z[lc++]="/* SIP */";
  z[lc++]="/*******/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_rtp_invite[NSYS_UDPMAXSIZE+1];";
  z[lc++]="unsigned char nsys_rtcp_invite[NSYS_UDPMAXSIZE+1];";
  z[lc++]="";
  z[lc++]="int nsys_rtp_sipretry;      /* sip server retry counter */";
  z[lc++]="int nsys_rtcp_sipretry;                 ";
  z[lc++]="";
  z[lc++]="int nsys_rtp_authretry;     /* reauthorization counter  */";
  z[lc++]="int nsys_rtcp_authretry;";
  z[lc++]="";
  z[lc++]="struct sockaddr_in nsys_sip_rtp_addr;   /* current SIP RTP channel */";
  z[lc++]="char nsys_sip_rtp_ip[16];";
  z[lc++]="unsigned long nsys_sip_rtp_inet_addr;";
  z[lc++]="unsigned short nsys_sip_rtp_port;";
  z[lc++]="unsigned short nsys_sip_rtp_sin_port;";
  z[lc++]="";
  z[lc++]="struct sockaddr_in nsys_sip_rtcp_addr;  /* current SIP RTCP channel */";
  z[lc++]="char nsys_sip_rtcp_ip[16];";
  z[lc++]="unsigned long nsys_sip_rtcp_inet_addr;";
  z[lc++]="unsigned short nsys_sip_rtcp_port;";
  z[lc++]="unsigned short nsys_sip_rtcp_sin_port;";
  z[lc++]="";
  z[lc++]="int nsys_graceful_exit;                 /* requests termination      */";
  z[lc++]="";
  z[lc++]="unsigned char nsys_rtp_info[NSYS_UDPMAXSIZE+1];  /* SIP INFO packets */";
  z[lc++]="unsigned char nsys_rtcp_info[NSYS_UDPMAXSIZE+1];";
  z[lc++]="";
  z[lc++]="int nsys_behind_nat;                      /* 1 if behind a nat        */";
  z[lc++]="int nsys_sipinfo_count;                   /* INFO sending timer       */";
  z[lc++]="int nsys_sipinfo_toggle;                  /* RTP/RTCP toggle          */";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* SSRC stack  */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="struct nsys_source * nsys_srcfree = NULL;       /* mset ssrc tokens */";
  z[lc++]="struct nsys_source * nsys_ssrc[NSYS_HASHSIZE];  /* SSRC hash table  */";
  z[lc++]="struct nsys_source * nsys_srcroot = NULL;       /* points into nsys_ssrc */";
  z[lc++]="";
  z[lc++]="/* end Network library -- global variables */";
  printlib(lc);
}


void makenet_siplib(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- SIP functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 high-level SIP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]=" ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        initialize SIP address and INVITE packet              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_initsip(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* create SIP addresses */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if ((nsys_netin_sipaddr(nsys_rtp_fd, NSYS_SIP_IP,";
  z[lc++]="			  NSYS_SIP_RTP_PORT) != NSYS_DONE) ||";
  z[lc++]="      (nsys_netin_sipaddr(nsys_rtcp_fd, NSYS_SIP_IP,";
  z[lc++]="			  NSYS_SIP_RTCP_PORT) != NSYS_DONE))";
  z[lc++]="    return NSYS_ERROR;";
  z[lc++]="";
  z[lc++]="  nsys_rtp_cseq = nsys_rtcp_cseq = 1;";
  z[lc++]="";
  z[lc++]="  /***********************************/";
  z[lc++]="  /* create SIP packets and send off */";
  z[lc++]="  /***********************************/";
  z[lc++]="  ";
  z[lc++]="  nsys_createsip(nsys_rtp_fd, \"INVITE\", nsys_rtp_invite, NULL, NULL); ";
  z[lc++]="  nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_invite);";
  z[lc++]="";
  z[lc++]="  nsys_createsip(nsys_rtcp_fd, \"INVITE\", nsys_rtcp_invite, NULL, NULL);";
  z[lc++]="  nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_invite);";
  z[lc++]="";
  z[lc++]="  nsys_rtp_sipretry = nsys_rtcp_sipretry = 1;";
  z[lc++]="";
  z[lc++]="  nsys_behind_nat = 0;";
  z[lc++]="";
  z[lc++]="  nsys_createsip(nsys_rtp_fd,  \"INFO\", nsys_rtp_info,  NULL, NULL); ";
  z[lc++]="  nsys_createsip(nsys_rtcp_fd, \"INFO\", nsys_rtcp_info, NULL, NULL); ";
  z[lc++]="";
  z[lc++]="  return NSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 handle a SIP reply packet                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_reply(int fd, struct sockaddr_in * addr, ";
  z[lc++]="		      unsigned char * packet, unsigned short status)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char ack[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  char natline[NSYS_SDPNATSIZE];";
  z[lc++]="  char nonce[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned long callid, cseq;";
  z[lc++]="  char * invite;";
  z[lc++]="";
  z[lc++]="  /***********************/";
  z[lc++]="  /* SIP validity checks */";
  z[lc++]="  /***********************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_siporigin(fd, addr) == NSYS_ERROR)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_replyparse(fd, packet, nonce, natline, &callid, &cseq)";
  z[lc++]="      == NSYS_ERROR)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /*************************************/";
  z[lc++]="  /* ignore informational status codes */";
  z[lc++]="  /*************************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 100) && (status < 200))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* all others receive acks */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  nsys_netin_ack(fd, ack, callid, cseq);";
  z[lc++]="  nsys_sendsip(fd, addr, ack);";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* take no action if unexpected */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  if ((fd == nsys_rtp_fd) && ((nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP) == 0))";
  z[lc++]="    return;";
  z[lc++]="      ";
  z[lc++]="  if ((fd == nsys_rtcp_fd) && ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP) == 0))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* 200 OK --> clear flag */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 200) && (status < 300))";
  z[lc++]="    {  ";
  z[lc++]="      if (fd == nsys_rtp_fd)";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTPNEXT);";
  z[lc++]="	  nsys_rtp_authretry = 0;";
  z[lc++]="	  ";
  z[lc++]="	  if (nsys_rtcp_sipretry)";
  z[lc++]="	    nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			 \"SIP server contact successful, awaiting client SIP\");";
  z[lc++]="	  nsys_rtp_sipretry = 0;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTCPSIP | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="	  nsys_rtcp_authretry = 0;";
  z[lc++]="";
  z[lc++]="	  if (nsys_rtp_sipretry)";
  z[lc++]="	    nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			 \"SIP server contact successful, awaiting client SIP\");";
  z[lc++]="";
  z[lc++]="	  nsys_rtcp_sipretry = 0;";
  z[lc++]="	}";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* 401 -- resend INVITE */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if ((status == 401) && (nonce[0]))";
  z[lc++]="    {";
  z[lc++]="      if (((fd == nsys_rtp_fd) && ";
  z[lc++]="	   (nsys_rtp_authretry++ > NSYS_SIP_AUTHRETRYMAX)) || ";
  z[lc++]="	  ((fd == nsys_rtcp_fd) && ";
  z[lc++]="	   (nsys_rtcp_authretry++ > NSYS_SIP_AUTHRETRYMAX)))";
  z[lc++]="	{";
  z[lc++]="	  nsys_terminate_error(\"Initial SIP server authentication failure\");";
  z[lc++]="	  return;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (fd == nsys_rtp_fd)";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtp_cseq++;";
  z[lc++]="	  invite = (char *) nsys_rtp_invite;";
  z[lc++]="";
  z[lc++]="	  nsys_rtcp_ex |=  NSYS_RTCPEX_RTPSIP;";
  z[lc++]="	  ";
  z[lc++]="	  if (nsys_nexttime < (time(NULL) + NSYS_RTCPTIME_SKIP))";
  z[lc++]="	    nsys_rtcp_ex |= NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="";
  z[lc++]="	  nsys_createsip(nsys_rtp_fd, \"INFO\", nsys_rtp_info,  NULL, NULL); ";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_cseq++;";
  z[lc++]="	  invite = (char *) nsys_rtcp_invite;";
  z[lc++]="";
  z[lc++]="	  nsys_rtcp_ex |=  NSYS_RTCPEX_RTCPSIP;";
  z[lc++]="	  ";
  z[lc++]="	  if (nsys_nexttime < (time(NULL) + NSYS_RTCPTIME_SKIP))";
  z[lc++]="	    nsys_rtcp_ex |= NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="";
  z[lc++]="	  nsys_createsip(nsys_rtcp_fd, \"INFO\", nsys_rtcp_info, NULL, NULL); ";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      nsys_createsip(fd, \"INVITE\", (unsigned char *) invite, ";
  z[lc++]="		     natline[0] ? natline : NULL, nonce[0] ? nonce : NULL);";
  z[lc++]="      nsys_sendsip(fd, NULL, (unsigned char *) invite);";
  z[lc++]="";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* 300 series --> do redirect */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 300) && (status < 400))";
  z[lc++]="    {";
  z[lc++]="      nsys_netin_redirect(fd, packet, status);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* 400 series --> buggy client */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 400) && (status < 500))";
  z[lc++]="    {";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, APPNAME \"/\" APPVERSION ";
  z[lc++]="		   \" is too out-of-date to function with SIP server\");";
  z[lc++]="";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Download new version at:\" ";
  z[lc++]="		   \" http://www.cs.berkeley.edu/~lazzaro/sa/index.html\");";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="			NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="";
  z[lc++]="      nsys_graceful_exit = 1;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* 500/600 series --> server down */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 500) && (status < 700))";
  z[lc++]="    {";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"SIP server is overloaded, refusing new sessions\");";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Please try again later. Ending session\");";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="			NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="";
  z[lc++]="      nsys_graceful_exit = 1;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 handle a SIP INVITE packet                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_invite(int fd, struct sockaddr_in * addr, ";
  z[lc++]="		       unsigned char * packet)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  struct sockaddr_in ** aptr;";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  char media[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  char sname[NSYS_BASE64_LENGTH];";
  z[lc++]="  char tool[32] = \"unknown\";";
  z[lc++]="  struct nsys_payinfo * marray;";
  z[lc++]="  int mlen = 0;";
  z[lc++]="  char cname[32];";
  z[lc++]="  char dnsname[64];";
  z[lc++]="  char ip[16], nat_ip[16];";
  z[lc++]="  unsigned long ssrc, sdp_time, now;";
  z[lc++]="  unsigned short port, nat_port, ptype;";
  z[lc++]="  int state, len;";
  z[lc++]="  int has_nat, has_session, has_time, has_ssrc; ";
  z[lc++]="  int has_dnsname, has_port, has_ip, has_map;";
  z[lc++]="";
  z[lc++]="  /*****************************************************************/";
  z[lc++]="  /* do weak and strong security checks, leave function if failure */";
  z[lc++]="  /*****************************************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_siporigin(fd, addr) == NSYS_ERROR)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  if ((packet = nsys_netin_readmethod(fd, addr, packet)) == NULL)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* parse SDP */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  has_nat = has_session = has_time = has_ssrc = 0;";
  z[lc++]="  has_dnsname = has_port = has_ip = has_map = 0;";
  z[lc++]="  state = NSYS_NETIN_SDPSTATE;";
  z[lc++]="";
  z[lc++]="  while (state == NSYS_NETIN_SDPSTATE)";
  z[lc++]="    {";
  z[lc++]="      len = sscanf((char *) packet, \"%1023[^\\n]\\n\", line);";
  z[lc++]="      if (len && (len != EOF))";
  z[lc++]="	{";
  z[lc++]="	  switch (line[0]) {";
  z[lc++]="	  case 'v':";
  z[lc++]="	    break;";
  z[lc++]="	  case 's':";
  z[lc++]="	    if ((sscanf(line, \"s = %24s\", sname) != 1) || ";
  z[lc++]="		(strcmp((char *) nsys_session_base64, sname)))";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      has_session = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 't':";
  z[lc++]="	    if (sscanf(line, \"t = %lu\", &sdp_time) == 1)";
  z[lc++]="	      {";
  z[lc++]="		now = time(NULL);";
  z[lc++]="		sdp_time -= 2208988800UL;";
  z[lc++]="		has_time = 1;";
  z[lc++]="";
  z[lc++]="		if (!nsys_msession || nsys_msessionmirror)";
  z[lc++]="		  {";
  z[lc++]="		    if ((sdp_time > now) && ";
  z[lc++]="			((sdp_time - now) > NSYS_MAXLATETIME))";
  z[lc++]="		      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="		    if ((sdp_time < now) && ";
  z[lc++]="			((now-sdp_time) > NSYS_MAXSSESIONTIME))";
  z[lc++]="		      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  case 'o':";
  z[lc++]="	    if (sscanf(line, \"o = %31s %lu %*u IN IP4 %63s\", ";
  z[lc++]="		       cname, &ssrc, dnsname) != 3)";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      has_dnsname = has_ssrc = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 'm':";
  z[lc++]="	    if (sscanf(line, \"m = audio %hu RTP/AVP %[0-9 ]\", &port, media) != 2)";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		has_port = 1;";
  z[lc++]="		if ((mlen = nsys_netin_make_marray(&marray, media)) < 1)";
  z[lc++]="		  state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  case 'c':";
  z[lc++]="	    if ((sscanf(line, \"c = IN IP4 %15s\", ip) != 1) || ";
  z[lc++]="		!(strcmp(ip, \"127.0.0.1\") && ";
  z[lc++]="		  strcmp(ip, \"0.0.0.0\") &&";
  z[lc++]="		  strcmp(ip, \"255.255.255.255\")))";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      has_ip = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 'a':";
  z[lc++]="	    if (sscanf(line, \"a = nat : %15s %hu\", nat_ip, &nat_port) == 2)";
  z[lc++]="	      {";
  z[lc++]="		has_nat = strcmp(nat_ip, \"127.0.0.1\") && ";
  z[lc++]="		  strcmp(nat_ip, \"0.0.0.0\") &&";
  z[lc++]="		  strcmp(nat_ip, \"255.255.255.255\");";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	    if (sscanf(line, \"a = tool : %31[^\\n]\", tool) == 1)";
  z[lc++]="	      break;";
  z[lc++]="	    if (sscanf(line, \"a = rtpmap : %hu\", &ptype) == 1)";
  z[lc++]="	      {";
  z[lc++]="		if ((!mlen) || (!nsys_netin_set_marray(line, marray, mlen)))";
  z[lc++]="		  state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="		else";
  z[lc++]="		  has_map = 1;";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	  packet += strlen(line) + 1;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	state = NSYS_NETIN_EOFSTATE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************************************/";
  z[lc++]="  /* miscellaneous security/syntax checks */";
  z[lc++]="  /****************************************/";
  z[lc++]="";
  z[lc++]="  if (!(has_session && has_time && has_ssrc && has_dnsname";
  z[lc++]="	&& has_port && has_ip && has_map))";
  z[lc++]="    state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="";
  z[lc++]="  if ((strcmp(ip, nsys_clientip) == 0) && (strcmp(cname, nsys_username) == 0)";
  z[lc++]="      && (port == nsys_rtp_port) && (nsys_myssrc == ssrc))";
  z[lc++]="    state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="";
  z[lc++]="  if (nsys_msession && !nsys_msessionmirror && ";
  z[lc++]="      ((strcmp(nsys_sip_rtp_ip, ip) && (fd == nsys_rtp_fd)) || ";
  z[lc++]="       (strcmp(nsys_sip_rtcp_ip, ip) && (fd == nsys_rtcp_fd)) || has_nat ))";
  z[lc++]="    state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="";
  z[lc++]="  if (state == NSYS_NETIN_EOFSTATE)";
  z[lc++]="    {  ";
  z[lc++]="      sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="      ";
  z[lc++]="      while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="	sptr = sptr->xtra;";
  z[lc++]="      ";
  z[lc++]="      if ((sptr == NULL) && nsys_netin_noreplay(ip, port, sdp_time) &&";
  z[lc++]="	  nsys_netin_payvalid(marray, mlen, fd) &&";
  z[lc++]="	  (sptr = nsys_netin_addsrc(fd, ssrc, ip, port)))";
  z[lc++]="	{";
  z[lc++]="	  ";
  z[lc++]="	  sptr->siptime = sdp_time;";
  z[lc++]="	  nsys_netin_payset(sptr, marray, mlen);";
  z[lc++]="	  sptr->last_hiseq_ext = nsys_netout_jsend_checkpoint_seqnum;";
  z[lc++]="";
  z[lc++]="	  if (nsys_msessionmirror)";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_SRCDUPL;";
  z[lc++]="	  ";
  z[lc++]="	  sptr->cname = calloc(strlen(cname) + strlen(dnsname) + 8,";
  z[lc++]="			       sizeof(char));";
  z[lc++]="	  sprintf(sptr->cname, \"%s@%s:%hu\", cname, dnsname, port);";
  z[lc++]="	  nsys_status(sptr, \"SIP INVITE accepted from\");";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (sptr && has_nat)";
  z[lc++]="	{";
  z[lc++]="	  if (fd == nsys_rtp_fd)";
  z[lc++]="	    aptr = &(sptr->alt_rtp_addr);";
  z[lc++]="	  else";
  z[lc++]="	    aptr = &(sptr->alt_rtcp_addr);";
  z[lc++]="	  ";
  z[lc++]="	  if (*aptr == NULL)";
  z[lc++]="	    {  ";
  z[lc++]="	      *aptr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="	      (*aptr)->sin_family = AF_INET;   ";
  z[lc++]="	    }";
  z[lc++]="	  (*aptr)->sin_port = htons(nat_port);";
  z[lc++]="	  (*aptr)->sin_addr.s_addr = inet_addr(nat_ip);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (state == NSYS_NETIN_ERRSTATE)";
  z[lc++]="    {		";
  z[lc++]="      sprintf(line, \"Discarding a SIP INVITE: probably a client/server bug\"); ";
  z[lc++]="      nsys_warning(NSYS_WARN_UNUSUAL, line);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               close down SIP server connection               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_sip_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char packet[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  fd_set set;";
  z[lc++]="  int rtp_flags, rtcp_flags;";
  z[lc++]="  struct timeval timeout, deadline;";
  z[lc++]="  int rtp_send = 1;";
  z[lc++]="  int rtcp_send = 1;";
  z[lc++]="  int waitcycles = 0;";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* create BYE packets */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_rtp_cseq++;";
  z[lc++]="  nsys_rtcp_cseq++;";
  z[lc++]="";
  z[lc++]="  nsys_createsip(nsys_rtp_fd, \"BYE\", nsys_rtp_invite, NULL, NULL);";
  z[lc++]="  nsys_createsip(nsys_rtcp_fd, \"BYE\", nsys_rtcp_invite, NULL, NULL);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* make sockets blocking */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  rtp_flags = fcntl(nsys_rtp_fd, F_GETFL);";
  z[lc++]="  rtcp_flags = fcntl(nsys_rtcp_fd, F_GETFL);";
  z[lc++]="";
  z[lc++]="  fcntl(nsys_rtp_fd,  F_SETFL, (~O_NONBLOCK) & rtp_flags );";
  z[lc++]="  fcntl(nsys_rtcp_fd, F_SETFL, (~O_NONBLOCK) & rtcp_flags);";
  z[lc++]="";
  z[lc++]="  /***********************************/";
  z[lc++]="  /* do three sends before giving up */";
  z[lc++]="  /***********************************/";
  z[lc++]="";
  z[lc++]="  while ((waitcycles++ < 3) && (rtp_send || rtcp_send))";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      if (rtp_send)";
  z[lc++]="	nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_invite);";
  z[lc++]="      if (rtcp_send)";
  z[lc++]="	nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_invite);";
  z[lc++]="";
  z[lc++]="      /* one second between resends */";
  z[lc++]="";
  z[lc++]="      gettimeofday(&deadline, NULL);";
  z[lc++]="      deadline.tv_sec++;";
  z[lc++]="      ";
  z[lc++]="      do {";
  z[lc++]="";
  z[lc++]="	FD_ZERO(&set);";
  z[lc++]="	FD_SET(nsys_rtp_fd, &set);";
  z[lc++]="	FD_SET(nsys_rtcp_fd, &set);";
  z[lc++]="";
  z[lc++]="	timeout.tv_sec = 0;";
  z[lc++]="	timeout.tv_usec = 200000;";
  z[lc++]=" ";
  z[lc++]="	select(nsys_max_fd, &set, NULL, NULL, &timeout);";
  z[lc++]="";
  z[lc++]="	if (FD_ISSET(nsys_rtp_fd, &set) &&";
  z[lc++]="	    (recv(nsys_rtp_fd, packet, NSYS_UDPMAXSIZE, 0) > 0) &&";
  z[lc++]="	    (packet[NSYS_RTPLOC_BYTE1] == 'S'))";
  z[lc++]="	  rtp_send = 0;";
  z[lc++]="";
  z[lc++]="	if (FD_ISSET(nsys_rtcp_fd, &set) &&";
  z[lc++]="	    (recv(nsys_rtcp_fd, packet, NSYS_UDPMAXSIZE, 0) > 0) &&";
  z[lc++]="	    (packet[NSYS_RTPLOC_BYTE1] == 'S'))";
  z[lc++]="	  rtcp_send = 0;";
  z[lc++]="";
  z[lc++]="	gettimeofday(&timeout, NULL);";
  z[lc++]="";
  z[lc++]="      } while ((rtcp_send | rtp_send) && ";
  z[lc++]="	       ((timeout.tv_sec < deadline.tv_sec) ||";
  z[lc++]="		((timeout.tv_sec == deadline.tv_sec) &&";
  z[lc++]="		 (timeout.tv_usec < deadline.tv_usec))));";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* restore socket status */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  fcntl(nsys_rtp_fd,  F_SETFL, rtp_flags);";
  z[lc++]="  fcntl(nsys_rtcp_fd, F_SETFL, rtcp_flags);";
  z[lc++]="";
  z[lc++]="}  ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level SIP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 create a SIP method packet                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_createsip(int fd, char * method, unsigned char * sip,";
  z[lc++]="		    char * natline, char * nonce) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char base64_digest[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char binary_digest[NSYS_MD5_LENGTH];";
  z[lc++]="  char media[4*NSYS_RTP_PAYSIZE + 1];";
  z[lc++]="  char nline[16+NSYS_BASE64_LENGTH];";
  z[lc++]="  int i, j, len, body, dpoint;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* create SIP headers */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  body = snprintf((char *) sip, NSYS_UDPMAXSIZE+1,";
  z[lc++]="		  \"%s sip:%s@%s:%hu SIP/2.0\\n\"     /* INVITE or BYE method */";
  z[lc++]="		  \"i: %lu\\n\"                       /* Call-ID              */";
  z[lc++]="		  \"v: SIP/2.0/UDP %s:%hu\\n\"        /* Via                  */";
  z[lc++]="		  \"%s\"                             /* Content-Type         */";
  z[lc++]="		  \"f: sip:%s@%s\\n\"                 /* From                 */";
  z[lc++]="		  \"t: sip:%s@%s:%hu\\n\"             /* To                   */";
  z[lc++]="		  \"CSeq: %lu\\n\"                    /* CSeq                 */";
  z[lc++]="                  \"User-Agent: %s/%s\\n\",           /* User-Agent           */";
  z[lc++]="		  ";
  z[lc++]="		  /* SIP URL */";
  z[lc++]="		  ";
  z[lc++]="		  method, nsys_session_base64, ";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		  ";
  z[lc++]="		  /* Call-ID */";
  z[lc++]="		  ";
  z[lc++]="		  nsys_myssrc + (fd == nsys_rtcp_fd),";
  z[lc++]="		  ";
  z[lc++]="		  /* Via */";
  z[lc++]="";
  z[lc++]="		  nsys_clientip,";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_rtp_port : nsys_rtcp_port,";
  z[lc++]="		  ";
  z[lc++]="		  /* Content-Type */";
  z[lc++]="";
  z[lc++]="		  (method[2] == 'V') ? \"c: application/sdp\\n\" : \"\",";
  z[lc++]="";
  z[lc++]="		  /* From */";
  z[lc++]="";
  z[lc++]="		  nsys_username, nsys_clientname,";
  z[lc++]="		  ";
  z[lc++]="		  /* To */";
  z[lc++]="		  ";
  z[lc++]="		  nsys_session_base64, ";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		  ";
  z[lc++]="		  /* CSeq */";
  z[lc++]="";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_rtp_cseq : nsys_rtcp_cseq,";
  z[lc++]="";
  z[lc++]="		  /* User-Agent */";
  z[lc++]="";
  z[lc++]="		  APPNAME, APPVERSION";
  z[lc++]="";
  z[lc++]="		  );";
  z[lc++]="";
  z[lc++]="  if (body > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [1]\");";
  z[lc++]="";
  z[lc++]="  if (method[2] != 'V')               /* BYE/INFO currently have no body */";
  z[lc++]="    return; ";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* add Authorization */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  if (nonce)";
  z[lc++]="    {";
  z[lc++]="      body += snprintf((char *) &(sip[body]), NSYS_UDPMAXSIZE+1-body,";
  z[lc++]="		       \"Authorization: SignSDP nonce=\\\"%s\\\", \"";
  z[lc++]="		       \"digest=\\\"012345678901234567890A==\\\"\\n\",";
  z[lc++]="		       nonce);";
  z[lc++]="      sprintf(nline, \"a=nonce:\\\"%s\\\"\\n\", nonce);";
  z[lc++]="      dpoint = body - 26;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    dpoint = 0;";
  z[lc++]="";
  z[lc++]="  if (body > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [2]\");";
  z[lc++]="";
  z[lc++]="  /***********/";
  z[lc++]="  /* add SDP */";
  z[lc++]="  /***********/";
  z[lc++]="";
  z[lc++]="  for (j = i = 0; i < NSYS_RTP_PAYSIZE; i++)";
  z[lc++]="    j += sprintf(&(media[j]), \"%hhu \", nsys_payload_types[i].ptype);";
  z[lc++]="";
  z[lc++]="  len = body + snprintf((char *) &(sip[body]), NSYS_UDPMAXSIZE+1-body,";
  z[lc++]="		 \"\\n\"";
  z[lc++]="		 \"v=0\\n\"";
  z[lc++]="		 \"o=%s %lu 0 IN IP4 %s\\n\"          /* CNAME, SSRC, IP    */";
  z[lc++]="		 \"s=%s\\n\"                          /* sessionname        */";
  z[lc++]="		 \"a=tool:%s %s\\n\"                  /* SDP creator        */";
  z[lc++]="		 \"t=%lu 0\\n\"                       /* current time       */";
  z[lc++]="		 \"m=audio %i RTP/AVP %s\\n\"         /* media              */";
  z[lc++]="		 \"c=IN IP4 %s\\n\"                   /* ipnumber           */";
  z[lc++]="		 \"%s\"                              /* nonce, if needed   */";
  z[lc++]=" 		 \"%s\",                             /* nat, if needed     */";
  z[lc++]="";
  z[lc++]="		 /* SDP originator (o=) */";
  z[lc++]="";
  z[lc++]="		 nsys_username, nsys_myssrc, nsys_clientname,";
  z[lc++]="";
  z[lc++]="		 /* SDP session (s=) */";
  z[lc++]="";
  z[lc++]="		 nsys_session_base64,";
  z[lc++]="";
  z[lc++]="		 /* SDP tool (a=tool) */";
  z[lc++]="";
  z[lc++]="		 APPNAME, APPVERSION,";
  z[lc++]="";
  z[lc++]=" 		 /* NTP time */";
  z[lc++]="";
  z[lc++]="		 ((unsigned long) time(NULL)) + NSYS_SIP_UNIXTONTP,";
  z[lc++]="";
  z[lc++]="		 /* SDP media (m=) */";
  z[lc++]="";
  z[lc++]="		 nsys_rtp_port, media,";
  z[lc++]="";
  z[lc++]="		 /* SDP connection (c=) */";
  z[lc++]="";
  z[lc++]="		 nsys_clientip,";
  z[lc++]="			";
  z[lc++]="		 /* nonce line */";
  z[lc++]="";
  z[lc++]="		 nonce ? nline : \"\",";
  z[lc++]="";
  z[lc++]="		 /* nat line */";
  z[lc++]="";
  z[lc++]="		 natline ? natline : \"\"";
  z[lc++]="";
  z[lc++]="		 );";
  z[lc++]="";
  z[lc++]="  if (len > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [3]\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_RTP_PAYSIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      /**********************/";
  z[lc++]="      /* append rtpmap line */";
  z[lc++]="      /**********************/";
  z[lc++]="";
  z[lc++]="      len += snprintf((char *) &(sip[len]), NSYS_UDPMAXSIZE+1 - len, ";
  z[lc++]="		      \"a=rtpmap:%hhu %s/%i\\n\", ";
  z[lc++]="		      nsys_payload_types[i].ptype, ";
  z[lc++]="		      nsys_payload_types[i].name, ";
  z[lc++]="		      nsys_payload_types[i].srate);";
  z[lc++]="";
  z[lc++]="      if ((len > NSYS_UDPMAXSIZE))";
  z[lc++]="	NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [4]\");";
  z[lc++]="";
  z[lc++]="      /*********************/";
  z[lc++]="      /* append fmtp lines */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      switch (nsys_payload_types[i].pindex) {";
  z[lc++]="      case NSYS_MPEG4_PINDEX:";
  z[lc++]="	len += snprintf((char *) &(sip[len]), NSYS_UDPMAXSIZE+1 - len,";
  z[lc++]="";
  z[lc++]="	\"a=fmtp:%hhu streamtype=5; mode=rtp-midi; profile-level-id=12;\"";
  z[lc++]="	\" config=\\\"\\\"; render=synthetic; subrender=default; rinit=audio/asc;\"";
  z[lc++]="	\" tsmode=buffer; octpos=last; mperiod=%lu;\"";
  z[lc++]="	\" rtp_ptime=0; rtp_maxptime=0; cm_unused=DEFMQVX;%s\"";
  z[lc++]="	\" guardtime=%lu\\n\",";
  z[lc++]="";
  z[lc++]="	nsys_payload_types[i].ptype,";
  z[lc++]="";
  z[lc++]="	/* tsmode line */";
  z[lc++]="";
  z[lc++]="	(unsigned long) ACYCLE,";
  z[lc++]="";
  z[lc++]="	/* rtp_ptime line */";
  z[lc++]="";
  z[lc++]="	(nsys_feclevel != NSYS_SM_FEC_NONE) ";
  z[lc++]="	? \"\" : \" j_sec=none;\",";
  z[lc++]="";
  z[lc++]="	/* guardtime line */";
  z[lc++]="";
  z[lc++]="	(unsigned long)(NSYS_SM_GUARD_MAXTIME*ARATE + 0.5F)";
  z[lc++]="";
  z[lc++]="	);";
  z[lc++]="";
  z[lc++]="	if ((len > NSYS_UDPMAXSIZE))";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [5]\");";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* compute digest, place in SIP header */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  if (nonce)";
  z[lc++]="    {    ";
  z[lc++]="      nsys_hmac_md5(&(sip[body + 1]), len - body - 1, ";
  z[lc++]="		    nsys_keydigest, binary_digest);";
  z[lc++]="      nsys_digest_base64(base64_digest, binary_digest);";
  z[lc++]="      for (i = 0; i < NSYS_BASE64_LENGTH - 1; i++)";
  z[lc++]="	sip[dpoint + i] = base64_digest[i];";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             reads an INVITE, generates an OK                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_netin_readmethod(int fd, struct sockaddr_in * addr, ";
  z[lc++]="				      unsigned char * packet) ";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  unsigned char local_base64[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char reply[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned char nonce[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char digest[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char local_binary[NSYS_MD5_LENGTH];";
  z[lc++]="  unsigned char text[14];";
  z[lc++]="  unsigned char * ret;";
  z[lc++]="  int found_invite, found_callid, found_reply, found_auth;";
  z[lc++]="  int num, len, first, overflow;";
  z[lc++]="  unsigned long callid, inreplyto;";
  z[lc++]="";
  z[lc++]="  first = 1;";
  z[lc++]="  overflow = len = found_invite = found_callid = found_reply = found_auth = 0;";
  z[lc++]="  nonce[0] = digest[0] = '\\0';";
  z[lc++]="";
  z[lc++]="  /***********************************************************/";
  z[lc++]="  /* extract Call-ID, In-Reply-To, Nonce and Digest from SIP */";
  z[lc++]="  /***********************************************************/";
  z[lc++]="";
  z[lc++]="  while ((num = sscanf((char *) packet, \"%[^\\n]\\n\", line)) && (num != EOF))";
  z[lc++]="    {";
  z[lc++]="      if (first)";
  z[lc++]="	{";
  z[lc++]="	  first = 0;";
  z[lc++]="	  found_invite = (line == ((unsigned char *)strstr((char *)line,\"INVITE\")));";
  z[lc++]="";
  z[lc++]="	  if ((len += strlen(\"SIP/2.0 200\\n\")) < NSYS_UDPMAXSIZE+1)";
  z[lc++]="	    strcpy((char *) reply, \"SIP/2.0 200\\n\");";
  z[lc++]="	  else";
  z[lc++]="	    overflow = 1;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if ((len += strlen((char *) line) + 1) < NSYS_UDPMAXSIZE+1)";
  z[lc++]="	    {";
  z[lc++]="	      strcat((char *) reply, (char *) line);";
  z[lc++]="	      strcat((char *) reply, \"\\n\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    overflow = 1;";
  z[lc++]="";
  z[lc++]="	  if ((line[0] == 'i') || (line[0] == 'C'))";
  z[lc++]="	    found_callid |= ((sscanf((char *) line, \"i : %lu\", &callid) == 1) || ";
  z[lc++]="			     (sscanf((char *) line, \"Call-ID : %lu\", &callid) == 1));";
  z[lc++]="	  if (line[0] == 'I')";
  z[lc++]="	    found_reply |= (sscanf((char *) line, \"In-Reply-To : %lu\",&inreplyto) == 1);";
  z[lc++]="";
  z[lc++]="	  if (line[0] == 'A')";
  z[lc++]="	    found_auth |= ((sscanf((char *) line, \"Authorization : SignSDP \" ";
  z[lc++]="				   \"nonce = \\\"%24[^\\\"]\\\" , \"";
  z[lc++]="				   \"digest = \\\"%24[^\\\"]\\\" , \",";
  z[lc++]="				   nonce, digest) == 2) || ";
  z[lc++]="			   (sscanf((char *) line, \"Authorization : SignSDP \" ";
  z[lc++]="				   \"digest = \\\"%24[^\\\"]\\\" , \"";
  z[lc++]="				   \"nonce = \\\"%24[^\\\"]\\\" , \",";
  z[lc++]="				   digest, nonce) == 2));";
  z[lc++]="	}";
  z[lc++]="      packet += strlen((char *) line) + 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ret = (num != EOF) ? packet + 1 : NULL;";
  z[lc++]="";
  z[lc++]="  if (found_invite && found_callid && found_reply && ";
  z[lc++]="      (inreplyto == (nsys_myssrc + (fd == nsys_rtcp_fd))))";
  z[lc++]="    {";
  z[lc++]="      memcpy(&(text[0]), &callid, 4);";
  z[lc++]="      memcpy(&(text[4]), &inreplyto, 4);";
  z[lc++]="      memcpy(&(text[8]), &(addr->sin_addr), 4);";
  z[lc++]="      memcpy(&(text[12]), &(addr->sin_port), 2);";
  z[lc++]="";
  z[lc++]="      nsys_hmac_md5(text, 14, nsys_keydigest, local_binary);";
  z[lc++]="      nsys_digest_base64(local_base64, local_binary);";
  z[lc++]="";
  z[lc++]="      if ((!found_auth) || strcmp((char *) local_base64, (char *) nonce))";
  z[lc++]="	{";
  z[lc++]="	  sprintf((char *) line, \"WWW-Authenticate: SignSDP nonce =\\\"%s\\\"\\n\",";
  z[lc++]="		  local_base64);";
  z[lc++]="";
  z[lc++]="	  if ((len += strlen((char *)line)) < NSYS_UDPMAXSIZE+1)";
  z[lc++]="	    strcat((char *) reply, (char *) line);";
  z[lc++]="	  else";
  z[lc++]="	    overflow = 1;";
  z[lc++]="";
  z[lc++]="	  reply[8] = '4'; reply[10] = '1';  /* 200 -> 401 */";
  z[lc++]="	  ret = NULL;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = NULL;";
  z[lc++]="";
  z[lc++]="  if (ret && (nsys_msession == 0))";
  z[lc++]="    {";
  z[lc++]="      nsys_hmac_md5(ret, strlen((char *) ret), nsys_keydigest, local_binary);";
  z[lc++]="      nsys_digest_base64(local_base64, local_binary);";
  z[lc++]="      if (strcmp((char *) digest, (char *) local_base64))";
  z[lc++]="	ret = NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_sendsip(fd, NULL, reply);";
  z[lc++]="";
  z[lc++]="  if (!ret && found_auth)";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="		 \"Discarding a SIP INVITE: probably a client/server bug\");";
  z[lc++]="";
  z[lc++]="  if (overflow)";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="		 \"Send a truncated 200 or 401: probably a client/server bug\");";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           reads a final response, generate an ACK            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_ack(int fd, unsigned char * reply, ";
  z[lc++]="		    unsigned long callid, unsigned long cseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  /****************************/";
  z[lc++]="  /* create top of ACK header */";
  z[lc++]="  /****************************/";
  z[lc++]="";
  z[lc++]="  len = snprintf((char *) reply, NSYS_UDPMAXSIZE+1, ";
  z[lc++]="	  ";
  z[lc++]="		 \"ACK sip:%s@%s:%hu SIP/2.0\\n\"";
  z[lc++]="		 \"v: SIP/2.0/UDP %s:%hu\\n\"        /* Via                  */";
  z[lc++]="		 \"f: sip:%s@%s\\n\"                 /* From                 */";
  z[lc++]="		 \"t: sip:%s@%s:%hu\\n\"             /* To                   */";
  z[lc++]="		 \"i: %lu\\n\"                       /* Call-ID              */	";
  z[lc++]="		 \"CSeq: %lu\\n\" 	                  /* CSeq                 */";
  z[lc++]="		 \"User-Agent: %s/%s\\n\",           /* User-Agent           */";
  z[lc++]="";
  z[lc++]="		 /* method line */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_session_base64, ";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		 ";
  z[lc++]="		 /* Via */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_clientip,";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_rtp_port : nsys_rtcp_port,";
  z[lc++]="		 ";
  z[lc++]="		 /* From */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_username, nsys_clientname,";
  z[lc++]="		 ";
  z[lc++]="		 /* To */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_session_base64, ";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		 ";
  z[lc++]="		 /* Call-ID, CSeq */";
  z[lc++]="		 ";
  z[lc++]="		 callid, cseq,";
  z[lc++]="";
  z[lc++]="		 /* User-Agent */";
  z[lc++]="		 ";
  z[lc++]="		 APPNAME, APPVERSION";
  z[lc++]="";
  z[lc++]="		 );";
  z[lc++]="";
  z[lc++]="  if (len > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP REPLY packet creation error [1]\");";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      read a SIP/2.0 reply packet, parse useful fields        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_replyparse(int fd, unsigned char * packet, ";
  z[lc++]="			  char * nonce, char * natline, ";
  z[lc++]="			  unsigned long * callid, unsigned long * cseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned short nat_port;";
  z[lc++]="  unsigned char nat_ip[16];";
  z[lc++]="  int found_callid = 0;";
  z[lc++]="  int found_cseq = 0;";
  z[lc++]="  int found_auth = 0;";
  z[lc++]="";
  z[lc++]="  natline[0] = '\\0';";
  z[lc++]="  nonce[0] = '\\0';";
  z[lc++]="";
  z[lc++]="  while (sscanf((char *) packet,\"%[^\\n]\\n\",line) == 1)";
  z[lc++]="    {";
  z[lc++]="      packet += strlen(line) + 1;";
  z[lc++]="";
  z[lc++]="      if ((sscanf(line, \"i : %lu\", callid) == 1) || ";
  z[lc++]="	  (sscanf(line, \"Call-ID : %lu\", callid) == 1))";
  z[lc++]="	{";
  z[lc++]="	  if (found_callid || (*callid != (nsys_myssrc + (fd == nsys_rtcp_fd))))";
  z[lc++]="	    return NSYS_ERROR;";
  z[lc++]="	  found_callid = 1;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if ((sscanf(line, \"CSeq : %lu\", cseq) == 1))";
  z[lc++]="	{";
  z[lc++]="	  if (found_cseq)";
  z[lc++]="	    return NSYS_ERROR;";
  z[lc++]="	  found_cseq = 1;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="     if (sscanf(line, ";
  z[lc++]="		\"WWW-Authenticate : SignSDP nonce = \\\"%24[^\\\"]\\\"\",";
  z[lc++]="		nonce) == 1)";
  z[lc++]="       {";
  z[lc++]="	 if (found_auth || !nsys_digest_syntaxcheck(nonce))";
  z[lc++]="	   nonce[0] = '\\0';";
  z[lc++]="	 else";
  z[lc++]="	   found_auth = 1;";
  z[lc++]="       }";
  z[lc++]="     ";
  z[lc++]="     if ((sscanf(line, \"v : %*[^;]; received = %15[0-9.] ; rport = %hu \",";
  z[lc++]="		nat_ip, &nat_port) == 2) || ";
  z[lc++]="	 (sscanf(line, \"Via : %*[^;]; received = %15[0-9.] ; rport = %hu \",";
  z[lc++]="		 nat_ip, &nat_port) == 2))";
  z[lc++]="       {";
  z[lc++]="	 sprintf(natline, \"a=nat:%s %hu\\n\", nat_ip, nat_port);";
  z[lc++]="	 nsys_behind_nat = 1;";
  z[lc++]="       }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ((found_callid && found_cseq) ? NSYS_DONE : NSYS_ERROR);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      read a SIP/2.0 300-series packet, do redirection        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_redirect(int fd, unsigned char * packet, ";
  z[lc++]="			 unsigned short status) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  int found = 0;";
  z[lc++]="  char ip[16];";
  z[lc++]="  unsigned short port;";
  z[lc++]="  char * invite;";
  z[lc++]="";
  z[lc++]="  /* find first contact address, extract IP and port */";
  z[lc++]="";
  z[lc++]="  while (sscanf((char *) packet,\"%[^\\n]\\n\",line) == 1)";
  z[lc++]="    {";
  z[lc++]="      packet += strlen(line) + 1;";
  z[lc++]="      if ((found = (sscanf(line,\"m:%*[^@]@%15[^:]:%hu\", ip, &port) == 2)))";
  z[lc++]="	break;";
  z[lc++]="      if ((found = (sscanf(line,";
  z[lc++]="			   \"Contact:%*[^@]@%15[^:]:%hu\", ip, &port) == 2)))";
  z[lc++]="	break;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* handle incomplete redirect packets */";
  z[lc++]="";
  z[lc++]="  if ((!found) || (nsys_netin_sipaddr(fd, ip, port) != NSYS_DONE))";
  z[lc++]="    {      ";
  z[lc++]="      nsys_terminate_error(\"SIP redirection to an unavailable/unknown server\");";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="			NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* send INVITE to new server */";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Redirecting %s INVITE to %s:%hu, please stand by ...\\n\",";
  z[lc++]="	    fd == nsys_rtp_fd ? \"RTP\" : \"RTCP\", ip, port);";
  z[lc++]="  fflush(stderr);";
  z[lc++]="";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      invite = (char *) nsys_rtp_invite;";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="      nsys_rtcp_ex |=  NSYS_RTCPEX_RTPSIP;";
  z[lc++]="      nsys_rtp_authretry = 0;";
  z[lc++]="      nsys_createsip(nsys_rtp_fd,  \"INFO\", nsys_rtp_info,  NULL, NULL); ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      invite = (char *) nsys_rtcp_invite;";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="      nsys_rtcp_ex |=  NSYS_RTCPEX_RTCPSIP;";
  z[lc++]="      nsys_rtcp_authretry = 0;";
  z[lc++]="      nsys_createsip(nsys_rtcp_fd, \"INFO\", nsys_rtcp_info, NULL, NULL); ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_createsip(fd, \"INVITE\", (unsigned char *) invite, NULL, NULL);";
  z[lc++]="  nsys_sendsip(fd, NULL, (unsigned char *) invite);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                   utility SIP functions                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             send a formatted SIP packet                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_sendsip(int fd, struct sockaddr_in * addr, unsigned char * sip) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  if (addr == NULL)";
  z[lc++]="    addr = (fd == nsys_rtp_fd) ? &nsys_sip_rtp_addr : &nsys_sip_rtcp_addr;";
  z[lc++]="";
  z[lc++]="  while (sendto(fd, sip, strlen((char *) sip) + 1, 0, (struct sockaddr *) addr,";
  z[lc++]="		sizeof(struct sockaddr)) == -1)";
  z[lc++]="    {";
  z[lc++]="      if (errno == EAGAIN)";
  z[lc++]="	continue;";
  z[lc++]="      ";
  z[lc++]="      if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	{";
  z[lc++]="	  if (++retry > NSYS_MAXRETRY)";
  z[lc++]="	    NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_sendsip\");";
  z[lc++]="	  continue;         ";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   sets a SIP address                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_sipaddr(int fd, char * ip, unsigned short port)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct sockaddr_in * addr;";
  z[lc++]="";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      addr = &nsys_sip_rtp_addr;";
  z[lc++]="      strcpy(nsys_sip_rtp_ip, ip);";
  z[lc++]="      nsys_sip_rtp_inet_addr = inet_addr(ip);";
  z[lc++]="      nsys_sip_rtp_port = port;";
  z[lc++]="      nsys_sip_rtp_sin_port = htons(port);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      addr = &nsys_sip_rtcp_addr;";
  z[lc++]="      strcpy(nsys_sip_rtcp_ip, ip);";
  z[lc++]="      nsys_sip_rtcp_inet_addr = inet_addr(ip);";
  z[lc++]="      nsys_sip_rtcp_port = port;";
  z[lc++]="      nsys_sip_rtcp_sin_port = htons(port);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  memset(&(addr->sin_zero), 0, 8);    ";
  z[lc++]="  addr->sin_family = AF_INET;   ";
  z[lc++]="  addr->sin_port = htons(port);";
  z[lc++]="  if ((addr->sin_addr.s_addr = inet_addr(ip)) == -1)";
  z[lc++]="    NSYS_ERROR_RETURN(\"Bad format for SIP address\");";
  z[lc++]="  ";
  z[lc++]="  return NSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              checks origin of incoming SIP                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_siporigin(int fd, struct sockaddr_in * addr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret = NSYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      if ((addr->sin_addr.s_addr == nsys_sip_rtp_inet_addr) && ";
  z[lc++]="	  (addr->sin_port == nsys_sip_rtp_sin_port))";
  z[lc++]="	ret = NSYS_DONE;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if ((addr->sin_addr.s_addr == nsys_sip_rtcp_inet_addr) && ";
  z[lc++]="	  (addr->sin_port == nsys_sip_rtcp_sin_port))";
  z[lc++]="	return ret = NSYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ret == NSYS_ERROR)";
  z[lc++]="    {";
  z[lc++]="      nsys_stderr_size += ";
  z[lc++]="	fprintf(stderr, \"Network advisory: SIP from unknown source %s:%hu\"";
  z[lc++]="		\" rejected\\n\", inet_ntoa(addr->sin_addr), ";
  z[lc++]="		ntohs(addr->sin_port));";
  z[lc++]="      fflush(stderr);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              makes an array of media payloads                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_make_marray(struct nsys_payinfo ** marray, char * media)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, i, len;";
  z[lc++]="  char * eptr, * cptr;";
  z[lc++]="";
  z[lc++]="  i = size = 0;";
  z[lc++]="  len = strlen(media);";
  z[lc++]="";
  z[lc++]="  while (i < len)";
  z[lc++]="    {";
  z[lc++]="      while ((i < len) && (media[i] == ' '))";
  z[lc++]="	i++;";
  z[lc++]="      size += (i < len);";
  z[lc++]="      while ((i < len) && (media[i] != ' '))";
  z[lc++]="	i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!size)";
  z[lc++]="    return size;";
  z[lc++]="";
  z[lc++]=" *marray = calloc(size, sizeof(struct nsys_payinfo));";
  z[lc++]=" cptr = media;";
  z[lc++]="";
  z[lc++]=" for (i = 0; i < size; i++)";
  z[lc++]="   {";
  z[lc++]="     (*marray)[i].pindex = i;";
  z[lc++]="     (*marray)[i].ptype = (unsigned char)strtoul(cptr, &eptr, 10);";
  z[lc++]="     cptr = eptr;";
  z[lc++]="   }";
  z[lc++]="";
  z[lc++]=" return size;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 sets media payloads                          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_set_marray(char * line, struct nsys_payinfo marray[], int mlen)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short ptype;  /* sscanf needs a short, not a char */";
  z[lc++]="  char name[32];";
  z[lc++]="  int srate; ";
  z[lc++]="  int i, num;";
  z[lc++]="";
  z[lc++]="  num = sscanf(line, \"a=rtpmap:%hu %31[^/]/%i\", &ptype, name, &srate);";
  z[lc++]="";
  z[lc++]="  if ((num != 2) && (num != 3))";
  z[lc++]="    return 0;";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < mlen)";
  z[lc++]="    {";
  z[lc++]="      if (marray[i].ptype == (unsigned char)ptype)";
  z[lc++]="	break;";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (i == mlen)";
  z[lc++]="    return 0;";
  z[lc++]="";
  z[lc++]="  strcpy(marray[i].name, name);";
  z[lc++]="";
  z[lc++]="  if (num == 3)";
  z[lc++]="    marray[i].srate = srate;";
  z[lc++]="  else";
  z[lc++]="    marray[i].srate = -1;";
  z[lc++]="";
  z[lc++]="  return 1;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             checks validity of payload ptype                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_payvalid(struct nsys_payinfo marray[], int mlen, ";
  z[lc++]="			int fd) ";
  z[lc++]="			 ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < mlen; i++)";
  z[lc++]="    for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="      if (!strcasecmp(marray[i].name, nsys_payload_types[j].name))";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_msession || (marray[i].srate == -1) || ";
  z[lc++]="	      (marray[i].srate == nsys_payload_types[j].srate))";
  z[lc++]="	    return 1;";
  z[lc++]="";
  z[lc++]="	  if (fd == nsys_rtp_fd)";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			   \"Rejecting an INVITE due to SAOL srate mismatch\");";
  z[lc++]="";
  z[lc++]="	      sprintf(line, \"(local srate %iHz, remote srate %iHz)\", ";
  z[lc++]="		      nsys_payload_types[j].srate, marray[i].srate);";
  z[lc++]="";
  z[lc++]="	      nsys_warning(NSYS_WARN_STANDARD, line);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  return 0;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Rejecting an INVITE, no common RTP payloads\");";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"(probably caused by local or remote out-of-date software)\");";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Download new version at:\" ";
  z[lc++]="		   \" http://www.cs.berkeley.edu/~lazzaro/sa/index.html\");";
  z[lc++]="    }";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             sets payload information in source               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_payset(struct nsys_source * sptr, struct nsys_payinfo marray[],";
  z[lc++]="		       int mlen) ";
  z[lc++]="			 ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < mlen; i++)";
  z[lc++]="    for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="      if (!strcasecmp(marray[i].name, nsys_payload_types[j].name))";
  z[lc++]="	{";
  z[lc++]="	  sptr->ptype = marray[i].ptype;";
  z[lc++]="	  sptr->pindex = nsys_payload_types[j].pindex;";
  z[lc++]="	  if ((sptr->srate = marray[i].srate) < 0)";
  z[lc++]="	    sptr->srate = nsys_payload_types[j].srate;";
  z[lc++]="	  return;";
  z[lc++]="	}";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             checks for a SIP replay attack                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_noreplay(char * ip, unsigned short port, unsigned long sdp_time)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct nsys_source * sptr = nsys_srcroot;";
  z[lc++]="  struct sockaddr_in ipaddr;";
  z[lc++]="  int ret = 1;";
  z[lc++]="";
  z[lc++]="  if (sptr)";
  z[lc++]="    {";
  z[lc++]="      memset(&ipaddr, 0, sizeof(struct sockaddr_in));";
  z[lc++]="      ipaddr.sin_port = htons(port);";
  z[lc++]="      ipaddr.sin_family = AF_INET;  ";
  z[lc++]="      ipaddr.sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="";
  z[lc++]="      do {";
  z[lc++]="	if ((!memcmp(&ipaddr, sptr->sdp_addr, sizeof(struct sockaddr_in))) &&";
  z[lc++]="	    (sptr->siptime > sdp_time))";
  z[lc++]="	  ret = 0;";
  z[lc++]="      } while ((sptr = sptr->next) != nsys_srcroot);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- SIP functions */";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makenet_rtplib(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- RTP functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 high-level RTP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]=" ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  sets up networking                          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_setup(int block) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct hostent * myinfo;";
  z[lc++]="  struct nsys_source * newsrc;";
  z[lc++]="  struct nsys_netout_jrecv_state * newrecv;";
  z[lc++]="  struct nsys_netout_jrecv_system_state * newrecvsys;";
  z[lc++]="  struct sockaddr_in iclient_addr; ";
  z[lc++]="  struct timeval tv;";
  z[lc++]="  unsigned char session_digest[NSYS_MD5_LENGTH];";
  z[lc++]="  int one = 1;";
  z[lc++]="  int i, rfd, bad_netconfig;";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* create RTP and RTCP sockets */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtp_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) ";
  z[lc++]="    NSYS_ERROR_RETURN(\"Couldn't create Internet RTP socket\");";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) ";
  z[lc++]="    NSYS_ERROR_RETURN(\"Couldn't create Internet RTCP socket\");";
  z[lc++]="";
  z[lc++]="  if (nsys_rtp_fd > nsys_rtcp_fd)";
  z[lc++]="    nsys_max_fd = nsys_rtp_fd + 1;";
  z[lc++]="  else";
  z[lc++]="    nsys_max_fd = nsys_rtcp_fd + 1;";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* find open ports for RTP */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  memset(&(iclient_addr.sin_zero), 0, 8);    ";
  z[lc++]="  iclient_addr.sin_family = AF_INET;   ";
  z[lc++]="  iclient_addr.sin_addr.s_addr = htonl(INADDR_ANY);";
  z[lc++]="";
  z[lc++]="  nsys_rtp_port = NSYS_RTP_PORT - 2;";
  z[lc++]="";
  z[lc++]="  while ((nsys_rtp_port += 2) < NSYS_RTP_MAXPORT)";
  z[lc++]="    {";
  z[lc++]="      iclient_addr.sin_port = htons(nsys_rtp_port);";
  z[lc++]="      if (bind(nsys_rtp_fd, (struct sockaddr *)&iclient_addr,";
  z[lc++]="	       sizeof(struct sockaddr)) < 0)";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EADDRINUSE) || (errno == EADDRNOTAVAIL))";
  z[lc++]="	    continue;";
  z[lc++]="	  else";
  z[lc++]="	    NSYS_ERROR_RETURN(\"Couldn't bind Internet RTP socket\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_port = nsys_rtp_port + 1;";
  z[lc++]="	  iclient_addr.sin_port = htons(nsys_rtcp_port);";
  z[lc++]="	  if (bind(nsys_rtcp_fd, (struct sockaddr *)&iclient_addr,";
  z[lc++]="		   sizeof(struct sockaddr)) < 0)";
  z[lc++]="	    {";
  z[lc++]="	      if ((errno == EADDRINUSE) || (errno == EADDRNOTAVAIL))";
  z[lc++]="		continue;";
  z[lc++]="	      else";
  z[lc++]="		NSYS_ERROR_RETURN(\"Couldn't bind Internet RTCP socket\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    break;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (nsys_rtp_port >= NSYS_RTP_MAXPORT)";
  z[lc++]="    NSYS_ERROR_RETURN(\"Couldn't find open ports for RTP/RTCP sockets\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /************************************************************/";
  z[lc++]="  /* set non-blocking status & shield ICMP ECONNREFUSED errno */";
  z[lc++]="  /************************************************************/";
  z[lc++]="";
  z[lc++]="  if (block == NSYS_NONBLOCK)";
  z[lc++]="    {";
  z[lc++]="      fcntl(nsys_rtp_fd, F_SETFL, O_NONBLOCK);";
  z[lc++]="      fcntl(nsys_rtcp_fd, F_SETFL, O_NONBLOCK);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  setsockopt(nsys_rtp_fd, SOL_SOCKET, SO_BSDCOMPAT, &one, sizeof(one));";
  z[lc++]="  setsockopt(nsys_rtcp_fd, SOL_SOCKET, SO_BSDCOMPAT, &one, sizeof(one));";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* pick SSRC, set CNAME */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  gettimeofday(&tv, 0);";
  z[lc++]="";
  z[lc++]="  srand((unsigned int)(((tv.tv_sec << NSYS_SECSHIFT) & NSYS_SECMASK)";
  z[lc++]="		       |(NSYS_USECMASK & tv.tv_usec)));";
  z[lc++]="";
  z[lc++]="  rfd = open(\"/dev/urandom\", O_RDONLY | O_NONBLOCK);";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0) || (read(rfd, &nsys_myssrc, sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_myssrc = (unsigned long)rand();";
  z[lc++]="";
  z[lc++]="  nsys_myssrc_net = htonl(nsys_myssrc);";
  z[lc++]="";
  z[lc++]="  bad_netconfig = 0;";
  z[lc++]="";
  z[lc++]="  if (gethostname(nsys_clientname, NSYS_HOSTNAMESIZE) < 0)";
  z[lc++]="    {";
  z[lc++]="      bad_netconfig = 1;";
  z[lc++]="      strcpy(nsys_clientname, \"not_known\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!bad_netconfig && (myinfo = gethostbyname(nsys_clientname)))";
  z[lc++]="    {";
  z[lc++]="      strcpy(nsys_clientip, inet_ntoa(*((struct in_addr *)myinfo->h_addr)));";
  z[lc++]="      bad_netconfig |= !strcmp(nsys_clientip, \"127.0.0.1\");";
  z[lc++]="      bad_netconfig |= !strcmp(nsys_clientip, \"0.0.0.0\");";
  z[lc++]="      bad_netconfig |= !strcmp(nsys_clientip, \"255.255.255.255\");";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    bad_netconfig = 1;";
  z[lc++]="";
  z[lc++]="  if (bad_netconfig)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_find_clientip(nsys_clientip) == NULL)";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP number unknown\");";
  z[lc++]="";
  z[lc++]="      if (!strcmp(nsys_clientip, \"127.0.0.1\"))";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP misconfiguration (loopback address)\");";
  z[lc++]="";
  z[lc++]="      if (!strcmp(nsys_clientip, \"0.0.0.0\"))";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP misconfiguration (0.0.0.0)\");";
  z[lc++]="";
  z[lc++]="      if (!strcmp(nsys_clientip, \"255.255.255.255\"))";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP misconfiguration (broadcast address)\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (getlogin())";
  z[lc++]="    strcpy((nsys_username = malloc(strlen(getlogin())+1)), getlogin());";
  z[lc++]="  else";
  z[lc++]="    nsys_username = \"unknown\";";
  z[lc++]="";
  z[lc++]="  snprintf(nsys_cname, NSYS_CNAMESIZE, \"%s@%s:%hu\",";
  z[lc++]="	   nsys_username, nsys_clientip, nsys_rtcp_port);";
  z[lc++]="  nsys_cname[NSYS_CNAMESIZE-1] = '\\0';";
  z[lc++]="  nsys_cname_len = (unsigned char) strlen(nsys_cname);";
  z[lc++]="";
  z[lc++]="  /************************************************************/";
  z[lc++]="  /* create digest sessionname, initialize authentication key */";
  z[lc++]="  /************************************************************/";
  z[lc++]="";
  z[lc++]="  nsys_msession = !strcmp(NSYS_MSESSION_NAME, nsys_sessionname);";
  z[lc++]="  nsys_msessionmirror = nsys_msession && !strcmp(\"mirror\", APPNAME);";
  z[lc++]="";
  z[lc++]="  if (nsys_sessionkey == NULL)";
  z[lc++]="    {";
  z[lc++]="      nsys_sessionkey = calloc(NSYS_MKEY_LENGTH + 1, 1);";
  z[lc++]="      i = 0;";
  z[lc++]="      while (i < NSYS_MKEY_LENGTH)";
  z[lc++]="	{";
  z[lc++]="	  if ((rfd < 0)|| (read(rfd, &(nsys_sessionkey[i]), sizeof(char)) < 0))";
  z[lc++]="	    nsys_sessionkey[i] = (char)((255.0F*rand()";
  z[lc++]="					 /(RAND_MAX+1.0F))-128.0F);";
  z[lc++]="	  i = (isprint((int)nsys_sessionkey[i])) ? i + 1 : i; ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_md5(nsys_keydigest, (unsigned char *) nsys_sessionkey, ";
  z[lc++]="	   strlen(nsys_sessionkey));";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_MD5_ROUNDS; i++)";
  z[lc++]="    nsys_md5(nsys_keydigest, nsys_keydigest, NSYS_MD5_LENGTH);";
  z[lc++]="";
  z[lc++]="  if (nsys_msession)";
  z[lc++]="    nsys_md5(session_digest, (unsigned char *) nsys_sessionname, ";
  z[lc++]="	     strlen(nsys_sessionname));";
  z[lc++]="  else";
  z[lc++]="    nsys_hmac_md5((unsigned char *) nsys_sessionname, strlen(nsys_sessionname), ";
  z[lc++]="		   nsys_keydigest, session_digest);";
  z[lc++]="";
  z[lc++]="  nsys_digest_base64(nsys_session_base64, session_digest);";
  z[lc++]="";
  z[lc++]="  /*************************************/";
  z[lc++]="  /* create and send SIP invite packet */";
  z[lc++]="  /*************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_initsip() == NSYS_ERROR)";
  z[lc++]="    return NSYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* create mset slots */";
  z[lc++]="";
  z[lc++]="  for (i = NSYS_MSETS; i > 0; i--)";
  z[lc++]="    {";
  z[lc++]="      newsrc = calloc(1, sizeof(struct nsys_source));";
  z[lc++]="      newsrc->mset = i;";
  z[lc++]="      newsrc->next = nsys_srcfree;";
  z[lc++]="      nsys_srcfree = newsrc;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_RECVCHAN*NSYS_MSETS; i++)";
  z[lc++]="    {";
  z[lc++]="      newrecv = calloc(1, sizeof(struct nsys_netout_jrecv_state));";
  z[lc++]="      newrecv->next = nsys_recvfree;";
  z[lc++]="      nsys_recvfree = newrecv;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_MSETS; i++)";
  z[lc++]="    {";
  z[lc++]="      newrecvsys = calloc(1, sizeof(struct nsys_netout_jrecv_system_state));";
  z[lc++]="      newrecvsys->next = nsys_recvsysfree;";
  z[lc++]="      nsys_recvsysfree = newrecvsys;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_SM_CX_MAXSLOTS; i++)";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_jsend_xpile[i].next = nsys_netout_jsend_xstackfree; ";
  z[lc++]="      nsys_netout_jsend_xstackfree = &(nsys_netout_jsend_xpile[i]); ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* setup network output */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0)||(read(rfd, &(nsys_netout_tstamp), sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_netout_tstamp = (unsigned long) rand();";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0)||(read(rfd, &(nsys_netout_seqnum), sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_netout_seqnum = ((unsigned long) rand());";
  z[lc++]="";
  z[lc++]="  nsys_netout_seqnum &= 0x0000FFFF;";
  z[lc++]="  nsys_netout_seqnum = (!nsys_netout_seqnum) ? 1 : nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLOC_BYTE1] = NSYS_RTPVAL_BYTE1;";
  z[lc++]="";
  z[lc++]="  nsys_netout_markbit = NSYS_RTPVAL_SETMARK;   /* required by mpeg4-generic */";
  z[lc++]="";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_SSRC]), &nsys_myssrc_net,";
  z[lc++]="	 sizeof(long));";
  z[lc++]="";
  z[lc++]="  if (nsys_feclevel != NSYS_SM_FEC_NONE)";
  z[lc++]="    nsys_netout_sm_header = NSYS_SM_SETJ;";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* setup RTCP system */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initpackets();";
  z[lc++]="  nsys_nexttime = time(NULL) + NSYS_RTCPTIME_INCR;";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex  = NSYS_RTCPEX_NULLROOT;";
  z[lc++]="  nsys_rtcp_ex |= (NSYS_RTCPEX_RTCPSIP | NSYS_RTCPEX_RTPSIP); ";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* setup rtp-midi packetization */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_checkpoint_seqnum = nsys_netout_seqnum;";
  z[lc++]="  nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] = 0;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_MIDI_NUMCHAN; i++)";
  z[lc++]="    nsys_netout_jsend[i].chan = i;";
  z[lc++]="";
  z[lc++]="  nsys_netout_journal_changecheck();";
  z[lc++]="";
  z[lc++]="  switch (nsys_feclevel) {";
  z[lc++]="  case NSYS_SM_FEC_NONE:";
  z[lc++]="  case NSYS_SM_FEC_NOGUARD:";
  z[lc++]="    nsys_netout_jsend_guard_ontime  = 0;";
  z[lc++]="    nsys_netout_jsend_guard_mintime = 0;";
  z[lc++]="    nsys_netout_jsend_guard_maxtime = 0;";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_FEC_MINIMAL:";
  z[lc++]="    nsys_netout_jsend_guard_ontime  = 0;";
  z[lc++]="    nsys_netout_jsend_guard_mintime = (ARATE*NSYS_SM_GUARD_MINTIME)/ACYCLE;";
  z[lc++]="    nsys_netout_jsend_guard_maxtime = (ARATE*NSYS_SM_GUARD_MAXTIME)/ACYCLE;";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_FEC_STANDARD:";
  z[lc++]="    nsys_netout_jsend_guard_ontime  = 0;";
  z[lc++]="    nsys_netout_jsend_guard_mintime = (ARATE*NSYS_SM_GUARD_STDTIME)/ACYCLE;";
  z[lc++]="    nsys_netout_jsend_guard_maxtime = (ARATE*NSYS_SM_GUARD_MAXTIME)/ACYCLE;";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_FEC_EXTRA:";
  z[lc++]="    nsys_netout_jsend_guard_ontime  = (ARATE*NSYS_SM_GUARD_ONTIME)/ACYCLE;";
  z[lc++]="    nsys_netout_jsend_guard_mintime = (ARATE*NSYS_SM_GUARD_STDTIME)/ACYCLE;";
  z[lc++]="    nsys_netout_jsend_guard_maxtime = (ARATE*NSYS_SM_GUARD_MAXTIME)/ACYCLE;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (rfd >= 0)";
  z[lc++]="    close(rfd);";
  z[lc++]="";
  z[lc++]="  return NSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  tears down networking                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_shutdown(void) ";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  struct nsys_source * sptr = nsys_srcroot;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  nsys_warning(NSYS_WARN_STANDARD, \"Shutdown in progress\");";
  z[lc++]="";
  z[lc++]="  /* send RTCP BYE command to all listeners */";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & NSYS_RTCPEX_NULLROOT) == 0)";
  z[lc++]="    nsys_netout_rtcpsend(nsys_netout_rtcp_packet_bye, ";
  z[lc++]="			 nsys_netout_rtcp_len_bye + NSYS_RTPSIZE_DIGEST);";
  z[lc++]="";
  z[lc++]="  /* send SIP BYE command to the SIP server */";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & (NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP)) == 0)";
  z[lc++]="    nsys_sip_shutdown();";
  z[lc++]="";
  z[lc++]="  /* close network FD's */";
  z[lc++]="";
  z[lc++]="  close(nsys_rtp_fd);";
  z[lc++]="  close(nsys_rtcp_fd);";
  z[lc++]="";
  z[lc++]="  nsys_warning(NSYS_WARN_STANDARD, \"Shutdown completed\");";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="";
  z[lc++]="  if (sptr)";
  z[lc++]="    do {";
  z[lc++]="      printf(\"mset%i packets expected: %i\\n\", sptr->mset,";
  z[lc++]="	     sptr->hi_ext - sptr->base_seq + 1);";
  z[lc++]="      printf(\"mset%i packets received: %i\\n\", sptr->mset,";
  z[lc++]="	     sptr->received);";
  z[lc++]="      if (sptr->tm_fd)";
  z[lc++]="	fclose(sptr->tm_fd);";
  z[lc++]="    } while ((sptr = sptr->next) != nsys_srcroot);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level RTP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              add new SSRC to send/receive list               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="nsys_source * nsys_netin_addsrc(int fd, long ssrc, char * ip, unsigned short port)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  struct sockaddr_in ipaddr;";
  z[lc++]="";
  z[lc++]="  if (nsys_srcfree == NULL)";
  z[lc++]="    {";
  z[lc++]="      memset(&ipaddr, 0, sizeof(struct sockaddr_in));";
  z[lc++]="      ipaddr.sin_port = htons(port);";
  z[lc++]="      ipaddr.sin_family = AF_INET;  ";
  z[lc++]="      ipaddr.sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="      if (nsys_harvest_ssrc(nsys_rtp_fd, &ipaddr) == NULL)";
  z[lc++]="	return NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex |= (nsys_myssrc == ssrc) ? NSYS_RTCPEX_SRCDUPL : 0;";
  z[lc++]="";
  z[lc++]="  sptr = nsys_srcfree;";
  z[lc++]="  nsys_srcfree = nsys_srcfree->next;";
  z[lc++]="  ";
  z[lc++]="  /* set ssrc and IP/port */";
  z[lc++]="";
  z[lc++]="  sptr->ssrc = ssrc;";
  z[lc++]="";
  z[lc++]="  /* unchanged, used to detect replay attacks */";
  z[lc++]="";
  z[lc++]="  sptr->sdp_addr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="  sptr->sdp_addr->sin_family = AF_INET;   ";
  z[lc++]="  sptr->sdp_addr->sin_port = htons(port);";
  z[lc++]="  sptr->sdp_addr->sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="";
  z[lc++]="  /* may be changed if NAT present */";
  z[lc++]="";
  z[lc++]="  sptr->rtp_addr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="  sptr->rtp_addr->sin_family = AF_INET;   ";
  z[lc++]="  sptr->rtp_addr->sin_port = htons(port);";
  z[lc++]="  sptr->rtp_addr->sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="";
  z[lc++]="  sptr->rtcp_addr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="  sptr->rtcp_addr->sin_family = AF_INET;   ";
  z[lc++]="  sptr->rtcp_addr->sin_port = htons(port + 1);";
  z[lc++]="  sptr->rtcp_addr->sin_addr.s_addr = sptr->rtp_addr->sin_addr.s_addr;";
  z[lc++]="";
  z[lc++]="  sptr->alt_rtp_addr = sptr->alt_rtcp_addr = NULL;";
  z[lc++]="  sptr->cname = NULL;";
  z[lc++]="";
  z[lc++]="  if (nsys_srcroot)";
  z[lc++]="    {";
  z[lc++]="      nsys_srcroot->next->prev = sptr;";
  z[lc++]="      sptr->next = nsys_srcroot->next;";
  z[lc++]="      sptr->prev = nsys_srcroot;";
  z[lc++]="      nsys_srcroot->next = sptr;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      nsys_srcroot = sptr->prev = sptr->next = sptr;";
  z[lc++]="      nsys_rtcp_ex &= ~NSYS_RTCPEX_NULLROOT;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sptr->xtra = nsys_ssrc[NSYS_HASHMASK & ssrc];";
  z[lc++]="  nsys_ssrc[NSYS_HASHMASK & ssrc] = sptr;";
  z[lc++]="";
  z[lc++]="  sptr->birthtime = time(NULL);";
  z[lc++]="  sptr->expire_rtcp = sptr->birthtime + NSYS_RTCPTIME_TIMEOUT;";
  z[lc++]="";
  z[lc++]="  nsys_netout_midistate_init();";
  z[lc++]="";
  z[lc++]="  return sptr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         updates RTCP info for a new RTP packet               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_rtpstats(nsys_source * sptr, unsigned char * packet)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long seq;";
  z[lc++]="  int seqinc, delta;";
  z[lc++]="  int rtpcode;";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  int mlen, first;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  seq = ntohs(*((unsigned short *)&(packet[NSYS_RTPLOC_SEQNUM])));";
  z[lc++]="";
  z[lc++]="  delta = nsys_netout_tstamp - ";
  z[lc++]="    ntohl(*((unsigned long *)&(packet[NSYS_RTPLOC_TSTAMP])));";
  z[lc++]="   ";
  z[lc++]="  if (sptr->received++)";
  z[lc++]="    {";
  z[lc++]="      if (abs((seqinc = (seq - sptr->hi_lobits))) > NSYS_RTPSEQ_MAXDIFF)";
  z[lc++]="	{";
  z[lc++]="	  if ((seq < NSYS_RTPSEQ_LOWLIMIT) && ";
  z[lc++]="	      (sptr->hi_lobits > NSYS_RTPSEQ_HILIMIT))";
  z[lc++]="	    {";
  z[lc++]="	      /* wraparound */";
  z[lc++]="	      ";
  z[lc++]="	      seqinc = seq + (NSYS_RTPSEQ_LOMASK - sptr->hi_lobits) + 1;";
  z[lc++]="	      sptr->hi_ext += NSYS_RTPSEQ_EXINCR;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if ((sptr->hi_lobits < NSYS_RTPSEQ_LOWLIMIT) && ";
  z[lc++]="		  (seq < NSYS_RTPSEQ_HILIMIT))";
  z[lc++]="		{";
  z[lc++]="		  seqinc = 0;  /* out-of-order packets in wraparound */";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  /* possible replay attack -- discard packet */";
  z[lc++]="		  ";
  z[lc++]="		  sptr->received--;";
  z[lc++]="		  return NSYS_RTPCODE_SECURITY;";
  z[lc++]="		  ";
  z[lc++]="		  /* older behavior: something bad happened -- reset */";
  z[lc++]="		  ";
  z[lc++]="		  seqinc = 3;        ";
  z[lc++]="		  sptr->hi_ext = 0;";
  z[lc++]="		  sptr->base_seq = seq;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (seqinc <= 0)";
  z[lc++]="	rtpcode = NSYS_RTPCODE_DISCARD;   /* duplicate or out-of-order */";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  sptr->hi_lobits = seq;";
  z[lc++]="	  sptr->hi_ext &= NSYS_RTPSEQ_EXMASK;";
  z[lc++]="	  sptr->hi_ext += seq;";
  z[lc++]="	  ";
  z[lc++]="	  switch(seqinc) {";
  z[lc++]="	  case 1:";
  z[lc++]="	    rtpcode = NSYS_RTPCODE_NORMAL; ";
  z[lc++]="	    break;";
  z[lc++]="	  case 2:";
  z[lc++]="	    rtpcode = NSYS_RTPCODE_LOSTONE; ";
  z[lc++]="	    break;";
  z[lc++]="	  default:";
  z[lc++]="	    rtpcode = NSYS_RTPCODE_LOSTMANY; ";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      sptr->jitter += (abs(delta - sptr->j_delta) -";
  z[lc++]="		       ((sptr->jitter + 8) >> 4));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sptr->hi_ext = sptr->hi_lobits = sptr->base_seq = seq;";
  z[lc++]="      if (!(sptr->rtcp_received))";
  z[lc++]="	nsys_status(sptr, \"Media (RTP) flowing from\");";
  z[lc++]="      rtpcode = NSYS_RTPCODE_LOSTMANY;";
  z[lc++]="    }";
  z[lc++]="      ";
  z[lc++]="  sptr->j_delta = delta;";
  z[lc++]="";
  z[lc++]="  if (sptr->tm_margin)";
  z[lc++]="    {";
  z[lc++]="      sptr->ontime = (((signed long)(delta + sptr->tm_convert)) < 0);";
  z[lc++]="      if (sptr->ontime)";
  z[lc++]="	{";
  z[lc++]="	  if (sptr->tm_lateflag)";
  z[lc++]="	    sptr->tm_lateflag = 0;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_late_windowcheck(sptr, nsys_netout_tstamp - delta);";
  z[lc++]="	  sptr->ontime = !(sptr->tm_lateflag);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    sptr->ontime = 1;";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="";
  z[lc++]="  if (sptr->tm_margin)";
  z[lc++]="    {";
  z[lc++]="      fprintf(sptr->tm_fd, \"%f %f #\",";
  z[lc++]="	      (nsys_netout_tstamp - sptr->tm_first)/ARATE,";
  z[lc++]="	      ((int)(delta + sptr->tm_convert))/ARATE);";
  z[lc++]="";
  z[lc++]="      /* not checking length, but not dangerous */";
  z[lc++]="";
  z[lc++]="      mlen = NSYS_SM_MLENMASK & packet[NSYS_RTPLEN_HDR];";
  z[lc++]="      first = NSYS_RTPLEN_HDR + 1;";
  z[lc++]="";
  z[lc++]="      if (packet[NSYS_RTPLEN_HDR] & NSYS_SM_CHKB)";
  z[lc++]="	{";
  z[lc++]="	  mlen = packet[NSYS_RTPLEN_HDR+1] + (mlen << 8);";
  z[lc++]="	  first++;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (mlen == 0)";
  z[lc++]="	fprintf(sptr->tm_fd, \"Empty\\n\");";
  z[lc++]="      else";
  z[lc++]="	if (packet[NSYS_RTPLEN_HDR] & NSYS_SM_CHKZ)";
  z[lc++]="	  fprintf(sptr->tm_fd, \"Delta-Time\\n\");";
  z[lc++]="	else";
  z[lc++]="	  switch(packet[first] & 0xF0) {";
  z[lc++]="	  case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"NoteOff\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_NOTEON:";
  z[lc++]="	    if (packet[first + 2])";
  z[lc++]="	      fprintf(sptr->tm_fd, \"NoteOn\\n\");";
  z[lc++]="	    else";
  z[lc++]="	      fprintf(sptr->tm_fd, \"NoteOff\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_PTOUCH:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"PTouch\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_CC:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"CChange\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_PROGRAM:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"PChange\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_CTOUCH:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"CTouch\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_WHEEL:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"PWheel\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_SYSTEM:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"System\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  default:";
  z[lc++]="	    fprintf(sptr->tm_fd, \"Data Octet\\n\");";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return rtpcode;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             prints out warning messages                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_warning(int level, char * message) ";
  z[lc++]="		";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if (NSYS_WARN > NSYS_WARN_NONE)";
  z[lc++]="";
  z[lc++]="  time_t now = time(NULL);";
  z[lc++]="";
  z[lc++]="  switch (level) {";
  z[lc++]="  case NSYS_WARN_STANDARD:";
  z[lc++]="    nsys_stderr_size += ";
  z[lc++]="      fprintf(stderr, \"Network status: %s %s\", message,";
  z[lc++]="	      nsys_msessionmirror ? ctime(&now) : \"\\n\");";
  z[lc++]="    fflush(stderr);";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_WARN_UNUSUAL:";
  z[lc++]="    if (NSYS_WARN >= NSYS_WARN_UNUSUAL)";
  z[lc++]="      {";
  z[lc++]="	nsys_stderr_size += ";
  z[lc++]="	  fprintf(stderr, \"Network advisory: %s %s\", message,";
  z[lc++]="		  nsys_msessionmirror ? ctime(&now) : \"\\n\");";
  z[lc++]="	fflush(stderr);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="	";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             prints out status message for a source           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_status(nsys_source * sptr, char * message) ";
  z[lc++]="		";
  z[lc++]="{";
  z[lc++]="  time_t now = time(NULL);";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Network status: %s %s %s\", message, sptr->cname, ";
  z[lc++]="	    nsys_msessionmirror ? ctime(&now) : \"\\n\");";
  z[lc++]="";
  z[lc++]="  fflush(stderr);";
  z[lc++]="}";
  z[lc++]="	  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             prints out error-termination messages            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_terminate_error(char * message) ";
  z[lc++]="		";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Network status: Probable client/server bug found\\n\");";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"              : %s\\n\", message);";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"              : Please send bug details to\"";
  z[lc++]="	    \" lazzaro@cs.berkeley.edu -- thanks! --jl\\n\");";
  z[lc++]="  nsys_graceful_exit = 1;";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                   utility RTP functions                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             checks validity of payload ptype                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_ptypevalid(unsigned char ptype) ";
  z[lc++]="			 ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int j;";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="    if (nsys_payload_types[j].ptype == ptype)";
  z[lc++]="     return 1;";
  z[lc++]="      ";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              fix payload for new RTP stream                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_ptypeset(struct nsys_source * sptr, unsigned char ptype)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int j;";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="    if (nsys_payload_types[j].ptype == ptype)";
  z[lc++]="      {	  ";
  z[lc++]="	sptr->ptype  = ptype;";
  z[lc++]="	sptr->pindex = nsys_payload_types[j].pindex;";
  z[lc++]="	sptr->srate  = nsys_payload_types[j].srate;";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              return a new jrecv channel pointer              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="nsys_netout_jrecv_state * nsys_netin_newrecv(unsigned char chan)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jrecv_state * ret;";
  z[lc++]="";
  z[lc++]="  if (nsys_recvfree)";
  z[lc++]="    {";
  z[lc++]="      ret = nsys_recvfree;";
  z[lc++]="      nsys_recvfree = nsys_recvfree->next;";
  z[lc++]="      memset(ret, 0, sizeof(struct nsys_netout_jrecv_state));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = calloc(1, sizeof(struct nsys_netout_jrecv_state));";
  z[lc++]="";
  z[lc++]="  ret->chan = chan;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*              return a new jrecv system pointer              */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="nsys_netout_jrecv_system_state * nsys_netin_newrecvsys(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jrecv_system_state * ret;";
  z[lc++]="";
  z[lc++]="  if (nsys_recvfree)";
  z[lc++]="    {";
  z[lc++]="      ret = nsys_recvsysfree;";
  z[lc++]="      nsys_recvsysfree = nsys_recvsysfree->next;";
  z[lc++]="      memset(ret, 0, sizeof(struct nsys_netout_jrecv_system_state));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = calloc(1, sizeof(struct nsys_netout_jrecv_system_state));";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       determines client IP number, returns NULL on error     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="char * nsys_find_clientip(char * ip)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  char buf[64*sizeof(struct ifreq)];";
  z[lc++]="  struct ifconf ifc;";
  z[lc++]="  struct ifreq * ifr;";
  z[lc++]="  int s, n, incr;";
  z[lc++]="";
  z[lc++]="  /* open a socket, get list of addresses */";
  z[lc++]="  ";
  z[lc++]="  if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)";
  z[lc++]="    return NULL;";
  z[lc++]="  ";
  z[lc++]="  ifc.ifc_len = sizeof(buf);";
  z[lc++]="  ifc.ifc_buf = (caddr_t) buf;";
  z[lc++]="  ";
  z[lc++]="  if (ioctl(s, SIOCGIFCONF, &ifc) < 0)";
  z[lc++]="    {";
  z[lc++]="      close(s);";
  z[lc++]="      return NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* look through addresses, return a useful one    */";
  z[lc++]="  /* thanks to Jens-Uwe Mager for BSD 4.4 updates   */";
  z[lc++]="  /* found his code snippet on comp.unix.programmer */";
  z[lc++]="";
  z[lc++]="  ifr = ifc.ifc_req;";
  z[lc++]="";
  z[lc++]="  for (n = 0; n < ifc.ifc_len; ifr = (struct ifreq *)(incr + (char *)ifr))";
  z[lc++]="    {";
  z[lc++]="      incr = sizeof(struct ifreq);";
  z[lc++]="";
  z[lc++]="#if NSYS_IFCONF_VARLEN";
  z[lc++]="";
  z[lc++]="      incr -= sizeof(struct sockaddr);";
  z[lc++]="      incr += ((sizeof(struct sockaddr) > ifr->ifr_addr.sa_len) ?";
  z[lc++]="	       sizeof(struct sockaddr) : ifr->ifr_addr.sa_len);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="      n += incr;";
  z[lc++]="";
  z[lc++]="      if (ifr->ifr_addr.sa_family != AF_INET)";
  z[lc++]="	continue;";
  z[lc++]="      ";
  z[lc++]="      if (ioctl(s, SIOCGIFFLAGS, (char *) ifr) < 0)";
  z[lc++]="	continue;";
  z[lc++]="      ";
  z[lc++]="      if ((ifr->ifr_flags & IFF_UP) == 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      if (ifr->ifr_flags & IFF_LOOPBACK)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      if ((ifr->ifr_flags & (IFF_BROADCAST | IFF_POINTOPOINT)) == 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      if (ioctl(s, SIOCGIFADDR, (char *) ifr) < 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      close(s);";
  z[lc++]="      return strcpy(ip, ";
  z[lc++]="	     inet_ntoa(((struct sockaddr_in *)(&(ifr->ifr_addr)))->sin_addr));";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  close(s);";
  z[lc++]="  return NULL;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* end Network library -- RTP functions */";
  printlib(lc);
}


void makenet_rtcplib(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- RTP functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 high-level RCTP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        application-level function to trigger RTCP sends      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcptime(void)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  if (nsys_behind_nat && (++nsys_sipinfo_count >= NSYS_SIPINFO_TRIGGER))";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_keepalive();      /* resets nsys_sipinfo_count */";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_nexttime += NSYS_RTCPTIME_INCR; ";
  z[lc++]="";
  z[lc++]="  if (nsys_rtcp_ex && nsys_netout_excheck())";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcpreport();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              process received RTCP packet                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="nsys_source * nsys_netin_rtcp(unsigned char * packet, int len, ";
  z[lc++]="		     struct sockaddr_in * ipaddr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long ssrc, new_stamp, hiseq;";
  z[lc++]="  struct nsys_source * sptr = NULL;";
  z[lc++]="  int skip, overflow;";
  z[lc++]="  unsigned short sect_len;";
  z[lc++]="  int first = 0;";
  z[lc++]="  struct timeval now;";
  z[lc++]="  int offset;";
  z[lc++]="";
  z[lc++]="  gettimeofday(&now, 0);";
  z[lc++]="";
  z[lc++]="  if (NSYS_DISPLAY_RTCP)";
  z[lc++]="    nsys_netin_rtcp_display(packet, len, &now); ";
  z[lc++]="";
  z[lc++]="  while (len > 0)";
  z[lc++]="    {";
  z[lc++]="      if (len < NSYS_RTCPLEN_MINIMUM)";
  z[lc++]="	{";
  z[lc++]="	  nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP subpacket size subminimal\");";
  z[lc++]="	  return sptr;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* assume all sub-packets share ssrc, just look at first */";
  z[lc++]="";
  z[lc++]="      if (!first)";
  z[lc++]="	{";
  z[lc++]="	  first = 1;";
  z[lc++]="	  ssrc = ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SSRC])));";
  z[lc++]="	  sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="	  ";
  z[lc++]="	  while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="	    sptr = sptr->xtra;";
  z[lc++]="	  ";
  z[lc++]="	  if (!sptr)";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP packet source unknown\");";
  z[lc++]="	      return sptr;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  if (!(sptr->rtcp_received++))";
  z[lc++]="	    {";
  z[lc++]="	      if (!(sptr->received))";
  z[lc++]="		nsys_status(sptr, \"Media (RTCP) flowing from\");";
  z[lc++]="	      if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="		printf(\"%s is mset%i\\n\", sptr->cname, sptr->mset);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (((ipaddr->sin_addr.s_addr != sptr->rtcp_addr->sin_addr.s_addr) ||";
  z[lc++]="	      (ipaddr->sin_port != sptr->rtcp_addr->sin_port)) && ";
  z[lc++]="	      (sptr->alt_rtcp_addr == NULL))";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			   \"RTCP packet from unknown IP/port\");";
  z[lc++]="	      return NULL;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (sptr->alt_rtcp_addr)";
  z[lc++]="	    {  ";
  z[lc++]="	      if ((ipaddr->sin_addr.s_addr != nsys_sip_rtcp_inet_addr) ||";
  z[lc++]="		  (ipaddr->sin_port != nsys_sip_rtcp_sin_port))";
  z[lc++]="		{";
  z[lc++]="		  /* normal case */";
  z[lc++]="";
  z[lc++]="		  memcpy(sptr->rtcp_addr, ipaddr, sizeof(struct sockaddr_in));";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  /* source-forge trick which may later be implemented */";
  z[lc++]="";
  z[lc++]="		  memcpy(sptr->rtcp_addr, &(sptr->alt_rtcp_addr), ";
  z[lc++]="			 sizeof(struct sockaddr_in));";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      free(sptr->alt_rtcp_addr);";
  z[lc++]="	      sptr->alt_rtcp_addr = NULL;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  sptr->expire_rtcp = time(NULL) + NSYS_RTCPTIME_TIMEOUT;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* process sub-packet */";
  z[lc++]="";
  z[lc++]="      memcpy(&(sect_len), &(packet[NSYS_RTCPLOC_LENGTH]), sizeof(short));";
  z[lc++]="      skip = 4 + 4*ntohs(sect_len);";
  z[lc++]="      if ((len -= skip) < 0)";
  z[lc++]="	{      ";
  z[lc++]="	  nsys_netin_rtcp_trunc(packet[NSYS_RTCPLOC_PTYPE]);";
  z[lc++]="	  return sptr;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      overflow = offset = 0;";
  z[lc++]="";
  z[lc++]="      switch (packet[NSYS_RTCPLOC_PTYPE]) {";
  z[lc++]="      case NSYS_RTCPVAL_SR:";
  z[lc++]="	if (NSYS_RTCPVAL_COUNTMASK & packet[NSYS_RTCPLOC_BYTE1])";
  z[lc++]="	  {";
  z[lc++]="	    offset = NSYS_RTCPLEN_SRHDR + NSYS_RTCPLEN_SENDER;";
  z[lc++]="	    overflow = (skip < NSYS_RTCPLEN_SR);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  overflow = (skip < NSYS_RTCPLEN_SREMPTY);";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_RR:";
  z[lc++]="	if (NSYS_RTCPVAL_COUNTMASK & packet[NSYS_RTCPLOC_BYTE1])";
  z[lc++]="	  {";
  z[lc++]="	    offset = NSYS_RTCPLEN_RRHDR; ";
  z[lc++]="	    overflow = (skip < NSYS_RTCPLEN_RR);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  overflow = (skip < NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      ";
  z[lc++]="      if (overflow)";
  z[lc++]="	{      ";
  z[lc++]="	  nsys_netin_rtcp_trunc(packet[NSYS_RTCPLOC_PTYPE]);";
  z[lc++]="	  return sptr;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (offset)";
  z[lc++]="	{";
  z[lc++]="	  memcpy(&hiseq, &(packet[offset+NSYS_RTCPLOC_RR_HISEQ]),sizeof(long));";
  z[lc++]="	  hiseq = ntohl(hiseq);";
  z[lc++]="";
  z[lc++]="	  if ((hiseq >= sptr->last_hiseq_rec) || ";
  z[lc++]="	      (sptr->last_hiseq_rec > ";
  z[lc++]="	       ((unsigned long) (NSYS_RTPSEQ_EXMASK | NSYS_RTPSEQ_HILIMIT))))";
  z[lc++]="	    {";
  z[lc++]="	      sptr->last_hiseq_ext = sptr->last_hiseq_rec = hiseq;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, \"Possible RTCP replay attack\");";
  z[lc++]="	      return NULL; ";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      switch (packet[NSYS_RTCPLOC_PTYPE]) {";
  z[lc++]="      case NSYS_RTCPVAL_SR:";
  z[lc++]="";
  z[lc++]="	/* create LSR value from NTP */";
  z[lc++]="";
  z[lc++]="	sptr->lsr[0] =  packet[NSYS_RTCPLOC_SR_NTPMSB + 2];";
  z[lc++]="	sptr->lsr[1] =  packet[NSYS_RTCPLOC_SR_NTPMSB + 3];";
  z[lc++]="	sptr->lsr[2] =  packet[NSYS_RTCPLOC_SR_NTPLSB];";
  z[lc++]="	sptr->lsr[3] =  packet[NSYS_RTCPLOC_SR_NTPLSB + 1];";
  z[lc++]="";
  z[lc++]="	sptr->arrival.tv_sec = now.tv_sec;";
  z[lc++]="	sptr->arrival.tv_usec = now.tv_usec;";
  z[lc++]="";
  z[lc++]="	memcpy(&new_stamp, &(packet[NSYS_RTCPLOC_SR_TSTAMP]), sizeof(long));";
  z[lc++]="	new_stamp = ntohl(new_stamp);";
  z[lc++]="";
  z[lc++]="	if (sptr->tm_margin)";
  z[lc++]="	  {";
  z[lc++]="	    if (((int)(new_stamp - nsys_netout_tstamp - sptr->tm_convert)) > 0)";
  z[lc++]="	      {";
  z[lc++]="		sptr->tm_convert = (new_stamp - nsys_netout_tstamp";
  z[lc++]="				    - sptr->tm_margin);";
  z[lc++]="		if (sptr->tm_lateflag)";
  z[lc++]="		  sptr->tm_lateflag = 0;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      nsys_late_windowcheck(sptr, new_stamp);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    sptr->tm_margin = nsys_lateplay ? 0 : ARATE*nsys_latetime;";
  z[lc++]="	    sptr->tm_convert = (new_stamp - nsys_netout_tstamp -";
  z[lc++]="				sptr->tm_margin);";
  z[lc++]="	    if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="	      nsys_netin_latenotes_open(sptr);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_RR:";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_SDES:";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_BYE:";
  z[lc++]="	nsys_netin_bye(packet, skip);";
  z[lc++]="	return (sptr = NULL);";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_APP:";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="      packet += skip;     /* skip to next sub-packet */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return sptr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             top-level RTCP packet initializations            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initpackets(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int sdes_size;";
  z[lc++]="";
  z[lc++]="  /************************************/";
  z[lc++]="  /* calculate SDES CNAME packet size */";
  z[lc++]="  /************************************/";
  z[lc++]="";
  z[lc++]="  sdes_size = (NSYS_RTCPLEN_SDESHDR + NSYS_RTCPLEN_SDES_CHUNKHDR";
  z[lc++]="	       + NSYS_RTCPLEN_SDES_ITEMHDR + nsys_cname_len);";
  z[lc++]="  ";
  z[lc++]="  sdes_size += 4 - (sdes_size & 3);";
  z[lc++]="";
  z[lc++]="  if (!nsys_netout_rtcp_packet_bye)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      /*********************/";
  z[lc++]="      /* create BYE packet */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      nsys_netout_rtcp_len_bye = (NSYS_RTCPLEN_RREMPTY + sdes_size +";
  z[lc++]="			     NSYS_RTCPLEN_BYE);";
  z[lc++]="";
  z[lc++]="      nsys_netout_rtcp_packet_bye = malloc(nsys_netout_rtcp_len_bye + ";
  z[lc++]="				      NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="      /*********************/";
  z[lc++]="      /* create RR packets */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      nsys_netout_rtcp_len_rrempty = NSYS_RTCPLEN_RREMPTY + sdes_size;";
  z[lc++]="      nsys_netout_rtcp_packet_rrempty = malloc(nsys_netout_rtcp_len_rrempty + ";
  z[lc++]="					  NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="      nsys_netout_rtcp_len_rr = NSYS_RTCPLEN_RR + sdes_size;";
  z[lc++]="      nsys_netout_rtcp_packet_rr = malloc(nsys_netout_rtcp_len_rr + ";
  z[lc++]="				     NSYS_MD5_LENGTH + 1);";
  z[lc++]="	  ";
  z[lc++]="      /*********************/";
  z[lc++]="      /* create SR packets */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      nsys_netout_rtcp_len_srempty = NSYS_RTCPLEN_SREMPTY + sdes_size;";
  z[lc++]="      nsys_netout_rtcp_packet_srempty = malloc(nsys_netout_rtcp_len_srempty + ";
  z[lc++]="					  NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="      nsys_netout_rtcp_len_sr = NSYS_RTCPLEN_SR + sdes_size;";
  z[lc++]="      nsys_netout_rtcp_packet_sr = malloc(nsys_netout_rtcp_len_sr + ";
  z[lc++]="				     NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* initialize head of all RTCP packets */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initrr(nsys_netout_rtcp_packet_rrempty, NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="  nsys_netout_rtcp_initrr(nsys_netout_rtcp_packet_rr, NSYS_RTCPLEN_RR);";
  z[lc++]="  ";
  z[lc++]="  nsys_netout_rtcp_initsr(nsys_netout_rtcp_packet_srempty, NSYS_RTCPLEN_SREMPTY);";
  z[lc++]="  nsys_netout_rtcp_initsr(nsys_netout_rtcp_packet_sr, NSYS_RTCPLEN_SR);";
  z[lc++]="  ";
  z[lc++]="  nsys_netout_rtcp_initrr(nsys_netout_rtcp_packet_bye, NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="  ";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* initialize SDES of all RTCP packets */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(nsys_netout_rtcp_packet_rrempty";
  z[lc++]="			      [NSYS_RTCPLEN_RREMPTY]), sdes_size);";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(nsys_netout_rtcp_packet_rr";
  z[lc++]="			      [NSYS_RTCPLEN_RR]), sdes_size);";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(nsys_netout_rtcp_packet_srempty";
  z[lc++]="			      [NSYS_RTCPLEN_SREMPTY]), sdes_size);";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(nsys_netout_rtcp_packet_sr";
  z[lc++]="			      [NSYS_RTCPLEN_SR]), sdes_size);";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(nsys_netout_rtcp_packet_bye";
  z[lc++]="			      [NSYS_RTCPLEN_RREMPTY]), sdes_size);";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* initialize BYE packet, sign */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initbye(&(nsys_netout_rtcp_packet_bye";
  z[lc++]="			     [NSYS_RTCPLEN_RREMPTY + sdes_size]));";
  z[lc++]="";
  z[lc++]="  nsys_hmac_md5(nsys_netout_rtcp_packet_bye, nsys_netout_rtcp_len_bye, nsys_keydigest,";
  z[lc++]="		&(nsys_netout_rtcp_packet_bye[nsys_netout_rtcp_len_bye]));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               adds commands to reset an mset                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_clear_mset(unsigned char * buff, long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_source s;";
  z[lc++]="";
  z[lc++]="  if (!nsys_powerup_mset)";
  z[lc++]="    return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="";
  z[lc++]="  s.mset = nsys_powerup_mset;";
  z[lc++]="  nsys_powerup_mset = 0; ";
  z[lc++]=" ";
  z[lc++]="  return nsys_netin_journal_addcmd_three(&s, buff, fill, size, ";
  z[lc++]="					 CSYS_MIDI_POWERUP, 0, 0);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  second-level RTCP functions                 */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             handle special rtcptime cases                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netout_excheck(void) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  int print_exit, rfd;";
  z[lc++]="";
  z[lc++]="  if (nsys_rtcp_ex & (NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP))";
  z[lc++]="    {";
  z[lc++]="      print_exit = 0;";
  z[lc++]="";
  z[lc++]="      if (nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_rtcp_ex & NSYS_RTCPEX_RTPNEXT)";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_rtp_sipretry++ < NSYS_SIP_RETRYMAX)";
  z[lc++]="		nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_invite);";
  z[lc++]="	      else";
  z[lc++]="		print_exit = nsys_graceful_exit = 1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_rtcp_ex & NSYS_RTCPEX_RTCPNEXT)";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_rtcp_sipretry++ < NSYS_SIP_RETRYMAX)";
  z[lc++]="		nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_invite);";
  z[lc++]="	      else";
  z[lc++]="		print_exit = nsys_graceful_exit = 1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (print_exit)";
  z[lc++]="	nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		     \"SIP server probably off-line, exiting\");";
  z[lc++]="      else";
  z[lc++]="	if (((nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP) && ";
  z[lc++]="	     ((nsys_rtcp_ex & NSYS_RTCPEX_RTPNEXT) == 0)) || ";
  z[lc++]="	    ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP) && ";
  z[lc++]="	     ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPNEXT) == 0)))";
  z[lc++]="	  nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			 \"SIP server not responding, resending\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & NSYS_RTCPEX_SRCDUPL) == 0)";
  z[lc++]="    return (nsys_rtcp_ex & NSYS_RTCPEX_NULLROOT);";
  z[lc++]="";
  z[lc++]="  nsys_warning(NSYS_WARN_STANDARD, \"CSRC clash: reinitializing network\");";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="		    NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* send RTCP BYE packet  */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & NSYS_RTCPEX_NULLROOT) == 0)";
  z[lc++]="    nsys_netout_rtcpsend(nsys_netout_rtcp_packet_bye, ";
  z[lc++]="			 nsys_netout_rtcp_len_bye + NSYS_RTPSIZE_DIGEST);";
  z[lc++]="";
  z[lc++]="  /*****************/";
  z[lc++]="  /* shut down SIP */";
  z[lc++]="  /*****************/";
  z[lc++]="";
  z[lc++]="  nsys_sip_shutdown();           ";
  z[lc++]="";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  /* pick new ssrc value, send SIP INVITEs, set up RTP/RTCP packets */";
  z[lc++]="  /******************************************************************/";
  z[lc++]="";
  z[lc++]="  rfd = open(\"/dev/urandom\", O_RDONLY | O_NONBLOCK);";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0) || (read(rfd, &nsys_myssrc, sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_myssrc = (unsigned long)rand();";
  z[lc++]="";
  z[lc++]="  nsys_myssrc_net = htonl(nsys_myssrc);";
  z[lc++]="";
  z[lc++]="  if (rfd)";
  z[lc++]="    close(rfd);";
  z[lc++]="";
  z[lc++]="  if (nsys_initsip() == NSYS_ERROR)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"Error sending SIP INVITE during CSRC clash\");";
  z[lc++]="";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_SSRC]), &nsys_myssrc_net,";
  z[lc++]="	 sizeof(long));";
  z[lc++]="";
  z[lc++]="  nsys_nexttime = time(NULL) + NSYS_RTCPTIME_INCR;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initpackets();";
  z[lc++]="";
  z[lc++]="  nsys_sent_this = nsys_sent_last = 0;";
  z[lc++]="  nsys_sent_octets = nsys_sent_packets = 0;";
  z[lc++]="";
  z[lc++]="  if ((sptr = nsys_srcroot))";
  z[lc++]="    {";
  z[lc++]="      do ";
  z[lc++]="	{";
  z[lc++]="	  sptr->received = sptr->rtcp_received = sptr->received_prior = 0;";
  z[lc++]="	  sptr = sptr->next;";
  z[lc++]="	} ";
  z[lc++]="      while (sptr != nsys_srcroot);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* reset nsys_rtcp_ex */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex = (nsys_srcroot == NULL) ? NSYS_RTCPEX_NULLROOT : 0;";
  z[lc++]="  nsys_rtcp_ex |= (NSYS_RTCPEX_RTCPSIP | NSYS_RTCPEX_RTPSIP); ";
  z[lc++]="";
  z[lc++]="  return (0);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sends out RTCP SR/RR reports                          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcpreport(void)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int len_empty, len_full, offset;";
  z[lc++]="  unsigned char * p_empty, * p_full;";
  z[lc++]="  int len = 0;";
  z[lc++]="  unsigned char * p = NULL;";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int alt = 0;";
  z[lc++]="  unsigned long dead_ssrc;";
  z[lc++]="  unsigned long expected, expected_this, received_this;";
  z[lc++]="  long num_lost;";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  struct sockaddr * addr;";
  z[lc++]="  struct timeval now;";
  z[lc++]="";
  z[lc++]="  sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  if (nsys_sent_this || nsys_sent_last)";
  z[lc++]="    {";
  z[lc++]="      nsys_sent_last = nsys_sent_this;";
  z[lc++]="      nsys_sent_this = 0;";
  z[lc++]="      ";
  z[lc++]="      offset = NSYS_RTCPLEN_SRHDR + NSYS_RTCPLEN_SENDER;";
  z[lc++]="      len_empty = nsys_netout_rtcp_len_srempty;";
  z[lc++]="      p_empty = nsys_netout_rtcp_packet_srempty;";
  z[lc++]="      len_full = nsys_netout_rtcp_len_sr;";
  z[lc++]="      p_full = nsys_netout_rtcp_packet_sr;";
  z[lc++]="";
  z[lc++]="      gettimeofday(&now, 0);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(nsys_netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_NTPMSB])) =";
  z[lc++]="	htonl(0x83aa7e80 + now.tv_sec);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(nsys_netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_NTPLSB])) =";
  z[lc++]="	htonl((unsigned long) ";
  z[lc++]="	      (((((unsigned long)(now.tv_usec << 12))/15625) << 14))); ";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(nsys_netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_TSTAMP])) =";
  z[lc++]="	htonl(nsys_netout_tstamp);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(nsys_netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_PACKET])) =";
  z[lc++]="	htonl(nsys_sent_packets);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(nsys_netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_OCTET])) =";
  z[lc++]="	htonl(nsys_sent_octets);";
  z[lc++]="";
  z[lc++]="      memcpy(&(nsys_netout_rtcp_packet_srempty[NSYS_RTCPLEN_SRHDR]), ";
  z[lc++]="	     &(nsys_netout_rtcp_packet_sr[NSYS_RTCPLEN_SRHDR]), ";
  z[lc++]="	     NSYS_RTCPLEN_SENDER);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      offset = NSYS_RTCPLEN_RRHDR;";
  z[lc++]="";
  z[lc++]="      len_empty = nsys_netout_rtcp_len_rrempty;";
  z[lc++]="      p_empty = nsys_netout_rtcp_packet_rrempty;";
  z[lc++]="      len_full = nsys_netout_rtcp_len_rr;";
  z[lc++]="      p_full = nsys_netout_rtcp_packet_rr;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      if (!alt)";
  z[lc++]="	{";
  z[lc++]="	  addr = (struct sockaddr *)(sptr->rtcp_addr);";
  z[lc++]="	  if (time(NULL) > sptr->expire_rtcp)";
  z[lc++]="	    {";
  z[lc++]="	      dead_ssrc = sptr->ssrc;";
  z[lc++]="	      if ((sptr = sptr->next) == nsys_srcroot)";
  z[lc++]="		sptr = NULL;";
  z[lc++]="	      nsys_delete_ssrc(dead_ssrc, ";
  z[lc++]="			       \"RTCP silent too long, deleting\");";
  z[lc++]="	      if (sptr)";
  z[lc++]="		continue;";
  z[lc++]="	      else";
  z[lc++]="		break;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (sptr->received > sptr->received_prior)";
  z[lc++]="	    {";
  z[lc++]="";
  z[lc++]="	      p = p_full;";
  z[lc++]="	      len = len_full;";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_SSRC])) =";
  z[lc++]="		htonl(sptr->ssrc);";
  z[lc++]="";
  z[lc++]="	      expected = sptr->hi_ext - sptr->base_seq + 1;";
  z[lc++]="";
  z[lc++]="	      expected_this = expected - sptr->expected_prior;";
  z[lc++]="	      sptr->expected_prior = expected;";
  z[lc++]="";
  z[lc++]="	      received_this = sptr->received - sptr->received_prior;";
  z[lc++]="	      sptr->received_prior = sptr->received;";
  z[lc++]="";
  z[lc++]="	      num_lost = expected - sptr->received;";
  z[lc++]="	      ";
  z[lc++]="	      if (num_lost < NSYS_RTPSEQ_MINLOSS)";
  z[lc++]="		num_lost = NSYS_RTPSEQ_MINLOSS;";
  z[lc++]="";
  z[lc++]="	      if (num_lost > NSYS_RTPSEQ_MAXLOSS)";
  z[lc++]="		num_lost = NSYS_RTPSEQ_MAXLOSS;";
  z[lc++]="";
  z[lc++]="	      num_lost &= NSYS_RTPSEQ_FMASK;";
  z[lc++]="";
  z[lc++]="	      if (((expected_this - received_this) > 0) && expected_this)";
  z[lc++]="		num_lost |= ((((expected_this - received_this) << 8)";
  z[lc++]="			      /expected_this) << 24);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_FRACTLOSS])) =";
  z[lc++]="		htonl((unsigned long) num_lost);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_HISEQ])) =";
  z[lc++]="		htonl(sptr->hi_ext);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_JITTER])) =";
  z[lc++]="		htonl((unsigned long)(sptr->jitter >> 4));";
  z[lc++]="";
  z[lc++]="	      memcpy(&(p[offset + NSYS_RTCPLOC_RR_LASTSR]), sptr->lsr, 4);";
  z[lc++]="";
  z[lc++]="	      gettimeofday(&now, 0);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_DELAY])) =";
  z[lc++]="		(sptr->arrival.tv_sec == 0) ? 0 : ";
  z[lc++]="		htonl((unsigned long)";
  z[lc++]="		      (((now.tv_sec - sptr->arrival.tv_sec) << 16) +";
  z[lc++]="		       (((now.tv_usec - sptr->arrival.tv_usec) << 10) ";
  z[lc++]="			/15625)));";
  z[lc++]="";
  z[lc++]="	      sptr->received_prior = sptr->received;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      p = p_empty;";
  z[lc++]="	      len = len_empty;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  nsys_hmac_md5(p, len, nsys_keydigest, &(p[len]));";
  z[lc++]="	  len += NSYS_RTPSIZE_DIGEST;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	addr = (struct sockaddr *)(sptr->alt_rtcp_addr);";
  z[lc++]="      ";
  z[lc++]="      if (sendto(nsys_rtcp_fd, p, len, 0, addr, ";
  z[lc++]="		 sizeof(struct sockaddr)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    continue;";
  z[lc++]="	  ";
  z[lc++]="	  if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_netout_rtcptime\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (!(alt = ((!alt) && sptr->alt_rtcp_addr)))";
  z[lc++]="	sptr = sptr->next;";
  z[lc++]="    } ";
  z[lc++]="  while (alt || (sptr != nsys_srcroot));";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  sends out RTCP packets                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcpsend(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int alt = 0;";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  struct sockaddr * addr;";
  z[lc++]="";
  z[lc++]="  sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      addr = (alt ? (struct sockaddr *)(sptr->alt_rtcp_addr) : ";
  z[lc++]="	      (struct sockaddr *)(sptr->rtcp_addr));";
  z[lc++]="      ";
  z[lc++]="      if (sendto(nsys_rtcp_fd, p, len, 0, addr, ";
  z[lc++]="		 sizeof(struct sockaddr)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    continue;";
  z[lc++]="	  ";
  z[lc++]="	  if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_netout_rtcptime\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (!(alt = ((!alt) && sptr->alt_rtcp_addr)))";
  z[lc++]="	sptr = sptr->next;";
  z[lc++]="    } ";
  z[lc++]="  while (alt || (sptr != nsys_srcroot));";
  z[lc++]="  ";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             sends out keepalive SIP INFO packets             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_keepalive(void)";
  z[lc++]="";
  z[lc++]="{        ";
  z[lc++]="  if (nsys_sipinfo_toggle && ((nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP) == 0))";
  z[lc++]="    nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_info);";
  z[lc++]="  else";
  z[lc++]="    if ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP) == 0)";
  z[lc++]="      nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_info);";
  z[lc++]="  ";
  z[lc++]="  nsys_sipinfo_count = 0;";
  z[lc++]="  nsys_sipinfo_toggle = !nsys_sipinfo_toggle;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              display received RTCP packet information        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_rtcp_display(unsigned char * packet, int len, ";
  z[lc++]="			     struct timeval * now) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if NSYS_DISPLAY_RTCP";
  z[lc++]="";
  z[lc++]="  int error, complen;";
  z[lc++]="  unsigned long csrc, current, sent, delay;";
  z[lc++]="  long lost;";
  z[lc++]="  unsigned char contents, slen, offset;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="    {";
  z[lc++]="      printf(\"processing RTCP payload -- %i bytes\\n\", len);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  error = 0;";
  z[lc++]="  while ((len > 0) && !error)";
  z[lc++]="    {";
  z[lc++]="      contents = offset = 0;";
  z[lc++]="      complen = ntohs(*((unsigned short *)&(packet[NSYS_RTCPLOC_LENGTH])));";
  z[lc++]="      switch (packet[NSYS_RTCPLOC_PTYPE]) {";
  z[lc++]="      case NSYS_RTCPVAL_SR:";
  z[lc++]="	contents = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="	if (contents)";
  z[lc++]="	  offset = NSYS_RTCPLEN_SRHDR + NSYS_RTCPLEN_SENDER;";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    csrc = ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SSRC])));";
  z[lc++]="	    printf(\"type SR (%i bytes) from SSRC %lu with %hhu reception reports\\n\",";
  z[lc++]="		   4*complen + 4, csrc, contents);";
  z[lc++]="	  }";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_SRINFO)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"NTP time %f, RTP timestamp %lu\\n\", ";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_NTPMSB])))";
  z[lc++]="		   + (ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_NTPLSB])))";
  z[lc++]="		      /(4294967296.0)), (unsigned long)";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_TSTAMP]))));";
  z[lc++]="	    printf(\"Total packets %lu, total octets %lu\\n\", (unsigned long)";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_PACKET]))),";
  z[lc++]="		   (unsigned long) ";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_OCTET]))));";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_RR:";
  z[lc++]="	contents = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="	if (contents)";
  z[lc++]="	  offset = NSYS_RTCPLEN_RRHDR;";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    csrc = ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SSRC])));";
  z[lc++]="	    printf(\"type RR (%i bytes) -- from SSRC %lu with %hhu reception reports\\n\",";
  z[lc++]="		   4*complen + 4, csrc, contents);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_SDES:";
  z[lc++]="	contents = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"type SDES (%i bytes) -- %hhu chunks\\n\", 4*complen + 4,";
  z[lc++]="		   contents);";
  z[lc++]="	  }";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_SDES)";
  z[lc++]="	  {";
  z[lc++]="	    p = packet + NSYS_RTCPLEN_SDES_CHUNKHDR;";
  z[lc++]="	    while (contents--)";
  z[lc++]="	      {";
  z[lc++]="		/* add fail-safe for bad packets */";
  z[lc++]="		";
  z[lc++]="		csrc = ntohl(*((unsigned long *)p));";
  z[lc++]="		printf(\"SDES for CSRC %lu\\n\", csrc);";
  z[lc++]="		p += 4;";
  z[lc++]="		while (p[NSYS_RTCPLOC_SDESITEM_TYPE] != '\\0')";
  z[lc++]="		  {";
  z[lc++]="		    printf(\"%s: \", (p[NSYS_RTCPLOC_SDESITEM_TYPE] < ";
  z[lc++]="				    NSYS_RTCPVAL_SDES_SIZE) ? ";
  z[lc++]="			   sdes_typename[p[NSYS_RTCPLOC_SDESITEM_TYPE]] : ";
  z[lc++]="			   \"Illegal\");";
  z[lc++]="		    slen = p[NSYS_RTCPLOC_SDESITEM_LENGTH];";
  z[lc++]="		    p += 2;";
  z[lc++]="		    while (slen--)";
  z[lc++]="		      putchar(*(p++));";
  z[lc++]="		    printf(\"\\n\");";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_BYE:";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"type BYE (%i bytes)\\n\", 4*complen + 4);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_APP:	";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"type APP\\n\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	printf(\"error parsing PTYPE %i (%i bytes)\\n\",";
  z[lc++]="	       packet[NSYS_RTCPLOC_PTYPE], complen);";
  z[lc++]="	error = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="      if (offset && NSYS_DISPLAY_RTCP_RRINFO)";
  z[lc++]="	{";
  z[lc++]="	  printf(\"reception quality from SSRC %lu\\n\",(unsigned long)";
  z[lc++]="		 ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset+NSYS_RTCPLOC_RR_SSRC]))));";
  z[lc++]="";
  z[lc++]="	  printf(\"fraction lost: %f,\", ";
  z[lc++]="		 (packet[offset+NSYS_RTCPLOC_RR_FRACTLOSS]/256.0F));";
  z[lc++]="";
  z[lc++]="	  memcpy(&lost, &(packet[offset+NSYS_RTCPLOC_RR_FRACTLOSS]),";
  z[lc++]="		 sizeof(long));";
  z[lc++]="	  lost = (signed long)ntohl((unsigned long)lost);";
  z[lc++]="";
  z[lc++]="	  if (((lost &= NSYS_RTPSEQ_FMASK) & NSYS_RTPSEQ_TSIGN))";
  z[lc++]="	    lost |= (~NSYS_RTPSEQ_FMASK);";
  z[lc++]="";
  z[lc++]="	  printf(\" total lost packets %li\\n\", lost);";
  z[lc++]="";
  z[lc++]="	  printf(\"highest sequence number received %lu\\n\", (unsigned long)";
  z[lc++]="		 ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset+NSYS_RTCPLOC_RR_HISEQ]))));";
  z[lc++]="	  printf(\"jitter: %f ms\\n\", (1000/ARATE)*(unsigned long)";
  z[lc++]="		 ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset + NSYS_RTCPLOC_RR_JITTER]))));";
  z[lc++]="";
  z[lc++]="	  current = now->tv_sec;";
  z[lc++]="	  current = (current + 32384) << 16;";
  z[lc++]="	  current += (((unsigned long)now->tv_usec) << 10)/15625;";
  z[lc++]="	  sent = ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset + NSYS_RTCPLOC_RR_LASTSR])));";
  z[lc++]="	  delay = ntohl(*((unsigned long *)";
  z[lc++]="			  &(packet[offset + NSYS_RTCPLOC_RR_DELAY])));";
  z[lc++]="	  if (sent || delay)";
  z[lc++]="	    {";
  z[lc++]="	      if (current > sent)";
  z[lc++]="		printf(\"Estimated round-trip time: %f milliseconds\\n\",";
  z[lc++]="		       1000.0F*(current - sent - delay)/65536.0F);";
  z[lc++]="	      else";
  z[lc++]="		printf(\"Estimated round-trip time: %f milliseconds (flip)\\n\",";
  z[lc++]="		       1000.0F*(sent - current - delay)/65536.0F);";
  z[lc++]="	      if (NSYS_DISPLAY_RTCP_RRTCOMP)";
  z[lc++]="		{";
  z[lc++]="		  printf(\"    Components\\n\");";
  z[lc++]="		  printf(\"     Current time %fs\\n\", current/65536.0F);";
  z[lc++]="		  printf(\"        Sent time %fs\\n\", sent/65536.0F);";
  z[lc++]="		  printf(\"       Delay time %fs\\n\", delay/65536.0F);";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (error)";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      complen = 4*complen + 4;";
  z[lc++]="      len -= complen;";
  z[lc++]="      packet += complen;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (error)";
  z[lc++]="    printf(\"error processing RTCP payload\\n\");";
  z[lc++]="  else";
  z[lc++]="    if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="      printf(\"RTCP payload succesfully processed \\n\\n\");";
  z[lc++]="";
  z[lc++]="  printf(\"\\n\");";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   parse new SDES cname subpacket item -- presently not used  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="char * nsys_netin_newcname(unsigned char * packet, int len) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char slen;";
  z[lc++]="  char * ret, * rptr;";
  z[lc++]="";
  z[lc++]="  packet += 8;    /* skip header, assume one csrc */";
  z[lc++]="  len -= 8; ";
  z[lc++]="";
  z[lc++]="  while ((len > 0) && ";
  z[lc++]="	 (packet[NSYS_RTCPLOC_SDESITEM_TYPE] != NSYS_RTCPVAL_SDES_CNAME))";
  z[lc++]="    {";
  z[lc++]="      slen = packet[NSYS_RTCPLOC_SDESITEM_LENGTH];";
  z[lc++]="      len -= 2 + slen;";
  z[lc++]="      packet +=  2 + slen;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((len <= 0) || ";
  z[lc++]="      (packet[NSYS_RTCPLOC_SDESITEM_TYPE] != NSYS_RTCPVAL_SDES_CNAME))";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  slen = packet[NSYS_RTCPLOC_SDESITEM_LENGTH];";
  z[lc++]="  rptr = ret = calloc(slen + 1, sizeof(char));";
  z[lc++]="  packet += 2;";
  z[lc++]="";
  z[lc++]="  while (slen)";
  z[lc++]="    {";
  z[lc++]="      *(rptr++) = *(packet++);";
  z[lc++]="      slen--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Adding session member: %s\\n\", ret);";
  z[lc++]="  fflush(stderr);";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   parse new BYE subpacket                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_bye(unsigned char * packet, int len) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char sc;";
  z[lc++]="  unsigned long ssrc;";
  z[lc++]="";
  z[lc++]="  if ((len -= 4) <= 0)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  sc = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="";
  z[lc++]="  while (sc && ((len -= 4) >= 0))";
  z[lc++]="    {";
  z[lc++]="      packet += 4;";
  z[lc++]="      memcpy(&ssrc, packet, sizeof(long));";
  z[lc++]="      ssrc = ntohl(ssrc);";
  z[lc++]="      nsys_delete_ssrc(ssrc, \"RTCP BYE received, deleting\");";
  z[lc++]="      sc--;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                     initialize RR packets                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initrr(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  memset(p, 0, len);";
  z[lc++]="";
  z[lc++]="  /* Version 2, no padding, 0 or 1 reception reports */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = NSYS_RTCPVAL_BYTE1 + (len > NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="";
  z[lc++]="  /* PTYPE RR */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_RR;";
  z[lc++]="";
  z[lc++]="  /* length is number of 32-bit words - 1, in network byte order */";
  z[lc++]="";
  z[lc++]="  nlen = htons((len >> 2) - 1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                     initialize SR packets                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initsr(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  memset(p, 0, len);";
  z[lc++]="";
  z[lc++]="  /* Version 2, no padding, 0 or 1 reception reports */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = NSYS_RTCPVAL_BYTE1 + (len > NSYS_RTCPLEN_SREMPTY);";
  z[lc++]="";
  z[lc++]="  /* PTYPE SR */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_SR;";
  z[lc++]="";
  z[lc++]="  /* length is number of 32-bit words - 1, in network byte order */";
  z[lc++]="";
  z[lc++]="  nlen = htons((len >> 2) - 1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   initialize SDES packets                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initsdes(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  memset(p, 0, len);  /* zero-pads end of chunklist */";
  z[lc++]="";
  z[lc++]="  /* one SSRC chunk */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = 1 + NSYS_RTCPVAL_BYTE1;";
  z[lc++]="";
  z[lc++]="  /* PTYPE SDES */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_SDES;";
  z[lc++]="";
  z[lc++]="  /* length is number of 32-bit words - 1, in network byte order */";
  z[lc++]="";
  z[lc++]="  nlen = htons((len >> 2) - 1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  p += NSYS_RTCPLEN_SDESHDR;";
  z[lc++]="  memcpy(p, &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="  p += NSYS_RTCPLEN_SDES_CHUNKHDR;";
  z[lc++]="  p[NSYS_RTCPLOC_SDESITEM_TYPE] = NSYS_RTCPVAL_SDES_CNAME;";
  z[lc++]="  p[NSYS_RTCPLOC_SDESITEM_LENGTH] = nsys_cname_len;";
  z[lc++]="";
  z[lc++]="  p += NSYS_RTCPLEN_SDES_ITEMHDR;";
  z[lc++]="";
  z[lc++]="  strcpy((char *) p, nsys_cname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   initialize BYE packets                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initbye(unsigned char * p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  /* Version 2, no padding, 1 BYE */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = NSYS_RTCPVAL_BYTE1 + 1;";
  z[lc++]="";
  z[lc++]="  /* PTYPE SR */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_BYE;";
  z[lc++]="";
  z[lc++]="  /* BYE is 8 bytes long --> 2 - 1 words --> 1 word len field */";
  z[lc++]="";
  z[lc++]="  nlen = htons(1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level RTCP functions                    */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*                   delete an ssrc                            */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_delete_ssrc(unsigned long ssrc, char * reason)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct nsys_source * sptr;";
  z[lc++]="  struct nsys_source * last;";
  z[lc++]="  int mset, i;";
  z[lc++]="  last = NULL;";
  z[lc++]="  sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="";
  z[lc++]="  /**************/";
  z[lc++]="  /* find match */";
  z[lc++]="  /**************/";
  z[lc++]="";
  z[lc++]="  while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="    {";
  z[lc++]="      last = sptr;";
  z[lc++]="      sptr = sptr->xtra;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* leave if no match */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  if (sptr == NULL)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /***************/";
  z[lc++]="  /* update xtra */";
  z[lc++]="  /***************/";
  z[lc++]="";
  z[lc++]="  if (last)";
  z[lc++]="    last->xtra = sptr->xtra;";
  z[lc++]="  else";
  z[lc++]="    nsys_ssrc[ssrc & NSYS_HASHMASK] = sptr->xtra;";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* update prev, next */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  if ((sptr == nsys_srcroot) && (sptr->prev == nsys_srcroot))";
  z[lc++]="    {";
  z[lc++]="      nsys_srcroot = NULL;";
  z[lc++]="      nsys_rtcp_ex |= NSYS_RTCPEX_NULLROOT;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sptr->prev->next = sptr->next;";
  z[lc++]="      sptr->next->prev = sptr->prev;";
  z[lc++]="      if (nsys_srcroot == sptr)";
  z[lc++]="	nsys_srcroot = sptr->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_status(sptr, reason);";
  z[lc++]="";
  z[lc++]="  free(sptr->cname);";
  z[lc++]="  free(sptr->sdp_addr);";
  z[lc++]="  free(sptr->rtp_addr);";
  z[lc++]="  free(sptr->alt_rtp_addr);";
  z[lc++]="  free(sptr->rtcp_addr);";
  z[lc++]="  free(sptr->alt_rtcp_addr);";
  z[lc++]="";
  z[lc++]="  nsys_powerup_mset = mset = sptr->mset;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_MIDI_NUMCHAN; i++)";
  z[lc++]="    if (sptr->jrecv[i])";
  z[lc++]="      {";
  z[lc++]="	sptr->jrecv[i]->next = nsys_recvfree;";
  z[lc++]="	nsys_recvfree = sptr->jrecv[i];";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  if (sptr->jrecvsys)";
  z[lc++]="    {";
  z[lc++]="      sptr->jrecvsys->next = nsys_recvsysfree;";
  z[lc++]="      nsys_recvsysfree = sptr->jrecvsys;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  printf(\"mset%i packets expected: %i\\n\", sptr->mset,";
  z[lc++]="	 sptr->hi_ext - sptr->base_seq + 1);";
  z[lc++]="  printf(\"mset%i packets received: %i\\n\", sptr->mset,";
  z[lc++]="	 sptr->received);";
  z[lc++]="  fclose(sptr->tm_fd);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  memset(sptr, 0, sizeof(struct nsys_source));";
  z[lc++]="  ";
  z[lc++]="  sptr->mset = mset;";
  z[lc++]="  sptr->next = nsys_srcfree;";
  z[lc++]="  nsys_srcfree = sptr;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*               harvest an unused ssrc slot                   */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="nsys_source * nsys_harvest_ssrc(int fd, struct sockaddr_in * ipaddr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_source * sptr, * oldptr;";
  z[lc++]="  unsigned long now, oldtime;";
  z[lc++]="  int found = 0;";
  z[lc++]="";
  z[lc++]="  /* sanity checks */";
  z[lc++]="";
  z[lc++]="  if ((nsys_srcfree != NULL) || (nsys_srcroot == NULL)) ";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  oldtime = 0;";
  z[lc++]="  now = time(NULL);";
  z[lc++]="";
  z[lc++]="  oldptr = sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    if ((fd == nsys_rtp_fd) && ";
  z[lc++]="	(sptr->alt_rtp_addr == NULL) && sptr->rtp_addr && ";
  z[lc++]="	!memcmp(ipaddr, sptr->rtp_addr, sizeof(struct sockaddr_in)))";
  z[lc++]="      {";
  z[lc++]="	found = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    ";
  z[lc++]="    if ((fd == nsys_rtcp_fd) && ";
  z[lc++]="	(sptr->alt_rtcp_addr == NULL) && sptr->rtcp_addr && ";
  z[lc++]="	!memcmp(ipaddr, sptr->rtcp_addr, sizeof(struct sockaddr_in)))";
  z[lc++]="      {";
  z[lc++]="	found = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    if ((sptr->birthtime - now) >= oldtime)";
  z[lc++]="      {";
  z[lc++]="	oldptr = sptr;";
  z[lc++]="	oldtime = sptr->birthtime - now;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    sptr = sptr->next;";
  z[lc++]="    ";
  z[lc++]="  } while (sptr != nsys_srcroot);";
  z[lc++]="";
  z[lc++]="  if (found)";
  z[lc++]="    nsys_delete_ssrc(sptr->ssrc, ";
  z[lc++]="		     \"Remote client restarted, deleting old entry for\");";
  z[lc++]="  else";
  z[lc++]="    nsys_delete_ssrc(oldptr->ssrc, ";
  z[lc++]="		     \"Too many players, increase -bandsize value.\"";
  z[lc++]="		     \" Deleting oldest player\");";
  z[lc++]="";
  z[lc++]="  return nsys_srcfree;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*   state update when an RTP/RTCP packet arrive too late      */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_late_windowcheck(nsys_source * sptr, unsigned long tstamp)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long tdiff;";
  z[lc++]="";
  z[lc++]="  if (sptr->tm_lateflag)";
  z[lc++]="    {";
  z[lc++]="      tdiff = nsys_netout_tstamp - sptr->tm_latetime;";
  z[lc++]="      if (tdiff > (unsigned long)(ARATE*NSYS_SM_LATEWINDOW))";
  z[lc++]="	{";
  z[lc++]="	  sptr->tm_lateflag = 0;";
  z[lc++]="	  sptr->tm_convert = tstamp - nsys_netout_tstamp - sptr->tm_margin;";
  z[lc++]="	  nsys_warning(NSYS_WARN_UNUSUAL, \"Resetting late packet detection\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sptr->tm_latetime = nsys_netout_tstamp;";
  z[lc++]="      sptr->tm_lateflag = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*      print warning message for truncated RTCP packet        */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_rtcp_trunc(int sub)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch (sub) {";
  z[lc++]="  case NSYS_RTCPVAL_SR:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SR subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_RR:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP RR subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_SDES:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SDES subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_BYE:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SDES subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_APP:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SDES subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP unknown subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*         initialize debug files for latenotes                */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_latenotes_open(nsys_source * sptr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="				";
  z[lc++]="  sptr->tm_first = nsys_netout_tstamp;";
  z[lc++]="  ";
  z[lc++]="  switch (sptr->mset) {";
  z[lc++]="  case 1:";
  z[lc++]="    sptr->tm_fd = fopen(\"mset1.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  case 2:";
  z[lc++]="    sptr->tm_fd = fopen(\"mset2.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  case 3:";
  z[lc++]="    sptr->tm_fd = fopen(\"mset3.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    sptr->tm_fd = fopen(\"toomany.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  fprintf(sptr->tm_fd,\"1\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"#\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"pairs\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"remote%i\\n\", sptr->mset);";
  z[lc++]="  fprintf(sptr->tm_fd,\"*\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"*\\n\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- RTCP functions */";
  printlib(lc);
}


void makenet_jsend(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- sender journal functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     high-level functions: sending recovery journals          */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      generate recovery journal for an RTP packet             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_create(unsigned char * packet, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * p = packet;";
  z[lc++]="  int i, j, channel;";
  z[lc++]="  unsigned char toc;";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  nsys_netout_jsend_state * jsend;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* add journal header to packet */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  memcpy(p, nsys_netout_jsend_header, NSYS_SM_JH_SIZE);";
  z[lc++]="  p += NSYS_SM_JH_SIZE;";
  z[lc++]="  len -= NSYS_SM_JH_SIZE;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* add Systems if needed */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netout_jsend_system.sheader_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="      if ((len -= jsys->slen) >= 0)";
  z[lc++]="	{";
  z[lc++]="	  memcpy(p, jsys->sheader, NSYS_SM_SH_SIZE);";
  z[lc++]="	  p += NSYS_SM_SH_SIZE;";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter D */";
  z[lc++]="	  /*************/";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsys->chapterd_front, jsys->chapterd_front_size);";
  z[lc++]="	      p += jsys->chapterd_front_size;";
  z[lc++]="";
  z[lc++]="	      if (jsys->chapterd_scj_seqnum)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, jsys->chapterd_scj, jsys->chapterd_scj_size);";
  z[lc++]="		  p += jsys->chapterd_scj_size;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (jsys->chapterd_sck_seqnum)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, jsys->chapterd_sck, jsys->chapterd_sck_size);";
  z[lc++]="		  p += jsys->chapterd_sck_size;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (jsys->chapterd_rty_seqnum)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, jsys->chapterd_rty, NSYS_SM_CD_REALTIME_SIZE);";
  z[lc++]="		  p += NSYS_SM_CD_REALTIME_SIZE;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (jsys->chapterd_rtz_seqnum)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, jsys->chapterd_rtz, NSYS_SM_CD_REALTIME_SIZE);";
  z[lc++]="		  p += NSYS_SM_CD_REALTIME_SIZE;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter V */";
  z[lc++]="	  /*************/";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterv_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsys->chapterv, NSYS_SM_CV_SIZE);";
  z[lc++]="	      p += NSYS_SM_CV_SIZE;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter Q */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsys->chapterq_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsys->chapterq, jsys->chapterq_size);";
  z[lc++]="	      p += jsys->chapterq_size;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter F */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsys->chapterf_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsys->chapterf, jsys->chapterf_size);";
  z[lc++]="	      p += jsys->chapterf_size;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter X */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsys->chapterx_seqnum)";
  z[lc++]="	    for (i = 0; i < jsys->chapterx_stacklen; i++)";
  z[lc++]="	      {";
  z[lc++]="		memcpy(p, jsys->chapterx_stack[i]->log,";
  z[lc++]="		       jsys->chapterx_stack[i]->size);";
  z[lc++]="";
  z[lc++]="		if (!(jsys->chapterx_stack[i]->log[0] & NSYS_SM_CHKS))";
  z[lc++]="		  jsys->chapterx_stack[i]->log[0] |= NSYS_SM_SETS;";
  z[lc++]="";
  z[lc++]="		p += jsys->chapterx_stack[i]->size;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	}";
  z[lc++]="      else        /* recover from overly-large system journal */";
  z[lc++]="	{";
  z[lc++]="	  len += jsys->slen;";
  z[lc++]="	  packet[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_JH_CLRY;";
  z[lc++]="	  nsys_warning(NSYS_WARN_UNUSUAL, \"Sending an incomplete journal (sys)\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************************/";
  z[lc++]="  /* add chapter(s) if needed */";
  z[lc++]="  /****************************/";
  z[lc++]="";
  z[lc++]="  for (channel = 0; channel < nsys_netout_jsend_channel_size; channel++)";
  z[lc++]="    {";
  z[lc++]="      jsend = &(nsys_netout_jsend[nsys_netout_jsend_channel[channel]]);";
  z[lc++]="";
  z[lc++]="      if (jsend->cheader_seqnum)";
  z[lc++]="	{	  ";
  z[lc++]="";
  z[lc++]="	  if ((len -= (NSYS_SM_CH_LENMASK & jsend->clen)) < 0)";
  z[lc++]="	    {";
  z[lc++]="	      len += (NSYS_SM_CH_LENMASK & jsend->clen);";
  z[lc++]="";
  z[lc++]="	      if (packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHANMASK)";
  z[lc++]="		packet[NSYS_SM_JH_LOC_FLAGS]--;";
  z[lc++]="	      else";
  z[lc++]="		packet[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_JH_CLRA;";
  z[lc++]="";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, \"Sending an incomplete journal (ch)\");";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  memcpy(p, jsend->cheader, NSYS_SM_CH_SIZE);";
  z[lc++]="	  p += NSYS_SM_CH_SIZE;";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter P */";
  z[lc++]="	  /*************/";
  z[lc++]="";
  z[lc++]="	  if (jsend->chapterp_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterp, NSYS_SM_CP_SIZE);";
  z[lc++]="	      p += NSYS_SM_CP_SIZE;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter C */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterc_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterc, jsend->chapterc_size);";
  z[lc++]="	      p += jsend->chapterc_size;";
  z[lc++]="	      if (jsend->chapterc_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CC_HDRSIZE; i < jsend->chapterc_size;";
  z[lc++]="		       i += NSYS_SM_CC_LOGSIZE)";
  z[lc++]="		    jsend->chapterc[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chapterc_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter M */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterm_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterm, jsend->chapterm_size);";
  z[lc++]="	      p += jsend->chapterm_size;";
  z[lc++]="";
  z[lc++]="	      if (jsend->chapterl_size)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, jsend->chapterl, jsend->chapterl_size);";
  z[lc++]="		  p += jsend->chapterl_size;";
  z[lc++]="";
  z[lc++]="		  if (jsend->chapterm_sset)";
  z[lc++]="		    {";
  z[lc++]="		      for (i = 0; i < jsend->chapterl_size;)";
  z[lc++]="			{";
  z[lc++]="			  jsend->chapterl[i] |= NSYS_SM_SETS;";
  z[lc++]="			  ";
  z[lc++]="			  toc = jsend->chapterl[i + NSYS_SM_CM_LOC_TOC];";
  z[lc++]="			  i += NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="			  ";
  z[lc++]="			  if (toc & NSYS_SM_CM_TOC_CHKJ)";
  z[lc++]="			    i += NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="			  ";
  z[lc++]="			  if (toc & NSYS_SM_CM_TOC_CHKK)";
  z[lc++]="			    i += NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="			  ";
  z[lc++]="			  if (toc & NSYS_SM_CM_TOC_CHKL)";
  z[lc++]="			    i += NSYS_SM_CM_ABUTTON_SIZE;";
  z[lc++]="			  ";
  z[lc++]="			  if (toc & NSYS_SM_CM_TOC_CHKM)";
  z[lc++]="			    i += NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="";
  z[lc++]="			  if (toc & NSYS_SM_CM_TOC_CHKN)";
  z[lc++]="			    i += NSYS_SM_CM_COUNT_SIZE;";
  z[lc++]="			}";
  z[lc++]="		      jsend->chapterm_sset = 0;";
  z[lc++]="		    }";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter W */";
  z[lc++]="	  /*************/";
  z[lc++]="";
  z[lc++]="	  if (jsend->chapterw_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterw, NSYS_SM_CW_SIZE);";
  z[lc++]="	      p += NSYS_SM_CW_SIZE;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter N */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptern_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      if (jsend->chaptern_timernum)";
  z[lc++]="		{";
  z[lc++]="		  j = jsend->chaptern_timernum;";
  z[lc++]="		  for (i = jsend->chaptern_size - NSYS_SM_CN_HDRSIZE; ";
  z[lc++]="		       i >= NSYS_SM_CN_HDRSIZE; i -= NSYS_SM_CN_LOGSIZE)";
  z[lc++]="		    if (jsend->chaptern[i+1] & NSYS_SM_CN_CHKY)";
  z[lc++]="		      {";
  z[lc++]="			if (jsend->chaptern_timer[NSYS_SM_CLRS & ";
  z[lc++]="						 jsend->chaptern[i]]";
  z[lc++]="			    < nsys_netout_tstamp)";
  z[lc++]="			  {";
  z[lc++]="			    jsend->chaptern[i+1] &= NSYS_SM_CN_CLRY;";
  z[lc++]="			    jsend->chaptern_timernum--;";
  z[lc++]="			  }";
  z[lc++]="			if ((--j) == 0)";
  z[lc++]="			  break;";
  z[lc++]="		      }";
  z[lc++]="		}";
  z[lc++]="	      memcpy(p, jsend->chaptern, jsend->chaptern_size);";
  z[lc++]="	      p += jsend->chaptern_size;";
  z[lc++]="	      if (jsend->chaptern_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CN_HDRSIZE; i < jsend->chaptern_size;";
  z[lc++]="		       i += NSYS_SM_CN_LOGSIZE)";
  z[lc++]="		    jsend->chaptern[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chaptern_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	      if (jsend->chapterb_size)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, &(jsend->chapterb[jsend->chapterb_low]),";
  z[lc++]="			 jsend->chapterb_size);";
  z[lc++]="		  p += jsend->chapterb_size;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter E */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptere_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chaptere, jsend->chaptere_size);";
  z[lc++]="	      p += jsend->chaptere_size;";
  z[lc++]="	      if (jsend->chaptere_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CE_HDRSIZE; i < jsend->chaptere_size;";
  z[lc++]="		       i += NSYS_SM_CE_LOGSIZE)";
  z[lc++]="		    jsend->chaptere[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chaptere_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter T */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptert_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chaptert, NSYS_SM_CT_SIZE);";
  z[lc++]="	      p += NSYS_SM_CT_SIZE;";
  z[lc++]="	    }";
  z[lc++]="	  	  ";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter A */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptera_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chaptera, jsend->chaptera_size);";
  z[lc++]="	      p += jsend->chaptera_size;";
  z[lc++]="	      if (jsend->chaptera_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CA_HDRSIZE; i < jsend->chaptera_size;";
  z[lc++]="		       i += NSYS_SM_CA_LOGSIZE)";
  z[lc++]="		    jsend->chaptera[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chaptera_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************/";
  z[lc++]="  /* set S flags  */";
  z[lc++]="  /****************/";
  z[lc++]="";
  z[lc++]="  while (nsys_netout_jsend_slist_size > 0)";
  z[lc++]="    *(nsys_netout_jsend_slist[--nsys_netout_jsend_slist_size]) |= NSYS_SM_SETS; ";
  z[lc++]="";
  z[lc++]="  return (p - packet);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            sender state: add a new MIDI event                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addstate(unsigned char cmd, unsigned char ndata,";
  z[lc++]="				  unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  nsys_netout_jsend_state * jsend;";
  z[lc++]="  unsigned char chan;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_send = 0;";
  z[lc++]="";
  z[lc++]="  if (nsys_netout_jsend_checkpoint_changed)";
  z[lc++]="    nsys_netout_jsend_checkpoint_changed = 0;";
  z[lc++]="";
  z[lc++]="  if (cmd == CSYS_MIDI_NOOP)";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_SETS;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((cmd & 0xF0) < CSYS_MIDI_NOTEOFF)    /* System Chapter X */";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_journal_addsysex(cmd, ndata, vdata);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if ((cmd & 0xF0) < CSYS_MIDI_SYSTEM)";
  z[lc++]="    {";
  z[lc++]="      chan = 0x0F & cmd;";
  z[lc++]="      cmd &= 0xF0;";
  z[lc++]="";
  z[lc++]="      jsend = &(nsys_netout_jsend[chan]);";
  z[lc++]="";
  z[lc++]="      if (jsend->cheader_seqnum == 0)";
  z[lc++]="	{  ";
  z[lc++]="	  nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] = NSYS_SM_JH_SETA |";
  z[lc++]="	    (nsys_netout_jsend_system.sheader_seqnum ? NSYS_SM_JH_SETY : 0) |";
  z[lc++]="	    ((unsigned char) nsys_netout_jsend_channel_size);";
  z[lc++]="	  ";
  z[lc++]="	  nsys_netout_jsend_channel[nsys_netout_jsend_channel_size++] = chan;";
  z[lc++]="	  ";
  z[lc++]="	  jsend->clen = ((((unsigned short)chan) << (NSYS_SM_CH_CHANSHIFT + 8)) |";
  z[lc++]="			 NSYS_SM_CH_SIZE);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsend->cheader_seqnum = nsys_netout_seqnum;";
  z[lc++]="      nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="	&(jsend->cheader[NSYS_SM_CH_LOC_FLAGS]);";
  z[lc++]="";
  z[lc++]="      nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="      switch (cmd) {";
  z[lc++]="      case CSYS_MIDI_PROGRAM:";
  z[lc++]="	nsys_netout_journal_addprogram(jsend, ndata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_CC:";
  z[lc++]="	nsys_netout_journal_addcontrol(jsend, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_WHEEL:";
  z[lc++]="	nsys_netout_journal_addpwheel(jsend, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_NOTEON:";
  z[lc++]="	if (vdata)";
  z[lc++]="	  {";
  z[lc++]="	    nsys_netout_journal_addnoteon(jsend, ndata, vdata);";
  z[lc++]="	    if (NSYS_NETOUT_CHAPTERE_STATUS == NSYS_NETOUT_CHAPTERE_ON)";
  z[lc++]="	      nsys_netout_journal_addnoteon_extras(jsend, ndata);";
  z[lc++]="	    return;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  vdata = NSYS_SM_CE_DEFREL;  /* fall through */";
  z[lc++]="      case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	nsys_netout_journal_addnoteoff(jsend, ndata, vdata);";
  z[lc++]="	if (NSYS_NETOUT_CHAPTERE_STATUS == NSYS_NETOUT_CHAPTERE_ON)";
  z[lc++]="	  nsys_netout_journal_addnoteoff_extras(jsend, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_CTOUCH:";
  z[lc++]="	nsys_netout_journal_addctouch(jsend, ndata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_PTOUCH:";
  z[lc++]="	nsys_netout_journal_addptouch(jsend, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="  else   /* System command, excepting Chapter X */";
  z[lc++]="    {";
  z[lc++]="      jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="      /* leave early for commands that do not update the journal */";
  z[lc++]="";
  z[lc++]="      switch (cmd) {";
  z[lc++]="      case CSYS_MIDI_SYSTEM_STOP:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CLOCK:";
  z[lc++]="	if (!(jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKN))";
  z[lc++]="	  return;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CONTINUE:";
  z[lc++]="	if ((jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKN))";
  z[lc++]="	  return;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="      nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="      if (jsys->sheader_seqnum == 0)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netout_jsend_channel_size)";
  z[lc++]="	    nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_JH_SETY;";
  z[lc++]="	  else";
  z[lc++]="	    nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] = NSYS_SM_JH_SETY;";
  z[lc++]="";
  z[lc++]="	  jsys->slen = NSYS_SM_SH_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsys->sheader_seqnum = nsys_netout_seqnum;";
  z[lc++]="      nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="	&(jsys->sheader[NSYS_SM_SH_LOC_FLAGS]);";
  z[lc++]="";
  z[lc++]="      switch (cmd) {";
  z[lc++]="      case CSYS_MIDI_SYSTEM_RESET:";
  z[lc++]="	nsys_netout_journal_addreset();";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_TUNE_REQUEST:";
  z[lc++]="	nsys_netout_journal_addtune();";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SONG_SELECT:";
  z[lc++]="	nsys_netout_journal_addsong(ndata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED1:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED2:";
  z[lc++]="	nsys_netout_journal_addsc(cmd, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_TICK:";
  z[lc++]="	nsys_netout_journal_addrt(cmd);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED3:";
  z[lc++]="	nsys_netout_journal_addrt(cmd);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_QFRAME:";
  z[lc++]="	nsys_netout_journal_addtimecode(ndata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CLOCK:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_START:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CONTINUE: ";
  z[lc++]="      case CSYS_MIDI_SYSTEM_STOP:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SONG_PP:";
  z[lc++]="	nsys_netout_journal_addsequence(cmd, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SENSE:";
  z[lc++]="	nsys_netout_journal_addsense();";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            sender state: adds history information            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addhistory(unsigned char cmd, unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char chan = 0x0F & cmd;";
  z[lc++]="  nsys_netout_jsend_state * jsend;";
  z[lc++]="";
  z[lc++]="  cmd &= 0xF0;";
  z[lc++]="";
  z[lc++]="  if ((cmd != CSYS_MIDI_PROGRAM) && (cmd != CSYS_MIDI_CC))";
  z[lc++]="    return;";
  z[lc++]="  ";
  z[lc++]="  jsend = &(nsys_netout_jsend[chan]);";
  z[lc++]="";
  z[lc++]="  if (jsend->history_active == 0)";
  z[lc++]="    jsend->history_active = 1;";
  z[lc++]="";
  z[lc++]="  switch (cmd & 0xF0) {";
  z[lc++]="  case CSYS_MIDI_PROGRAM:";
  z[lc++]="    jsend->history_program = ndata | NSYS_SM_SETH;";
  z[lc++]="    jsend->history_program_bank_msb = jsend->history_cc_bank_msb;";
  z[lc++]="    jsend->history_program_bank_lsb = jsend->history_cc_bank_lsb;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC:  ";
  z[lc++]="    switch (ndata) {";
  z[lc++]="    case CSYS_MIDI_CC_BANKSELECT_MSB:";
  z[lc++]="      jsend->history_cc_bank_msb = vdata | NSYS_SM_CP_SETB;";
  z[lc++]="      jsend->history_cc_bank_lsb = 0;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_BANKSELECT_LSB:";
  z[lc++]="      if (jsend->history_cc_bank_msb & NSYS_SM_CP_CHKB)";
  z[lc++]="	jsend->history_cc_bank_lsb = vdata;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_MODWHEEL_MSB:";
  z[lc++]="      jsend->history_cc_modwheel = vdata | NSYS_SM_SETH;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_CHANVOLUME_MSB:";
  z[lc++]="      jsend->history_cc_volume = vdata | NSYS_SM_SETH;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_RESETALLCONTROL:";
  z[lc++]="      jsend->history_cc_bank_lsb |= NSYS_SM_CP_SETX;";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*    sender state:  trim journal, update checkpoint packet     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_journal_trimstate(nsys_source * lptr)";
  z[lc++]="";
  z[lc++]="{ ";
  z[lc++]="  unsigned long minseq;";
  z[lc++]="  nsys_source * minsource;";
  z[lc++]="  nsys_source * sptr;";
  z[lc++]="  int channel;";
  z[lc++]="  nsys_netout_jsend_state * jsend;";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  /********************************************/";
  z[lc++]="  /* localize extension to new last_hiseq_ext */";
  z[lc++]="  /********************************************/";
  z[lc++]="";
  z[lc++]="  if (lptr)";
  z[lc++]="    {";
  z[lc++]="      lptr->last_hiseq_ext &= NSYS_RTPSEQ_LOMASK;";
  z[lc++]="      lptr->last_hiseq_ext |= (nsys_netout_seqnum & NSYS_RTPSEQ_EXMASK);";
  z[lc++]="      if (lptr->last_hiseq_ext > nsys_netout_seqnum)";
  z[lc++]="	lptr->last_hiseq_ext -= NSYS_RTPSEQ_EXINCR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /********************************************/";
  z[lc++]="  /* find source with smallest last_hiseq_ext */";
  z[lc++]="  /********************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_srcroot == NULL)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  minsource = NULL;";
  z[lc++]="  minseq = NSYS_RTPSEQ_HIGHEST;";
  z[lc++]="  sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  /* later handle 32-bit wraparound correctly */";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="    if (minseq > sptr->last_hiseq_ext)";
  z[lc++]="      {";
  z[lc++]="	minsource = sptr;";
  z[lc++]="	minseq = sptr->last_hiseq_ext;";
  z[lc++]="      }";
  z[lc++]="  } while ((sptr = sptr->next) != nsys_srcroot);";
  z[lc++]="";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* return if checkpoint is still valid */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  if ((minseq == NSYS_RTPSEQ_HIGHEST) || ";
  z[lc++]="      (minseq == nsys_netout_jsend_checkpoint_seqnum))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* update checkpoint  */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_checkpoint_seqnum = minseq;";
  z[lc++]="  nsys_netout_journal_changecheck();";
  z[lc++]="";
  z[lc++]="  if ((nsys_netout_jsend_channel_size == 0) &&";
  z[lc++]="      (nsys_netout_jsend_system.sheader_seqnum == 0))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /***********************/";
  z[lc++]="  /* trim System journal */";
  z[lc++]="  /***********************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netout_jsend_system.sheader_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="      if (jsys->sheader_seqnum <= minseq)";
  z[lc++]="	{";
  z[lc++]="	  nsys_netout_journal_trimsystem();";
  z[lc++]="	  nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_JH_CLRY;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (jsys->chapterd_seqnum && (jsys->chapterd_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimsimple();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_reset_seqnum && ";
  z[lc++]="	      (jsys->chapterd_reset_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimreset();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_tune_seqnum && ";
  z[lc++]="	      (jsys->chapterd_tune_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimtune();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_song_seqnum && ";
  z[lc++]="	      (jsys->chapterd_song_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimsong();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_scj_seqnum && ";
  z[lc++]="	      (jsys->chapterd_scj_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimscj();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_sck_seqnum && ";
  z[lc++]="	      (jsys->chapterd_sck_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimsck();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_rty_seqnum && ";
  z[lc++]="	      (jsys->chapterd_rty_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimrty();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterd_seqnum && jsys->chapterd_rtz_seqnum && ";
  z[lc++]="	      (jsys->chapterd_rtz_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimrtz();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterv_seqnum && (jsys->chapterv_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimsense();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterq_seqnum && (jsys->chapterq_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimsequence();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterf_seqnum && (jsys->chapterf_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimtimecode();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterf_seqnum && jsys->chapterfc_seqnum && ";
  z[lc++]="	      (jsys->chapterfc_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimparttimecode();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterx_seqnum && (jsys->chapterx_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimsysex();";
  z[lc++]="";
  z[lc++]="	  if (jsys->chapterx_seqnum)";
  z[lc++]="	    nsys_netout_journal_trimpartsysex(minseq);";
  z[lc++]="";
  z[lc++]="	  /* other chapters go here */";
  z[lc++]="";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK);";
  z[lc++]="";
  z[lc++]="	  if (jsys->slen <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	    jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= ((unsigned char)(jsys->slen >> 8));";
  z[lc++]="	      jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="		(unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* trim channel journals */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netout_jsend_channel_size)";
  z[lc++]="    {";
  z[lc++]="      for (channel = nsys_netout_jsend_channel_size - 1; channel >= 0; channel--)";
  z[lc++]="	{";
  z[lc++]="	  jsend = &(nsys_netout_jsend[nsys_netout_jsend_channel[channel]]);";
  z[lc++]="	  ";
  z[lc++]="	  /*******************************/";
  z[lc++]="	  /* drop entire channel, or ... */";
  z[lc++]="	  /*******************************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->cheader_seqnum <= minseq)";
  z[lc++]="	    {";
  z[lc++]="	      nsys_netout_journal_trimchapter(jsend, channel);";
  z[lc++]="	      ";
  z[lc++]="	      if (nsys_netout_jsend_channel_size)";
  z[lc++]="		continue;";
  z[lc++]="	      else";
  z[lc++]="		break;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  /*****************************************/";
  z[lc++]="	  /* ... drop chapters from channel header */";
  z[lc++]="	  /*****************************************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterp_seqnum && (jsend->chapterp_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimprogram(jsend);";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterc_seqnum && (jsend->chapterc_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimallcontrol(jsend); ";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterc_seqnum)";
  z[lc++]="	    nsys_netout_journal_trimpartcontrol(jsend, minseq);";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterm_seqnum && (jsend->chapterm_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimallparams(jsend); ";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chapterm_seqnum)";
  z[lc++]="	    nsys_netout_journal_trimpartparams(jsend, minseq);";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chapterw_seqnum && (jsend->chapterw_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimpwheel(jsend);";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chaptern_seqnum && (jsend->chaptern_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimallnote(jsend); ";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chaptern_seqnum)";
  z[lc++]="	    nsys_netout_journal_trimpartnote(jsend, minseq); ";
  z[lc++]="";
  z[lc++]="	  if (jsend->chaptere_seqnum && (jsend->chaptere_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimallextras(jsend); ";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chaptere_seqnum)";
  z[lc++]="	    nsys_netout_journal_trimpartextras(jsend, minseq);";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chaptert_seqnum && (jsend->chaptert_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimctouch(jsend);";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chaptera_seqnum && (jsend->chaptera_seqnum <= minseq))";
  z[lc++]="	    nsys_netout_journal_trimallptouch(jsend); ";
  z[lc++]="	";
  z[lc++]="	  if (jsend->chaptera_seqnum)";
  z[lc++]="	    nsys_netout_journal_trimpartptouch(jsend, minseq);";
  z[lc++]="	";
  z[lc++]="	  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	    htons(jsend->clen);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (nsys_netout_jsend_channel_size == 0)";
  z[lc++]="	nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_JH_CLRA;";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= (~NSYS_SM_JH_CHANMASK);";
  z[lc++]="	  nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= ";
  z[lc++]="	    NSYS_SM_JH_SETA | ((unsigned char)(nsys_netout_jsend_channel_size - 1));";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************/";
  z[lc++]="  /* housekeeping */";
  z[lc++]="  /****************/";
  z[lc++]="";
  z[lc++]="  if (!nsys_netout_jsend_system.sheader_seqnum && !nsys_netout_jsend_channel_size)";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_jsend_slist_size =  0;";
  z[lc++]="";
  z[lc++]="      /* uncomment to disable keep-alive empty-journal RTP packets:        */ ";
  z[lc++]="      /* nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_send = 0;  */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!nsys_netout_jsend_channel_size && !nsys_netout_jsend_system.sheader_seqnum)";
  z[lc++]="    nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_SETS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               ticks down the guard packet timer              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_guard_tick(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* enable conditional to disable keep-alive empty-journal RTP packets */";
  z[lc++]="";
  z[lc++]="  if (1 || nsys_netout_jsend_channel_size)";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_jsend_guard_send = 1;";
  z[lc++]="      nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_next;";
  z[lc++]="      if ((nsys_netout_jsend_guard_next <<= 1) > nsys_netout_jsend_guard_maxtime)";
  z[lc++]="	nsys_netout_jsend_guard_next = nsys_netout_jsend_guard_maxtime;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         add initialization state to recovery journal         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_midistate_init(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int slist_size = nsys_netout_jsend_slist_size;";
  z[lc++]="  unsigned long seqsafe;";
  z[lc++]="  nsys_netout_jsend_state * jsend;";
  z[lc++]="  unsigned char i, cmd, ndata, vdata, bank_msb, bank_lsb;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /* seqnum updated so an rtcp packet doesn't delete inits */";
  z[lc++]="";
  z[lc++]="  seqsafe = nsys_netout_seqnum;      ";
  z[lc++]="  nsys_netout_seqnum = ((nsys_netout_seqnum != NSYS_RTPSEQ_HIGHEST) ?";
  z[lc++]="			(nsys_netout_seqnum + 1) : 1); ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /* load recovery journal with initial values */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_MIDI_NUMCHAN; i++)";
  z[lc++]="    {";
  z[lc++]="      jsend = &(nsys_netout_jsend[i]);";
  z[lc++]="";
  z[lc++]="      if (jsend->history_active == 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      /***********************/";
  z[lc++]="      /* MIDI Program Change */ ";
  z[lc++]="      /***********************/";
  z[lc++]="      ";
  z[lc++]="      bank_msb = jsend->history_cc_bank_msb;   /* save before overwrite happens */";
  z[lc++]="      bank_lsb = jsend->history_cc_bank_lsb;";
  z[lc++]="";
  z[lc++]="      if (jsend->history_program)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->history_program_bank_msb)";
  z[lc++]="	    {";
  z[lc++]="	      cmd = CSYS_MIDI_CC | i;";
  z[lc++]="	      ndata = CSYS_MIDI_CC_BANKSELECT_MSB;";
  z[lc++]="	      vdata = NSYS_SM_CP_CLRB & jsend->history_program_bank_msb;";
  z[lc++]="	      nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="";
  z[lc++]="	      ndata = CSYS_MIDI_CC_BANKSELECT_LSB;";
  z[lc++]="	      vdata = NSYS_SM_CP_CLRX & jsend->history_program_bank_lsb;";
  z[lc++]="	      nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  cmd = CSYS_MIDI_PROGRAM | i;";
  z[lc++]="	  ndata = NSYS_SM_CLRH & jsend->history_program;";
  z[lc++]="	  vdata = 0;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /************************/";
  z[lc++]="      /* MIDI Control Changes */ ";
  z[lc++]="      /************************/";
  z[lc++]="";
  z[lc++]="      cmd = CSYS_MIDI_CC | i;";
  z[lc++]="";
  z[lc++]="      if (bank_msb)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_BANKSELECT_MSB;";
  z[lc++]="	  vdata = NSYS_SM_CP_CLRB & bank_msb;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (bank_lsb)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_BANKSELECT_LSB;";
  z[lc++]="	  vdata = NSYS_SM_CP_CLRX & bank_lsb;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->history_cc_modwheel)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_MODWHEEL_MSB;";
  z[lc++]="	  vdata = NSYS_SM_CLRH & jsend->history_cc_modwheel;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->history_cc_volume)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_CHANVOLUME_MSB;";
  z[lc++]="	  vdata = NSYS_SM_CLRH & jsend->history_cc_volume;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      while (nsys_netout_jsend_slist_size > slist_size)";
  z[lc++]="	*(nsys_netout_jsend_slist[--nsys_netout_jsend_slist_size]) |= NSYS_SM_SETS;";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (slist_size == 0)";
  z[lc++]="    nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_SETS;";
  z[lc++]="  ";
  z[lc++]="  while (slist_size > 0)";
  z[lc++]="    *(nsys_netout_jsend_slist[--slist_size]) &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  nsys_netout_seqnum = seqsafe;   /* restore nsys_netout_seqnum */";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_send = 1;    ";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*      second-level journal functions: addstate chapters       */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               add MIDI Program Change chapter                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addprogram(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  jsend->chapterp[NSYS_SM_CP_LOC_PROGRAM] = ndata;";
  z[lc++]="  jsend->chapterp[NSYS_SM_CP_LOC_BANKMSB] = jsend->history_cc_bank_msb;";
  z[lc++]="  jsend->chapterp[NSYS_SM_CP_LOC_BANKLSB] = jsend->history_cc_bank_lsb;";
  z[lc++]="    ";
  z[lc++]="  nsys_netout_journal_addhistory(CSYS_MIDI_PROGRAM | jsend->chan, ndata, 0);";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterp[NSYS_SM_CP_LOC_PROGRAM]);";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterp_seqnum)";
  z[lc++]="    jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETP;";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons((jsend->clen += NSYS_SM_CP_SIZE));";
  z[lc++]="    }";
  z[lc++]="  jsend->chapterp_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI Controller chapter                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addcontrol(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* Chapter M state machine */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  switch(ndata) {";
  z[lc++]="  case CSYS_MIDI_CC_RPN_MSB:";
  z[lc++]="    jsend->chapterm_state = NSYS_SM_CM_STATE_PENDING_RPN;";
  z[lc++]="    jsend->chapterm_rpn_msb = vdata;";
  z[lc++]="    jsend->chapterm_rpn_lsb = 0;";
  z[lc++]="    nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_CC_NRPN_MSB:";
  z[lc++]="    jsend->chapterm_state = NSYS_SM_CM_STATE_PENDING_NRPN;";
  z[lc++]="    jsend->chapterm_nrpn_msb = vdata;";
  z[lc++]="    jsend->chapterm_nrpn_lsb = 0;";
  z[lc++]="    nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_CC_RPN_LSB:";
  z[lc++]="    jsend->chapterm_state = NSYS_SM_CM_STATE_RPN;";
  z[lc++]="    jsend->chapterm_rpn_lsb = vdata;";
  z[lc++]="    nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_CC_NRPN_LSB:";
  z[lc++]="    jsend->chapterm_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="    jsend->chapterm_nrpn_lsb = vdata;";
  z[lc++]="    nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRY_MSB:";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRY_LSB:";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRYPLUS:";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRYMINUS:";
  z[lc++]="    switch(jsend->chapterm_state) {";
  z[lc++]="    case NSYS_SM_CM_STATE_OFF:   ";
  z[lc++]="      break;                            /* code in Chapter C */";
  z[lc++]="    case NSYS_SM_CM_STATE_PENDING_RPN:";
  z[lc++]="      jsend->chapterm_state = NSYS_SM_CM_STATE_RPN;";
  z[lc++]="      nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="      return;";
  z[lc++]="    case NSYS_SM_CM_STATE_PENDING_NRPN: ";
  z[lc++]="      jsend->chapterm_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="      nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="      return;";
  z[lc++]="    case NSYS_SM_CM_STATE_RPN:";
  z[lc++]="    case NSYS_SM_CM_STATE_NRPN:";
  z[lc++]="      nsys_netout_journal_addparameter(jsend, ndata, vdata);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  /*****************************/";
  z[lc++]="  /* initialize chapter header */";
  z[lc++]="  /*****************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterc_seqnum)";
  z[lc++]="    jsend->chapterc[NSYS_SM_CC_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->clen += NSYS_SM_CC_HDRSIZE;";
  z[lc++]="      jsend->chapterc_size = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="      jsend->chapterc[NSYS_SM_CC_LOC_LENGTH] = 0;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETC;";
  z[lc++]="    }";
  z[lc++]="    ";
  z[lc++]="  /**************************/";
  z[lc++]="  /* update ancillary state */";
  z[lc++]="  /**************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_journal_addhistory(CSYS_MIDI_CC | jsend->chan, ndata, vdata);";
  z[lc++]="";
  z[lc++]="  switch (ndata) {";
  z[lc++]="  case CSYS_MIDI_CC_SUSTAIN:";
  z[lc++]="    if (((vdata >= 64) && !(jsend->chapterc_sustain & 0x01)) || ";
  z[lc++]="	((vdata < 64) && (jsend->chapterc_sustain & 0x01)))";
  z[lc++]="      jsend->chapterc_sustain = ((jsend->chapterc_sustain + 1)  ";
  z[lc++]="				  & NSYS_SM_CC_ALTMOD);";
  z[lc++]="";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | NSYS_SM_CC_SETT | jsend->chapterc_sustain;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="    jsend->chapterc_allsound = ((jsend->chapterc_allsound + 1)  ";
  z[lc++]="				& NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_allsound;";
  z[lc++]="    nsys_netout_journal_clear_nactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_RESETALLCONTROL:";
  z[lc++]="    jsend->chapterc_rac = ((jsend->chapterc_rac + 1) & NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_rac;";
  z[lc++]="    nsys_netout_journal_clear_cactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="    jsend->chapterc_allnotes = ((jsend->chapterc_allnotes + 1)  ";
  z[lc++]="				& NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_allnotes;";
  z[lc++]="    nsys_netout_journal_clear_nactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_OMNI_OFF:";
  z[lc++]="    jsend->chapterc_omni_off = ((jsend->chapterc_omni_off + 1)  ";
  z[lc++]="				& NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_omni_off;";
  z[lc++]="    nsys_netout_journal_clear_nactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_OMNI_ON:";
  z[lc++]="    jsend->chapterc_omni_on = ((jsend->chapterc_omni_on + 1)  ";
  z[lc++]="			       & NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_omni_on;";
  z[lc++]="    nsys_netout_journal_clear_nactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_MONOMODE:";
  z[lc++]="    jsend->chapterc_monomode = ((jsend->chapterc_monomode + 1)  ";
  z[lc++]="				& NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_monomode;";
  z[lc++]="    nsys_netout_journal_clear_nactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_POLYMODE:";
  z[lc++]="    jsend->chapterc_polymode = ((jsend->chapterc_polymode + 1)  ";
  z[lc++]="				& NSYS_SM_CC_ALTMOD);";
  z[lc++]="    vdata = NSYS_SM_CC_SETA | jsend->chapterc_polymode;";
  z[lc++]="    nsys_netout_journal_clear_nactive(jsend);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  /******************************************/";
  z[lc++]="  /* prepare for two types of log additions */";
  z[lc++]="  /******************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterc_seqarray[ndata])";
  z[lc++]="    {";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* \"update log\" preparations */";
  z[lc++]="      /*****************************/";
  z[lc++]="";
  z[lc++]="      i = jsend->chapterc_logptr[ndata];";
  z[lc++]="";
  z[lc++]="      if (i < jsend->chapterc_size - NSYS_SM_CC_LOGSIZE)";
  z[lc++]="	{";
  z[lc++]="	  memmove(&(jsend->chapterc[i]),";
  z[lc++]="		  &(jsend->chapterc[i + NSYS_SM_CC_LOGSIZE]),";
  z[lc++]="		  jsend->chapterc_size - i - NSYS_SM_CC_LOGSIZE);";
  z[lc++]="";
  z[lc++]="	  while (i < (jsend->chapterc_size - NSYS_SM_CC_LOGSIZE))";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterc_logptr[jsend->chapterc[i + NSYS_SM_CC_LOC_LNUM]";
  z[lc++]="				    & NSYS_SM_CLRS] = i;";
  z[lc++]="	      i += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      /**************************/";
  z[lc++]="      /* \"new log\" preparations */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      jsend->chapterc_size += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterc_seqnum)";
  z[lc++]="	jsend->chapterc[NSYS_SM_CC_LOC_LENGTH]++;";
  z[lc++]="";
  z[lc++]="      jsend->clen += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*******************/";
  z[lc++]="  /* do log addition */";
  z[lc++]="  /*******************/";
  z[lc++]="";
  z[lc++]="  i = (jsend->chapterc_size - NSYS_SM_CC_LOGSIZE);";
  z[lc++]="  jsend->chapterc[i + NSYS_SM_CC_LOC_LNUM] = ndata;";
  z[lc++]="  jsend->chapterc[i + NSYS_SM_CC_LOC_LVAL] = vdata;";
  z[lc++]="  jsend->chapterc_logptr[ndata] = i;";
  z[lc++]="";
  z[lc++]="  /***********************************************/";
  z[lc++]="  /* update slists, seqnums, cheader, guard time */";
  z[lc++]="  /***********************************************/";
  z[lc++]="  ";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterc[NSYS_SM_CC_LOC_LENGTH]);";
  z[lc++]="";
  z[lc++]="  jsend->chapterc_sset = 1;";
  z[lc++]="  ";
  z[lc++]="  jsend->chapterc_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chapterc_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  /* writing clen also clears S bit, which is always needed */";
  z[lc++]="";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);  ";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   add Parameter chapter                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addparameter(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				      unsigned char ndata,";
  z[lc++]="				      unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * logplace;";
  z[lc++]="  unsigned char toc;";
  z[lc++]="  unsigned short bholder;";
  z[lc++]="  int loglen, logincr, i, j, nullparam, dummy;";
  z[lc++]=" ";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* at present, all non-null NRPNs, and all non-null RPNs";
  z[lc++]="     except for MSB=00, LSB==00-02, are coded as dummies.";
  z[lc++]="";
  z[lc++]="     dummy coding preserves transactional semantics of the";
  z[lc++]="     RPN/NRPN system, but state information to recovery the";
  z[lc++]="     value of dummy variables is not coded in Chapter M.";
  z[lc++]="  */";
  z[lc++]="  /*________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /*****************************/";
  z[lc++]="  /* initialize chapter header */";
  z[lc++]="  /*****************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterm_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      jsend->clen += NSYS_SM_CM_HDRSIZE;";
  z[lc++]="      jsend->chapterm_size = NSYS_SM_CM_HDRSIZE;";
  z[lc++]="      jsend->chapterl_size = 0;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETM;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************************/";
  z[lc++]="  /* check for null, dummy parameters */";
  z[lc++]="  /************************************/";
  z[lc++]="";
  z[lc++]="  nullparam = (((ndata == CSYS_MIDI_CC_RPN_LSB) && ";
  z[lc++]="		(jsend->chapterm_rpn_msb == CSYS_MIDI_RPN_NULL_MSB) && ";
  z[lc++]="		(jsend->chapterm_rpn_lsb == CSYS_MIDI_RPN_NULL_LSB)) ||";
  z[lc++]="	       ((ndata == CSYS_MIDI_CC_NRPN_LSB) && ";
  z[lc++]="		(jsend->chapterm_nrpn_msb == CSYS_MIDI_NRPN_NULL_MSB) && ";
  z[lc++]="		(jsend->chapterm_nrpn_lsb == CSYS_MIDI_NRPN_NULL_LSB)));";
  z[lc++]="";
  z[lc++]="  if (nullparam)";
  z[lc++]="    dummy = 0;";
  z[lc++]="  else";
  z[lc++]="    dummy = ((jsend->chapterm_state == NSYS_SM_CM_STATE_NRPN) ||";
  z[lc++]="	     (jsend->chapterm_rpn_lsb >= NSYS_SM_CM_ARRAYSIZE) ||  ";
  z[lc++]="	     jsend->chapterm_rpn_msb);";
  z[lc++]="";
  z[lc++]="  /************************************/";
  z[lc++]="  /* remove current dummy if unneeded */";
  z[lc++]="  /************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterm_dummy_seqnum && !dummy)";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterm_dummy_seqnum = 0;";
  z[lc++]="      jsend->chapterl_size -= NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="      jsend->clen -= NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /***********************/";
  z[lc++]="  /* update button state */";
  z[lc++]="  /***********************/";
  z[lc++]="";
  z[lc++]="  switch (ndata) {";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRY_MSB:";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRY_LSB:";
  z[lc++]="    jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] = 0;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRYPLUS:";
  z[lc++]="    jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] += 2;  /* fallthru */";
  z[lc++]="  case CSYS_MIDI_CC_DATAENTRYMINUS:";
  z[lc++]="    jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] -= 1;";
  z[lc++]="";
  z[lc++]="    if (jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] > NSYS_SM_CM_BUTTON_LIMIT)";
  z[lc++]="      jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] = NSYS_SM_CM_BUTTON_LIMIT;";
  z[lc++]="    else";
  z[lc++]="      if (jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] < - NSYS_SM_CM_BUTTON_LIMIT)";
  z[lc++]="	jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] = - NSYS_SM_CM_BUTTON_LIMIT;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  /*****************/";
  z[lc++]="  /* do log update */";
  z[lc++]="  /*****************/";
  z[lc++]="";
  z[lc++]="  if ((jsend->chapterm_state == NSYS_SM_CM_STATE_PENDING_RPN) || ";
  z[lc++]="      (jsend->chapterm_state == NSYS_SM_CM_STATE_PENDING_NRPN))";
  z[lc++]="    {";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* add PENDING field to header */";
  z[lc++]="      /*_____________________________*/";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterm_size == NSYS_SM_CM_HDRSIZE)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterm_size += NSYS_SM_CM_PENDINGSIZE;";
  z[lc++]="	  jsend->clen += NSYS_SM_CM_PENDINGSIZE;";
  z[lc++]="	}";
  z[lc++]="      if (jsend->chapterm_state == NSYS_SM_CM_STATE_PENDING_RPN)";
  z[lc++]="	jsend->chapterm[NSYS_SM_CM_LOC_PENDING] = vdata;";
  z[lc++]="      else";
  z[lc++]="	jsend->chapterm[NSYS_SM_CM_LOC_PENDING] = vdata | NSYS_SM_CM_PENDING_SETQ;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* remove PENDING field from header */";
  z[lc++]="      /*__________________________________*/";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterm_seqnum && ";
  z[lc++]="	  (jsend->chapterm[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKP))";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterm_size -= NSYS_SM_CM_PENDINGSIZE;";
  z[lc++]="	  jsend->clen -= NSYS_SM_CM_PENDINGSIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (!nullparam && !dummy && ";
  z[lc++]="	  (jsend->chapterm_seqarray[jsend->chapterm_rpn_lsb]))";
  z[lc++]="	{";
  z[lc++]="	  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="	  /* move, resize, and update an existing log */";
  z[lc++]="	  /*__________________________________________*/";
  z[lc++]="	  ";
  z[lc++]="	  /******************************/";
  z[lc++]="	  /* compute current log length */";
  z[lc++]="	  /******************************/";
  z[lc++]="	  ";
  z[lc++]="	  i = jsend->chapterm_logptr[jsend->chapterm_rpn_lsb];";
  z[lc++]="	  toc = jsend->chapterl[i + NSYS_SM_CM_LOC_TOC];";
  z[lc++]="	  ";
  z[lc++]="	  loglen = NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="	  ";
  z[lc++]="	  if (toc & NSYS_SM_CM_TOC_CHKJ)";
  z[lc++]="	    loglen += NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="	  ";
  z[lc++]="	  if (toc & NSYS_SM_CM_TOC_CHKK)";
  z[lc++]="	    loglen += NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="	  ";
  z[lc++]="	  if (toc & NSYS_SM_CM_TOC_CHKL)";
  z[lc++]="	    loglen += NSYS_SM_CM_ABUTTON_SIZE;";
  z[lc++]="	  ";
  z[lc++]="	  if (toc & NSYS_SM_CM_TOC_CHKM)";
  z[lc++]="	    loglen += NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="";
  z[lc++]="	  if (toc & NSYS_SM_CM_TOC_CHKN)";
  z[lc++]="	    loglen += NSYS_SM_CM_COUNT_SIZE;";
  z[lc++]="	  ";
  z[lc++]="	  /*************************/";
  z[lc++]="	  /* move log if necessary */";
  z[lc++]="	  /*************************/";
  z[lc++]="	  ";
  z[lc++]="	  if (i + loglen != jsend->chapterl_size)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(&(jsend->chapterl[jsend->chapterl_size]),";
  z[lc++]="		     &(jsend->chapterl[i]), loglen);";
  z[lc++]="	      memmove(&(jsend->chapterl[i]), &(jsend->chapterl[i + loglen]),";
  z[lc++]="		     jsend->chapterl_size - i);";
  z[lc++]="";
  z[lc++]="	      for (j = 0; j < NSYS_SM_CM_ARRAYSIZE; j++)";
  z[lc++]="		if (jsend->chapterm_seqarray[j] && (jsend->chapterm_logptr[j] > i)";
  z[lc++]="		    && (j != jsend->chapterm_rpn_lsb))";
  z[lc++]="		  jsend->chapterm_logptr[j] -= loglen;";
  z[lc++]="";
  z[lc++]="	      i = jsend->chapterm_logptr[jsend->chapterm_rpn_lsb] = ";
  z[lc++]="		jsend->chapterl_size - loglen;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*****************************************************/";
  z[lc++]="	  /* update log contents, compute log resize increment */";
  z[lc++]="	  /*****************************************************/";
  z[lc++]="	  ";
  z[lc++]="	  logplace = &(jsend->chapterl[i]);";
  z[lc++]="	  logplace[NSYS_SM_CM_LOC_PNUMLSB] &= NSYS_SM_CLRS;";
  z[lc++]="	  logincr = 0;";
  z[lc++]="	  ";
  z[lc++]="	  switch (ndata) {";
  z[lc++]="	  case CSYS_MIDI_CC_DATAENTRY_MSB:";
  z[lc++]="	    if (!(logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKJ))";
  z[lc++]="	      logincr += NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="	    if (logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKK)";
  z[lc++]="	      logincr -= NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="	    if (logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKM)";
  z[lc++]="	      logincr -= NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="";
  z[lc++]="	    logplace[NSYS_SM_CM_LOC_TOC] = (NSYS_SM_CM_TOC_SETJ |";
  z[lc++]="					     NSYS_SM_CM_INFO_SETV);";
  z[lc++]="	    logplace[NSYS_SM_CM_LOGHDRSIZE] = vdata;";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_CC_DATAENTRY_LSB:";
  z[lc++]="	    if (!(logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKK))";
  z[lc++]="	      logincr += NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="	    if (logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKM)";
  z[lc++]="	      logincr -= NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="	    ";
  z[lc++]="	    if (logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKJ)";
  z[lc++]="	      {";
  z[lc++]="		logplace[NSYS_SM_CM_LOC_TOC] = (NSYS_SM_CM_TOC_SETJ |";
  z[lc++]="						NSYS_SM_CM_TOC_SETK |";
  z[lc++]="						NSYS_SM_CM_INFO_SETV);";
  z[lc++]="		logplace[NSYS_SM_CM_LOGHDRSIZE + NSYS_SM_CM_ENTRYMSB_SIZE] = vdata;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		logplace[NSYS_SM_CM_LOC_TOC] = (NSYS_SM_CM_TOC_SETK |";
  z[lc++]="						 NSYS_SM_CM_INFO_SETV);";
  z[lc++]="		logplace[NSYS_SM_CM_LOGHDRSIZE] = vdata;";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_CC_DATAENTRYPLUS:";
  z[lc++]="	  case CSYS_MIDI_CC_DATAENTRYMINUS:";
  z[lc++]="	    if (!(logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKM))";
  z[lc++]="	      {";
  z[lc++]="		logincr += NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="		logplace[NSYS_SM_CM_LOC_TOC] |= NSYS_SM_CM_TOC_SETM;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    j = NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="	    if (logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKJ)";
  z[lc++]="	      j += NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="	    if (logplace[NSYS_SM_CM_LOC_TOC] & NSYS_SM_CM_TOC_CHKK)";
  z[lc++]="	      j += NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="";
  z[lc++]="	    bholder = abs(jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb]);";
  z[lc++]="	    bholder = htons((unsigned short) bholder);";
  z[lc++]="";
  z[lc++]="	    memmove(&(logplace[j]), &bholder, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="	    if (jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb] < 0)";
  z[lc++]="	      logplace[j] |= NSYS_SM_CM_BUTTON_SETG;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	  /****************/";
  z[lc++]="	  /* update state */";
  z[lc++]="	  /****************/";
  z[lc++]="	  ";
  z[lc++]="	  jsend->chapterm_seqarray[jsend->chapterm_rpn_lsb] = nsys_netout_seqnum;";
  z[lc++]="	  jsend->clen += logincr;";
  z[lc++]="	  jsend->chapterl_size += logincr;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  /******************************/";
  z[lc++]="	  /* make new log for parameter */";
  z[lc++]="	  /******************************/";
  z[lc++]="	  ";
  z[lc++]="	  /* determine log length */";
  z[lc++]="	  ";
  z[lc++]="	  if (nullparam)";
  z[lc++]="	    loglen = 0;   ";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (dummy)";
  z[lc++]="		loglen = NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="	      else";
  z[lc++]="		switch (ndata) {";
  z[lc++]="		case CSYS_MIDI_CC_DATAENTRY_MSB:";
  z[lc++]="		  loglen = NSYS_SM_CM_LOGHDRSIZE + NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="		  break;";
  z[lc++]="		case CSYS_MIDI_CC_DATAENTRY_LSB:";
  z[lc++]="		  loglen = NSYS_SM_CM_LOGHDRSIZE + NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="		  break;";
  z[lc++]="		case CSYS_MIDI_CC_DATAENTRYPLUS:";
  z[lc++]="		case CSYS_MIDI_CC_DATAENTRYMINUS:";
  z[lc++]="		  loglen = NSYS_SM_CM_LOGHDRSIZE + NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="		  break;";
  z[lc++]="		default:";
  z[lc++]="		  loglen = NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="		  break;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dummy && jsend->chapterm_dummy_seqnum)";
  z[lc++]="	    i = jsend->chapterm_dummy_logptr;";
  z[lc++]="	  else";
  z[lc++]="	    i = jsend->chapterl_size;";
  z[lc++]="";
  z[lc++]="	  /* fill in new log */";
  z[lc++]="	  ";
  z[lc++]="	  if (loglen)";
  z[lc++]="	    {";
  z[lc++]="	      if (jsend->chapterm_state == NSYS_SM_CM_STATE_RPN)";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMMSB] = ";
  z[lc++]="		    jsend->chapterm_rpn_msb;";
  z[lc++]="		  ";
  z[lc++]="		  jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMLSB] = ";
  z[lc++]="		    jsend->chapterm_rpn_lsb;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMLSB] = ";
  z[lc++]="		    jsend->chapterm_nrpn_lsb;";
  z[lc++]="		  ";
  z[lc++]="		  jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMMSB] = ";
  z[lc++]="		    jsend->chapterm_nrpn_msb | NSYS_SM_CM_SETQ;";
  z[lc++]="		}";
  z[lc++]="	      ";
  z[lc++]="	      if (!dummy)";
  z[lc++]="		{";
  z[lc++]="		  switch (ndata) {";
  z[lc++]="		  case CSYS_MIDI_CC_DATAENTRY_MSB:";
  z[lc++]="		    jsend->chapterl[i + NSYS_SM_CM_LOC_TOC]";
  z[lc++]="		      = NSYS_SM_CM_TOC_SETJ | NSYS_SM_CM_INFO_SETV;";
  z[lc++]="		    jsend->chapterl[i + NSYS_SM_CM_LOGHDRSIZE] = vdata;";
  z[lc++]="		    break;";
  z[lc++]="		  case CSYS_MIDI_CC_DATAENTRY_LSB:";
  z[lc++]="		    jsend->chapterl[i + NSYS_SM_CM_LOC_TOC]";
  z[lc++]="		      = NSYS_SM_CM_TOC_SETK | NSYS_SM_CM_INFO_SETV;";
  z[lc++]="		    jsend->chapterl[i + NSYS_SM_CM_LOGHDRSIZE] = vdata;";
  z[lc++]="		    break;";
  z[lc++]="		  case CSYS_MIDI_CC_DATAENTRYPLUS:";
  z[lc++]="		  case CSYS_MIDI_CC_DATAENTRYMINUS:";
  z[lc++]="		    jsend->chapterl[i + NSYS_SM_CM_LOC_TOC]";
  z[lc++]="		      = NSYS_SM_CM_TOC_SETM | NSYS_SM_CM_INFO_SETV;";
  z[lc++]="";
  z[lc++]="		    bholder = abs(jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb]);";
  z[lc++]="		    bholder = htons((unsigned short) bholder);";
  z[lc++]="";
  z[lc++]="		    memmove(&(jsend->chapterl[i + NSYS_SM_CM_LOGHDRSIZE]), ";
  z[lc++]="			    &bholder, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="		    if (jsend->chapterm_cbutton[jsend->chapterm_rpn_lsb]< 0)";
  z[lc++]="		       jsend->chapterl[i + NSYS_SM_CM_LOGHDRSIZE] |= ";
  z[lc++]="			 NSYS_SM_CM_BUTTON_SETG;";
  z[lc++]="		  break;";
  z[lc++]="		  default:";
  z[lc++]="		    jsend->chapterl[i + NSYS_SM_CM_LOC_TOC] = NSYS_SM_CM_INFO_SETV;";
  z[lc++]="		    break;  ";
  z[lc++]="		  }";
  z[lc++]="		  jsend->chapterm_logptr[jsend->chapterm_rpn_lsb] = i;";
  z[lc++]="		  jsend->chapterm_seqarray[jsend->chapterm_rpn_lsb]";
  z[lc++]="		    = nsys_netout_seqnum;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterl[i + NSYS_SM_CM_LOC_TOC] = 0;";
  z[lc++]="		  if (jsend->chapterm_dummy_seqnum)";
  z[lc++]="		    loglen = 0;";
  z[lc++]="		  jsend->chapterm_dummy_seqnum = nsys_netout_seqnum;";
  z[lc++]="		  jsend->chapterm_dummy_logptr = i;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	";
  z[lc++]="	  jsend->clen += loglen;";
  z[lc++]="	  jsend->chapterl_size += loglen;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**************************************************/";
  z[lc++]="  /* update slists, seqnums, state, guard time, etc */";
  z[lc++]="  /**************************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterm[NSYS_SM_CM_LOC_HDR]);";
  z[lc++]="";
  z[lc++]="  jsend->chapterm_sset = 1;";
  z[lc++]="  jsend->chapterm_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  *((unsigned short *) &(jsend->chapterm[NSYS_SM_CM_LOC_HDR])) = ";
  z[lc++]="    htons((unsigned short)(jsend->chapterm_size + jsend->chapterl_size));  ";
  z[lc++]="";
  z[lc++]="  if (nullparam)";
  z[lc++]="    jsend->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="";
  z[lc++]="  if ((jsend->chapterm_state == NSYS_SM_CM_STATE_PENDING_RPN) || ";
  z[lc++]="      (jsend->chapterm_state == NSYS_SM_CM_STATE_PENDING_NRPN))";
  z[lc++]="    jsend->chapterm[NSYS_SM_CM_LOC_HDR] |= NSYS_SM_CM_HDR_SETP;";
  z[lc++]="  else";
  z[lc++]="    if (jsend->chapterm_state != NSYS_SM_CM_STATE_OFF)";
  z[lc++]="      jsend->chapterm[NSYS_SM_CM_LOC_HDR] |= NSYS_SM_CM_HDR_SETE;";
  z[lc++]="";
  z[lc++]="  /* writing clen also clears S bit, which is always needed */";
  z[lc++]="";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               add MIDI Pitch Wheel chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addpwheel(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  jsend->chapterw[NSYS_SM_CW_LOC_FIRST] = ndata;";
  z[lc++]="  jsend->chapterw[NSYS_SM_CW_LOC_SECOND] = vdata;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterw[NSYS_SM_CW_LOC_FIRST]);";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterw_seqnum)";
  z[lc++]="    jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETW;";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons((jsend->clen += NSYS_SM_CW_SIZE));";
  z[lc++]="    }";
  z[lc++]="  jsend->chapterw_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI NoteOff chapter                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addnoteoff(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char bitfield;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  bitfield = (ndata >> NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  ";
  z[lc++]="  /******************************/";
  z[lc++]="  /* initialize chapter and TOC */";
  z[lc++]="  /******************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptern_size = NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->chapterb_size = 1;";
  z[lc++]="      jsend->chapterb_low = bitfield;";
  z[lc++]="      jsend->chapterb_high = bitfield;";
  z[lc++]="      ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LENGTH] = 0;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="      jsend->chapterb[bitfield] = 0;";
  z[lc++]="      ";
  z[lc++]="      jsend->clen += 1 + NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETN;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /***************************/";
  z[lc++]="  /* delete expired note log */";
  z[lc++]="  /***************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqarray[ndata] && ";
  z[lc++]="      ((i = jsend->chaptern_logptr[ndata]) < NSYS_SM_CN_SIZE))";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY)";
  z[lc++]="	jsend->chaptern_timernum--;";
  z[lc++]="      memmove(&(jsend->chaptern[i]), ";
  z[lc++]="	      &(jsend->chaptern[i + NSYS_SM_CN_LOGSIZE]),";
  z[lc++]="	      jsend->chaptern_size - i - NSYS_SM_CN_LOGSIZE);";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptern_size < NSYS_SM_CN_SIZE)";
  z[lc++]="	jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]--;";
  z[lc++]="      jsend->chaptern_size -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="      jsend->clen -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      while (i < jsend->chaptern_size)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptern_logptr[jsend->chaptern[i] & NSYS_SM_CLRS] ";
  z[lc++]="	    -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /********************************/";
  z[lc++]="  /* add bitfield bytes if needed */";
  z[lc++]="  /********************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterb_high < jsend->chapterb_low)";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterb_size = 1;";
  z[lc++]="      jsend->chapterb_low = bitfield;";
  z[lc++]="      jsend->chapterb_high = bitfield;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="      jsend->chapterb[bitfield] = 0;";
  z[lc++]="      jsend->clen++;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (bitfield > jsend->chapterb_high)";
  z[lc++]="    {";
  z[lc++]="      memset(&(jsend->chapterb[jsend->chapterb_high + 1]), 0,";
  z[lc++]="	     (bitfield - jsend->chapterb_high));";
  z[lc++]="      jsend->chapterb_size += (bitfield - jsend->chapterb_high);";
  z[lc++]="      jsend->clen += (bitfield - jsend->chapterb_high);";
  z[lc++]="      jsend->chapterb_high = bitfield;	  ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (bitfield < jsend->chapterb_low)";
  z[lc++]="    {";
  z[lc++]="      memset(&(jsend->chapterb[bitfield]), 0,";
  z[lc++]="	     (jsend->chapterb_low - bitfield));";
  z[lc++]="      jsend->chapterb_size += (jsend->chapterb_low - bitfield);";
  z[lc++]="      jsend->clen += (jsend->chapterb_low - bitfield);";
  z[lc++]="      jsend->chapterb_low = bitfield;	  ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /*****************/";
  z[lc++]="  /* update slists */";
  z[lc++]="  /*****************/";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptern[NSYS_SM_CN_LOC_LENGTH] &= NSYS_SM_CLRS; ";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]);";
  z[lc++]="  ";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  /* set correct bit in bitfield byte, update channel/chapter state */";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  ";
  z[lc++]="  jsend->chapterb[bitfield] |= (1 << ((~ndata) & NSYS_SM_CN_BFMASK));";
  z[lc++]="  jsend->chaptern_logptr[ndata] = (NSYS_SM_CN_SIZE + bitfield);";
  z[lc++]="  ";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptern_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chaptern_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               add MIDI NoteOn chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addnoteon(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				   unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* initialize chapter and TOC */";
  z[lc++]="  /******************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptern_size = NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->chapterb_size = 0;";
  z[lc++]="      jsend->chapterb_low = NSYS_SM_CN_BFMAX;";
  z[lc++]="      jsend->chapterb_high = 1;";
  z[lc++]="      ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LENGTH] = NSYS_SM_CN_SETB;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="      ";
  z[lc++]="      jsend->clen += NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETN;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqarray[ndata]) ";
  z[lc++]="    {";
  z[lc++]="      if ((i = (jsend->chaptern_logptr[ndata] - NSYS_SM_CN_SIZE)) >= 0)";
  z[lc++]="	{";
  z[lc++]="";
  z[lc++]="	  /*********************************/";
  z[lc++]="	  /* zero expired NoteOff bitfield */";
  z[lc++]="	  /*********************************/";
  z[lc++]="	  ";
  z[lc++]="	  jsend->chapterb[i] &= ~(1 << ((~ndata) & NSYS_SM_CN_BFMASK));";
  z[lc++]="	  if ((jsend->chapterb[i] == 0) && ";
  z[lc++]="	      ((i == jsend->chapterb_low) || ";
  z[lc++]="	       (i == jsend->chapterb_high)))";
  z[lc++]="	    {";
  z[lc++]="	      while (jsend->chapterb_size && ";
  z[lc++]="		     (jsend->chapterb[jsend->chapterb_low] == 0))";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterb_low++;";
  z[lc++]="		  jsend->chapterb_size--;";
  z[lc++]="		  jsend->clen--;";
  z[lc++]="		}";
  z[lc++]="	      while (jsend->chapterb_size && ";
  z[lc++]="		     (jsend->chapterb[jsend->chapterb_high] == 0))";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterb_high--;";
  z[lc++]="		  jsend->chapterb_size--;";
  z[lc++]="		  jsend->clen--;";
  z[lc++]="		}";
  z[lc++]="	      if (jsend->chapterb_size == 0)";
  z[lc++]="		{	  ";
  z[lc++]="		  jsend->chapterb_low = NSYS_SM_CN_BFMAX;";
  z[lc++]="		  jsend->chapterb_high = 1; ";
  z[lc++]="		}";
  z[lc++]="	      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="		((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="		 jsend->chapterb_high);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  /***************************/";
  z[lc++]="	  /* delete expired note log */";
  z[lc++]="	  /***************************/";
  z[lc++]="";
  z[lc++]="	  i = jsend->chaptern_logptr[ndata];";
  z[lc++]="";
  z[lc++]="	  if (jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY)";
  z[lc++]="	    jsend->chaptern_timernum--;";
  z[lc++]="	  memmove(&(jsend->chaptern[i]), ";
  z[lc++]="		  &(jsend->chaptern[i + NSYS_SM_CN_LOGSIZE]),";
  z[lc++]="		  jsend->chaptern_size - i - NSYS_SM_CN_LOGSIZE);";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptern_size < NSYS_SM_CN_SIZE)";
  z[lc++]="	    jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]--;";
  z[lc++]="	  else";
  z[lc++]="	    jsend->chapterb_high = 1; ";
  z[lc++]="";
  z[lc++]="	  jsend->chaptern_size -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  jsend->clen -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  ";
  z[lc++]="	  while (i < jsend->chaptern_size)";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chaptern_logptr[jsend->chaptern[i] & NSYS_SM_CLRS] ";
  z[lc++]="		-= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	      i += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /********************/";
  z[lc++]="  /* add new note log */";
  z[lc++]="  /********************/";
  z[lc++]="";
  z[lc++]="  jsend->chaptern[jsend->chaptern_size +";
  z[lc++]="		  NSYS_SM_CN_LOC_NUM] = ndata;";
  z[lc++]="  jsend->chaptern[jsend->chaptern_size +";
  z[lc++]="		  NSYS_SM_CN_LOC_VEL] = (vdata | NSYS_SM_CN_SETY);";
  z[lc++]="  jsend->chaptern_logptr[ndata] = jsend->chaptern_size;";
  z[lc++]="  jsend->chaptern_timernum++;";
  z[lc++]="  jsend->chaptern_size += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="  jsend->clen += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_size != NSYS_SM_CN_SIZE)";
  z[lc++]="    jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]++;";
  z[lc++]="  else";
  z[lc++]="    jsend->chapterb_high = NSYS_SM_CN_BFMIN;";
  z[lc++]="";
  z[lc++]="  jsend->chaptern_timer[ndata] = (nsys_netout_tstamp + (int)";
  z[lc++]="				  (ARATE * NSYS_SM_CN_MAXDELAY));";
  z[lc++]="  ";
  z[lc++]="  /********************************/";
  z[lc++]="  /* update channel/chapter state */";
  z[lc++]="  /********************************/";
  z[lc++]="  ";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="  jsend->chaptern_sset = 1;";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptern_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chaptern_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  if (nsys_netout_jsend_guard_ontime)";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_ontime;";
  z[lc++]="      nsys_netout_jsend_guard_next = nsys_netout_jsend_guard_mintime;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            NoteOn update for Note Extras chapter             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addnoteon_extras(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					 unsigned char ndata)";
  z[lc++]="{";
  z[lc++]="  int i, j, update, delete;";
  z[lc++]="";
  z[lc++]="  delete = update = 0;";
  z[lc++]="";
  z[lc++]="  /**********************************************/";
  z[lc++]="  /* delete old reference count for note number */";
  z[lc++]="  /**********************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterer_seqarray[ndata])";
  z[lc++]="    {";
  z[lc++]="      update = 1;";
  z[lc++]="";
  z[lc++]="      i = jsend->chapterer_logptr[ndata];";
  z[lc++]="";
  z[lc++]="      memmove(&(jsend->chaptere[i]), ";
  z[lc++]="	      &(jsend->chaptere[i + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="	      jsend->chaptere_size - i - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="";
  z[lc++]="      jsend->chapterer_seqarray[ndata] = 0;";
  z[lc++]="      jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      while (i < jsend->chaptere_size)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chaptere[i + 1] & NSYS_SM_CE_CHKV) ";
  z[lc++]="	    jsend->chapterev_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  else";
  z[lc++]="	    jsend->chapterer_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="      else";
  z[lc++]="	delete = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*******************************************/";
  z[lc++]="  /* delete release velocity for note number */";
  z[lc++]="  /*******************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterev_seqarray[ndata])";
  z[lc++]="    {";
  z[lc++]="      update = 1;";
  z[lc++]="";
  z[lc++]="      i = jsend->chapterev_logptr[ndata];";
  z[lc++]="";
  z[lc++]="      memmove(&(jsend->chaptere[i]), ";
  z[lc++]="	      &(jsend->chaptere[i + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="	      jsend->chaptere_size - i - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="";
  z[lc++]="      jsend->chapterev_seqarray[ndata] = 0;";
  z[lc++]="      jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      while (i < jsend->chaptere_size)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chaptere[i + 1] & NSYS_SM_CE_CHKV) ";
  z[lc++]="	    jsend->chapterev_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  else";
  z[lc++]="	    jsend->chapterer_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="      else";
  z[lc++]="	delete = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**************************************************/";
  z[lc++]="  /* increase reference count, add log if necessary */";
  z[lc++]="  /**************************************************/";
  z[lc++]="";
  z[lc++]="  jsend->chaptere_ref[ndata]++;";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptere_ref[ndata] > 1)";
  z[lc++]="    {";
  z[lc++]="      /***************************************/";
  z[lc++]="      /* make space for new log if necessary */";
  z[lc++]="      /***************************************/";
  z[lc++]="      ";
  z[lc++]="      if ((jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS) == 127)";
  z[lc++]="	{";
  z[lc++]="	  j = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	  while (j < jsend->chaptere_size)";
  z[lc++]="	    {";
  z[lc++]="	      i = NSYS_SM_CLRS & jsend->chaptere[j];";
  z[lc++]="	      ";
  z[lc++]="	      if (((jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS) == 127) &&";
  z[lc++]="		  (jsend->chaptere[j + 1] & NSYS_SM_CE_CHKV))";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterev_seqarray[i] = 0;";
  z[lc++]="		  memmove(&(jsend->chaptere[j]), ";
  z[lc++]="			  &(jsend->chaptere[j + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="			  jsend->chaptere_size - j - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="		  jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="		  jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="		  jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  if (jsend->chaptere[j + 1] & NSYS_SM_CE_CHKV)";
  z[lc++]="		    jsend->chapterev_logptr[i] = j;";
  z[lc++]="		  else";
  z[lc++]="		    jsend->chapterer_logptr[i] = j;";
  z[lc++]="		  j += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* initialize chapter header */";
  z[lc++]="      /*****************************/";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chaptere_seqnum)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere_size = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	  jsend->chaptere[NSYS_SM_CA_LOC_LENGTH] = 0;";
  z[lc++]="	  jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************************************/";
  z[lc++]="      /* code below is broken for counts > 127.         */";
  z[lc++]="      /* sender needs to keep track of counts > 127.    */";
  z[lc++]="      /**************************************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere_ref[ndata] > NSYS_SM_CE_MAXCOUNT)";
  z[lc++]="	jsend->chaptere_ref[ndata] = NSYS_SM_CE_MAXCOUNT;";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* add new controller log */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere_seqnum && !delete)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]++;";
  z[lc++]="     ";
  z[lc++]="      jsend->chaptere[jsend->chaptere_size + NSYS_SM_CE_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptere[jsend->chaptere_size + NSYS_SM_CE_LOC_COUNTVEL] = ";
  z[lc++]="	jsend->chaptere_ref[ndata];  /* also sets V bit to 0 */";
  z[lc++]="";
  z[lc++]="      jsend->chapterer_logptr[ndata] = jsend->chaptere_size;";
  z[lc++]="      jsend->chaptere_size += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->clen += (NSYS_SM_CE_LOGSIZE + (jsend->chaptere_seqnum ? 0 :";
  z[lc++]="					    NSYS_SM_CE_HDRSIZE));";
  z[lc++]="";
  z[lc++]="      jsend->chapterer_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="      jsend->chaptere_sset = 1;";
  z[lc++]="";
  z[lc++]="      nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="	&(jsend->chaptere[NSYS_SM_CA_LOC_LENGTH]);";
  z[lc++]="";
  z[lc++]="      nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="      nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="				      (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="      update = 1;";
  z[lc++]="      delete = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**************************/";
  z[lc++]="  /* Chapter E housekeeping */";
  z[lc++]="  /**************************/";
  z[lc++]="";
  z[lc++]="  if (update)";
  z[lc++]="    {";
  z[lc++]="      if (delete)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere_sset = 0;";
  z[lc++]="	  jsend->chaptere_seqnum = 0;";
  z[lc++]="	  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRE;";
  z[lc++]="	  jsend->clen -= NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="  	  jsend->chaptere_seqnum = nsys_netout_seqnum;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons(jsend->clen);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            NoteOff update for Note Extras chapter             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addnoteoff_extras(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata)";
  z[lc++]="{";
  z[lc++]="  int i, j, update, delete;";
  z[lc++]="";
  z[lc++]="  delete = update = 0;";
  z[lc++]="";
  z[lc++]="  /**********************************************/";
  z[lc++]="  /* delete old reference count for note number */";
  z[lc++]="  /**********************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterer_seqarray[ndata])";
  z[lc++]="    {";
  z[lc++]="      update = 1;";
  z[lc++]="";
  z[lc++]="      i = jsend->chapterer_logptr[ndata];";
  z[lc++]="";
  z[lc++]="      memmove(&(jsend->chaptere[i]), ";
  z[lc++]="	      &(jsend->chaptere[i + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="	      jsend->chaptere_size - i - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="";
  z[lc++]="      jsend->chapterer_seqarray[ndata] = 0;";
  z[lc++]="      jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      while (i < jsend->chaptere_size)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chaptere[i + 1] & NSYS_SM_CE_CHKV) ";
  z[lc++]="	    jsend->chapterev_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  else";
  z[lc++]="	    jsend->chapterer_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="      else";
  z[lc++]="	delete = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*******************************************/";
  z[lc++]="  /* delete release velocity for note number */";
  z[lc++]="  /*******************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterev_seqarray[ndata])";
  z[lc++]="    {";
  z[lc++]="      update = 1;";
  z[lc++]="";
  z[lc++]="      i = jsend->chapterev_logptr[ndata];";
  z[lc++]="";
  z[lc++]="      memmove(&(jsend->chaptere[i]), ";
  z[lc++]="	      &(jsend->chaptere[i + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="	      jsend->chaptere_size - i - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="";
  z[lc++]="      jsend->chapterev_seqarray[ndata] = 0;";
  z[lc++]="      jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      while (i < jsend->chaptere_size)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chaptere[i + 1] & NSYS_SM_CE_CHKV) ";
  z[lc++]="	    jsend->chapterev_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  else";
  z[lc++]="	    jsend->chapterer_logptr[jsend->chaptere[i] & NSYS_SM_CLRS] ";
  z[lc++]="	      -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="      else";
  z[lc++]="	delete = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**************************************************/";
  z[lc++]="  /* decrease reference count, add log if necessary */";
  z[lc++]="  /**************************************************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptere_ref[ndata])";
  z[lc++]="    jsend->chaptere_ref[ndata]--;";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptere_ref[ndata] > 1)";
  z[lc++]="    {";
  z[lc++]="      /***************************************/";
  z[lc++]="      /* make space for new log if necessary */";
  z[lc++]="      /***************************************/";
  z[lc++]="      ";
  z[lc++]="      if ((jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS) == 127)";
  z[lc++]="	{";
  z[lc++]="	  j = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	  while (j < jsend->chaptere_size)";
  z[lc++]="	    {";
  z[lc++]="	      i = NSYS_SM_CLRS & jsend->chaptere[j];";
  z[lc++]="	      ";
  z[lc++]="	      if (((jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS) == 127) &&";
  z[lc++]="		  (jsend->chaptere[j + 1] & NSYS_SM_CE_CHKV))";
  z[lc++]="		{";
  z[lc++]="		  jsend->chapterev_seqarray[i] = 0;";
  z[lc++]="		  memmove(&(jsend->chaptere[j]), ";
  z[lc++]="			  &(jsend->chaptere[j + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="			  jsend->chaptere_size - j - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="		  jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="		  jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="		  jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  if (jsend->chaptere[j + 1] & NSYS_SM_CE_CHKV)";
  z[lc++]="		    jsend->chapterev_logptr[i] = j;";
  z[lc++]="		  else";
  z[lc++]="		    jsend->chapterer_logptr[i] = j;";
  z[lc++]="		  j += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* initialize chapter header */";
  z[lc++]="      /*****************************/";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chaptere_seqnum)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere_size = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	  jsend->chaptere[NSYS_SM_CA_LOC_LENGTH] = 0;";
  z[lc++]="	  jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************************************/";
  z[lc++]="      /* code below is broken for counts > 127.         */";
  z[lc++]="      /* sender needs to keep track of counts > 127.    */";
  z[lc++]="      /**************************************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere_ref[ndata] > NSYS_SM_CE_MAXCOUNT)";
  z[lc++]="	jsend->chaptere_ref[ndata] = NSYS_SM_CE_MAXCOUNT;";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* add new controller log */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere_seqnum && !delete)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]++;";
  z[lc++]="     ";
  z[lc++]="      jsend->chaptere[jsend->chaptere_size + NSYS_SM_CE_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptere[jsend->chaptere_size + NSYS_SM_CE_LOC_COUNTVEL] = ";
  z[lc++]="	jsend->chaptere_ref[ndata];  /* also sets V bit to 0 */";
  z[lc++]="";
  z[lc++]="      jsend->chapterer_logptr[ndata] = jsend->chaptere_size;";
  z[lc++]="      jsend->chaptere_size += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->clen += (NSYS_SM_CE_LOGSIZE + (jsend->chaptere_seqnum ? 0 :";
  z[lc++]="					    NSYS_SM_CE_HDRSIZE));";
  z[lc++]="";
  z[lc++]="      jsend->chapterer_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="      jsend->chaptere_sset = 1;";
  z[lc++]="";
  z[lc++]="      nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="	&(jsend->chaptere[NSYS_SM_CA_LOC_LENGTH]);";
  z[lc++]="	";
  z[lc++]="      nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="      nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="				      (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="      update = 1;";
  z[lc++]="      delete = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /***************************************************************/";
  z[lc++]="  /* add release velocity log if necessary, and if there is room */";
  z[lc++]="  /***************************************************************/";
  z[lc++]="";
  z[lc++]="  if ((vdata != NSYS_SM_CE_DEFREL) && ";
  z[lc++]="      ((jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS) < 127))";
  z[lc++]="    {";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* initialize chapter header */";
  z[lc++]="      /*****************************/";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chaptere_seqnum)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere[NSYS_SM_CE_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere_size = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	  jsend->chaptere[NSYS_SM_CA_LOC_LENGTH] = 0;";
  z[lc++]="	  jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* add new controller log */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptere_seqnum && !delete)";
  z[lc++]="	jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]++;";
  z[lc++]="     ";
  z[lc++]="      jsend->chaptere[jsend->chaptere_size + NSYS_SM_CE_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptere[jsend->chaptere_size + NSYS_SM_CE_LOC_COUNTVEL] = ";
  z[lc++]="	vdata | NSYS_SM_CE_SETV;";
  z[lc++]="";
  z[lc++]="      jsend->chapterev_logptr[ndata] = jsend->chaptere_size;";
  z[lc++]="      jsend->chaptere_size += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      jsend->clen += (NSYS_SM_CE_LOGSIZE + (jsend->chaptere_seqnum ? 0 :";
  z[lc++]="					    NSYS_SM_CE_HDRSIZE));";
  z[lc++]="";
  z[lc++]="      jsend->chapterev_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="      jsend->chaptere_sset = 1;";
  z[lc++]="";
  z[lc++]="      nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="	&(jsend->chaptere[NSYS_SM_CA_LOC_LENGTH]);";
  z[lc++]="      ";
  z[lc++]="      nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="      nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="				      (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="      update = 1;";
  z[lc++]="      delete = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**************************/";
  z[lc++]="  /* Chapter E housekeeping */";
  z[lc++]="  /**************************/";
  z[lc++]="";
  z[lc++]="  if (update)";
  z[lc++]="    {";
  z[lc++]="      if (delete)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptere_sset = 0;";
  z[lc++]="	  jsend->chaptere_seqnum = 0;";
  z[lc++]="	  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRE;";
  z[lc++]="	  jsend->clen -= NSYS_SM_CE_HDRSIZE;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="  	  jsend->chaptere_seqnum = nsys_netout_seqnum;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons(jsend->clen);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI Channel Touch chapter              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addctouch(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				 unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  jsend->chaptert[NSYS_SM_CT_LOC_PRESSURE] = ndata;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chaptert[NSYS_SM_CT_LOC_PRESSURE]);";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptert_seqnum)";
  z[lc++]="    jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETT;";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons((jsend->clen += NSYS_SM_CT_SIZE));";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptert_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI Poly Touch chapter                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addptouch(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /*****************************/";
  z[lc++]="  /* initialize chapter header */";
  z[lc++]="  /*****************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptera_seqnum)";
  z[lc++]="    jsend->chaptera[NSYS_SM_CA_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptera_size = NSYS_SM_CA_HDRSIZE;";
  z[lc++]="      jsend->chaptera[NSYS_SM_CA_LOC_LENGTH] = 0;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETA;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptera_seqarray[ndata])";
  z[lc++]="    {";
  z[lc++]="      /**********************/";
  z[lc++]="      /* remove expired log */";
  z[lc++]="      /**********************/";
  z[lc++]="";
  z[lc++]="      i = jsend->chaptera_logptr[ndata];";
  z[lc++]="";
  z[lc++]="      memmove(&(jsend->chaptera[i]), ";
  z[lc++]="	      &(jsend->chaptera[i + NSYS_SM_CA_LOGSIZE]),";
  z[lc++]="	      jsend->chaptera_size - i - NSYS_SM_CA_LOGSIZE);";
  z[lc++]="";
  z[lc++]="      jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]--;";
  z[lc++]="      jsend->chaptera_size -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="      jsend->clen -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="";
  z[lc++]="      while (i < jsend->chaptera_size)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptera_logptr[jsend->chaptera[i] & NSYS_SM_CLRS] ";
  z[lc++]="	    -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /************************/";
  z[lc++]="  /* add new pressure log */";
  z[lc++]="  /************************/";
  z[lc++]="  ";
  z[lc++]="  /* put data in chapter a and update state variables */";
  z[lc++]="      ";
  z[lc++]="  if (jsend->chaptera_seqnum)";
  z[lc++]="    jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]++;";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptera[jsend->chaptera_size + ";
  z[lc++]="		  NSYS_SM_CA_LOC_NUM] = ndata;";
  z[lc++]="  jsend->chaptera[jsend->chaptera_size + ";
  z[lc++]="		  NSYS_SM_CA_LOC_PRESSURE] = vdata;";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptera_logptr[ndata] = jsend->chaptera_size;";
  z[lc++]="  jsend->chaptera_size += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="  ";
  z[lc++]="  jsend->clen += (NSYS_SM_CA_LOGSIZE + (jsend->chaptera_seqnum ? 0 :";
  z[lc++]="					NSYS_SM_CA_HDRSIZE));";
  z[lc++]="  ";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="  ";
  z[lc++]="  /*****************/";
  z[lc++]="  /* update slists */";
  z[lc++]="  /*****************/";
  z[lc++]="  ";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]);";
  z[lc++]="  jsend->chaptera_sset = 1;";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptera_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chaptera_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              add Reset to System Simple chapter              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addreset()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  nsys_netout_journal_clear_active(CSYS_MIDI_SYSTEM_RESET);";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_reset++;";
  z[lc++]="  jsys->chapterd_reset &= NSYS_SM_CLRS;";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS] = jsys->chapterd_reset;";
  z[lc++]="";
  z[lc++]="  if (!(jsys->chapterd_reset_seqnum))";
  z[lc++]="    {";
  z[lc++]="      p = &(jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS]);";
  z[lc++]="      if (jsys->chapterd_tune_seqnum)";
  z[lc++]="	(*(++p)) = jsys->chapterd_tune;";
  z[lc++]="      if (jsys->chapterd_song_seqnum)";
  z[lc++]="	(*(++p)) = jsys->chapterd_song;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterd_front[NSYS_SM_CD_LOC_TOC]);";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_seqnum && jsys->chapterd_reset_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CLRS;";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK | NSYS_SM_SETS);";
  z[lc++]="";
  z[lc++]="      if (!(jsys->chapterd_seqnum))";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETD;";
  z[lc++]="	  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] = 0;";
  z[lc++]="	  jsys->slen += NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	  jsys->chapterd_front_size = NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] |= NSYS_SM_CD_TOC_SETB;";
  z[lc++]="      jsys->chapterd_front_size += NSYS_SM_CD_SIZE_RESET;";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += NSYS_SM_CD_SIZE_RESET) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= (unsigned char)(jsys->slen >> 8);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = nsys_netout_seqnum;";
  z[lc++]="  jsys->chapterd_reset_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           add Tune Request to System Simple chapter          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addtune()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_tune++;";
  z[lc++]="  jsys->chapterd_tune &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  p = &(jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_reset_seqnum)";
  z[lc++]="    p++;";
  z[lc++]="";
  z[lc++]="  *p = jsys->chapterd_tune;";
  z[lc++]="";
  z[lc++]="  if (!(jsys->chapterd_tune_seqnum) && (jsys->chapterd_song_seqnum))";
  z[lc++]="    *(p + 1) = jsys->chapterd_song;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterd_front[NSYS_SM_CD_LOC_TOC]);";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = p;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_seqnum && jsys->chapterd_tune_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CLRS;";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK | NSYS_SM_SETS);";
  z[lc++]="";
  z[lc++]="      if (!(jsys->chapterd_seqnum))";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETD;";
  z[lc++]="	  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] = 0;";
  z[lc++]="	  jsys->slen += NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	  jsys->chapterd_front_size = NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] |= NSYS_SM_CD_TOC_SETG;";
  z[lc++]="      jsys->chapterd_front_size += NSYS_SM_CD_SIZE_TUNE;";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += NSYS_SM_CD_SIZE_TUNE) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= (unsigned char)(jsys->slen >> 8);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = nsys_netout_seqnum;";
  z[lc++]="  jsys->chapterd_tune_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           add Song Select to System Simple chapter           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addsong(unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_song = (ndata & NSYS_SM_CLRS);";
  z[lc++]="";
  z[lc++]="  p = &(jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_reset_seqnum)";
  z[lc++]="    p++;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_tune_seqnum)";
  z[lc++]="    p++;";
  z[lc++]="";
  z[lc++]="  (*p) = jsys->chapterd_song;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterd_front[NSYS_SM_CD_LOC_TOC]);";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = p;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_seqnum && jsys->chapterd_song_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CLRS;";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK | NSYS_SM_SETS);";
  z[lc++]="";
  z[lc++]="      if (!(jsys->chapterd_seqnum))";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETD;";
  z[lc++]="	  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] = 0;";
  z[lc++]="	  jsys->slen += NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	  jsys->chapterd_front_size = NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] |= NSYS_SM_CD_TOC_SETH;";
  z[lc++]="      jsys->chapterd_front_size += NSYS_SM_CD_SIZE_SONG;";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += NSYS_SM_CD_SIZE_SONG) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= (unsigned char)(jsys->slen >> 8);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = nsys_netout_seqnum;";
  z[lc++]="  jsys->chapterd_song_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      add undefined System Common to System Simple chapter    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addsc(unsigned char cmd, ";
  z[lc++]="			       unsigned char ndata,";
  z[lc++]="			       unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned long sc_seqnum;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="  unsigned char dsize;";
  z[lc++]="  int delta;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  ";
  z[lc++]="  dsize = ((ndata != CSYS_MIDI_SYSTEM_SYSEX_END) +";
  z[lc++]="	   (vdata != CSYS_MIDI_SYSTEM_SYSEX_END));";
  z[lc++]="";
  z[lc++]="  p = (cmd == CSYS_MIDI_SYSTEM_UNUSED1) ? jsys->chapterd_scj : jsys->chapterd_sck;";
  z[lc++]="";
  z[lc++]="  /* line below sets LENGTH MSBs to 0, as desired */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_SM_CD_COMMON_LOC_TOC] = ((dsize << 2) | NSYS_SM_CD_COMMON_TOC_SETC |";
  z[lc++]="				  (dsize ? NSYS_SM_CD_COMMON_TOC_SETV : 0));";
  z[lc++]="  ";
  z[lc++]="  delta = (NSYS_SM_CD_COMMON_TOC_SIZE + NSYS_SM_CD_COMMON_LENGTH_SIZE +";
  z[lc++]="	   NSYS_SM_CD_COMMON_COUNT_SIZE + dsize);";
  z[lc++]="";
  z[lc++]="  p[NSYS_SM_CD_COMMON_LOC_LENGTH] = delta;  /* MSBs set to 0 above */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_SM_CD_COMMON_LOC_FIELDS]++;      /* increment COUNT */";
  z[lc++]="";
  z[lc++]="  if (ndata != CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="    {";
  z[lc++]="      if (vdata != CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	p[NSYS_SM_CD_COMMON_LOC_FIELDS + 1] = ndata;";
  z[lc++]="      else";
  z[lc++]="      	p[NSYS_SM_CD_COMMON_LOC_FIELDS + 1] = ndata | NSYS_SM_CX_DATA_SETEND;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (vdata != CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="    p[NSYS_SM_CD_COMMON_LOC_FIELDS + 2] = vdata | NSYS_SM_CX_DATA_SETEND;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterd_front[NSYS_SM_CD_LOC_TOC]);";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(p[NSYS_SM_CD_COMMON_LOC_TOC]);";
  z[lc++]="";
  z[lc++]="  sc_seqnum = ((cmd == CSYS_MIDI_SYSTEM_UNUSED1) ? ";
  z[lc++]="	       jsys->chapterd_scj_seqnum : jsys->chapterd_sck_seqnum);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_seqnum && sc_seqnum)";
  z[lc++]="    {";
  z[lc++]="      delta -= ((cmd == CSYS_MIDI_SYSTEM_UNUSED1) ? ";
  z[lc++]="		jsys->chapterd_scj_size : jsys->chapterd_sck_size);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (!(jsys->chapterd_seqnum))";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETD;";
  z[lc++]="	  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] = 0;";
  z[lc++]="	  jsys->slen += NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	  jsys->chapterd_front_size = NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] |= ";
  z[lc++]="	(cmd == CSYS_MIDI_SYSTEM_UNUSED1) ? NSYS_SM_CD_TOC_SETJ : NSYS_SM_CD_TOC_SETK;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (delta)";
  z[lc++]="    {";
  z[lc++]="      if (cmd == CSYS_MIDI_SYSTEM_UNUSED1)";
  z[lc++]="	jsys->chapterd_scj_size = p[NSYS_SM_CD_COMMON_LOC_LENGTH];";
  z[lc++]="      else";
  z[lc++]="	jsys->chapterd_sck_size = p[NSYS_SM_CD_COMMON_LOC_LENGTH];";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += delta) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= (unsigned char)(jsys->slen >> 8);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CLRS;";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  if (cmd == CSYS_MIDI_SYSTEM_UNUSED1)";
  z[lc++]="    jsys->chapterd_scj_seqnum = nsys_netout_seqnum;";
  z[lc++]="  else";
  z[lc++]="    jsys->chapterd_sck_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         add undefined RealTime to System Simple chapter      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addrt(unsigned char cmd)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned long rt_seqnum;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  p = (cmd == CSYS_MIDI_SYSTEM_TICK) ? jsys->chapterd_rty : jsys->chapterd_rtz;";
  z[lc++]="  rt_seqnum = ((cmd == CSYS_MIDI_SYSTEM_TICK) ? ";
  z[lc++]="	       jsys->chapterd_rty_seqnum : jsys->chapterd_rtz_seqnum);";
  z[lc++]="";
  z[lc++]="  if (!rt_seqnum)";
  z[lc++]="    p[NSYS_SM_CD_REALTIME_LOC_TOC] = ";
  z[lc++]="      (NSYS_SM_CD_REALTIME_TOC_SETC | NSYS_SM_CD_REALTIME_SIZE);";
  z[lc++]="";
  z[lc++]="  p[NSYS_SM_CD_REALTIME_LOC_TOC] &= NSYS_SM_CLRS; ";
  z[lc++]="  p[NSYS_SM_CD_REALTIME_LOC_FIELDS]++;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterd_front[NSYS_SM_CD_LOC_TOC]);";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(p[NSYS_SM_CD_REALTIME_LOC_TOC]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_seqnum && rt_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CLRS;";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK | NSYS_SM_SETS);";
  z[lc++]="";
  z[lc++]="      if (!(jsys->chapterd_seqnum))";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETD;";
  z[lc++]="	  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] = 0;";
  z[lc++]="	  jsys->slen += NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	  jsys->chapterd_front_size = NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] |= ";
  z[lc++]="	(cmd == CSYS_MIDI_SYSTEM_TICK) ? NSYS_SM_CD_TOC_SETY : NSYS_SM_CD_TOC_SETZ;";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += NSYS_SM_CD_REALTIME_SIZE) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= (unsigned char)(jsys->slen >> 8);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  if (cmd == CSYS_MIDI_SYSTEM_TICK)";
  z[lc++]="    jsys->chapterd_rty_seqnum = nsys_netout_seqnum;";
  z[lc++]="  else";
  z[lc++]="    jsys->chapterd_rtz_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add System Active Sense chapter             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addsense()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterv[NSYS_SM_CV_LOC_COUNT]++;";
  z[lc++]="  jsys->chapterv[NSYS_SM_CV_LOC_COUNT] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterv[NSYS_SM_CV_LOC_COUNT]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterv_seqnum)";
  z[lc++]="    jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK |";
  z[lc++]="					       NSYS_SM_SETS);";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += NSYS_SM_CV_SIZE) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETV;";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= ";
  z[lc++]="	    (NSYS_SM_SH_SETV | ((unsigned char)(jsys->slen >> 8)));";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterv_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            add command to System sequencer chapter           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addsequence(unsigned char cmd, unsigned char ndata,";
  z[lc++]="				     unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  long song_pp, slen_update;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  slen_update = 0;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterq[NSYS_SM_CQ_LOC_HDR]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterq_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      if (jsys->chapterq_size == 0)";
  z[lc++]="	jsys->chapterq_size = NSYS_SM_CQ_SIZE_HDR;";
  z[lc++]="      jsys->slen += jsys->chapterq_size;";
  z[lc++]="      slen_update = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  /* caller pre-filters stopped CLOCKs, redundant CONTINUE and STOPs */";
  z[lc++]="";
  z[lc++]="  switch (cmd) {";
  z[lc++]="  case CSYS_MIDI_SYSTEM_CLOCK:  ";
  z[lc++]="    if (!(jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKD))";
  z[lc++]="      jsys->chapterq[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETD;";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	if (!(jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	  {";
  z[lc++]="	    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETC;";
  z[lc++]="	    jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS + 1] = 0;";
  z[lc++]="	    jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS] = 0;";
  z[lc++]="	    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	    jsys->chapterq_size += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	    jsys->slen += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	    slen_update = 1;";
  z[lc++]="	  }";
  z[lc++]="	if (!(++(jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS + 1])))";
  z[lc++]="	  if (!(++(jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS])))";
  z[lc++]="	    {";
  z[lc++]="	      if ((jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_TOP_MASK) !=";
  z[lc++]="		  NSYS_SM_CQ_TOP_MASK)";
  z[lc++]="		jsys->chapterq[NSYS_SM_CQ_LOC_HDR]++;";
  z[lc++]="	      else";
  z[lc++]="		jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	    }";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_SYSTEM_START:";
  z[lc++]="    if ((jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="      {";
  z[lc++]="	jsys->chapterq_size -= NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	jsys->slen -= NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	slen_update = 1;";
  z[lc++]="      }";
  z[lc++]="    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] = NSYS_SM_CQ_HDR_SETN;  /* C = D = 0 */";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_SYSTEM_CONTINUE:";
  z[lc++]="    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETN;";
  z[lc++]="    if (!(jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="      {";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETC;";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS + 1] = 0;";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS] = 0;";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	jsys->chapterq_size += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	jsys->slen += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	slen_update = 1;";
  z[lc++]="      }";
  z[lc++]="    if (jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKD)";
  z[lc++]="      {";
  z[lc++]="	if (!(++(jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS + 1])))";
  z[lc++]="	  if (!(++(jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS])))";
  z[lc++]="	    {";
  z[lc++]="	      if ((jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_TOP_MASK) !=";
  z[lc++]="		  NSYS_SM_CQ_TOP_MASK)";
  z[lc++]="		jsys->chapterq[NSYS_SM_CQ_LOC_HDR]++;";
  z[lc++]="	      else";
  z[lc++]="		jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	    }";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRD;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_SYSTEM_STOP:";
  z[lc++]="    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRN;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_SYSTEM_SONG_PP:";
  z[lc++]="    if ((song_pp = 6*((vdata << 7) + ndata)))";
  z[lc++]="      {";
  z[lc++]="	if (!(jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	  {";
  z[lc++]="	    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETC;";
  z[lc++]="	    jsys->chapterq_size += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	    jsys->slen += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	    slen_update = 1;";
  z[lc++]="	  }";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS + 1] = ";
  z[lc++]="	  (unsigned char) (song_pp & 0x000000FF);";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_FIELDS] = ";
  z[lc++]="	  (unsigned char) ((song_pp >> 8) & 0x000000FF);";
  z[lc++]="	jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	if (song_pp > NSYS_SM_CQ_BOTTOM_MASK)";
  z[lc++]="	  jsys->chapterq[NSYS_SM_CQ_LOC_HDR] |= 0x01;  /* song_pp range limit */";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	if ((jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	  {";
  z[lc++]="	    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRC;";
  z[lc++]="	    jsys->chapterq_size -= NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	    jsys->slen -= NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="	    slen_update = 1;";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="    jsys->chapterq[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRD;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (slen_update)";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK);";
  z[lc++]="      if (jsys->slen <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] =";
  z[lc++]="	    (unsigned char)(jsys->slen & NSYS_SM_SH_LSBMASK);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= ";
  z[lc++]="	    (unsigned char)((jsys->slen >> 8) & NSYS_SM_SH_MSBMASK);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterq_seqnum == 0)";
  z[lc++]="    jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETQ;";
  z[lc++]="";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  jsys->chapterq_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         add command to System MIDI Time Code chapter         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addtimecode(unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned char point, idnum, direction, partial, complete;";
  z[lc++]="  unsigned char frames, seconds, minutes, hours, type, typeframe;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="  int slen_update;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  slen_update = 0;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->chapterf[NSYS_SM_CF_LOC_HDR]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterf_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      if (jsys->chapterf_size == 0)";
  z[lc++]="	jsys->chapterf_size = NSYS_SM_CF_SIZE_HDR;";
  z[lc++]="      jsys->slen += jsys->chapterf_size;";
  z[lc++]="      slen_update = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  point = jsys->chapterf_point;";
  z[lc++]="  jsys->chapterf_point = idnum = (ndata & NSYS_SM_CF_IDNUM_MASK) >> 4;";
  z[lc++]="";
  z[lc++]="  complete = jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC;";
  z[lc++]="  partial = jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP;";
  z[lc++]="  direction = jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKD;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    /* handle QF commands with expected idnums */";
  z[lc++]="";
  z[lc++]="    if ((!direction && (((point + 1) & NSYS_SM_CF_POINT_MASK) == idnum)) ||";
  z[lc++]="	(direction && (((point - 1) & NSYS_SM_CF_POINT_MASK) == idnum)))";
  z[lc++]="      {";
  z[lc++]="	switch (idnum) {               	     ";
  z[lc++]="	case NSYS_SM_CF_IDNUM_FR_LSN:";
  z[lc++]="	case NSYS_SM_CF_IDNUM_HR_MSN:";
  z[lc++]="	  if ((direction && (idnum == NSYS_SM_CF_IDNUM_FR_LSN)) ||";
  z[lc++]="	      (!direction && (idnum == NSYS_SM_CF_IDNUM_HR_MSN)))";
  z[lc++]="	    {";
  z[lc++]="	      /* handle QF commands that end the frame */";
  z[lc++]="";
  z[lc++]="	      if (partial)";
  z[lc++]="		{";
  z[lc++]="		  jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_POINT_CLR;";
  z[lc++]="		  jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= idnum;";
  z[lc++]="		  jsys->chapterfc_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="		  jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRP;";
  z[lc++]="		  jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= ";
  z[lc++]="		    (NSYS_SM_CF_HDR_SETC | NSYS_SM_CF_HDR_SETQ);";
  z[lc++]="";
  z[lc++]="		  /* the old partial becomes the new complete */";
  z[lc++]="";
  z[lc++]="		  if (complete)";
  z[lc++]="		    {";
  z[lc++]="		      memcpy(&(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]),";
  z[lc++]="			     &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + ";
  z[lc++]="					      NSYS_SM_CF_SIZE_COMPLETE]),";
  z[lc++]="			     NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="		      ";
  z[lc++]="		      jsys->chapterf_size -= NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="		      jsys->slen -= NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="		      slen_update = 1;";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /* write the new complete's MT0 or MT7 */";
  z[lc++]="";
  z[lc++]="		  if (!direction)";
  z[lc++]="		    {";
  z[lc++]="		      p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + ";
  z[lc++]="					   NSYS_SM_CF_QF_LOC_HR_MSN]);";
  z[lc++]="		      (*p) &= NSYS_SM_CF_ODD_CLR;";
  z[lc++]="		      (*p) |= (ndata & NSYS_SM_CF_PAYLOAD_MASK);";
  z[lc++]="		    }";
  z[lc++]="		  else";
  z[lc++]="		    {";
  z[lc++]="		      p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + ";
  z[lc++]="					   NSYS_SM_CF_QF_LOC_FR_LSN]);";
  z[lc++]="		      (*p) &= NSYS_SM_CF_EVEN_CLR;";
  z[lc++]="		      (*p) |= (ndata << 4);";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /* for forward tape, adjust complete by two frames */";
  z[lc++]="	      ";
  z[lc++]="		  if (!direction)";
  z[lc++]="		    {";
  z[lc++]="		      p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]);";
  z[lc++]="		      ";
  z[lc++]="		      frames = ((p[0] >> 4) & 0x0F) + ((p[0] & 0x01) << 4);";
  z[lc++]="		      if ((type = p[3] & 0x06))";
  z[lc++]="			typeframe = (type == 2) ? 25 : 30;";
  z[lc++]="		      else";
  z[lc++]="			typeframe = 24;";
  z[lc++]="		      ";
  z[lc++]="		      if ((frames += 2) >= typeframe)";
  z[lc++]="			{";
  z[lc++]="			  frames -= typeframe;";
  z[lc++]="			  seconds = ((p[1] >> 4) & 0x0F) + ((p[1] & 0x03) << 4);";
  z[lc++]="			  if ((++seconds) >= 60)";
  z[lc++]="			    {";
  z[lc++]="			      seconds -= 60;";
  z[lc++]="			      minutes = ((p[2] >> 4) & 0x0F) + ((p[2] & 0x03) << 4);";
  z[lc++]="			      if ((++minutes) >= 60)";
  z[lc++]="				{";
  z[lc++]="				  minutes -= 60;";
  z[lc++]="				  hours = ((p[3] >> 4) & 0x0F) + ((p[3] & 0x01) << 4);";
  z[lc++]="				  if ((++hours) >= 24)";
  z[lc++]="				    hours -= 24;";
  z[lc++]="				  p[3] = ((0x0F & hours) << 4)  | (hours >> 4) | type;";
  z[lc++]="				}";
  z[lc++]="			      p[2] = ((0x0F & minutes) << 4) | (minutes >> 4);";
  z[lc++]="			    }";
  z[lc++]="			  p[1] = ((0x0F & seconds) << 4) | (seconds >> 4);";
  z[lc++]="			}";
  z[lc++]="		      p[0] = ((0x0F & frames) << 4)  | (frames >> 4);";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		}";
  z[lc++]="	      break;      /* from switch, for logic for ending a frame */";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /* handle QF commands that start a frame: make partial space, fall through */";
  z[lc++]="";
  z[lc++]="	  if (!partial)";
  z[lc++]="	    {";
  z[lc++]="	      if (complete)";
  z[lc++]="		p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]);";
  z[lc++]="	      else";
  z[lc++]="		p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]);";
  z[lc++]="	      memset(p, 0, NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="";
  z[lc++]="	      jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= NSYS_SM_CF_HDR_SETP;";
  z[lc++]="	      jsys->chapterf_size += NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="	      jsys->slen += NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="	      partial = slen_update = 1;";
  z[lc++]="	    }";
  z[lc++]="	default:    /* handle all expected non-frame-ending MT values */";
  z[lc++]="	  if (partial)";
  z[lc++]="	    {";
  z[lc++]="	      jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_POINT_CLR;";
  z[lc++]="	      jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= idnum;";
  z[lc++]="";
  z[lc++]="	      if (complete)";
  z[lc++]="		p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + ";
  z[lc++]="				     NSYS_SM_CF_SIZE_COMPLETE + (idnum >> 1)]);";
  z[lc++]="	      else";
  z[lc++]="		p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + (idnum >> 1)]);";
  z[lc++]="";
  z[lc++]="	      if (idnum & 0x01)";
  z[lc++]="		{";
  z[lc++]="		  (*p) &= NSYS_SM_CF_ODD_CLR;";
  z[lc++]="		  (*p) |= (ndata & NSYS_SM_CF_PAYLOAD_MASK);";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  (*p) &= NSYS_SM_CF_EVEN_CLR;";
  z[lc++]="		  (*p) |= (ndata << 4);";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="	break;   /* from do/while, for QF commands with expected values */";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    /* next, handle tape direction change that happens in a legal way */";
  z[lc++]="";
  z[lc++]="    if ((idnum == NSYS_SM_CF_IDNUM_FR_LSN) || (idnum == NSYS_SM_CF_IDNUM_HR_MSN))";
  z[lc++]="      {";
  z[lc++]="	jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_POINT_CLR;";
  z[lc++]="	jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= idnum;";
  z[lc++]="";
  z[lc++]="	if (idnum == NSYS_SM_CF_IDNUM_FR_LSN)";
  z[lc++]="	  jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRD;";
  z[lc++]="	else";
  z[lc++]="	  jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= NSYS_SM_CF_HDR_SETD;";
  z[lc++]="";
  z[lc++]="	if (!partial)";
  z[lc++]="	  {";
  z[lc++]="	    jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= NSYS_SM_CF_HDR_SETP;";
  z[lc++]="	    jsys->chapterf_size += NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="	    jsys->slen += NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="	    slen_update = 1;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	if (complete)";
  z[lc++]="	  p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]);";
  z[lc++]="	else";
  z[lc++]="	  p = &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]);";
  z[lc++]="";
  z[lc++]="	memset(p, 0, NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="";
  z[lc++]="	if (idnum == NSYS_SM_CF_IDNUM_FR_LSN)";
  z[lc++]="	  {";
  z[lc++]="	    (*p) &= NSYS_SM_CF_EVEN_CLR;";
  z[lc++]="	    (*p) |= (ndata << 4);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    p += (NSYS_SM_CF_SIZE_PARTIAL - 1);";
  z[lc++]="	    (*p) &= NSYS_SM_CF_ODD_CLR;";
  z[lc++]="	    (*p) |= (ndata & NSYS_SM_CF_PAYLOAD_MASK);";
  z[lc++]="	  }	";
  z[lc++]="";
  z[lc++]="	break;  /* from do/while, for tape movement reset */";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    /* handle \"wrong direction guess\" for an earlier unexpected QF command */";
  z[lc++]="";
  z[lc++]="    if (!direction && (((point - 1) & NSYS_SM_CF_POINT_MASK) == idnum))";
  z[lc++]="      {";
  z[lc++]="	jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_POINT_CLR;";
  z[lc++]="	jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= NSYS_SM_CF_HDR_SETD;";
  z[lc++]="	break;  /* from do/while */";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    /* handle unexpected QF commands */";
  z[lc++]="";
  z[lc++]="    jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRD;";
  z[lc++]="";
  z[lc++]="    if (partial)";
  z[lc++]="      {";
  z[lc++]="	jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRP;";
  z[lc++]="	jsys->chapterf[NSYS_SM_CF_LOC_HDR] |= NSYS_SM_CF_POINT_MASK;";
  z[lc++]="	jsys->chapterf_size -= NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="	jsys->slen -= NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="	slen_update = 1;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  } while (0);";
  z[lc++]="";
  z[lc++]="  /* housekeeping before exit */";
  z[lc++]="  ";
  z[lc++]="  if (slen_update)";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK);";
  z[lc++]="      if (jsys->slen <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] =";
  z[lc++]="	    (unsigned char)(jsys->slen & NSYS_SM_SH_LSBMASK);";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= ";
  z[lc++]="	    (unsigned char)((jsys->slen >> 8) & NSYS_SM_SH_MSBMASK);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterf_seqnum == 0)";
  z[lc++]="    jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETF;";
  z[lc++]="";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  jsys->chapterf_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           add command to System Exclusive chapter            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addsysex(unsigned char cmd, ";
  z[lc++]="				  unsigned char ndata, ";
  z[lc++]="				  unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  nsys_netout_jsend_xstack_element * eptr;";
  z[lc++]="  int sincr, i;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  if ((cmd != CSYS_MIDI_GMRESET) && (cmd != CSYS_MIDI_MVOLUME))";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_SETS;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (cmd == CSYS_MIDI_GMRESET) ";
  z[lc++]="    nsys_netout_journal_clear_active(cmd);";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  sincr = 0;";
  z[lc++]="";
  z[lc++]="  if (jsys->sheader_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netout_jsend_channel_size)";
  z[lc++]="	nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_JH_SETY;";
  z[lc++]="      else";
  z[lc++]="	nsys_netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] = NSYS_SM_JH_SETY;";
  z[lc++]="      ";
  z[lc++]="      jsys->slen = NSYS_SM_SH_SIZE;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  jsys->sheader_seqnum = nsys_netout_seqnum;";
  z[lc++]="  nsys_netout_jsend_slist[nsys_netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsys->sheader[NSYS_SM_SH_LOC_FLAGS]);";
  z[lc++]="";
  z[lc++]="  switch (cmd) {";
  z[lc++]="  case CSYS_MIDI_GMRESET:";
  z[lc++]="    if (ndata == NSYS_SM_CX_GMRESET_ONVAL)";
  z[lc++]="      eptr = jsys->chapterx_gmreset_on;";
  z[lc++]="    else";
  z[lc++]="      eptr = jsys->chapterx_gmreset_off;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_MVOLUME:";
  z[lc++]="    eptr = jsys->chapterx_mvolume;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    eptr = NULL;  /* should never execute -- gcc warning supression */";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (eptr)       /* move existing recency log to the top of the stack */";
  z[lc++]="    {";
  z[lc++]="      if (eptr->index != jsys->chapterx_stacklen - 1)";
  z[lc++]="	{";
  z[lc++]="	  for (i = eptr->index + 1; i < jsys->chapterx_stacklen; i++)";
  z[lc++]="	    {";
  z[lc++]="	      jsys->chapterx_stack[i]->index = i - 1;";
  z[lc++]="	      jsys->chapterx_stack[i - 1] = jsys->chapterx_stack[i];";
  z[lc++]="	    }";
  z[lc++]="	  jsys->chapterx_stack[i - 1] = eptr;";
  z[lc++]="	  eptr->index = i - 1;";
  z[lc++]="	}";
  z[lc++]="      eptr->log[0] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  else         /* add a new recency log to the top of the stack */";
  z[lc++]="    {";
  z[lc++]="      eptr = nsys_netout_jsend_xstackfree;";
  z[lc++]="      nsys_netout_jsend_xstackfree = nsys_netout_jsend_xstackfree->next;";
  z[lc++]="      eptr->index = jsys->chapterx_stacklen;";
  z[lc++]="      eptr->next = NULL;";
  z[lc++]="";
  z[lc++]="      switch (cmd) {";
  z[lc++]="      case CSYS_MIDI_GMRESET:";
  z[lc++]="	if (ndata == NSYS_SM_CX_GMRESET_ONVAL)";
  z[lc++]="	  {";
  z[lc++]="	    jsys->chapterx_gmreset_on = eptr;";
  z[lc++]="	    eptr->cmdptr = &(jsys->chapterx_gmreset_on);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    jsys->chapterx_gmreset_off = eptr;";
  z[lc++]="	    eptr->cmdptr = &(jsys->chapterx_gmreset_off);";
  z[lc++]="	  }";
  z[lc++]="	sincr = eptr->size = NSYS_SM_CX_SIZE_GMRESET;";
  z[lc++]="	eptr->log[0] = (NSYS_SM_CX_HDR_SETT | NSYS_SM_CX_HDR_SETD |";
  z[lc++]="			NSYS_SM_CX_STA_NORMAL);";
  z[lc++]="	eptr->log[2] = 0x7E;";
  z[lc++]="	eptr->log[3] = 0x7F;";
  z[lc++]="	eptr->log[4] = 0x09;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_MVOLUME:";
  z[lc++]="	jsys->chapterx_mvolume = eptr;";
  z[lc++]="	eptr->cmdptr = &(jsys->chapterx_mvolume);";
  z[lc++]="	sincr = eptr->size = NSYS_SM_CX_SIZE_MVOLUME;";
  z[lc++]="	eptr->log[0] = (NSYS_SM_CX_HDR_SETT | NSYS_SM_CX_HDR_SETD |";
  z[lc++]="			NSYS_SM_CX_STA_NORMAL);";
  z[lc++]="	eptr->log[2] = 0x7F;";
  z[lc++]="	eptr->log[3] = 0x7F;";
  z[lc++]="	eptr->log[4] = 0x04;";
  z[lc++]="	eptr->log[5] = 0x01;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      jsys->chapterx_stack[(jsys->chapterx_stacklen)++] = eptr;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* work in common for new and moved stack tops */";
  z[lc++]="";
  z[lc++]="  eptr->seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  switch (cmd) {";
  z[lc++]="  case CSYS_MIDI_GMRESET:";
  z[lc++]="    if (ndata == NSYS_SM_CX_GMRESET_ONVAL)";
  z[lc++]="      eptr->log[1] = ++(jsys->chapterx_gmreset_on_count);";
  z[lc++]="    else";
  z[lc++]="      eptr->log[1] = ++(jsys->chapterx_gmreset_off_count);";
  z[lc++]="    eptr->log[5] = ndata | NSYS_SM_CX_DATA_SETEND;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_MVOLUME:";
  z[lc++]="    eptr->log[1] = ++(jsys->chapterx_mvolume_count);";
  z[lc++]="    eptr->log[6] = ndata;";
  z[lc++]="    eptr->log[7] = vdata | NSYS_SM_CX_DATA_SETEND;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_stack[0]->log[0] &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  if (sincr == 0)";
  z[lc++]="    jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= ~(NSYS_SM_SH_MSBMASK |";
  z[lc++]="					       NSYS_SM_SETS);";
  z[lc++]="";
  z[lc++]="      if ((jsys->slen += sincr) <= NSYS_SM_SH_LSBMASK)";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= NSYS_SM_SH_SETX;";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = (unsigned char)(jsys->slen);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] |= ";
  z[lc++]="	    (NSYS_SM_SH_SETX | ((unsigned char)(jsys->slen >> 8)));";
  z[lc++]="	  jsys->sheader[NSYS_SM_SH_LOC_LENLSB] = ";
  z[lc++]="	    (unsigned char)(NSYS_SM_SH_LSBMASK & jsys->slen);  ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_guard_time = nsys_netout_jsend_guard_mintime;";
  z[lc++]="  nsys_netout_jsend_guard_next = (nsys_netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*      second-level journal functions: trimstate chapters      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  trim entire chapter                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimchapter(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				     int channel)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k;";
  z[lc++]="";
  z[lc++]="  memset(jsend->cheader, 0, NSYS_SM_CH_SIZE);";
  z[lc++]="";
  z[lc++]="  jsend->cheader_seqnum  = 0;";
  z[lc++]="  jsend->chapterp_seqnum = 0;";
  z[lc++]="  jsend->chapterc_seqnum = 0;";
  z[lc++]="  jsend->chapterm_seqnum = 0;";
  z[lc++]="  jsend->chapterw_seqnum = 0;";
  z[lc++]="  jsend->chaptern_seqnum = 0;";
  z[lc++]="  jsend->chaptere_seqnum = 0;";
  z[lc++]="  jsend->chaptert_seqnum = 0;";
  z[lc++]="  jsend->chaptera_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsend->chapterc_sset = 0;";
  z[lc++]="  jsend->chapterm_sset = 0;";
  z[lc++]="  jsend->chaptern_sset = 0;";
  z[lc++]="  jsend->chaptere_sset = 0;";
  z[lc++]="  jsend->chaptera_sset = 0;";
  z[lc++]="";
  z[lc++]="  jsend->chaptern_timernum = 0;";
  z[lc++]="";
  z[lc++]="  /*******************************************/";
  z[lc++]="  /* clear seqnums of journal chapter arrays */";
  z[lc++]="  /*******************************************/";
  z[lc++]="";
  z[lc++]="  while (jsend->chapterc_size > NSYS_SM_CC_HDRSIZE)";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterc_size -= NSYS_SM_CC_LOGSIZE;";
  z[lc++]="      i = jsend->chapterc[jsend->chapterc_size];";
  z[lc++]="      jsend->chapterc_seqarray[NSYS_SM_CLRS & i] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->chapterm_dummy_seqnum = 0;";
  z[lc++]="  for (j = 0; j < NSYS_SM_CM_ARRAYSIZE; j++)";
  z[lc++]="    jsend->chapterm_seqarray[j] = 0;";
  z[lc++]="";
  z[lc++]="  for (j = NSYS_SM_CN_HDRSIZE; j < jsend->chaptern_size;";
  z[lc++]="       j += NSYS_SM_CN_LOGSIZE)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptern[j];";
  z[lc++]="      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  i = (jsend->chapterb_low << NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  for (j = jsend->chapterb_low; j <= jsend->chapterb_high; j++)";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chapterb[j])";
  z[lc++]="	for (k = 128; k >= 1; k = (k >> 1))";
  z[lc++]="	  {";
  z[lc++]="	    if (jsend->chapterb[j] & k)";
  z[lc++]="	      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="	    i++;";
  z[lc++]="	  }";
  z[lc++]="      else";
  z[lc++]="	i += 8;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (jsend->chaptere_size > NSYS_SM_CE_HDRSIZE)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptere[jsend->chaptere_size];";
  z[lc++]="      if (jsend->chaptere[jsend->chaptere_size + 1] & NSYS_SM_CE_CHKV)";
  z[lc++]="	jsend->chapterev_seqarray[i] = 0;";
  z[lc++]="      else";
  z[lc++]="	jsend->chapterer_seqarray[i] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (jsend->chaptera_size > NSYS_SM_CA_HDRSIZE)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptera_size -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="      i = jsend->chaptera[jsend->chaptera_size];";
  z[lc++]="      jsend->chaptera_seqarray[NSYS_SM_CLRS & i] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* update channel array */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if (channel < (--nsys_netout_jsend_channel_size))";
  z[lc++]="    memmove(&(nsys_netout_jsend_channel[channel]), ";
  z[lc++]="	    &(nsys_netout_jsend_channel[channel+1]),";
  z[lc++]="	    sizeof(unsigned char)*(nsys_netout_jsend_channel_size -";
  z[lc++]="				   channel));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim program change chapter                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimprogram(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  jsend->chapterp_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRP;";
  z[lc++]="  jsend->clen -= NSYS_SM_CP_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire controller chapter               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallcontrol(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  jsend->chapterc_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRC;";
  z[lc++]="  jsend->clen -= jsend->chapterc_size;";
  z[lc++]="  j = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="  while (j < jsend->chapterc_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chapterc[j];";
  z[lc++]="      jsend->chapterc_seqarray[i] = 0;";
  z[lc++]="      j += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="  jsend->chapterc_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 partially trim controller chapter            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartcontrol(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					 unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="";
  z[lc++]="  while (j < jsend->chapterc_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chapterc[j];";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterc_seqarray[i] <= minseq)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterc_seqarray[i] = 0;";
  z[lc++]="	  jsend->clen -= NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	  jsend->chapterc_size -= NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	  jsend->chapterc[NSYS_SM_CC_LOC_LENGTH]--;";
  z[lc++]="	  j += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	break;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (j == NSYS_SM_CC_HDRSIZE)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  memmove(&(jsend->chapterc[NSYS_SM_CC_HDRSIZE]), &(jsend->chapterc[j]),";
  z[lc++]="	  jsend->chapterc_size - NSYS_SM_CC_HDRSIZE);";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="";
  z[lc++]="  while (j < jsend->chapterc_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chapterc[j];";
  z[lc++]="      jsend->chapterc_logptr[i] = j;";
  z[lc++]="      j += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire parameter chapter                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallparams(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  jsend->chapterm_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRM;";
  z[lc++]="  jsend->clen -= (jsend->chapterm_size + jsend->chapterl_size);";
  z[lc++]="  jsend->chapterm_dummy_seqnum = 0;";
  z[lc++]="  for (i = 0; i < NSYS_SM_CM_ARRAYSIZE; i++)";
  z[lc++]="    jsend->chapterm_seqarray[i] = 0;";
  z[lc++]="  jsend->chapterm_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 partially trim parameter chapter             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartparams(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char lsb, msb, nrpn, hbits, toc;";
  z[lc++]="  int i, j, loglen, found;";
  z[lc++]="  ";
  z[lc++]="  found = i = 0;";
  z[lc++]="";
  z[lc++]="  while (i < jsend->chapterl_size)";
  z[lc++]="    {";
  z[lc++]="      msb = jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMMSB] & NSYS_SM_CM_CLRQ;";
  z[lc++]="      lsb = jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMLSB] & NSYS_SM_CLRS;";
  z[lc++]="      nrpn =  jsend->chapterl[i + NSYS_SM_CM_LOC_PNUMMSB] & NSYS_SM_CM_CHKQ;";
  z[lc++]="";
  z[lc++]="      if (nrpn || (msb || (lsb >= NSYS_SM_CM_ARRAYSIZE)))";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chapterm_dummy_seqnum <= minseq)";
  z[lc++]="	    jsend->chapterm_dummy_seqnum = 0;";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      found = 1;";
  z[lc++]="	      break;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chapterm_seqarray[lsb] <= minseq)";
  z[lc++]="	    jsend->chapterm_seqarray[lsb] = 0;";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      found = 1;";
  z[lc++]="	      break;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      loglen = NSYS_SM_CM_LOGHDRSIZE;";
  z[lc++]="      toc = jsend->chapterl[i + NSYS_SM_CM_LOC_TOC];";
  z[lc++]="";
  z[lc++]="      if (toc & NSYS_SM_CM_TOC_CHKJ)";
  z[lc++]="	loglen += NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="      ";
  z[lc++]="      if (toc & NSYS_SM_CM_TOC_CHKK)";
  z[lc++]="	loglen += NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="      ";
  z[lc++]="      if (toc & NSYS_SM_CM_TOC_CHKL)";
  z[lc++]="	loglen += NSYS_SM_CM_ABUTTON_SIZE;";
  z[lc++]="      ";
  z[lc++]="      if (toc & NSYS_SM_CM_TOC_CHKM)";
  z[lc++]="	loglen += NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="";
  z[lc++]="      if (toc & NSYS_SM_CM_TOC_CHKN)";
  z[lc++]="	loglen += NSYS_SM_CM_COUNT_SIZE;";
  z[lc++]="      ";
  z[lc++]="      i += loglen;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!i)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  if (found)";
  z[lc++]="    {";
  z[lc++]="      memmove(jsend->chapterl, &(jsend->chapterl[i]), jsend->chapterl_size - i);";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterm_dummy_seqnum)";
  z[lc++]="	jsend->chapterm_dummy_logptr -= i;";
  z[lc++]="";
  z[lc++]="      for (j = 0; j < NSYS_SM_CM_ARRAYSIZE; j++)";
  z[lc++]="	if (jsend->chapterm_seqarray[j])";
  z[lc++]="	  jsend->chapterm_logptr[j] -= i;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->clen -= i;";
  z[lc++]="  jsend->chapterl_size -= i;";
  z[lc++]="";
  z[lc++]="  hbits = ((NSYS_SM_CHKS | NSYS_SM_CM_HDR_CHKP | NSYS_SM_CM_HDR_CHKE)";
  z[lc++]="	   & jsend->chapterm[NSYS_SM_CM_LOC_HDR]);";
  z[lc++]="";
  z[lc++]="  *((unsigned short *) &(jsend->chapterm[NSYS_SM_CM_LOC_HDR])) = ";
  z[lc++]="    htons((unsigned short)(jsend->chapterm_size + jsend->chapterl_size));";
  z[lc++]="";
  z[lc++]="  jsend->chapterm[NSYS_SM_CM_LOC_HDR] |= hbits;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim pitch wheel chapter                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpwheel(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  jsend->chapterw_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRW;";
  z[lc++]="  jsend->clen -= NSYS_SM_CW_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire note chapter                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallnote(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j, k;";
  z[lc++]="";
  z[lc++]="  jsend->chaptern_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRN;";
  z[lc++]="  jsend->clen -= (jsend->chaptern_size + jsend->chapterb_size);";
  z[lc++]="  ";
  z[lc++]="  for (j = NSYS_SM_CN_HDRSIZE; j < jsend->chaptern_size;";
  z[lc++]="       j += NSYS_SM_CN_LOGSIZE)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptern[j];";
  z[lc++]="      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="    }";
  z[lc++]="  i = (jsend->chapterb_low << NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  for (j = jsend->chapterb_low; j <= jsend->chapterb_high; j++)";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chapterb[j])";
  z[lc++]="	for (k = 128; k >= 1; k = (k >> 1))";
  z[lc++]="	  {";
  z[lc++]="	    if (jsend->chapterb[j] & k) ";
  z[lc++]="	      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="	    i++;";
  z[lc++]="	  }";
  z[lc++]="      else";
  z[lc++]="	i += 8;";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptern_timernum = 0;";
  z[lc++]="  jsend->chaptern_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim partial note chapter                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartnote(nsys_netout_jsend_state * jsend, ";
  z[lc++]="				      unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k;";
  z[lc++]="";
  z[lc++]="  /* first prune note logs */";
  z[lc++]="  ";
  z[lc++]="  j = NSYS_SM_CN_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptern_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptern[j];";
  z[lc++]="      if (jsend->chaptern_seqarray[i] <= minseq)";
  z[lc++]="	{	  ";
  z[lc++]="	  if (jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY)";
  z[lc++]="	    jsend->chaptern_timernum--;";
  z[lc++]="	  jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="	  memmove(&(jsend->chaptern[j]), ";
  z[lc++]="		  &(jsend->chaptern[j + NSYS_SM_CN_LOGSIZE]),";
  z[lc++]="		  jsend->chaptern_size - j - NSYS_SM_CN_LOGSIZE);";
  z[lc++]="";
  z[lc++]="	  if (jsend->chaptern_size < NSYS_SM_CN_SIZE)";
  z[lc++]="	    jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]--;";
  z[lc++]="	  jsend->chaptern_size -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  jsend->clen -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptern_logptr[i] = j;";
  z[lc++]="	  j += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /* then prune bitfields */";
  z[lc++]="  ";
  z[lc++]="  i = (jsend->chapterb_low << NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  for (j = jsend->chapterb_low; j <= jsend->chapterb_high; j++)";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chapterb[j])";
  z[lc++]="	for (k = 128; k >= 1; k = (k >> 1))";
  z[lc++]="	  {";
  z[lc++]="	    if ((jsend->chapterb[j] & k) && ";
  z[lc++]="		(jsend->chaptern_seqarray[i] <= minseq))";
  z[lc++]="	      {";
  z[lc++]="		jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="		jsend->chapterb[j] &= ~k;";
  z[lc++]="	      }";
  z[lc++]="	    i++;";
  z[lc++]="	  }";
  z[lc++]="      else";
  z[lc++]="	i += 8;";
  z[lc++]="      if ((j == jsend->chapterb_low) && ";
  z[lc++]="	  (jsend->chapterb[j] == 0))";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterb_low++;";
  z[lc++]="	  jsend->chapterb_size--;";
  z[lc++]="	  jsend->clen--;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  while (jsend->chapterb_size && ";
  z[lc++]="	 (jsend->chapterb[jsend->chapterb_high] == 0))";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterb_high--;";
  z[lc++]="      jsend->chapterb_size--;";
  z[lc++]="      jsend->clen--;";
  z[lc++]="    }";
  z[lc++]="  if (jsend->chapterb_size == 0)";
  z[lc++]="    {	  ";
  z[lc++]="      jsend->chapterb_low = NSYS_SM_CN_BFMAX;";
  z[lc++]="      if (jsend->chaptern_size != NSYS_SM_CN_SIZE)";
  z[lc++]="	jsend->chapterb_high = 1;";
  z[lc++]="      else";
  z[lc++]="	jsend->chapterb_high = NSYS_SM_CN_BFMIN;";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="    ((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="     jsend->chapterb_high);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                trim entire note extras chapter               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallextras(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  jsend->chaptere_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRE;";
  z[lc++]="  jsend->clen -= jsend->chaptere_size;";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptere_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptere[j];";
  z[lc++]="      if (jsend->chaptere[j + 1] & NSYS_SM_CE_CHKV)";
  z[lc++]="	jsend->chapterev_seqarray[i] = 0;";
  z[lc++]="      else";
  z[lc++]="	jsend->chapterer_seqarray[i] = 0;";
  z[lc++]="      j += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->chaptere_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              partially trim note extras chapter              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartextras(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CE_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptere_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptere[j];";
  z[lc++]="      if (jsend->chaptere[j + 1] & NSYS_SM_CE_CHKV)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chapterev_seqarray[i] <= minseq)";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterev_seqarray[i] = 0;";
  z[lc++]="	      memmove(&(jsend->chaptere[j]), ";
  z[lc++]="		      &(jsend->chaptere[j + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="		      jsend->chaptere_size - j - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="	      jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	      jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterev_logptr[i] = j;";
  z[lc++]="	      j += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->chapterer_seqarray[i] <= minseq)";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterer_seqarray[i] = 0;";
  z[lc++]="	      memmove(&(jsend->chaptere[j]), ";
  z[lc++]="		      &(jsend->chaptere[j + NSYS_SM_CE_LOGSIZE]),";
  z[lc++]="		      jsend->chaptere_size - j - NSYS_SM_CE_LOGSIZE);";
  z[lc++]="	      jsend->clen -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	      jsend->chaptere_size -= NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	      jsend->chaptere[NSYS_SM_CE_LOC_LENGTH]--;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterer_logptr[i] = j;";
  z[lc++]="	      j += NSYS_SM_CE_LOGSIZE;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim channel touch chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimctouch(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  jsend->chaptert_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRT;";
  z[lc++]="  jsend->clen -= NSYS_SM_CT_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire poly touch chapter               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallptouch(nsys_netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  jsend->chaptera_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRA;";
  z[lc++]="  jsend->clen -= jsend->chaptera_size;";
  z[lc++]="  j = NSYS_SM_CA_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptera_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptera[j];";
  z[lc++]="      jsend->chaptera_seqarray[i] = 0;";
  z[lc++]="      j += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptera_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 partially trim poly touch chapter            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartptouch(nsys_netout_jsend_state * jsend, ";
  z[lc++]="					unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CA_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptera_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptera[j];";
  z[lc++]="      if (jsend->chaptera_seqarray[i] <= minseq)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptera_seqarray[i] = 0;";
  z[lc++]="	  memmove(&(jsend->chaptera[j]), ";
  z[lc++]="		  &(jsend->chaptera[j + NSYS_SM_CA_LOGSIZE]),";
  z[lc++]="		  jsend->chaptera_size - j - NSYS_SM_CA_LOGSIZE);";
  z[lc++]="	  jsend->clen -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	  jsend->chaptera_size -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	  jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]--;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptera_logptr[i] = j;";
  z[lc++]="	  j += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  trim entire Systems journal                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsystem(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  memset(jsys->sheader, 0, NSYS_SM_SH_SIZE);";
  z[lc++]="";
  z[lc++]="  jsys->sheader_seqnum  = 0;";
  z[lc++]="  jsys->chapterv_seqnum = 0;";
  z[lc++]="  jsys->chapterq_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterf_seqnum = 0;";
  z[lc++]="  jsys->chapterfc_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = 0;";
  z[lc++]="  jsys->chapterd_reset_seqnum = 0;";
  z[lc++]="  jsys->chapterd_tune_seqnum = 0;";
  z[lc++]="  jsys->chapterd_song_seqnum = 0;";
  z[lc++]="  jsys->chapterd_scj_seqnum = 0;";
  z[lc++]="  jsys->chapterd_sck_seqnum = 0;";
  z[lc++]="  jsys->chapterd_rty_seqnum = 0;";
  z[lc++]="  jsys->chapterd_rtz_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRC;";
  z[lc++]="      jsys->chapterf_size -= NSYS_SM_CF_SIZE_COMPLETE;";
  z[lc++]="";
  z[lc++]="      if (jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP)";
  z[lc++]="	memcpy(&(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]),";
  z[lc++]="	       &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]),";
  z[lc++]="	       NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_gmreset_off = NULL;";
  z[lc++]="  jsys->chapterx_gmreset_on = NULL;";
  z[lc++]="  jsys->chapterx_mvolume = NULL;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < jsys->chapterx_stacklen; i++)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterx_stack[i]->next = nsys_netout_jsend_xstackfree;";
  z[lc++]="      nsys_netout_jsend_xstackfree = jsys->chapterx_stack[i];";
  z[lc++]="      jsys->chapterx_stack[i] = NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_stacklen = 0;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 Trim (entire) simple chapter                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsimple(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_seqnum = 0;";
  z[lc++]="  jsys->chapterd_reset_seqnum = 0;";
  z[lc++]="  jsys->chapterd_tune_seqnum = 0;";
  z[lc++]="  jsys->chapterd_song_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_SH_CLRD;";
  z[lc++]="  jsys->slen -= jsys->chapterd_front_size;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_scj_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->slen -= jsys->chapterd_scj_size;";
  z[lc++]="      jsys->chapterd_scj_seqnum = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_sck_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->slen -= jsys->chapterd_sck_size;";
  z[lc++]="      jsys->chapterd_sck_seqnum = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_rty_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->slen -= NSYS_SM_CD_REALTIME_SIZE;";
  z[lc++]="      jsys->chapterd_rty_seqnum = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_rtz_seqnum)";
  z[lc++]="    {";
  z[lc++]="      jsys->slen -= NSYS_SM_CD_REALTIME_SIZE;";
  z[lc++]="      jsys->chapterd_rtz_seqnum = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                Trim Reset from simple chapter                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimreset(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_reset_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  p = &(jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_tune_seqnum)";
  z[lc++]="    (*(++p)) = jsys->chapterd_tune;";
  z[lc++]="  if (jsys->chapterd_song_seqnum)";
  z[lc++]="    (*(++p)) = jsys->chapterd_song;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRB;";
  z[lc++]="  jsys->chapterd_front_size -= NSYS_SM_CD_SIZE_RESET;";
  z[lc++]="  jsys->slen -= NSYS_SM_CD_SIZE_RESET;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             Trim Tune Request from simple chapter            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimtune(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_tune_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  p = &(jsys->chapterd_front[NSYS_SM_CD_LOC_LOGS]);";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_reset_seqnum)";
  z[lc++]="    p++;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterd_song_seqnum)";
  z[lc++]="    *p = jsys->chapterd_song;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRG;";
  z[lc++]="  jsys->chapterd_front_size -= NSYS_SM_CD_SIZE_TUNE;";
  z[lc++]="  jsys->slen -= NSYS_SM_CD_SIZE_TUNE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            Trim Song Select from simple chapter              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsong(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_song_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRH;";
  z[lc++]="  jsys->chapterd_front_size -= NSYS_SM_CD_SIZE_SONG;";
  z[lc++]="  jsys->slen -= NSYS_SM_CD_SIZE_SONG;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        Trim undefined Common (j) from simple chapter         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimscj(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_scj_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRJ;";
  z[lc++]="  jsys->slen -= jsys->chapterd_scj_size;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        Trim undefined Common (k) from simple chapter         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsck(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_sck_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRK;";
  z[lc++]="  jsys->slen -= jsys->chapterd_sck_size;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        Trim undefined Realtime (y) from simple chapter       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimrty(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_rty_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRY;";
  z[lc++]="  jsys->slen -= NSYS_SM_CD_REALTIME_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        Trim undefined Realtime (z) from simple chapter       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimrtz(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_rtz_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterd_front[NSYS_SM_CD_LOC_TOC] &= NSYS_SM_CD_TOC_CLRZ;";
  z[lc++]="  jsys->slen -= NSYS_SM_CD_REALTIME_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  Trim active sense chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsense(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  jsys->chapterv_seqnum = 0;";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_SH_CLRV;";
  z[lc++]="  jsys->slen -= NSYS_SM_CV_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  Trim sequencer chapter                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsequence(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  jsys->chapterq_seqnum = 0;";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_SH_CLRQ;";
  z[lc++]="  if (jsys->chapterq[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC)";
  z[lc++]="    jsys->slen -= NSYS_SM_CQ_SIZE_CLOCK + NSYS_SM_CQ_SIZE_HDR;";
  z[lc++]="  else";
  z[lc++]="    jsys->slen -= NSYS_SM_CQ_SIZE_HDR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  Trim MIDI Time code chapter                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimtimecode(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_SH_CLRF;";
  z[lc++]="  jsys->slen -= NSYS_SM_CF_SIZE_HDR;";
  z[lc++]="  jsys->chapterf_seqnum = 0;";
  z[lc++]="  jsys->chapterfc_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRC;";
  z[lc++]="      jsys->chapterf_size -= NSYS_SM_CF_SIZE_COMPLETE;";
  z[lc++]="      jsys->slen -= NSYS_SM_CF_SIZE_COMPLETE;";
  z[lc++]="";
  z[lc++]="      if (jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP)";
  z[lc++]="	memcpy(&(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]),";
  z[lc++]="	       &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]),";
  z[lc++]="	       NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP)";
  z[lc++]="    jsys->slen -= NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        Trim COMPLETE field from MIDI Time code chapter       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimparttimecode(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  jsys->chapterfc_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterf[NSYS_SM_CF_LOC_HDR] &= NSYS_SM_CF_HDR_CLRC;";
  z[lc++]="  jsys->chapterf_size -= NSYS_SM_CF_SIZE_COMPLETE;";
  z[lc++]="  jsys->slen -= NSYS_SM_CF_SIZE_COMPLETE;";
  z[lc++]="";
  z[lc++]="  if (jsys->chapterf[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP)";
  z[lc++]="    memcpy(&(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS]),";
  z[lc++]="	   &(jsys->chapterf[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]),";
  z[lc++]="	   NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    Trim SysEx chapter                        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimsysex(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="  jsys->chapterx_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_gmreset_off = NULL;";
  z[lc++]="  jsys->chapterx_gmreset_on = NULL;";
  z[lc++]="  jsys->chapterx_mvolume = NULL;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < jsys->chapterx_stacklen; i++)";
  z[lc++]="    {";
  z[lc++]="      jsys->slen -= jsys->chapterx_stack[i]->size;";
  z[lc++]="      jsys->chapterx_stack[i]->next = nsys_netout_jsend_xstackfree;";
  z[lc++]="      nsys_netout_jsend_xstackfree = jsys->chapterx_stack[i];";
  z[lc++]="      jsys->chapterx_stack[i] = NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_stacklen = 0;";
  z[lc++]="";
  z[lc++]="  jsys->sheader[NSYS_SM_SH_LOC_FLAGS] &= NSYS_SM_SH_CLRX;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            Trim part of the SysEx chapter                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartsysex(unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jsend_system_state * jsys;";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  jsys = &(nsys_netout_jsend_system);";
  z[lc++]="";
  z[lc++]="  for (i = j = 0; i < jsys->chapterx_stacklen; i++)";
  z[lc++]="    if (jsys->chapterx_stack[i]->seqnum <= minseq)";
  z[lc++]="      {";
  z[lc++]="	jsys->slen -= jsys->chapterx_stack[i]->size;";
  z[lc++]="	*(jsys->chapterx_stack[i]->cmdptr) = NULL;";
  z[lc++]="	jsys->chapterx_stack[i]->next = nsys_netout_jsend_xstackfree;";
  z[lc++]="	nsys_netout_jsend_xstackfree = jsys->chapterx_stack[i];";
  z[lc++]="	jsys->chapterx_stack[i] = NULL;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	j = i;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  jsys->chapterx_stacklen -= j;";
  z[lc++]="  ";
  z[lc++]="  for (i = 0; i < jsys->chapterx_stacklen; i++)";
  z[lc++]="    {";
  z[lc++]="      jsys->chapterx_stack[i] = jsys->chapterx_stack[i + j];";
  z[lc++]="      jsys->chapterx_stack[i]->index = i;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*      second-level journal functions: miscellaneous           */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           updates state after checkpoint change              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_changecheck(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short check_seqnum_net;";
  z[lc++]="";
  z[lc++]="  nsys_netout_jsend_checkpoint_changed = 1;";
  z[lc++]="  check_seqnum_net = htons((unsigned short) (NSYS_RTPSEQ_LOMASK &";
  z[lc++]="					     nsys_netout_jsend_checkpoint_seqnum));";
  z[lc++]="  memcpy(&(nsys_netout_jsend_header[NSYS_SM_JH_LOC_CHECK]),";
  z[lc++]="	 &check_seqnum_net, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*    sender state:  clear N-active state, Chapters N, T, A     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_clear_nactive(nsys_netout_jsend_state * jsend)";
  z[lc++]="";
  z[lc++]="{ ";
  z[lc++]="  if (jsend->chaptern_seqnum)";
  z[lc++]="    nsys_netout_journal_trimallnote(jsend); ";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptere_seqnum)";
  z[lc++]="    nsys_netout_journal_trimallextras(jsend); ";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptert_seqnum)";
  z[lc++]="    nsys_netout_journal_trimctouch(jsend);";
  z[lc++]="";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*    sender state:  clear C-active state, Chapters C, M        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_clear_cactive(nsys_netout_jsend_state * jsend)";
  z[lc++]="";
  z[lc++]="{ ";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* Chapter C */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterc_sustain & 0x01)";
  z[lc++]="    jsend->chapterc_sustain = ((jsend->chapterc_sustain + 1)  ";
  z[lc++]="			       & NSYS_SM_CC_ALTMOD);";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* Chapter M */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  jsend->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="  for (i = 0; i < NSYS_SM_CM_ARRAYSIZE; i++)";
  z[lc++]="    jsend->chapterm_cbutton[i] = 0;";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* Chapter W */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chapterw_seqnum)";
  z[lc++]="    nsys_netout_journal_trimpwheel(jsend);";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* Chapter T */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptert_seqnum)";
  z[lc++]="    nsys_netout_journal_trimctouch(jsend);";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* Chapter A */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  if (jsend->chaptera_seqnum)";
  z[lc++]="    nsys_netout_journal_trimallptouch(jsend);";
  z[lc++]="";
  z[lc++]="  /***************/";
  z[lc++]="  /* update clen */";
  z[lc++]="  /***************/";
  z[lc++]="";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            sender state:  clear all active state             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_clear_active(unsigned char cmd)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* to do ";
  z[lc++]="   *";
  z[lc++]="   * cmd codes CSYS_MIDI_SYSTEM_RESET or CSYS_MIDI_GMRESET";
  z[lc++]="   *";
  z[lc++]="   * clear journal state defined as \"active\"";
  z[lc++]="   *";
  z[lc++]="   */";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level journal functions                 */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* end Network library -- sender journal functions */";
  printlib(lc);
}


void makenet_jrecv(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- receiver journal functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     high-level functions: receiving recovery journals        */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          main routine for parsing recovery journal           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_recovery(nsys_source * sptr, int rtpcode, ";
  z[lc++]="				unsigned char * packet,";
  z[lc++]="				int numbytes, unsigned char * buff,  ";
  z[lc++]="				long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jrecv_state * jrecv;";
  z[lc++]="  nsys_netout_jrecv_system_state * jrecvsys;";
  z[lc++]="  int numchan, bflag, i, j;";
  z[lc++]="  short chanlen, syslen, loglen, cmdlen, paramlen;";
  z[lc++]="  unsigned char chan, low, high, many, sysj, chanj;";
  z[lc++]="  unsigned char chapters, schapters, dchapters;";
  z[lc++]="  unsigned char * checkptr, * p, * ps;";
  z[lc++]="";
  z[lc++]="  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="    {";
  z[lc++]="      printf(\"\\ndoing recovery for mset%i (fill: %i)\\n\", sptr->mset, ";
  z[lc++]="	     (j = (*fill))); ";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="      if (sptr->tm_margin)";
  z[lc++]="	printf(\"Time: %f\\n\", (nsys_netout_tstamp - sptr->tm_first)/ARATE);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="      fflush(stdout);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((numbytes -= 1) < NSYS_SM_JH_SIZE)";
  z[lc++]="    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="  cmdlen = (*packet) & NSYS_SM_MLENMASK;";
  z[lc++]="";
  z[lc++]="  if ((*packet) & NSYS_SM_CHKB)";
  z[lc++]="    {";
  z[lc++]="      if ((numbytes -= 1) < NSYS_SM_JH_SIZE)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      cmdlen = packet[1] + (cmdlen << 8);";
  z[lc++]="      packet += 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((numbytes -= cmdlen) < NSYS_SM_JH_SIZE)";
  z[lc++]="    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="  packet += 1 + cmdlen;";
  z[lc++]="  many = (rtpcode == NSYS_RTPCODE_LOSTMANY);";
  z[lc++]="";
  z[lc++]="  sysj = (packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHKY);";
  z[lc++]="  chanj = (packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHKA);";
  z[lc++]="";
  z[lc++]="  if ((!sysj && !chanj) || ";
  z[lc++]="      ((packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_CHKS) && (!many)))";
  z[lc++]="    return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="";
  z[lc++]="  numchan = chanj ? (packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHANMASK) + 1 : 0;";
  z[lc++]="  checkptr = &(packet[NSYS_SM_JH_LOC_CHECK]);";
  z[lc++]="";
  z[lc++]="  numbytes -= NSYS_SM_JH_SIZE;";
  z[lc++]="  packet += NSYS_SM_JH_SIZE;";
  z[lc++]="";
  z[lc++]="  if (sysj)";
  z[lc++]="    {";
  z[lc++]="      if (numbytes < NSYS_SM_SH_SIZE)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      if ((jrecvsys = sptr->jrecvsys) == NULL)";
  z[lc++]="	jrecvsys = sptr->jrecvsys = nsys_netin_newrecvsys();";
  z[lc++]="";
  z[lc++]="      schapters = packet[NSYS_SM_SH_LOC_FLAGS];";
  z[lc++]="      syslen = packet[NSYS_SM_SH_LOC_LENLSB] + ((schapters & NSYS_SM_SH_MSBMASK) << 8);";
  z[lc++]="";
  z[lc++]="      if ((numbytes -= syslen) < 0)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      ps = packet + NSYS_SM_SH_SIZE;";
  z[lc++]="      packet += syslen;";
  z[lc++]="      syslen -= NSYS_SM_SH_SIZE;";
  z[lc++]="";
  z[lc++]="      /*************************************/";
  z[lc++]="      /* chapter D: Simple System Commands */";
  z[lc++]="      /*************************************/";
  z[lc++]="";
  z[lc++]="      if (schapters & NSYS_SM_SH_CHKD)";
  z[lc++]="	{";
  z[lc++]="	  if ((syslen -= NSYS_SM_CD_SIZE_TOC) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  dchapters = ps[NSYS_SM_CD_LOC_TOC];";
  z[lc++]="	  ps += NSYS_SM_CD_SIZE_TOC;";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKB)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= NSYS_SM_CD_SIZE_RESET) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_reset(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      ps += NSYS_SM_CD_SIZE_RESET;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKG)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= NSYS_SM_CD_SIZE_TUNE) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_tune(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      ps += NSYS_SM_CD_SIZE_TUNE;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKH)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= NSYS_SM_CD_SIZE_SONG) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_song(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      ps += NSYS_SM_CD_SIZE_SONG;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKJ)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= (NSYS_SM_CD_COMMON_TOC_SIZE +";
  z[lc++]="			      NSYS_SM_CD_COMMON_LENGTH_SIZE)) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      loglen = ps[1] + ((ps[0] & NSYS_SM_CD_COMMON_LENMSB_MASK) << 8);";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_scj(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      syslen -= (loglen - (NSYS_SM_CD_COMMON_TOC_SIZE +";
  z[lc++]="				   NSYS_SM_CD_COMMON_LENGTH_SIZE));";
  z[lc++]="	      ps += loglen;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKK)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= (NSYS_SM_CD_COMMON_TOC_SIZE +";
  z[lc++]="			      NSYS_SM_CD_COMMON_LENGTH_SIZE)) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      loglen = ps[1] + ((ps[0] & NSYS_SM_CD_COMMON_LENMSB_MASK) << 8);";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_sck(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      syslen -= (loglen - (NSYS_SM_CD_COMMON_TOC_SIZE +";
  z[lc++]="				   NSYS_SM_CD_COMMON_LENGTH_SIZE));";
  z[lc++]="	      ps += loglen;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKY)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= NSYS_SM_CD_REALTIME_TOC_SIZE) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      loglen = ps[0] & NSYS_SM_CD_REALTIME_LENGTH_MASK;";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_rty(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      syslen -= (loglen - NSYS_SM_CD_REALTIME_TOC_SIZE);";
  z[lc++]="	      ps += loglen;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (dchapters & NSYS_SM_CD_TOC_CHKZ)";
  z[lc++]="	    {";
  z[lc++]="	      if ((syslen -= NSYS_SM_CD_REALTIME_TOC_SIZE) < 0)";
  z[lc++]="		return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	      loglen = ps[0] & NSYS_SM_CD_REALTIME_LENGTH_MASK;";
  z[lc++]="";
  z[lc++]="	      if (((!(ps[0] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="		  nsys_netin_jrec_rtz(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	      syslen -= (loglen - NSYS_SM_CD_REALTIME_TOC_SIZE);";
  z[lc++]="	      ps += loglen;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /***************************/";
  z[lc++]="      /* chapter V: Active Sense */";
  z[lc++]="      /***************************/";
  z[lc++]="";
  z[lc++]="      if (schapters & NSYS_SM_SH_CHKV)";
  z[lc++]="	{";
  z[lc++]="	  if ((syslen -= NSYS_SM_CV_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(ps[NSYS_SM_CV_LOC_COUNT] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_sense(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  ps += NSYS_SM_CV_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /************************/";
  z[lc++]="      /* chapter Q: Sequencer */";
  z[lc++]="      /************************/";
  z[lc++]="";
  z[lc++]="      if (schapters & NSYS_SM_SH_CHKQ)";
  z[lc++]="	{";
  z[lc++]="	  if ((syslen -= NSYS_SM_CQ_SIZE_HDR) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen = 0;";
  z[lc++]="";
  z[lc++]="	  if (ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC)";
  z[lc++]="	    loglen += NSYS_SM_CQ_SIZE_CLOCK;";
  z[lc++]="";
  z[lc++]="	  if (ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKT)";
  z[lc++]="	    loglen += NSYS_SM_CQ_SIZE_TIMETOOLS;";
  z[lc++]="";
  z[lc++]="	  if ((syslen -= loglen) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen += NSYS_SM_CQ_SIZE_HDR;";
  z[lc++]="";
  z[lc++]="	  if (((!(ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_sequence(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  ps += loglen;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* chapter F: MIDI Time Code */";
  z[lc++]="      /*****************************/";
  z[lc++]="";
  z[lc++]="      if (schapters & NSYS_SM_SH_CHKF)";
  z[lc++]="	{";
  z[lc++]="	  if ((syslen -= NSYS_SM_CF_SIZE_HDR) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen = 0;";
  z[lc++]="";
  z[lc++]="	  if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="	    loglen += NSYS_SM_CF_SIZE_COMPLETE;";
  z[lc++]="";
  z[lc++]="	  if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP)";
  z[lc++]="	    loglen += NSYS_SM_CF_SIZE_PARTIAL;";
  z[lc++]="";
  z[lc++]="	  if ((syslen -= loglen) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen += NSYS_SM_CF_SIZE_HDR;";
  z[lc++]="";
  z[lc++]="	  if (((!(ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_timecode(sptr, ps, jrecvsys, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  ps += loglen;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*******************************/";
  z[lc++]="      /* chapter X: System Exclusive */";
  z[lc++]="      /*******************************/";
  z[lc++]="";
  z[lc++]="      if ((schapters & NSYS_SM_SH_CHKX) && syslen && ";
  z[lc++]="	  (!(ps[NSYS_SM_CX_LOC_HDR] & NSYS_SM_CHKS) || many))";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_jrec_sysex(sptr, ps, syslen, jrecvsys, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (numchan--)";
  z[lc++]="    {";
  z[lc++]="      if (numbytes < NSYS_SM_CH_SIZE)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      chan = ((packet[NSYS_SM_CH_LOC_FLAGS] & NSYS_SM_CH_CHANMASK)";
  z[lc++]="	      >> NSYS_SM_CH_CHANSHIFT);";
  z[lc++]="";
  z[lc++]="      if ((jrecv = sptr->jrecv[chan]) == NULL)";
  z[lc++]="	jrecv = sptr->jrecv[chan] = nsys_netin_newrecv(chan);";
  z[lc++]="";
  z[lc++]="      chapters = packet[NSYS_SM_CH_LOC_TOC];";
  z[lc++]="      chanlen = *((short *)&(packet[NSYS_SM_CH_LOC_FLAGS]));";
  z[lc++]="      chanlen = ntohs((unsigned short)chanlen) & NSYS_SM_CH_LENMASK;";
  z[lc++]="      ";
  z[lc++]="      if ((numbytes -= chanlen) < 0)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      p = packet + NSYS_SM_CH_SIZE;";
  z[lc++]="      packet += chanlen;";
  z[lc++]="";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* chapter P: Program Change */";
  z[lc++]="      /*****************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETP)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CP_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CP_LOC_PROGRAM] & NSYS_SM_CHKS)) || many) && ";
  z[lc++]="	      nsys_netin_jrec_program(sptr, p, jrecv, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CP_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter C: Controllers */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETC)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CC_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen = (p[NSYS_SM_CC_LOC_LENGTH] & NSYS_SM_CLRS) + 1;";
  z[lc++]="";
  z[lc++]="	  if ((chanlen -= loglen*NSYS_SM_CC_LOGSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  if (((!(p[NSYS_SM_CC_LOC_LENGTH] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_control(sptr, p, jrecv, loglen, many,";
  z[lc++]="				      buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += (NSYS_SM_CC_HDRSIZE + loglen*NSYS_SM_CC_LOGSIZE);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*******************************/";
  z[lc++]="      /* chapter M: Parameter System */";
  z[lc++]="      /*******************************/";
  z[lc++]="      ";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETM)";
  z[lc++]="	{";
  z[lc++]="	  if (chanlen < NSYS_SM_CM_HDRSIZE)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  memcpy(&(paramlen), &(p[NSYS_SM_CM_LOC_HDR]), sizeof(short));";
  z[lc++]="	  paramlen = ntohs(paramlen) & NSYS_SM_CM_LENMASK;";
  z[lc++]="	  ";
  z[lc++]="	  if ((chanlen -= paramlen) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_param(sptr, p, jrecv, paramlen, many,";
  z[lc++]="				    buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += paramlen;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter W: Pitch Wheel */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETW)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CW_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CW_LOC_FIRST] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_wheel(sptr, p, jrecv, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CW_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter N: Note On/Off */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETN)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CN_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen = p[NSYS_SM_CN_LOC_LENGTH] & NSYS_SM_CN_CLRB;";
  z[lc++]="	  bflag = !(p[NSYS_SM_CN_LOC_LENGTH] & NSYS_SM_CN_CHKB);";
  z[lc++]="	  low = ((p[NSYS_SM_CN_LOC_LOWHIGH] & NSYS_SM_CN_LOWMASK) >>";
  z[lc++]="		 NSYS_SM_CN_LOWSHIFT);";
  z[lc++]="	  high = (p[NSYS_SM_CN_LOC_LOWHIGH] & NSYS_SM_CN_HIGHMASK);";
  z[lc++]="";
  z[lc++]="	  if ((loglen == 127) && (low == 15) && (high == 0))";
  z[lc++]="	    loglen = 128;";
  z[lc++]="";
  z[lc++]="	  if ((chanlen -= (loglen*NSYS_SM_CN_LOGSIZE + ";
  z[lc++]="			   ((low <= high) ? (high - low + 1) : 0))) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CN_HDRSIZE;";
  z[lc++]="";
  z[lc++]="	  if (loglen)";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_netin_jrec_notelog(sptr, p, jrecv, many, loglen,";
  z[lc++]="					  checkptr, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      p += loglen*NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	    }";
  z[lc++]="	  if ((bflag || many) && (low <= high))";
  z[lc++]="	    {	      ";
  z[lc++]="	      if (nsys_netin_jrec_bitfield(sptr, p, jrecv, low, high,";
  z[lc++]="					   buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  p += (low <= high) ? (high - low + 1) : 0;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter E: Note Extras */";
  z[lc++]="      /**************************/";
  z[lc++]="      ";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETE)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CE_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  loglen = (p[NSYS_SM_CE_LOC_LENGTH] & NSYS_SM_CLRS) + 1;";
  z[lc++]="	  ";
  z[lc++]="	  if ((chanlen -= loglen*NSYS_SM_CE_LOGSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  p += (NSYS_SM_CE_HDRSIZE + loglen*NSYS_SM_CE_LOGSIZE);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /****************************/";
  z[lc++]="      /* chapter T: Channel Touch */";
  z[lc++]="      /****************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETT)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CT_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CT_LOC_PRESSURE] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_ctouch(sptr, p, jrecv, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CT_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter A: Poly Touch */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETA)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CA_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  loglen = (p[NSYS_SM_CA_LOC_LENGTH] & NSYS_SM_CLRS) + 1;";
  z[lc++]="";
  z[lc++]="	  if ((chanlen -= loglen*NSYS_SM_CA_LOGSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CA_LOC_LENGTH] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_ptouch(sptr, p, jrecv, loglen, many,";
  z[lc++]="				     buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += (NSYS_SM_CA_HDRSIZE + loglen*NSYS_SM_CA_LOGSIZE);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="    {";
  z[lc++]="      printf(\"recovery (fill: %li):\", (*fill));";
  z[lc++]="      for (i = 0; j + i < (*fill); i++)";
  z[lc++]="	printf(\" %hhu\", buff[j + i]);";
  z[lc++]="      printf(\"\\n\");";
  z[lc++]="      fflush(stdout);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            receiver state: add a new MIDI event              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_journal_trackstate(nsys_source * sptr, unsigned char cmd,";
  z[lc++]="				   unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_netout_jrecv_state * jrecv;";
  z[lc++]="  nsys_netout_jrecv_system_state * jrecvsys;";
  z[lc++]="  long song_pp;";
  z[lc++]="";
  z[lc++]="  if (cmd < CSYS_MIDI_NOTEOFF)      /* SysEx */";
  z[lc++]="    {";
  z[lc++]="      if ((jrecvsys = sptr->jrecvsys) == NULL)";
  z[lc++]="	jrecvsys = sptr->jrecvsys = nsys_netin_newrecvsys();";
  z[lc++]="";
  z[lc++]="      switch (cmd) {";
  z[lc++]="      case CSYS_MIDI_GMRESET:";
  z[lc++]="	nsys_netin_journal_clear_active(cmd);";
  z[lc++]="	jrecvsys->chapterx_gmreset = ndata | NSYS_SM_RV_SETF;";
  z[lc++]="	if (ndata == NSYS_SM_CX_GMRESET_ONVAL)";
  z[lc++]="	  jrecvsys->chapterx_gmreset_on_count++;";
  z[lc++]="	else";
  z[lc++]="	  jrecvsys->chapterx_gmreset_off_count++; ";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_MVOLUME:";
  z[lc++]="	jrecvsys->chapterx_mvolume_lsb = ndata | NSYS_SM_RV_SETF;";
  z[lc++]="	jrecvsys->chapterx_mvolume_msb = vdata;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      return;                      ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (cmd < ((unsigned char) CSYS_MIDI_SYSTEM))";
  z[lc++]="    {";
  z[lc++]="      if ((jrecv = sptr->jrecv[cmd & 0x0F]) == NULL)";
  z[lc++]="	jrecv = sptr->jrecv[cmd & 0x0F] = nsys_netin_newrecv(cmd & 0x0F);";
  z[lc++]="";
  z[lc++]="      switch (cmd & 0xF0) {";
  z[lc++]="";
  z[lc++]="      case CSYS_MIDI_PROGRAM:";
  z[lc++]="	jrecv->chapterp_program = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="	jrecv->chapterp_bank_msb = NSYS_SM_RV_CLRF & ";
  z[lc++]="	  jrecv->chapterc_value[CSYS_MIDI_CC_BANKSELECT_MSB];";
  z[lc++]="	jrecv->chapterp_bank_lsb = NSYS_SM_RV_CLRF & ";
  z[lc++]="	  jrecv->chapterc_value[CSYS_MIDI_CC_BANKSELECT_LSB];";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      case CSYS_MIDI_CC:";
  z[lc++]="	switch (ndata) {";
  z[lc++]="	case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="	case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="	case CSYS_MIDI_CC_RESETALLCONTROL:";
  z[lc++]="	case CSYS_MIDI_CC_OMNI_OFF:";
  z[lc++]="	case CSYS_MIDI_CC_OMNI_ON:";
  z[lc++]="	case CSYS_MIDI_CC_MONOMODE:";
  z[lc++]="	case CSYS_MIDI_CC_POLYMODE:";
  z[lc++]="	  jrecv->chapterc_value[ndata] = NSYS_SM_RV_SETF | ";
  z[lc++]="	    (((jrecv->chapterc_value[ndata] & NSYS_SM_CC_ALTMOD) + 1)";
  z[lc++]="	     & NSYS_SM_CC_ALTMOD);";
  z[lc++]="	  switch (ndata) {";
  z[lc++]="	  case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="	  case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="	  case CSYS_MIDI_CC_OMNI_OFF:";
  z[lc++]="	  case CSYS_MIDI_CC_OMNI_ON:";
  z[lc++]="	  case CSYS_MIDI_CC_MONOMODE:";
  z[lc++]="	  case CSYS_MIDI_CC_POLYMODE:";
  z[lc++]="	    memset(jrecv->chaptern_ref, 0, NSYS_SM_CN_ARRAYSIZE);";
  z[lc++]="	    jrecv->chaptert_pressure = 0;";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_CC_RESETALLCONTROL:";
  z[lc++]="";
  z[lc++]="	    /* Chapter C -- update pedal count */";
  z[lc++]="";
  z[lc++]="	    jrecv->chapterc_value[CSYS_MIDI_CC_SUSTAIN] = NSYS_SM_RV_SETF |";
  z[lc++]="	      (((jrecv->chapterc_value[CSYS_MIDI_CC_SUSTAIN] & NSYS_SM_CC_ALTMOD) + 1)";
  z[lc++]="	       & NSYS_SM_CC_ALTMOD);";
  z[lc++]="";
  z[lc++]="	    /* Clear parameter transaction system */";
  z[lc++]="";
  z[lc++]="	    jrecv->chapterm_nrpn_msb = jrecv->chapterm_nrpn_lsb = 0;";
  z[lc++]="	    jrecv->chapterm_rpn_msb = jrecv->chapterm_rpn_lsb = 0;";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="";
  z[lc++]="	    /* Clear parameter system C-BUTTON counts */";
  z[lc++]="";
  z[lc++]="	    memset(jrecv->chapterm_cbutton, 0, sizeof(short)*NSYS_SM_CM_ARRAYSIZE);";
  z[lc++]="";
  z[lc++]="	    /* C-active Chapters:  W, T, and A */";
  z[lc++]="";
  z[lc++]="	    jrecv->chapterw_first = 0;";
  z[lc++]="	    jrecv->chapterw_second = 0;";
  z[lc++]="	    memset(jrecv->chaptera_pressure, 0, NSYS_SM_CA_ARRAYSIZE);";
  z[lc++]="	    jrecv->chaptert_pressure = 0;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_SUSTAIN:";
  z[lc++]="	  if (((vdata >= 64) && !(jrecv->chapterc_value[ndata] & 0x01))";
  z[lc++]="	      || ((vdata < 64) && (jrecv->chapterc_value[ndata] & 0x01)))";
  z[lc++]="	    {";
  z[lc++]="	      jrecv->chapterc_value[ndata] = NSYS_SM_RV_SETF |";
  z[lc++]="		(((jrecv->chapterc_value[ndata] & NSYS_SM_CC_ALTMOD) + 1)";
  z[lc++]="		 & NSYS_SM_CC_ALTMOD);";
  z[lc++]="	    }";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_RPN_MSB:";
  z[lc++]="	  jrecv->chapterm_state = NSYS_SM_CM_STATE_PENDING_RPN;";
  z[lc++]="	  jrecv->chapterm_rpn_msb = vdata;";
  z[lc++]="	  jrecv->chapterm_rpn_lsb = 0;";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_NRPN_MSB:";
  z[lc++]="	  jrecv->chapterm_state = NSYS_SM_CM_STATE_PENDING_NRPN;";
  z[lc++]="	  jrecv->chapterm_nrpn_msb = vdata;";
  z[lc++]="	  jrecv->chapterm_nrpn_lsb = 0;";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_RPN_LSB:";
  z[lc++]="	  if ((jrecv->chapterm_rpn_msb == CSYS_MIDI_RPN_NULL_MSB) &&";
  z[lc++]="	      (vdata == CSYS_MIDI_RPN_NULL_LSB))";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="	  else";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_RPN;";
  z[lc++]="	  jrecv->chapterm_rpn_lsb = vdata;";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_NRPN_LSB:";
  z[lc++]="	  if ((jrecv->chapterm_nrpn_msb == CSYS_MIDI_NRPN_NULL_MSB) &&";
  z[lc++]="	      (vdata == CSYS_MIDI_NRPN_NULL_LSB))";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="	  else";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="	  jrecv->chapterm_nrpn_lsb = vdata;";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_DATAENTRY_MSB:";
  z[lc++]="	case CSYS_MIDI_CC_DATAENTRY_LSB:";
  z[lc++]="	  switch(jrecv->chapterm_state) {";
  z[lc++]="	  case NSYS_SM_CM_STATE_OFF:   ";
  z[lc++]="	    jrecv->chapterc_value[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="	    break;    ";
  z[lc++]="	  case NSYS_SM_CM_STATE_PENDING_NRPN: ";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="	    break;";
  z[lc++]="	  case NSYS_SM_CM_STATE_NRPN:";
  z[lc++]="	    break;";
  z[lc++]="	  case NSYS_SM_CM_STATE_PENDING_RPN:";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_RPN; /* fall through */";
  z[lc++]="	  case NSYS_SM_CM_STATE_RPN:";
  z[lc++]="	    if ((jrecv->chapterm_rpn_msb == 0) && ";
  z[lc++]="		(jrecv->chapterm_rpn_lsb < NSYS_SM_CM_ARRAYSIZE))";
  z[lc++]="	      {";
  z[lc++]="		if (ndata == CSYS_MIDI_CC_DATAENTRY_LSB)";
  z[lc++]="		  jrecv->chapterm_value_lsb[jrecv->chapterm_rpn_lsb] = vdata;";
  z[lc++]="		else";
  z[lc++]="		  {";
  z[lc++]="		    jrecv->chapterm_value_msb[jrecv->chapterm_rpn_lsb] = vdata;";
  z[lc++]="		    jrecv->chapterm_value_lsb[jrecv->chapterm_rpn_lsb] = 0;";
  z[lc++]="		  }";
  z[lc++]="		jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb] = 0;";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC_DATAENTRYPLUS:";
  z[lc++]="	case CSYS_MIDI_CC_DATAENTRYMINUS:";
  z[lc++]="	  switch(jrecv->chapterm_state) {";
  z[lc++]="	  case NSYS_SM_CM_STATE_OFF:   ";
  z[lc++]="	    jrecv->chapterc_value[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="	    break;    ";
  z[lc++]="	  case NSYS_SM_CM_STATE_PENDING_NRPN: ";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="	    break;";
  z[lc++]="	  case NSYS_SM_CM_STATE_NRPN:";
  z[lc++]="	    break;";
  z[lc++]="	  case NSYS_SM_CM_STATE_PENDING_RPN: ";
  z[lc++]="	    jrecv->chapterm_state = NSYS_SM_CM_STATE_RPN;  /* fall through */";
  z[lc++]="	    break;";
  z[lc++]="	  case NSYS_SM_CM_STATE_RPN:";
  z[lc++]="	    if ((jrecv->chapterm_rpn_msb == 0) && ";
  z[lc++]="		(jrecv->chapterm_rpn_lsb < NSYS_SM_CM_ARRAYSIZE))";
  z[lc++]="	      {";
  z[lc++]="		if (ndata == CSYS_MIDI_CC_DATAENTRYPLUS)";
  z[lc++]="		  jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb]++;";
  z[lc++]="		else";
  z[lc++]="		  jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb]--;";
  z[lc++]="		";
  z[lc++]="		if (jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb] > ";
  z[lc++]="		    NSYS_SM_CM_BUTTON_LIMIT)";
  z[lc++]="		  jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb] =";
  z[lc++]="		    NSYS_SM_CM_BUTTON_LIMIT;";
  z[lc++]="		else";
  z[lc++]="		  {";
  z[lc++]="		    if (jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb] < ";
  z[lc++]="			- NSYS_SM_CM_BUTTON_LIMIT)";
  z[lc++]="		      jrecv->chapterm_cbutton[jrecv->chapterm_rpn_lsb] =";
  z[lc++]="			- NSYS_SM_CM_BUTTON_LIMIT;";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	  break;";
  z[lc++]="	default:";
  z[lc++]="	  jrecv->chapterc_value[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      case CSYS_MIDI_WHEEL:";
  z[lc++]="	jrecv->chapterw_first = ndata | NSYS_SM_RV_SETF;";
  z[lc++]="	jrecv->chapterw_second = vdata;";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	if (jrecv->chaptern_ref[ndata])";
  z[lc++]="	  {";
  z[lc++]="	    jrecv->chaptern_ref[ndata]--;";
  z[lc++]="	    jrecv->chaptern_vel[ndata] = 0;";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      case CSYS_MIDI_NOTEON:";
  z[lc++]="	if (vdata)";
  z[lc++]="	  {";
  z[lc++]="	    if ((++(jrecv->chaptern_ref[ndata])) == 1)";
  z[lc++]="	      {";
  z[lc++]="		jrecv->chaptern_vel[ndata] = vdata;";
  z[lc++]="		jrecv->chaptern_tstamp[ndata] = nsys_netout_tstamp;";
  z[lc++]="		jrecv->chaptern_extseq[ndata] = sptr->hi_ext;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		jrecv->chaptern_vel[ndata] = 0;";
  z[lc++]="		";
  z[lc++]="		if ((jrecv->chaptern_ref[ndata]) == 0)";
  z[lc++]="		  jrecv->chaptern_ref[ndata] = 255;";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  if (jrecv->chaptern_ref[ndata])";
  z[lc++]="	    {";
  z[lc++]="	      jrecv->chaptern_ref[ndata]--;";
  z[lc++]="	      jrecv->chaptern_vel[ndata] = 0;";
  z[lc++]="	    }";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      case CSYS_MIDI_CTOUCH:";
  z[lc++]="	jrecv->chaptert_pressure = ndata | NSYS_SM_RV_SETF;";
  z[lc++]="	break;";
  z[lc++]="	";
  z[lc++]="      case CSYS_MIDI_PTOUCH:";
  z[lc++]="	jrecv->chaptera_pressure[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if ((jrecvsys = sptr->jrecvsys) == NULL)";
  z[lc++]="	jrecvsys = sptr->jrecvsys = nsys_netin_newrecvsys();";
  z[lc++]="";
  z[lc++]="      switch (cmd) {";
  z[lc++]="      case CSYS_MIDI_SYSTEM_RESET:";
  z[lc++]="	nsys_netin_journal_clear_active(cmd);";
  z[lc++]="	jrecvsys->chapterd_reset = NSYS_SM_RV_CLRF & (jrecvsys->chapterd_reset + 1);";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_TUNE_REQUEST:";
  z[lc++]="	jrecvsys->chapterd_tune = NSYS_SM_RV_CLRF & (jrecvsys->chapterd_tune + 1);";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SONG_SELECT:";
  z[lc++]="	jrecvsys->chapterd_song = ndata;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_TICK:";
  z[lc++]="	jrecvsys->chapterd_rty++;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED3:";
  z[lc++]="	jrecvsys->chapterd_rtz++;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_QFRAME:";
  z[lc++]="	nsys_netin_track_timecode(jrecvsys, ndata);";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED1:";
  z[lc++]="	jrecvsys->chapterd_scj_count++;";
  z[lc++]="	jrecvsys->chapterd_scj_data1 = ndata;";
  z[lc++]="	jrecvsys->chapterd_scj_data2 = vdata;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED2:";
  z[lc++]="	jrecvsys->chapterd_sck_count++;";
  z[lc++]="	jrecvsys->chapterd_sck_data1 = ndata;";
  z[lc++]="	jrecvsys->chapterd_sck_data2 = vdata;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CLOCK:  ";
  z[lc++]="	if (!(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKD))";
  z[lc++]="	  jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETD;";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    if (!(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	      {";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETC;";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS + 1] = 0;";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS] = 0;";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	      }";
  z[lc++]="	    if (!(++(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS + 1])))";
  z[lc++]="	      if (!(++(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS])))";
  z[lc++]="		{";
  z[lc++]="		  if ((jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] ";
  z[lc++]="		       & NSYS_SM_CQ_TOP_MASK) != NSYS_SM_CQ_TOP_MASK)";
  z[lc++]="		    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR]++;";
  z[lc++]="		  else";
  z[lc++]="		    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &=";
  z[lc++]="		      ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="		}";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_START:";
  z[lc++]="	jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] = NSYS_SM_CQ_HDR_SETN;  /* C=D=0 */";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CONTINUE:";
  z[lc++]="	jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETN;";
  z[lc++]="	if (jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKD)";
  z[lc++]="	  {";
  z[lc++]="	    if (!(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	      {";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETC;";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS + 1] = 0;";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS] = 0;";
  z[lc++]="		jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	      }";
  z[lc++]="	    if (!(++(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS + 1])))";
  z[lc++]="	      if (!(++(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS])))";
  z[lc++]="		{";
  z[lc++]="		  if ((jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] ";
  z[lc++]="		       & NSYS_SM_CQ_TOP_MASK) != NSYS_SM_CQ_TOP_MASK)";
  z[lc++]="		    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR]++;";
  z[lc++]="		  else";
  z[lc++]="		    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &=";
  z[lc++]="		      ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="		}";
  z[lc++]="	    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRD;";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_STOP:";
  z[lc++]="	jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRN;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SONG_PP:";
  z[lc++]="	if ((song_pp = 6*((vdata << 7) + ndata)))";
  z[lc++]="	  {";
  z[lc++]="	    if (!(jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	      jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] |= NSYS_SM_CQ_HDR_SETC;";
  z[lc++]="	    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS + 1] = ";
  z[lc++]="	      (unsigned char) (song_pp & 0x000000FF);";
  z[lc++]="	    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS] = ";
  z[lc++]="	      (unsigned char) ((song_pp >> 8) & 0x000000FF);";
  z[lc++]="	    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= ~(NSYS_SM_CQ_TOP_MASK);";
  z[lc++]="	    if (song_pp > NSYS_SM_CQ_BOTTOM_MASK)";
  z[lc++]="	      jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] |= 0x01;  /* range limit */";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  if ((jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC))";
  z[lc++]="	    jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRC;";
  z[lc++]="	jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] &= NSYS_SM_CQ_HDR_CLRD;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SENSE:";
  z[lc++]="	jrecvsys->chapterv_count = NSYS_SM_RV_CLRF & (jrecvsys->chapterv_count + 1);";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 second-level receiver functions              */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter P (program change)             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_program(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			  nsys_netout_jrecv_state * jrecv,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy, vel, yflag;";
  z[lc++]="";
  z[lc++]="  vel = (p[NSYS_SM_CP_LOC_PROGRAM] & NSYS_SM_CLRS);";
  z[lc++]="  newx = (p[NSYS_SM_CP_LOC_BANKMSB] & NSYS_SM_CP_CLRB);";
  z[lc++]="  newy = (p[NSYS_SM_CP_LOC_BANKLSB] & NSYS_SM_CP_CLRX);";
  z[lc++]="  ";
  z[lc++]="  if ((jrecv->chapterp_program == 0) || ";
  z[lc++]="      (newx != jrecv->chapterp_bank_msb) || ";
  z[lc++]="      (newy != jrecv->chapterp_bank_lsb) ||";
  z[lc++]="      (vel != (jrecv->chapterp_program & NSYS_SM_RV_CLRF)))";
  z[lc++]="    {";
  z[lc++]="      yflag = ((newx != (NSYS_SM_CLRS & jrecv->chapterc_value";
  z[lc++]="			 [CSYS_MIDI_CC_BANKSELECT_MSB])) ||";
  z[lc++]="	       (newy != (NSYS_SM_CLRS & jrecv->chapterc_value";
  z[lc++]="			 [CSYS_MIDI_CC_BANKSELECT_LSB])) ||";
  z[lc++]="	       (jrecv->chapterc_value";
  z[lc++]="		[CSYS_MIDI_CC_BANKSELECT_MSB] == 0) ||";
  z[lc++]="	       (jrecv->chapterc_value";
  z[lc++]="		[CSYS_MIDI_CC_BANKSELECT_LSB] == 0));";
  z[lc++]="      ";
  z[lc++]="      /* if needed, change bank-switch values */";
  z[lc++]="      ";
  z[lc++]="      if (yflag)";
  z[lc++]="	{			  ";
  z[lc++]="	  if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_MSB";
  z[lc++]="					, newx)) ";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_LSB";
  z[lc++]="					, newy))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      /* do program change */";
  z[lc++]="      ";
  z[lc++]="      if (nsys_netin_journal_addcmd_two(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_PROGRAM, vel))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      /* if changed, reset bank-switch values */";
  z[lc++]="      ";
  z[lc++]="      if (yflag)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_MSB";
  z[lc++]="					, jrecv->chapterc_value";
  z[lc++]="					[CSYS_MIDI_CC_BANKSELECT_MSB])) ";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_LSB";
  z[lc++]="					, jrecv->chapterc_value";
  z[lc++]="					[CSYS_MIDI_CC_BANKSELECT_LSB]))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"PChange %hhu [%hhu,%hhu] --> %hhu [%hhu, %hhu]\\n\",";
  z[lc++]="	       jrecv->chapterp_program & NSYS_SM_RV_CLRF,";
  z[lc++]="	       jrecv->chapterp_bank_msb, jrecv->chapterp_bank_lsb,";
  z[lc++]="	       vel, newx, newy);";
  z[lc++]="      ";
  z[lc++]="      jrecv->chapterp_program = vel | NSYS_SM_RV_SETF;";
  z[lc++]="      jrecv->chapterp_bank_msb = newx ;";
  z[lc++]="      jrecv->chapterp_bank_lsb = newy ;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter C (controllers)                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_control(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			    nsys_netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="			    unsigned char many, unsigned char * buff, ";
  z[lc++]="			    long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy, cancel;";
  z[lc++]="  int unexpected = 0;";
  z[lc++]="  int update = 0;";
  z[lc++]="";
  z[lc++]="  p += NSYS_SM_CC_HDRSIZE;";
  z[lc++]="  while (loglen)";
  z[lc++]="    {";
  z[lc++]="      if ((!(p[NSYS_SM_CC_LOC_LNUM] & NSYS_SM_CHKS)) || many)";
  z[lc++]="	{";
  z[lc++]="	  newx = p[NSYS_SM_CC_LOC_LNUM] & NSYS_SM_CLRS;";
  z[lc++]="	  newy = p[NSYS_SM_CC_LOC_LVAL];";
  z[lc++]="";
  z[lc++]="	  switch (newx) {   ";
  z[lc++]="	  case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="	  case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="	  case CSYS_MIDI_CC_RESETALLCONTROL:";
  z[lc++]="	  case CSYS_MIDI_CC_OMNI_OFF:";
  z[lc++]="	  case CSYS_MIDI_CC_OMNI_ON:";
  z[lc++]="	  case CSYS_MIDI_CC_MONOMODE:";
  z[lc++]="	  case CSYS_MIDI_CC_POLYMODE:";
  z[lc++]="	    if ((newy & NSYS_SM_CC_CHKA) && !(newy & NSYS_SM_CC_CHKT))";
  z[lc++]="	      {";
  z[lc++]="		update = ((jrecv->chapterc_value[newx] == 0) || ";
  z[lc++]="			  ((jrecv->chapterc_value[newx] & NSYS_SM_RV_CLRF) !=";
  z[lc++]="			   (newy & NSYS_SM_CC_ALTMOD)));";
  z[lc++]="";
  z[lc++]="		if (update)";
  z[lc++]="		  {";
  z[lc++]="		    jrecv->chapterc_value[newx] = ((newy & NSYS_SM_CC_ALTMOD)";
  z[lc++]="						   | NSYS_SM_RV_SETF);";
  z[lc++]="		    newy = 0;";
  z[lc++]="";
  z[lc++]="		    switch (newx) {";
  z[lc++]="		    case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="		    case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="		    case CSYS_MIDI_CC_OMNI_OFF:";
  z[lc++]="		    case CSYS_MIDI_CC_OMNI_ON:";
  z[lc++]="		    case CSYS_MIDI_CC_MONOMODE:";
  z[lc++]="		    case CSYS_MIDI_CC_POLYMODE:";
  z[lc++]="		      memset(jrecv->chaptern_ref, 0, NSYS_SM_CN_ARRAYSIZE);";
  z[lc++]="		      jrecv->chaptert_pressure = 0;";
  z[lc++]="		      break;";
  z[lc++]="		    case CSYS_MIDI_CC_RESETALLCONTROL:";
  z[lc++]="";
  z[lc++]="		      /* Chapter C -- update pedal count */";
  z[lc++]="		      ";
  z[lc++]="		      jrecv->chapterc_value[CSYS_MIDI_CC_SUSTAIN] = NSYS_SM_RV_SETF |";
  z[lc++]="			(((jrecv->chapterc_value[CSYS_MIDI_CC_SUSTAIN] ";
  z[lc++]="			   & NSYS_SM_CC_ALTMOD) + 1) & NSYS_SM_CC_ALTMOD);";
  z[lc++]="";
  z[lc++]="		      /* Clear parameter transaction system */";
  z[lc++]="		      ";
  z[lc++]="		      jrecv->chapterm_nrpn_msb = jrecv->chapterm_nrpn_lsb = 0;";
  z[lc++]="		      jrecv->chapterm_rpn_msb = jrecv->chapterm_rpn_lsb = 0;";
  z[lc++]="		      jrecv->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="";
  z[lc++]="		      /* Clear parameter system C-BUTTON counts */";
  z[lc++]="";
  z[lc++]="		      memset(jrecv->chapterm_cbutton, 0, ";
  z[lc++]="			     sizeof(short)*NSYS_SM_CM_ARRAYSIZE);";
  z[lc++]="";
  z[lc++]="		      /* C-active Chapters:  W, T, and A */";
  z[lc++]="		      ";
  z[lc++]="		      jrecv->chapterw_first = 0;";
  z[lc++]="		      jrecv->chapterw_second = 0;";
  z[lc++]="		      memset(jrecv->chaptera_pressure, 0, NSYS_SM_CA_ARRAYSIZE);";
  z[lc++]="		      jrecv->chaptert_pressure = 0;";
  z[lc++]="		      break;";
  z[lc++]="		    }";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      unexpected = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_CC_SUSTAIN:";
  z[lc++]="	    if ((newy & NSYS_SM_CC_CHKA) && (newy & NSYS_SM_CC_CHKT))";
  z[lc++]="	      {";
  z[lc++]="		update = ((jrecv->chapterc_value[newx] == 0) || ";
  z[lc++]="			  ((jrecv->chapterc_value[newx] & NSYS_SM_RV_CLRF) !=";
  z[lc++]="			   (newy & NSYS_SM_CC_ALTMOD)));";
  z[lc++]="";
  z[lc++]="		if (update)";
  z[lc++]="		  {";
  z[lc++]="		    cancel = (newy & 0x01) & (jrecv->chapterc_value[newx] & 1);";
  z[lc++]="";
  z[lc++]="		    jrecv->chapterc_value[newx] = ((newy & NSYS_SM_CC_ALTMOD)";
  z[lc++]="						   | NSYS_SM_RV_SETF);";
  z[lc++]="		    newy = (newy & 0x01) ? 64 : 0;";
  z[lc++]="";
  z[lc++]="		    if (cancel)";
  z[lc++]="		      {";
  z[lc++]="			if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="						      jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="						      newx, 0))";
  z[lc++]="			  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      ";
  z[lc++]="			if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="			  printf(\"CntrlLog %hhu: cancel sustain pedal\\n\", newx);";
  z[lc++]="		      }";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      unexpected = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  default:";
  z[lc++]="	    if (!(newy & NSYS_SM_CC_CHKA))";
  z[lc++]="	      {";
  z[lc++]="		update = (jrecv->chapterc_value[newx] == 0) || ";
  z[lc++]="		  ((jrecv->chapterc_value[newx] & NSYS_SM_RV_CLRF) != newy);";
  z[lc++]="";
  z[lc++]="		if (update)";
  z[lc++]="		  jrecv->chapterc_value[newx] = newy | NSYS_SM_RV_SETF;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      unexpected = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	  if (update && unexpected)";
  z[lc++]="	    unexpected = update = 0;   /* unexpected log format -- do later */";
  z[lc++]="";
  z[lc++]="	  if (update)";
  z[lc++]="	    {";
  z[lc++]="	      update = 0;";
  z[lc++]="";
  z[lc++]="	      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					    jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					    newx, newy))";
  z[lc++]="		  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"CntrlLog %hhu: --> %hhu\\n\", newx, newy);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      loglen--;";
  z[lc++]="      p += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter M (parameters)                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_param(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			  nsys_netout_jrecv_state * jrecv, ";
  z[lc++]="			  short paramlen, unsigned char many, ";
  z[lc++]="			  unsigned char * buff, long * fill,";
  z[lc++]="			  long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char msb_num, lsb_num, msb_val, lsb_val, toc;";
  z[lc++]="  int has_j, has_k, has_l, has_m, has_n;";
  z[lc++]="  short cbutton;";
  z[lc++]="  int i, rpnlog, rpnlast, final_state, skip, adjust, val_eq, button_eq;";
  z[lc++]="  int repair = 0;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* repair RTP values */";
  z[lc++]="  /*___________________*/";
  z[lc++]="";
  z[lc++]="  rpnlast = NSYS_SM_CM_TRANS_NONE;";
  z[lc++]="  msb_num = lsb_num = 0;";
  z[lc++]="  adjust = 0;";
  z[lc++]="";
  z[lc++]="  if (p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKP)";
  z[lc++]="    i = NSYS_SM_CM_HDRSIZE + NSYS_SM_CM_PENDINGSIZE;";
  z[lc++]="  else";
  z[lc++]="    i = NSYS_SM_CM_HDRSIZE;";
  z[lc++]="";
  z[lc++]="  if ((p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKZ) &&";
  z[lc++]="      ((p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKU) ||";
  z[lc++]="       (p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKW)))";
  z[lc++]="    adjust = 1;";
  z[lc++]="";
  z[lc++]="  rpnlast = (p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKU) ?";
  z[lc++]="    NSYS_SM_CM_TRANS_RPN : NSYS_SM_CM_TRANS_NRPN;";
  z[lc++]="";
  z[lc++]="  while (i + NSYS_SM_CM_LOGHDRSIZE - adjust <= paramlen)";
  z[lc++]="    {";
  z[lc++]="      skip = (p[i + NSYS_SM_CM_LOC_PNUMLSB] & NSYS_SM_CHKS) && !many;";
  z[lc++]="      lsb_num = p[i + NSYS_SM_CM_LOC_PNUMLSB] & NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="      if (!adjust)";
  z[lc++]="	{";
  z[lc++]="	  msb_num = p[i + NSYS_SM_CM_LOC_PNUMMSB] & NSYS_SM_CM_CLRQ;";
  z[lc++]="	  rpnlast = (p[i + NSYS_SM_CM_LOC_PNUMMSB] & NSYS_SM_CM_CHKQ) ?";
  z[lc++]="	    NSYS_SM_CM_TRANS_NRPN : NSYS_SM_CM_TRANS_RPN;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      toc = p[i + NSYS_SM_CM_LOC_TOC - adjust];";
  z[lc++]="";
  z[lc++]="      has_j = toc & NSYS_SM_CM_TOC_CHKJ;";
  z[lc++]="      has_k = toc & NSYS_SM_CM_TOC_CHKK;";
  z[lc++]="      has_l = toc & NSYS_SM_CM_TOC_CHKL;";
  z[lc++]="      has_m = toc & NSYS_SM_CM_TOC_CHKM;";
  z[lc++]="      has_n = toc & NSYS_SM_CM_TOC_CHKN;";
  z[lc++]="";
  z[lc++]="      i += (NSYS_SM_CM_LOGHDRSIZE - adjust);";
  z[lc++]="";
  z[lc++]="      if (skip || (rpnlast != NSYS_SM_CM_TRANS_RPN) || msb_num ";
  z[lc++]="	  || (lsb_num >= NSYS_SM_CM_ARRAYSIZE) || ";
  z[lc++]="	  ! (has_j || has_k || has_m))";
  z[lc++]="	{";
  z[lc++]="	  i += ((has_j ? NSYS_SM_CM_ENTRYMSB_SIZE : 0) + ";
  z[lc++]="		(has_k ? NSYS_SM_CM_ENTRYLSB_SIZE : 0) +";
  z[lc++]="		(has_l ? NSYS_SM_CM_ABUTTON_SIZE  : 0) +";
  z[lc++]="		(has_m ? NSYS_SM_CM_CBUTTON_SIZE  : 0) +";
  z[lc++]="		(has_n ? NSYS_SM_CM_COUNT_SIZE    : 0));";
  z[lc++]="	  continue;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      msb_val = jrecv->chapterm_value_msb[lsb_num];";
  z[lc++]="      lsb_val = jrecv->chapterm_value_lsb[lsb_num];";
  z[lc++]="      cbutton = jrecv->chapterm_cbutton[lsb_num];";
  z[lc++]="";
  z[lc++]="      if (has_j)";
  z[lc++]="	{";
  z[lc++]="	  if (i < paramlen)";
  z[lc++]="	    {";
  z[lc++]="	      msb_val = p[i] & NSYS_SM_CM_CLRX;";
  z[lc++]="	      if (!has_k)";
  z[lc++]="		lsb_val = 0;";
  z[lc++]="	      if (!has_m)";
  z[lc++]="		cbutton = 0;";
  z[lc++]="	      i += NSYS_SM_CM_ENTRYMSB_SIZE;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED; /* add state repairs */";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (has_k)";
  z[lc++]="	{";
  z[lc++]="	  if (i < paramlen)";
  z[lc++]="	    {";
  z[lc++]="	      lsb_val = p[i] & NSYS_SM_CM_CLRX;";
  z[lc++]="	      if (!has_m)";
  z[lc++]="		cbutton = 0;";
  z[lc++]="	      i += NSYS_SM_CM_ENTRYLSB_SIZE;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED; /* add state repairs */";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (has_l)";
  z[lc++]="	i += NSYS_SM_CM_ABUTTON_SIZE;";
  z[lc++]="";
  z[lc++]="      if (has_m)";
  z[lc++]="	{";
  z[lc++]="	  if ((i + 1) < paramlen)";
  z[lc++]="	    {";
  z[lc++]="	      cbutton = p[i] & (NSYS_SM_CM_BUTTON_CLRX & NSYS_SM_CM_BUTTON_CLRG);";
  z[lc++]="	      cbutton = (cbutton << 8) + p[i+1];";
  z[lc++]="	      if (p[i] & NSYS_SM_CM_BUTTON_CHKG)";
  z[lc++]="		cbutton = - cbutton;";
  z[lc++]="	      i += NSYS_SM_CM_CBUTTON_SIZE;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED; /* add state repairs */";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (has_n)";
  z[lc++]="	i += NSYS_SM_CM_COUNT_SIZE;";
  z[lc++]="";
  z[lc++]="      if (i > paramlen)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED; /* add state repairs */";
  z[lc++]="";
  z[lc++]="      val_eq = ((msb_val == jrecv->chapterm_value_msb[lsb_num]) && ";
  z[lc++]="		(lsb_val == jrecv->chapterm_value_lsb[lsb_num]));";
  z[lc++]="";
  z[lc++]="      button_eq = (cbutton == jrecv->chapterm_cbutton[lsb_num]);";
  z[lc++]="";
  z[lc++]="      if (val_eq && button_eq)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      repair = 1;";
  z[lc++]="";
  z[lc++]="      if (!val_eq)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="				       rpnlast, msb_num, lsb_num, msb_val, lsb_val))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;  /* add state repairs */";
  z[lc++]="";
  z[lc++]="	  if (has_m && cbutton)";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_netin_journal_button_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="						  rpnlast, msb_num, lsb_num, cbutton))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;  /* add state repairs */";
  z[lc++]="";
  z[lc++]="	    if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	      printf(\"RPN-Log %hhu: --> (%hhu, %hhu) delta %hi\\n\", lsb_num, ";
  z[lc++]="		     msb_val, lsb_val, cbutton);";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	      printf(\"RPN-Log %hhu: --> (%hhu, %hhu)\\n\", lsb_num, msb_val, lsb_val);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_button_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="					      rpnlast, msb_num, lsb_num, cbutton -";
  z[lc++]="					      jrecv->chapterm_cbutton[lsb_num]))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;  /* add state repairs */";
  z[lc++]="";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    printf(\"RPN-Log %hhu: --> delta %hi\\n\", lsb_num, ";
  z[lc++]="		   cbutton - jrecv->chapterm_cbutton[lsb_num]);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* determine final state */";
  z[lc++]="  /*_______________________*/";
  z[lc++]="";
  z[lc++]="  if (p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKP)";
  z[lc++]="    {";
  z[lc++]="      if (p[NSYS_SM_CM_LOC_PENDING] & NSYS_SM_CM_PENDING_CHKQ)";
  z[lc++]="	final_state = NSYS_SM_CM_STATE_PENDING_NRPN;";
  z[lc++]="      else";
  z[lc++]="	final_state = NSYS_SM_CM_STATE_PENDING_RPN;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (p[NSYS_SM_CM_LOC_HDR] & NSYS_SM_CM_HDR_CHKE)";
  z[lc++]="	{";
  z[lc++]="	  switch (rpnlast) {";
  z[lc++]="	    case NSYS_SM_CM_TRANS_RPN:";
  z[lc++]="	      final_state = NSYS_SM_CM_STATE_RPN;";
  z[lc++]="	      break;";
  z[lc++]="	    case NSYS_SM_CM_TRANS_NRPN:";
  z[lc++]="	      final_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="	      break;";
  z[lc++]="	  default:";
  z[lc++]="	    switch (jrecv->chapterm_state) {    /* should never run */";
  z[lc++]="	    case NSYS_SM_CM_STATE_PENDING_NRPN:";
  z[lc++]="	    case NSYS_SM_CM_STATE_NRPN:";
  z[lc++]="	      final_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="	      lsb_num = jrecv->chapterm_nrpn_lsb;";
  z[lc++]="	      msb_num = jrecv->chapterm_nrpn_msb;";
  z[lc++]="	      break;";
  z[lc++]="	    default:";
  z[lc++]="	      final_state = NSYS_SM_CM_STATE_RPN;";
  z[lc++]="	      lsb_num = jrecv->chapterm_rpn_lsb;";
  z[lc++]="	      msb_num = jrecv->chapterm_rpn_msb;";
  z[lc++]="	      break;";
  z[lc++]="	    }";
  z[lc++]="	  }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	final_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* exit if no changes */";
  z[lc++]="  /*____________________*/";
  z[lc++]="";
  z[lc++]="  if ((repair == 0) && (final_state == jrecv->chapterm_state))";
  z[lc++]="    {";
  z[lc++]="      switch (final_state) {";
  z[lc++]="      case NSYS_SM_CM_STATE_OFF:";
  z[lc++]="	return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="      case NSYS_SM_CM_STATE_RPN:";
  z[lc++]="	if ((lsb_num == jrecv->chapterm_rpn_lsb)";
  z[lc++]="	    && (msb_num == jrecv->chapterm_rpn_msb))";
  z[lc++]="	  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_SM_CM_STATE_PENDING_RPN:";
  z[lc++]="	if ((p[NSYS_SM_CM_LOC_PENDING] & NSYS_SM_CM_PENDING_CLRQ) ";
  z[lc++]="	    == jrecv->chapterm_rpn_msb)";
  z[lc++]="	  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_SM_CM_STATE_NRPN:";
  z[lc++]="	if ((lsb_num == jrecv->chapterm_nrpn_lsb)";
  z[lc++]="	    && (msb_num == jrecv->chapterm_nrpn_msb))";
  z[lc++]="	  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_SM_CM_STATE_PENDING_NRPN:";
  z[lc++]="	if ((p[NSYS_SM_CM_LOC_PENDING] & NSYS_SM_CM_PENDING_CLRQ) ";
  z[lc++]="	    == jrecv->chapterm_rpn_msb)";
  z[lc++]="	  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* do transaction repairs for each state */";
  z[lc++]="  /*_______________________________________*/";
  z[lc++]="";
  z[lc++]="  switch (final_state) {";
  z[lc++]="  case NSYS_SM_CM_STATE_OFF:";
  z[lc++]="    jrecv->chapterm_state = NSYS_SM_CM_STATE_OFF;";
  z[lc++]="    if (!repair)";
  z[lc++]="      {";
  z[lc++]="	rpnlog = (NSYS_SM_CM_TRANS_RPN | NSYS_SM_CM_TRANS_NO_OPEN";
  z[lc++]="		  | NSYS_SM_CM_TRANS_NO_SET);";
  z[lc++]="	if (nsys_netin_journal_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="				     rpnlog, 0, 0, 0, 0))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;   /* add state repairs */";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"ParamLog  --> off-state\\n\");";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_CM_STATE_RPN:";
  z[lc++]="    jrecv->chapterm_state = NSYS_SM_CM_STATE_RPN;";
  z[lc++]="    jrecv->chapterm_rpn_lsb = lsb_num;";
  z[lc++]="    jrecv->chapterm_rpn_msb = msb_num;";
  z[lc++]="    rpnlog = (NSYS_SM_CM_TRANS_RPN | NSYS_SM_CM_TRANS_NO_SET";
  z[lc++]="	      | NSYS_SM_CM_TRANS_NO_CLOSE);";
  z[lc++]="    if (nsys_netin_journal_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="				 rpnlog, msb_num, lsb_num, 0, 0))";
  z[lc++]="      return NSYS_JOURNAL_FILLEDBUFF;  /* add state repairs */";
  z[lc++]="    if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="      printf(\"ParamLog: --> rpn-state (%hhu, %hhu)\\n\", msb_num, lsb_num);";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_CM_STATE_NRPN:";
  z[lc++]="    jrecv->chapterm_state = NSYS_SM_CM_STATE_NRPN;";
  z[lc++]="    jrecv->chapterm_nrpn_lsb = lsb_num;";
  z[lc++]="    jrecv->chapterm_nrpn_msb = msb_num;";
  z[lc++]="    rpnlog = (NSYS_SM_CM_TRANS_NRPN | NSYS_SM_CM_TRANS_NO_SET";
  z[lc++]="	      | NSYS_SM_CM_TRANS_NO_CLOSE);";
  z[lc++]="    if (nsys_netin_journal_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="				 rpnlog, msb_num, lsb_num, 0, 0))";
  z[lc++]="      return NSYS_JOURNAL_FILLEDBUFF;  /* add state repairs */";
  z[lc++]="    if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="      printf(\"ParamLog: --> nrpn-state (%hhu, %hhu)\\n\", msb_num, lsb_num);";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_CM_STATE_PENDING_RPN:";
  z[lc++]="    if (!repair && (jrecv->chapterm_state != NSYS_SM_CM_STATE_OFF))";
  z[lc++]="      {";
  z[lc++]="	if ((jrecv->chapterm_state == NSYS_SM_CM_STATE_PENDING_RPN) || ";
  z[lc++]="	    (jrecv->chapterm_state == NSYS_SM_CM_STATE_RPN))";
  z[lc++]="	  rpnlog = (NSYS_SM_CM_TRANS_RPN | NSYS_SM_CM_TRANS_NO_OPEN";
  z[lc++]="		    | NSYS_SM_CM_TRANS_NO_SET);";
  z[lc++]="	else";
  z[lc++]="	  rpnlog = (NSYS_SM_CM_TRANS_NRPN | NSYS_SM_CM_TRANS_NO_OPEN";
  z[lc++]="		    | NSYS_SM_CM_TRANS_NO_SET);";
  z[lc++]="	";
  z[lc++]="	if (nsys_netin_journal_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="				     rpnlog, 0, 0, 0, 0))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;   /* add state repairs */";
  z[lc++]="      }";
  z[lc++]="      jrecv->chapterm_state = NSYS_SM_CM_STATE_PENDING_RPN;";
  z[lc++]="      jrecv->chapterm_rpn_msb = p[NSYS_SM_CM_LOC_PENDING] & NSYS_SM_CM_PENDING_CLRQ;";
  z[lc++]="      jrecv->chapterm_rpn_lsb = 0;";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="				    CSYS_MIDI_CC_RPN_MSB";
  z[lc++]="				    , jrecv->chapterm_rpn_msb)) ";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF; /* add state repairs */";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"ParamLog: --> rpn-pending (%hhu, 0)\\n\", jrecv->chapterm_rpn_msb);";
  z[lc++]="      break;";
  z[lc++]="  case NSYS_SM_CM_STATE_PENDING_NRPN:";
  z[lc++]="    if (!repair && (jrecv->chapterm_state != NSYS_SM_CM_STATE_OFF))";
  z[lc++]="      {";
  z[lc++]="	if ((jrecv->chapterm_state == NSYS_SM_CM_STATE_PENDING_RPN) || ";
  z[lc++]="	    (jrecv->chapterm_state == NSYS_SM_CM_STATE_RPN))";
  z[lc++]="	  rpnlog = (NSYS_SM_CM_TRANS_RPN | NSYS_SM_CM_TRANS_NO_OPEN";
  z[lc++]="		    | NSYS_SM_CM_TRANS_NO_SET);";
  z[lc++]="	else";
  z[lc++]="	  rpnlog = (NSYS_SM_CM_TRANS_NRPN | NSYS_SM_CM_TRANS_NO_OPEN";
  z[lc++]="		    | NSYS_SM_CM_TRANS_NO_SET);";
  z[lc++]="	";
  z[lc++]="	if (nsys_netin_journal_trans(sptr, buff, fill, size, jrecv->chan,";
  z[lc++]="				     rpnlog, 0, 0, 0, 0))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;   /* add state repairs */";
  z[lc++]="      }";
  z[lc++]="      jrecv->chapterm_state = NSYS_SM_CM_STATE_PENDING_NRPN;";
  z[lc++]="      jrecv->chapterm_nrpn_msb = p[NSYS_SM_CM_LOC_PENDING] & NSYS_SM_CM_PENDING_CLRQ;";
  z[lc++]="      jrecv->chapterm_nrpn_lsb = 0;";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="				    CSYS_MIDI_CC_NRPN_MSB,";
  z[lc++]="				    jrecv->chapterm_nrpn_msb)) ";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF; /* add state repairs */";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"ParamLog: --> nrpn-pending (%hhu, 0)\\n\", jrecv->chapterm_nrpn_msb);";
  z[lc++]="      break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter W (pitch wheel)                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_wheel(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			  nsys_netout_jrecv_state * jrecv,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy;";
  z[lc++]="";
  z[lc++]="  newx = p[NSYS_SM_CW_LOC_FIRST] & NSYS_SM_CLRS;";
  z[lc++]="  newy = p[NSYS_SM_CW_LOC_SECOND] & NSYS_SM_CLRS;";
  z[lc++]="  ";
  z[lc++]="  if ((newx != (jrecv->chapterw_first & NSYS_SM_RV_CLRF)) || ";
  z[lc++]="      (newy != jrecv->chapterw_second) || ";
  z[lc++]="      (jrecv->chapterw_first == 0))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_WHEEL,";
  z[lc++]="				    newx, newy))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"PWheel (%hhu, %hhu) --> (%hhu, %hhu)\\n\", ";
  z[lc++]="	       jrecv->chapterw_first & NSYS_SM_CLRS,";
  z[lc++]="	       jrecv->chapterw_second, newx, newy);";
  z[lc++]="      ";
  z[lc++]="      jrecv->chapterw_first = newx | NSYS_SM_RV_SETF;";
  z[lc++]="      jrecv->chapterw_second = newy;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process Note Logs of chapter N                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_notelog(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			    nsys_netout_jrecv_state * jrecv, unsigned char many, ";
  z[lc++]="			    short loglen, unsigned char * checkptr,";
  z[lc++]="			    unsigned char * buff, ";
  z[lc++]="			    long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy, vel, i;";
  z[lc++]="  int yflag, noteon, noteoff, dated, predate;";
  z[lc++]="  unsigned long check_ext;";
  z[lc++]="";
  z[lc++]="  /*********************************************/";
  z[lc++]="  /* prepare extended checkpoint packet number */";
  z[lc++]="  /*********************************************/";
  z[lc++]="  ";
  z[lc++]="  check_ext = ntohs(*((unsigned short *)checkptr)); ";
  z[lc++]="  ";
  z[lc++]="  if (check_ext < sptr->hi_lobits)";
  z[lc++]="    check_ext |= (sptr->hi_ext & NSYS_RTPSEQ_EXMASK);";
  z[lc++]="  else";
  z[lc++]="    check_ext |= ((sptr->hi_ext & NSYS_RTPSEQ_EXMASK)";
  z[lc++]="		  - NSYS_RTPSEQ_EXINCR);";
  z[lc++]="";
  z[lc++]="  /**************************/";
  z[lc++]="  /* loop through note logs */";
  z[lc++]="  /**************************/";
  z[lc++]="";
  z[lc++]="  while (loglen)";
  z[lc++]="    {";
  z[lc++]="      if ((!(p[NSYS_SM_CN_LOC_NUM] & NSYS_SM_CHKS)) || many)";
  z[lc++]="	{		      ";
  z[lc++]="	  newx = p[NSYS_SM_CN_LOC_NUM] & NSYS_SM_CLRS;";
  z[lc++]="	  newy = p[NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CLRY;";
  z[lc++]="	  yflag = (p[NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY);";
  z[lc++]="	  vel = jrecv->chaptern_vel[newx];";
  z[lc++]="";
  z[lc++]="	  /**************************************/";
  z[lc++]="	  /* by default, turn off all notes ... */";
  z[lc++]="	  /**************************************/";
  z[lc++]="";
  z[lc++]="	  noteoff = jrecv->chaptern_ref[newx];";
  z[lc++]="";
  z[lc++]="	  /******************************************************/";
  z[lc++]="	  /* ... and play the new NoteOn if it won't sound late */";
  z[lc++]="	  /******************************************************/";
  z[lc++]="";
  z[lc++]="	  noteon = (newy != 0) && yflag && sptr->ontime;";
  z[lc++]="";
  z[lc++]="	  /*************************************/";
  z[lc++]="	  /* exceptions for the ambigious case */";
  z[lc++]="	  /*************************************/";
  z[lc++]="";
  z[lc++]="	  if ((noteoff == 1)  &&               /* one note is playing */";
  z[lc++]="	      (vel && newy && (vel == newy)))  /* unchanged velocity  */";
  z[lc++]="	    {";
  z[lc++]="	      /* has old note been playing a long time? */";
  z[lc++]="";
  z[lc++]="	      dated = NSYS_SM_CN_RECDELAY < (nsys_netout_tstamp - ";
  z[lc++]="					     jrecv->chaptern_tstamp[newx]);";
  z[lc++]="";
  z[lc++]="	      /* does playing note predate checkpoint? (if so, different) */";
  z[lc++]="";
  z[lc++]="	      predate = (jrecv->chaptern_extseq[newx] < check_ext);";
  z[lc++]="";
  z[lc++]="	      if (noteon)";
  z[lc++]="		{";
  z[lc++]="		  /* noteon = 1 because new note is recent. if the evidence */";
  z[lc++]="		  /* indicates old note is recent too, then let note ring   */";
  z[lc++]="";
  z[lc++]="		  if ((!predate) && (!dated))";
  z[lc++]="		      noteon = noteoff = 0;";
  z[lc++]="";
  z[lc++]="		  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		    printf(\" -EX1- \");";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  /* noteon = 0 because we think new note is old. if the   */";
  z[lc++]="		  /* old note appears old too, then let the note ring      */";
  z[lc++]="";
  z[lc++]="		  if (predate || dated)";
  z[lc++]="		    noteoff = 0;";
  z[lc++]="";
  z[lc++]="		  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		    printf(\" -EX2- \");";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    {";
  z[lc++]="	      printf(\"NoteLog %hhu: %s(%hhu, %hhu); Actions: \", ";
  z[lc++]="		     newx, (p[NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY) ";
  z[lc++]="		     ? \"#\" : \"-\", vel, newy);";
  z[lc++]="";
  z[lc++]="	      if (noteoff)";
  z[lc++]="		printf(\" NoteOff \");";
  z[lc++]=" ";
  z[lc++]="	      if (noteoff > 1)";
  z[lc++]="		printf( \"(%i) \", noteoff);";
  z[lc++]="";
  z[lc++]="	      if (noteon)";
  z[lc++]="		printf(\" NoteOn\");";
  z[lc++]="";
  z[lc++]="	      printf(\"\\n\");";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  /* do NoteOff, then NoteOn, then update state */";
  z[lc++]="";
  z[lc++]="	  for (i = 0; i < noteoff; i++)";
  z[lc++]="	    if ((nsys_netin_journal_addcmd_three";
  z[lc++]="		 (sptr, buff, fill, size,";
  z[lc++]="		  jrecv->chan | CSYS_MIDI_NOTEOFF, newx, 64)))";
  z[lc++]="	      return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  if (noteon && (nsys_netin_journal_addcmd_three";
  z[lc++]="			 (sptr, buff, fill, size,";
  z[lc++]="			  jrecv->chan | CSYS_MIDI_NOTEON, newx, newy)))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  if (noteoff || noteon)";
  z[lc++]="	    {";
  z[lc++]="	      jrecv->chaptern_ref[newx] -= (noteoff - noteon);";
  z[lc++]="";
  z[lc++]="	      if (noteon)";
  z[lc++]="		{";
  z[lc++]="		  jrecv->chaptern_vel[newx] = newy;";
  z[lc++]="		  jrecv->chaptern_tstamp[newx] = nsys_netout_tstamp;";
  z[lc++]="		  jrecv->chaptern_extseq[newx] = sptr->hi_ext;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		if (jrecv->chaptern_ref[newx] == 0)";
  z[lc++]="		  jrecv->chaptern_vel[newx] = 0;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      loglen--;";
  z[lc++]="      p += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process bitfields of chapter N                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_bitfield(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			     nsys_netout_jrecv_state * jrecv, unsigned char low, ";
  z[lc++]="			     unsigned char high, unsigned char * buff, ";
  z[lc++]="			     long * fill, long size)";
  z[lc++]="{";
  z[lc++]="  int i, first;";
  z[lc++]="  unsigned char newx, bitfield;";
  z[lc++]="";
  z[lc++]="  while (low <= high)";
  z[lc++]="    {	      ";
  z[lc++]="      i = 0;";
  z[lc++]="      bitfield = 128;";
  z[lc++]="      while (bitfield)";
  z[lc++]="	{";
  z[lc++]="	  if ((*p) & bitfield)";
  z[lc++]="	    {";
  z[lc++]="	      newx = (low << NSYS_SM_CN_BFSHIFT) + i;";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"Bitfield %hhu: (%hhu); \", newx,  ";
  z[lc++]="		       jrecv->chaptern_vel[newx]);";
  z[lc++]="";
  z[lc++]="	      first = 1;";
  z[lc++]="";
  z[lc++]="	      while (jrecv->chaptern_ref[newx])";
  z[lc++]="		{";
  z[lc++]="		  if (nsys_netin_journal_addcmd_three ";
  z[lc++]="		      (sptr, buff, fill, size, ";
  z[lc++]="		       jrecv->chan | CSYS_MIDI_NOTEOFF, newx, 64))";
  z[lc++]="		    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="		  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		    if (first)";
  z[lc++]="		      {";
  z[lc++]="			first = 0;";
  z[lc++]="			printf(\" Actions: Noteoff (%hhu) \",";
  z[lc++]="			       jrecv->chaptern_ref[newx]);";
  z[lc++]="		      }";
  z[lc++]="";
  z[lc++]="		  jrecv->chaptern_ref[newx]--;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (jrecv->chaptern_vel[newx])";
  z[lc++]="		jrecv->chaptern_vel[newx] = 0;";
  z[lc++]="";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"\\n\");";
  z[lc++]="	    }";
  z[lc++]="	  bitfield >>= 1;";
  z[lc++]="	  i++;";
  z[lc++]="	}";
  z[lc++]="      low++;";
  z[lc++]="      p++;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter T (channel touch)              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_ctouch(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			   nsys_netout_jrecv_state * jrecv,";
  z[lc++]="			   unsigned char * buff,  ";
  z[lc++]="			   long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx;";
  z[lc++]="";
  z[lc++]="  newx = p[NSYS_SM_CT_LOC_PRESSURE] & NSYS_SM_CLRS;";
  z[lc++]="  if ((newx != (jrecv->chaptert_pressure & NSYS_SM_RV_CLRF)) ||";
  z[lc++]="      (jrecv->chaptert_pressure == 0))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_two(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_CTOUCH, newx))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"CTouch (%hhu) --> (%hhu)\\n\", ";
  z[lc++]="	       jrecv->chaptert_pressure & NSYS_SM_RV_CLRF, newx);";
  z[lc++]="      ";
  z[lc++]="      jrecv->chaptert_pressure = newx | NSYS_SM_RV_SETF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter P (poly touch)                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_ptouch(nsys_source * sptr, unsigned char * p,";
  z[lc++]="			   nsys_netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="			   unsigned char many, unsigned char * buff, ";
  z[lc++]="			   long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy;";
  z[lc++]="";
  z[lc++]="  p += NSYS_SM_CA_HDRSIZE;";
  z[lc++]="  while (loglen)";
  z[lc++]="    {";
  z[lc++]="      if ((!(p[NSYS_SM_CA_LOC_NUM] & NSYS_SM_CHKS)) || many)";
  z[lc++]="	{";
  z[lc++]="	  newx = p[NSYS_SM_CA_LOC_NUM] & NSYS_SM_CLRS;";
  z[lc++]="	  newy = p[NSYS_SM_CA_LOC_PRESSURE] & NSYS_SM_CA_CLRX;";
  z[lc++]="	  if (((jrecv->chaptera_pressure[newx] & NSYS_SM_RV_CLRF)";
  z[lc++]="	       != newy) || (jrecv->chaptera_pressure[newx] == 0))";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					    jrecv->chan | CSYS_MIDI_PTOUCH,";
  z[lc++]="					    newx, newy))";
  z[lc++]="		  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"PTouchLog %hhu: %hhu --> %hhu\\n\", newx, ";
  z[lc++]="		       jrecv->chaptera_pressure[newx] &";
  z[lc++]="		       NSYS_SM_RV_CLRF, newy);";
  z[lc++]="	      ";
  z[lc++]="	      jrecv->chaptera_pressure[newx] = (newy |";
  z[lc++]="						NSYS_SM_RV_SETF);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      loglen--;";
  z[lc++]="      p += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              process System Chapter D/B (Reset)              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_reset(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			  nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  unsigned char reset;";
  z[lc++]="";
  z[lc++]="  reset = ps[0] & NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  if (reset != jrecvsys->chapterd_reset)";
  z[lc++]="    {";
  z[lc++]="      nsys_netin_journal_clear_active(CSYS_MIDI_SYSTEM_RESET);";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, CSYS_MIDI_SYSTEM_RESET))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"System Reset (%hhu) --> (%hhu)\\n\", jrecvsys->chapterd_reset, reset);";
  z[lc++]="      ";
  z[lc++]="      jrecvsys->chapterd_reset = reset;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter D/G (Tune Request)          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_tune(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			 nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			 unsigned char * buff,  ";
  z[lc++]="			 long * fill, long size)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  unsigned char tune;";
  z[lc++]="";
  z[lc++]="  tune = ps[0] & NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  if (tune != jrecvsys->chapterd_tune)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_TUNE_REQUEST))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Tune Request (%hhu) --> (%hhu)\\n\", jrecvsys->chapterd_tune, tune);";
  z[lc++]="      ";
  z[lc++]="      jrecvsys->chapterd_tune = tune;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter D/H (Song Select)           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_song(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			 nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			 unsigned char * buff,  ";
  z[lc++]="			 long * fill, long size)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  unsigned char song;";
  z[lc++]="";
  z[lc++]="  song = ps[0] & NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  if (song != jrecvsys->chapterd_song)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_two(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_SONG_SELECT, song))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Song Select (%hhu) --> (%hhu)\\n\", jrecvsys->chapterd_song, song);";
  z[lc++]="      ";
  z[lc++]="      jrecvsys->chapterd_song = song;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter D/J (unused Common)        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_scj(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			unsigned char * buff,  ";
  z[lc++]="			long * fill, long size)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  unsigned char ndata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="  unsigned char vdata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="  unsigned char count = 0;";
  z[lc++]="  int has_count = 0;";
  z[lc++]="  int dstart, dsize, update;";
  z[lc++]="";
  z[lc++]="  dstart = NSYS_SM_CD_COMMON_LOC_FIELDS;";
  z[lc++]="";
  z[lc++]="  if ((has_count = (ps[NSYS_SM_CD_COMMON_LOC_TOC] & NSYS_SM_CD_COMMON_TOC_CHKC)))";
  z[lc++]="    {";
  z[lc++]="      count = ps[NSYS_SM_CD_COMMON_LOC_FIELDS];";
  z[lc++]="      dstart++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ps[NSYS_SM_CD_COMMON_LOC_TOC] & NSYS_SM_CD_COMMON_TOC_CHKV)";
  z[lc++]="    {";
  z[lc++]="      ndata = ps[dstart] & NSYS_SM_RV_CLRF;";
  z[lc++]="      if (ps[dstart] & NSYS_SM_RV_CHKF)";
  z[lc++]="	vdata = ps[dstart + 1] & NSYS_SM_RV_CLRF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  dsize = ((ndata != CSYS_MIDI_SYSTEM_SYSEX_END) + ";
  z[lc++]="	   (vdata != CSYS_MIDI_SYSTEM_SYSEX_END));";
  z[lc++]="";
  z[lc++]="  if (has_count)";
  z[lc++]="    {";
  z[lc++]="      if ((update = (count != jrecvsys->chapterd_scj_count)))";
  z[lc++]="	jrecvsys->chapterd_scj_count = count;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    update = ((ndata != jrecvsys->chapterd_scj_data1) ||";
  z[lc++]="	      (vdata != jrecvsys->chapterd_scj_data2));";
  z[lc++]="";
  z[lc++]="  if (update)";
  z[lc++]="    switch (dsize) {";
  z[lc++]="    case 0:";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_UNUSED1))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Common %hhu\\n\", CSYS_MIDI_SYSTEM_UNUSED1);";
  z[lc++]="      break;";
  z[lc++]="    case 1:";
  z[lc++]="      if (nsys_netin_journal_addcmd_two(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_UNUSED1, ";
  z[lc++]="					ndata))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Common %hhu (%hhu) --> (%hhu)\\n\", ";
  z[lc++]="	       CSYS_MIDI_SYSTEM_UNUSED1, ";
  z[lc++]="	       jrecvsys->chapterd_scj_data1, ndata);";
  z[lc++]="      break;";
  z[lc++]="    case 2:";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, ";
  z[lc++]="					  CSYS_MIDI_SYSTEM_UNUSED1, ";
  z[lc++]="					  ndata, vdata))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Common %hhu (%hhu %hhu) --> (%hhu %hhu)\\n\", ";
  z[lc++]="	       CSYS_MIDI_SYSTEM_UNUSED1, ";
  z[lc++]="	       jrecvsys->chapterd_scj_data1, ";
  z[lc++]="	       jrecvsys->chapterd_scj_data2, ";
  z[lc++]="	       ndata, vdata);";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ndata != jrecvsys->chapterd_scj_data1)";
  z[lc++]="    jrecvsys->chapterd_scj_data1 = ndata;";
  z[lc++]="";
  z[lc++]="  if (ndata != jrecvsys->chapterd_scj_data2)";
  z[lc++]="    jrecvsys->chapterd_scj_data2 = vdata;";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter D/K (unused Common)        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_sck(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			unsigned char * buff,  ";
  z[lc++]="			long * fill, long size)";
  z[lc++]="{";
  z[lc++]="  unsigned char ndata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="  unsigned char vdata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="  unsigned char count = 0;";
  z[lc++]="  int has_count = 0;";
  z[lc++]="  int dstart, dsize, update;";
  z[lc++]="";
  z[lc++]="  dstart = NSYS_SM_CD_COMMON_LOC_FIELDS;";
  z[lc++]="";
  z[lc++]="  if ((has_count = (ps[NSYS_SM_CD_COMMON_LOC_TOC] & NSYS_SM_CD_COMMON_TOC_CHKC)))";
  z[lc++]="    {";
  z[lc++]="      count = ps[NSYS_SM_CD_COMMON_LOC_FIELDS];";
  z[lc++]="      dstart++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ps[NSYS_SM_CD_COMMON_LOC_TOC] & NSYS_SM_CD_COMMON_TOC_CHKV)";
  z[lc++]="    {";
  z[lc++]="      ndata = ps[dstart] & NSYS_SM_RV_CLRF;";
  z[lc++]="      if (ps[dstart] & NSYS_SM_RV_CHKF)";
  z[lc++]="	vdata = ps[dstart + 1] & NSYS_SM_RV_CLRF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  dsize = ((ndata != CSYS_MIDI_SYSTEM_SYSEX_END) + ";
  z[lc++]="	   (vdata != CSYS_MIDI_SYSTEM_SYSEX_END));";
  z[lc++]="";
  z[lc++]="  if (has_count)";
  z[lc++]="    {";
  z[lc++]="      if ((update = (count != jrecvsys->chapterd_sck_count)))";
  z[lc++]="	jrecvsys->chapterd_sck_count = count;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    update = ((ndata != jrecvsys->chapterd_sck_data1) ||";
  z[lc++]="	      (vdata != jrecvsys->chapterd_sck_data2));";
  z[lc++]="";
  z[lc++]="  if (update)";
  z[lc++]="    switch (dsize) {";
  z[lc++]="    case 0:";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Common %hhu\\n\", CSYS_MIDI_SYSTEM_UNUSED2);";
  z[lc++]="      break;";
  z[lc++]="    case 1:";
  z[lc++]="      if (nsys_netin_journal_addcmd_two(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_UNUSED2, ";
  z[lc++]="					ndata))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Common %hhu (%hhu) --> (%hhu)\\n\", ";
  z[lc++]="	       CSYS_MIDI_SYSTEM_UNUSED2, ";
  z[lc++]="	       jrecvsys->chapterd_sck_data1, ndata);";
  z[lc++]="      break;";
  z[lc++]="    case 2:";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, ";
  z[lc++]="					  CSYS_MIDI_SYSTEM_UNUSED2, ";
  z[lc++]="					  ndata, vdata))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Common %hhu (%hhu %hhu) --> (%hhu %hhu)\\n\", ";
  z[lc++]="	       CSYS_MIDI_SYSTEM_UNUSED2, ";
  z[lc++]="	       jrecvsys->chapterd_sck_data1, ";
  z[lc++]="	       jrecvsys->chapterd_sck_data2, ";
  z[lc++]="	       ndata, vdata);";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ndata != jrecvsys->chapterd_sck_data1)";
  z[lc++]="    jrecvsys->chapterd_sck_data1 = ndata;";
  z[lc++]="";
  z[lc++]="  if (ndata != jrecvsys->chapterd_sck_data2)";
  z[lc++]="    jrecvsys->chapterd_sck_data2 = vdata;";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter D/Y (unused RealTime)       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_rty(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			unsigned char * buff,  ";
  z[lc++]="			long * fill, long size)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  unsigned char rty;";
  z[lc++]="";
  z[lc++]="  if (ps[NSYS_SM_CD_REALTIME_LOC_TOC] & NSYS_SM_CD_REALTIME_TOC_CHKC)";
  z[lc++]="    {";
  z[lc++]="      rty = ps[NSYS_SM_CD_REALTIME_LOC_FIELDS];";
  z[lc++]="";
  z[lc++]="      if (rty != jrecvsys->chapterd_rty)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					    CSYS_MIDI_SYSTEM_TICK))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    printf(\"RealTime 0xF9 (%hhu) --> (%hhu)\\n\", jrecvsys->chapterd_rty, rty);";
  z[lc++]="	  ";
  z[lc++]="	  jrecvsys->chapterd_rty = rty;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter D/Z (unused RealTime)       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_rtz(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			unsigned char * buff,  ";
  z[lc++]="			long * fill, long size)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  unsigned char rtz;";
  z[lc++]="";
  z[lc++]="  if (ps[NSYS_SM_CD_REALTIME_LOC_TOC] & NSYS_SM_CD_REALTIME_TOC_CHKC)";
  z[lc++]="    {";
  z[lc++]="      rtz = ps[NSYS_SM_CD_REALTIME_LOC_FIELDS];";
  z[lc++]="";
  z[lc++]="      if (rtz != jrecvsys->chapterd_rtz)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					    CSYS_MIDI_SYSTEM_UNUSED3))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    printf(\"RealTime 0xFD (%hhu) --> (%hhu)\\n\", jrecvsys->chapterd_rtz, rtz);";
  z[lc++]="	  ";
  z[lc++]="	  jrecvsys->chapterd_rtz = rtz;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter V (active sense)            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_sense(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			  nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char count;";
  z[lc++]="";
  z[lc++]="  count = (ps[NSYS_SM_CV_LOC_COUNT] & NSYS_SM_CLRS);";
  z[lc++]="";
  z[lc++]="  if (count != jrecvsys->chapterv_count)";
  z[lc++]="    {";
  z[lc++]="      /* a simple-minded repair approach -- later, consider sensing */";
  z[lc++]="      /* the disappearance of active sense commands in the stream,  */";
  z[lc++]="      /* and synthesizing them on the fly.                          */";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, CSYS_MIDI_SYSTEM_SENSE))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Active Sense (%hhu) --> (%hhu)\\n\", jrecvsys->chapterv_count, count);";
  z[lc++]="      ";
  z[lc++]="      jrecvsys->chapterv_count = count;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter Q (sequencer)               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_sequence(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			     nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			     unsigned char * buff,  ";
  z[lc++]="			     long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long chapter_clocks, nearest_pp;";
  z[lc++]="  int chapter_running, shadow_running;";
  z[lc++]="  int chapter_downbeat, chapter_size;";
  z[lc++]="";
  z[lc++]="  /*****************************************************/";
  z[lc++]="  /* leave quickly if chapter and shadow are identical */";
  z[lc++]="  /*****************************************************/";
  z[lc++]="";
  z[lc++]="  chapter_size = (ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC) ? 3 : 1;";
  z[lc++]="";
  z[lc++]="  if ((ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CLRS) == ";
  z[lc++]="      jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR])";
  z[lc++]="    {";
  z[lc++]="      if (chapter_size == 3)";
  z[lc++]="	{";
  z[lc++]="	  if ((ps[NSYS_SM_CQ_LOC_FIELDS] == ";
  z[lc++]="	       jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS]) &&";
  z[lc++]="	      (ps[NSYS_SM_CQ_LOC_FIELDS + 1] == ";
  z[lc++]="	       jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_FIELDS + 1]))";
  z[lc++]="	    return NSYS_JOURNAL_RECOVERED;	";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	return NSYS_JOURNAL_RECOVERED;	";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /********************************************************/";
  z[lc++]="  /* extract chapter and shadow state, then update shadow */";
  z[lc++]="  /********************************************************/";
  z[lc++]="";
  z[lc++]="  shadow_running = jrecvsys->chapterq_shadow[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKN;";
  z[lc++]="  memcpy(jrecvsys->chapterq_shadow, ps, chapter_size);";
  z[lc++]="";
  z[lc++]="  chapter_running = ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKN;";
  z[lc++]="  chapter_downbeat = ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKD;";
  z[lc++]="";
  z[lc++]="  if (ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_HDR_CHKC)";
  z[lc++]="    chapter_clocks = (ps[NSYS_SM_CQ_LOC_FIELDS + 1] +";
  z[lc++]="		      (ps[NSYS_SM_CQ_LOC_FIELDS] << 8) +";
  z[lc++]="		      ((ps[NSYS_SM_CQ_LOC_HDR] & NSYS_SM_CQ_TOP_MASK) << 16));";
  z[lc++]="  else";
  z[lc++]="    chapter_clocks = 0;";
  z[lc++]="";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  /* Do repairs -- artifact-laden repairs done here for simplicity. */";
  z[lc++]="  /*   A production implementation would do incremental updating.   */";
  z[lc++]="  /******************************************************************/";
  z[lc++]="";
  z[lc++]="  if (shadow_running)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_STOP))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Sequencer STOP issued.\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nearest_pp = chapter_clocks / 6;";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, ";
  z[lc++]="				      CSYS_MIDI_SYSTEM_SONG_PP, (unsigned char)";
  z[lc++]="				      (nearest_pp & 0x007F), (unsigned char)";
  z[lc++]="				      ((nearest_pp >> 7) & 0x007F)))";
  z[lc++]="    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="  ";
  z[lc++]="  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="    printf(\"Song Position moved to %li clocks.\\n\", nearest_pp*6);";
  z[lc++]="";
  z[lc++]="  if (chapter_downbeat)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					CSYS_MIDI_SYSTEM_CONTINUE))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"Sequencer CONTINUE issued.\\n\");";
  z[lc++]="";
  z[lc++]="      chapter_clocks -=  nearest_pp*6 - 1;";
  z[lc++]="";
  z[lc++]="      while (chapter_clocks--)";
  z[lc++]="	if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					  CSYS_MIDI_SYSTEM_CLOCK))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	else";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    printf(\"Sequencer CLOCK issued.\\n\");";
  z[lc++]="";
  z[lc++]="      if (!chapter_running)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					    CSYS_MIDI_SYSTEM_STOP))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    printf(\"Sequencer STOP issued.\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    if (chapter_running)";
  z[lc++]="      {";
  z[lc++]="	if (nsys_netin_journal_addcmd_one(sptr, buff, fill, size, ";
  z[lc++]="					  CSYS_MIDI_SYSTEM_CONTINUE))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	";
  z[lc++]="	if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	  printf(\"Sequencer CONTINUE issued.\\n\");";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           process System Chapter F (MIDI Time Code)          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_timecode(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			     nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			     unsigned char * buff,  ";
  z[lc++]="			     long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int complete_equal, partial_equal;";
  z[lc++]="";
  z[lc++]="  /* fast path checks: breaks denote cases that may need repair */";
  z[lc++]="";
  z[lc++]="  complete_equal = partial_equal = 0;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="      {";
  z[lc++]="	if (!jrecvsys->chapterf_has_complete)";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if ((ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKQ) ? ";
  z[lc++]="	    !jrecvsys->chapterf_quarter : jrecvsys->chapterf_quarter)";
  z[lc++]="	  break;";
  z[lc++]="	";
  z[lc++]="	if (memcmp(&(ps[NSYS_SM_CF_LOC_FIELDS]), jrecvsys->chapterf_complete, ";
  z[lc++]="		   NSYS_SM_CF_SIZE_COMPLETE))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	complete_equal = 1;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP)";
  z[lc++]="      {";
  z[lc++]="	if (!jrecvsys->chapterf_has_partial)";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if ((ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKD) ? ";
  z[lc++]="	    !jrecvsys->chapterf_direction : jrecvsys->chapterf_direction)";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if ((ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_POINT_MASK) != jrecvsys->chapterf_point)";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="	  {";
  z[lc++]="	    if (memcmp(&(ps[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]),";
  z[lc++]="		       jrecvsys->chapterf_partial, NSYS_SM_CF_SIZE_PARTIAL))";
  z[lc++]="	      break;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    if (memcmp(&(ps[NSYS_SM_CF_LOC_FIELDS]), jrecvsys->chapterf_partial, ";
  z[lc++]="		       NSYS_SM_CF_SIZE_PARTIAL))";
  z[lc++]="	      break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	partial_equal = 1;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      if (jrecvsys->chapterf_has_partial)";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="    return NSYS_JOURNAL_RECOVERED;   /* no repairs or state updates are needed */";
  z[lc++]="";
  z[lc++]="  } while (0);";
  z[lc++]="";
  z[lc++]="  /* repairs start here */";
  z[lc++]="";
  z[lc++]="  if ((ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC) && !complete_equal)";
  z[lc++]="    {";
  z[lc++]="      jrecvsys->chapterf_has_complete = 1;";
  z[lc++]="      memcpy(jrecvsys->chapterf_complete, &(ps[NSYS_SM_CF_LOC_FIELDS]),";
  z[lc++]="	     NSYS_SM_CF_SIZE_COMPLETE);";
  z[lc++]="      jrecvsys->chapterf_quarter = ((ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKQ)";
  z[lc++]="				    ? 1 : 0);";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	  printf(\"Time Code COMPLETE repair.\\n\");";
  z[lc++]="";
  z[lc++]="      /*";
  z[lc++]="       * Later, add commands to gracefully issue Full Frame or QF command(s)";
  z[lc++]="       */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP) && !partial_equal)";
  z[lc++]="    {";
  z[lc++]="      jrecvsys->chapterf_has_partial = 1;";
  z[lc++]="      jrecvsys->chapterf_point = ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_POINT_MASK;";
  z[lc++]="      jrecvsys->chapterf_direction = ";
  z[lc++]="	(ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKD) ? 1 : 0;";
  z[lc++]="";
  z[lc++]="      if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="	memcpy(jrecvsys->chapterf_partial, ";
  z[lc++]="	       &(ps[NSYS_SM_CF_LOC_FIELDS + NSYS_SM_CF_SIZE_COMPLETE]), ";
  z[lc++]="	       NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="      else";
  z[lc++]="	memcpy(jrecvsys->chapterf_partial, &(ps[NSYS_SM_CF_LOC_FIELDS]), ";
  z[lc++]="	       NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	  printf(\"Time Code PARTIAL repair.\\n\");";
  z[lc++]="";
  z[lc++]="      /*";
  z[lc++]="       * Later, add commands to gracefully issue QF command(s)";
  z[lc++]="       */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!(ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKP))";
  z[lc++]="    {";
  z[lc++]="      jrecvsys->chapterf_has_partial = 0;";
  z[lc++]="";
  z[lc++]="      if (ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKC)";
  z[lc++]="	jrecvsys->chapterf_point = ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_POINT_MASK;";
  z[lc++]="";
  z[lc++]="      jrecvsys->chapterf_direction = ";
  z[lc++]="	(ps[NSYS_SM_CF_LOC_HDR] & NSYS_SM_CF_HDR_CHKD) ? 1 : 0;";
  z[lc++]="";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	  printf(\"Time Code PARTIAL zeroing.\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      track commands for System Chapter F (MIDI Time Code)    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_track_timecode(nsys_netout_jrecv_system_state *";
  z[lc++]="			       jrecvsys, unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char frames, seconds, minutes, hours, type, typeframe;";
  z[lc++]="  unsigned char point, direction, idnum;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  point = jrecvsys->chapterf_point;";
  z[lc++]="  direction = jrecvsys->chapterf_direction;";
  z[lc++]="  jrecvsys->chapterf_point = (idnum = (ndata & NSYS_SM_CF_IDNUM_MASK) >> 4);";
  z[lc++]="";
  z[lc++]="  /* handle QF commands with expected idnums */";
  z[lc++]="";
  z[lc++]="  if ((!direction && (((point + 1) & NSYS_SM_CF_POINT_MASK) == idnum)) ||";
  z[lc++]="      (direction && (((point - 1) & NSYS_SM_CF_POINT_MASK) == idnum)))";
  z[lc++]="    {";
  z[lc++]="      switch (idnum) {               	     ";
  z[lc++]="      case NSYS_SM_CF_IDNUM_FR_LSN:";
  z[lc++]="      case NSYS_SM_CF_IDNUM_HR_MSN:";
  z[lc++]="	if ((direction && (idnum == NSYS_SM_CF_IDNUM_FR_LSN)) ||";
  z[lc++]="	    (!direction && (idnum == NSYS_SM_CF_IDNUM_HR_MSN)))";
  z[lc++]="	  {";
  z[lc++]="	    /* handle QF commands that end the frame */";
  z[lc++]="	    ";
  z[lc++]="	    if (jrecvsys->chapterf_has_partial)";
  z[lc++]="	      {";
  z[lc++]="		jrecvsys->chapterf_has_partial = 0;";
  z[lc++]="		jrecvsys->chapterf_has_complete = 1;";
  z[lc++]="		jrecvsys->chapterf_quarter = 1;";
  z[lc++]="";
  z[lc++]="		memcpy(jrecvsys->chapterf_complete, jrecvsys->chapterf_partial,";
  z[lc++]="		       NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="";
  z[lc++]="		if (!direction)";
  z[lc++]="		  {";
  z[lc++]="		    p = &(jrecvsys->chapterf_complete[NSYS_SM_CF_QF_LOC_HR_MSN]);";
  z[lc++]="		    (*p) &= NSYS_SM_CF_ODD_CLR;";
  z[lc++]="		    (*p) |= (ndata & NSYS_SM_CF_PAYLOAD_MASK);";
  z[lc++]="		  }";
  z[lc++]="		else";
  z[lc++]="		  {";
  z[lc++]="		    p = &(jrecvsys->chapterf_complete[NSYS_SM_CF_QF_LOC_FR_LSN]);";
  z[lc++]="		    (*p) &= NSYS_SM_CF_EVEN_CLR;";
  z[lc++]="		    (*p) |= (ndata << 4);";
  z[lc++]="		  }";
  z[lc++]="		";
  z[lc++]="		/* for forward tape motion, adjust complete by two frames */";
  z[lc++]="		";
  z[lc++]="		if (!direction)";
  z[lc++]="		  {";
  z[lc++]="		    p = jrecvsys->chapterf_complete;";
  z[lc++]="		    ";
  z[lc++]="		    frames = ((p[0] >> 4) & 0x0F) + ((p[0] & 0x01) << 4);";
  z[lc++]="		    if ((type = p[3] & 0x06))";
  z[lc++]="		      typeframe = (type == 2) ? 25 : 30;";
  z[lc++]="		    else";
  z[lc++]="		      typeframe = 24;";
  z[lc++]="		    ";
  z[lc++]="		    if ((frames += 2) >= typeframe)";
  z[lc++]="		      {";
  z[lc++]="			frames -= typeframe;";
  z[lc++]="			seconds = ((p[1] >> 4) & 0x0F) + ((p[1] & 0x03) << 4);";
  z[lc++]="			if ((++seconds) >= 60)";
  z[lc++]="			  {";
  z[lc++]="			    seconds -= 60;";
  z[lc++]="			    minutes = ((p[2] >> 4) & 0x0F) + ((p[2] & 0x03) << 4);";
  z[lc++]="			    if ((++minutes) >= 60)";
  z[lc++]="			      {";
  z[lc++]="				minutes -= 60;";
  z[lc++]="				hours = ((p[3] >> 4) & 0x0F) + ((p[3] & 0x01) << 4);";
  z[lc++]="				if ((++hours) >= 24)";
  z[lc++]="				  hours -= 24;";
  z[lc++]="				p[3] = ((0x0F & hours) << 4)  | (hours >> 4) | type;";
  z[lc++]="			      }";
  z[lc++]="			    p[2] = ((0x0F & minutes) << 4) | (minutes >> 4);";
  z[lc++]="			  }";
  z[lc++]="			p[1] = ((0x0F & seconds) << 4) | (seconds >> 4);";
  z[lc++]="		      }";
  z[lc++]="		    p[0] = ((0x0F & frames) << 4)  | (frames >> 4);";
  z[lc++]="		  }";
  z[lc++]="";
  z[lc++]="	      }";
  z[lc++]="	    return;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	/* handle QF commands that start a frame */";
  z[lc++]="";
  z[lc++]="	if (!(jrecvsys->chapterf_has_partial))";
  z[lc++]="	  {";
  z[lc++]="	    jrecvsys->chapterf_has_partial = 1;";
  z[lc++]="	    memset(jrecvsys->chapterf_partial, 0, NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="	  }";
  z[lc++]="      default:           /* handle all expected non-frame-ending MT values */";
  z[lc++]="	if (jrecvsys->chapterf_has_partial)";
  z[lc++]="	  {";
  z[lc++]="	    p = &(jrecvsys->chapterf_partial[idnum >> 1]);";
  z[lc++]="	    if (idnum & 0x01)";
  z[lc++]="	      {";
  z[lc++]="		(*p) &= NSYS_SM_CF_ODD_CLR;";
  z[lc++]="		(*p) |= (ndata & NSYS_SM_CF_PAYLOAD_MASK);";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		(*p) &= NSYS_SM_CF_EVEN_CLR;";
  z[lc++]="		(*p) |= (ndata << 4);";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* handle tape direction change that happens in a legal way */";
  z[lc++]="  ";
  z[lc++]="  if ((idnum == NSYS_SM_CF_IDNUM_FR_LSN) || (idnum == NSYS_SM_CF_IDNUM_HR_MSN))";
  z[lc++]="    {";
  z[lc++]="      jrecvsys->chapterf_has_partial = 1;";
  z[lc++]="";
  z[lc++]="      if (idnum == NSYS_SM_CF_IDNUM_FR_LSN)";
  z[lc++]="	jrecvsys->chapterf_direction = 0;";
  z[lc++]="      else";
  z[lc++]="	jrecvsys->chapterf_direction = 1;";
  z[lc++]="      ";
  z[lc++]="      memset((p = jrecvsys->chapterf_partial), 0, NSYS_SM_CF_SIZE_PARTIAL);";
  z[lc++]="      ";
  z[lc++]="      if (idnum == NSYS_SM_CF_IDNUM_FR_LSN)";
  z[lc++]="	{";
  z[lc++]="	  (*p) &= NSYS_SM_CF_EVEN_CLR;";
  z[lc++]="	  (*p) |= (ndata << 4);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  p += (NSYS_SM_CF_SIZE_PARTIAL - 1);";
  z[lc++]="	  (*p) &= NSYS_SM_CF_ODD_CLR;";
  z[lc++]="	  (*p) |= (ndata & NSYS_SM_CF_PAYLOAD_MASK);";
  z[lc++]="	}	";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* handle \"wrong direction guess\" for an earlier unexpected QF command */";
  z[lc++]="";
  z[lc++]="  if (!direction && (((point - 1) & NSYS_SM_CF_POINT_MASK) == idnum))";
  z[lc++]="    {";
  z[lc++]="      jrecvsys->chapterf_direction = 1;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* handle unexpected QF commands */";
  z[lc++]="";
  z[lc++]="  jrecvsys->chapterf_has_partial = jrecvsys->chapterf_direction = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          process System Chapter X (System Exclusive)         */";
  z[lc++]="/*  (does not process unfinished command logs and other items)  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_sysex(nsys_source * sptr, unsigned char * ps,";
  z[lc++]="			  int syslen,";
  z[lc++]="			  nsys_netout_jrecv_system_state * jrecvsys,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int sysex_len;";
  z[lc++]="  unsigned char sysex_hdr;";
  z[lc++]="  unsigned char gmreset_state, mvolume_lsb_state, mvolume_msb_state;";
  z[lc++]="  unsigned char gmreset_has_tcount, gmreset_tcount;";
  z[lc++]="  unsigned char sysex_has_tcount, sysex_tcount;";
  z[lc++]="  unsigned char sysex_has_first, sysex_first;";
  z[lc++]="  unsigned char sysexbuff[NSYS_SM_CX_SIZE_MAXLOG - 1];";
  z[lc++]="";
  z[lc++]="  gmreset_state = gmreset_tcount = gmreset_has_tcount = 0;";
  z[lc++]="  mvolume_lsb_state = mvolume_msb_state = 0;";
  z[lc++]="  ";
  z[lc++]="  /* parse each log in list */";
  z[lc++]="";
  z[lc++]="  do";
  z[lc++]="    {";
  z[lc++]="      sysex_has_tcount = sysex_has_first = sysex_first = 0;";
  z[lc++]="      ";
  z[lc++]="      /* parse log header */";
  z[lc++]="";
  z[lc++]="      if ((syslen -= NSYS_SM_CX_SIZE_HDR) < 0)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="      ";
  z[lc++]="      if ((sysex_hdr = *(ps++)) & NSYS_SM_CX_HDR_CHKT)";
  z[lc++]="	{";
  z[lc++]="	  if ((syslen -= NSYS_SM_CX_SIZE_TCOUNT) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  sysex_has_tcount = 1;";
  z[lc++]="	  sysex_tcount = ps[0];";
  z[lc++]="	  ps += NSYS_SM_CX_SIZE_TCOUNT;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (sysex_hdr & NSYS_SM_CX_HDR_CHKC)";
  z[lc++]="	{";
  z[lc++]="	  if ((syslen -= NSYS_SM_CX_SIZE_COUNT) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ps += NSYS_SM_CX_SIZE_COUNT;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (sysex_hdr & NSYS_SM_CX_HDR_CHKF)";
  z[lc++]="	{";
  z[lc++]="	  if ((--syslen) >= 0)";
  z[lc++]="	    sysex_first = NSYS_SM_CX_DATA_MASK & ps[0];";
  z[lc++]="	  else";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  while (NSYS_SM_CX_DATA_CHKEND & ps[0])";
  z[lc++]="	    if ((--syslen) >= 0)";
  z[lc++]="	      sysex_first = ((sysex_first << 7) + ";
  z[lc++]="			     (NSYS_SM_CX_DATA_MASK & (++ps)[0]));";
  z[lc++]="	    else";
  z[lc++]="	      return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  sysex_has_first = 1;";
  z[lc++]="	  ps++;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if ((!syslen) && (sysex_hdr & NSYS_SM_CX_HDR_CHKD))";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      sysex_len = 0;";
  z[lc++]="";
  z[lc++]="      if (sysex_hdr & NSYS_SM_CX_HDR_CHKD)";
  z[lc++]="	do";
  z[lc++]="	  {";
  z[lc++]="	    if (sysex_len < (NSYS_SM_CX_SIZE_MAXLOG - 1))";
  z[lc++]="	      sysexbuff[sysex_len++] = (*ps) & NSYS_SM_CX_DATA_CLREND;";
  z[lc++]="	    ";
  z[lc++]="	    syslen--;";
  z[lc++]="	    ";
  z[lc++]="	    if ((*(ps++)) & NSYS_SM_CX_DATA_CHKEND)";
  z[lc++]="	      break;";
  z[lc++]="	    ";
  z[lc++]="	    if (!syslen)";
  z[lc++]="	      return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	    ";
  z[lc++]="	  } while (1);";
  z[lc++]="";
  z[lc++]="      /* skip processing for unimplemented features, cancelled commands */";
  z[lc++]="";
  z[lc++]="      if ((sysex_has_first && sysex_first) /* windowed data */ ||";
  z[lc++]="	  ((sysex_hdr & NSYS_SM_CX_STA_MASK) == NSYS_SM_CX_STA_UNFINISHED) ||";
  z[lc++]="	  ((sysex_hdr & NSYS_SM_CX_STA_MASK) == NSYS_SM_CX_STA_CANCELLED))";
  z[lc++]="	{";
  z[lc++]="	  if (syslen)";
  z[lc++]="	    continue;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      /* update GMRESET, MVOLUME state for log */";
  z[lc++]="      ";
  z[lc++]="      if ((sysex_len == (NSYS_SM_CX_SIZE_GMRESET - 1)) && ";
  z[lc++]="	  (!memcmp(&(nsys_netout_sysconst_gmreset[1]), sysexbuff, 3)) &&";
  z[lc++]="	  ((sysexbuff[3] == NSYS_SM_CX_GMRESET_ONVAL) ||";
  z[lc++]="	   (sysexbuff[3] == NSYS_SM_CX_GMRESET_OFFVAL)))";
  z[lc++]="	{";
  z[lc++]="	  gmreset_state = sysexbuff[3] | NSYS_SM_RV_SETF;";
  z[lc++]="	  if (sysex_has_tcount)";
  z[lc++]="	    {";
  z[lc++]="	      gmreset_tcount = sysex_tcount;";
  z[lc++]="	      gmreset_has_tcount = 1;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    gmreset_has_tcount = 0;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if ((sysex_len == NSYS_SM_CX_SIZE_MVOLUME - 1) && ";
  z[lc++]="	  !memcmp(&(nsys_netout_sysconst_mvolume[1]), sysexbuff, 4))";
  z[lc++]="	{";
  z[lc++]="	  mvolume_lsb_state = sysexbuff[4] | NSYS_SM_RV_SETF;";
  z[lc++]="	  mvolume_msb_state = sysexbuff[5];";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="    } while (syslen);";
  z[lc++]="  ";
  z[lc++]="  /* do MVOLUME repairs */";
  z[lc++]="  ";
  z[lc++]="  if (mvolume_lsb_state && ";
  z[lc++]="      ((mvolume_lsb_state != jrecvsys->chapterx_mvolume_lsb) ||";
  z[lc++]="       (mvolume_msb_state != jrecvsys->chapterx_mvolume_msb)))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three";
  z[lc++]="	  (sptr, buff, fill, size, CSYS_MIDI_MVOLUME,";
  z[lc++]="	   mvolume_lsb_state & NSYS_SM_RV_CLRF, mvolume_msb_state))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"MVOLUME (%hhu, %hhu) --> (%hhu, %hhu)\\n\", ";
  z[lc++]="	       jrecvsys->chapterx_mvolume_lsb & NSYS_SM_RV_CLRF, ";
  z[lc++]="	       jrecvsys->chapterx_mvolume_msb,";
  z[lc++]="	       mvolume_lsb_state & NSYS_SM_RV_CLRF, mvolume_msb_state);";
  z[lc++]="      ";
  z[lc++]="      jrecvsys->chapterx_mvolume_lsb = mvolume_lsb_state;";
  z[lc++]="      jrecvsys->chapterx_mvolume_msb = mvolume_msb_state;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /* do GMRESET repairs */";
  z[lc++]="  ";
  z[lc++]="  do {";
  z[lc++]="    ";
  z[lc++]="    if (jrecvsys->chapterx_gmreset == gmreset_state)";
  z[lc++]="      {";
  z[lc++]="	if (!gmreset_has_tcount)";
  z[lc++]="	  break;";
  z[lc++]="	";
  z[lc++]="	if (gmreset_state == (NSYS_SM_RV_SETF | NSYS_SM_CX_GMRESET_ONVAL))";
  z[lc++]="	  {";
  z[lc++]="	    if (jrecvsys->chapterx_gmreset_on_count == gmreset_state)";
  z[lc++]="	      break;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  if (jrecvsys->chapterx_gmreset_off_count == gmreset_state)";
  z[lc++]="	    break;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      jrecvsys->chapterx_gmreset = gmreset_state;";
  z[lc++]="    ";
  z[lc++]="    if (gmreset_has_tcount)";
  z[lc++]="      {";
  z[lc++]="	if (gmreset_state == (NSYS_SM_RV_SETF | NSYS_SM_CX_GMRESET_ONVAL))";
  z[lc++]="	  {";
  z[lc++]="	    if (jrecvsys->chapterx_gmreset_on_count != gmreset_state)";
  z[lc++]="	      jrecvsys->chapterx_gmreset_on_count = gmreset_state;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  if (jrecvsys->chapterx_gmreset_off_count != gmreset_state)";
  z[lc++]="	    jrecvsys->chapterx_gmreset_off_count = gmreset_state;";
  z[lc++]="      }";
  z[lc++]="    ";
  z[lc++]="    if (nsys_netin_journal_addcmd_two(sptr, buff, fill, size,";
  z[lc++]="				      CSYS_MIDI_GMRESET,";
  z[lc++]="				      gmreset_state & NSYS_SM_RV_CLRF))";
  z[lc++]="      return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    ";
  z[lc++]="    if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="      printf(\"GMRESET %s \\n\", ";
  z[lc++]="	     (gmreset_state == (NSYS_SM_RV_SETF | NSYS_SM_CX_GMRESET_ONVAL))";
  z[lc++]="	     ? \"On\" : \"Off\");";
  z[lc++]="";
  z[lc++]="    nsys_netin_journal_clear_active(CSYS_MIDI_GMRESET);";
  z[lc++]="";
  z[lc++]="  } ";
  z[lc++]="  while (0);";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level journal functions                 */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           adds a 3-octet MIDI command to the buffer          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_addcmd_three(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="				    long * fill, long size,";
  z[lc++]="				    unsigned char cmd, unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="			      ";
  z[lc++]="{";
  z[lc++]="  long idx;";
  z[lc++]="";
  z[lc++]="  if ((size - (*fill)) < 4)           /* 3 octets + mset */";
  z[lc++]="    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="  idx = *fill;";
  z[lc++]="";
  z[lc++]="  buff[idx++] = cmd;";
  z[lc++]="  buff[idx++] = ndata;";
  z[lc++]="  buff[idx++] = vdata;";
  z[lc++]="  buff[idx++] = (unsigned char)(sptr->mset);";
  z[lc++]="";
  z[lc++]="  *fill = idx;";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           adds a 2-octet MIDI command to the buffer          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_addcmd_two(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="				    long * fill, long size,";
  z[lc++]="				    unsigned char cmd, unsigned char ndata)";
  z[lc++]="			      ";
  z[lc++]="{";
  z[lc++]="  long idx;";
  z[lc++]="";
  z[lc++]="  if ((size - (*fill)) < 3)           /* 2 octets + mset */";
  z[lc++]="    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="  idx = *fill;";
  z[lc++]="";
  z[lc++]="  buff[idx++] = cmd;";
  z[lc++]="  buff[idx++] = ndata;";
  z[lc++]="  buff[idx++] = (unsigned char)(sptr->mset);";
  z[lc++]="";
  z[lc++]="  *fill = idx;";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           adds a 1-octet MIDI command to the buffer          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_addcmd_one(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="				  long * fill, long size, unsigned char cmd)";
  z[lc++]="			      ";
  z[lc++]="{";
  z[lc++]="  long idx;";
  z[lc++]="";
  z[lc++]="  if ((size - (*fill)) < 2)           /* 1 octet + mset */";
  z[lc++]="    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="  idx = *fill;";
  z[lc++]="";
  z[lc++]="  buff[idx++] = cmd;";
  z[lc++]="  buff[idx++] = (unsigned char)(sptr->mset);";
  z[lc++]="";
  z[lc++]="  *fill = idx;";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           adds a parameter transaction to the buffer         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_trans(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="			     long * fill, long size, unsigned char chan,";
  z[lc++]="			     int flags, unsigned char msb_num, ";
  z[lc++]="			     unsigned char lsb_num, unsigned char msb_val, ";
  z[lc++]="			     unsigned char lsb_val)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  unsigned char msb_cmd, lsb_cmd;";
  z[lc++]="";
  z[lc++]="  msb_cmd = ((flags & NSYS_SM_CM_TRANS_RPN) ? CSYS_MIDI_CC_RPN_MSB :";
  z[lc++]="	     CSYS_MIDI_CC_NRPN_MSB);";
  z[lc++]="  lsb_cmd = ((flags & NSYS_SM_CM_TRANS_RPN) ? CSYS_MIDI_CC_RPN_LSB :";
  z[lc++]="	     CSYS_MIDI_CC_NRPN_LSB);";
  z[lc++]="";
  z[lc++]="  if (!(flags & NSYS_SM_CM_TRANS_NO_OPEN))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="				    chan | CSYS_MIDI_CC, msb_cmd, msb_num))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="				    chan | CSYS_MIDI_CC, lsb_cmd, lsb_num))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!(flags & NSYS_SM_CM_TRANS_NO_SET))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="				    CSYS_MIDI_CC_DATAENTRY_MSB, msb_val))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="				    CSYS_MIDI_CC_DATAENTRY_LSB, lsb_val))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!(flags & NSYS_SM_CM_TRANS_NO_CLOSE))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="				    msb_cmd, CSYS_MIDI_RPN_NULL_MSB))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="				    lsb_cmd, CSYS_MIDI_RPN_NULL_LSB))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="/*************************************************************/";
  z[lc++]="/*           adds a button transaction to the buffer         */";
  z[lc++]="/*************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_button_trans(nsys_source * sptr, unsigned char * buff, ";
  z[lc++]="				    long * fill, long size, ";
  z[lc++]="				    unsigned char chan, int flags,";
  z[lc++]="				    unsigned char msb_num, ";
  z[lc++]="				    unsigned char lsb_num, short count)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  unsigned char msb_cmd, lsb_cmd, minus;";
  z[lc++]="";
  z[lc++]="  if ((minus = (count < 0)))";
  z[lc++]="    count = - count;";
  z[lc++]="";
  z[lc++]="  msb_cmd = ((flags & NSYS_SM_CM_TRANS_RPN) ? CSYS_MIDI_CC_RPN_MSB :";
  z[lc++]="	     CSYS_MIDI_CC_NRPN_MSB);";
  z[lc++]="  lsb_cmd = ((flags & NSYS_SM_CM_TRANS_RPN) ? CSYS_MIDI_CC_RPN_LSB :";
  z[lc++]="	     CSYS_MIDI_CC_NRPN_LSB);";
  z[lc++]="";
  z[lc++]="  if (!(flags & NSYS_SM_CM_TRANS_NO_OPEN))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					  chan | CSYS_MIDI_CC, msb_cmd, msb_num))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size,";
  z[lc++]="					  chan | CSYS_MIDI_CC, lsb_cmd, lsb_num))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!(flags & NSYS_SM_CM_TRANS_NO_SET))";
  z[lc++]="    {";
  z[lc++]="      while (count--)";
  z[lc++]="	if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="					    minus ? CSYS_MIDI_CC_DATAENTRYMINUS :";
  z[lc++]="					    CSYS_MIDI_CC_DATAENTRYPLUS, 0))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!(flags & NSYS_SM_CM_TRANS_NO_CLOSE))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="					  msb_cmd, CSYS_MIDI_RPN_NULL_MSB))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="      if (nsys_netin_journal_addcmd_three(sptr, buff, fill, size, chan | CSYS_MIDI_CC,";
  z[lc++]="					  lsb_cmd, CSYS_MIDI_RPN_NULL_LSB))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            sender state:  clear all active state             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_journal_clear_active(unsigned char cmd)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* to do ";
  z[lc++]="   *";
  z[lc++]="   * cmd codes CSYS_MIDI_SYSTEM_RESET or CSYS_MIDI_GMRESET";
  z[lc++]="   *";
  z[lc++]="   * clear journal state defined as \"active\"";
  z[lc++]="   *";
  z[lc++]="   */";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- receiver journal functions */";
  z[lc++]="";
  printlib(lc);
}


void makenet_crypto(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- crypto functions";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 2000-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#include <ctype.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/* beginning of MD5 code, extensively altered from Aladdin version */";
  z[lc++]="/*                 BSD applies to our modified form only           */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="  Copyright (C) 1999 Aladdin Enterprises.  All rights reserved.";
  z[lc++]="";
  z[lc++]="  This software is provided 'as-is', without any express or implied";
  z[lc++]="  warranty.  In no event will the authors be held liable for any damages";
  z[lc++]="  arising from the use of this software.";
  z[lc++]="";
  z[lc++]="  Permission is granted to anyone to use this software for any purpose,";
  z[lc++]="  including commercial applications, and to alter it and redistribute it";
  z[lc++]="  freely, subject to the following restrictions:";
  z[lc++]="";
  z[lc++]="  1. The origin of this software must not be misrepresented; you must not";
  z[lc++]="     claim that you wrote the original software. If you use this software";
  z[lc++]="     in a product, an acknowledgment in the product documentation would be";
  z[lc++]="     appreciated but is not required.";
  z[lc++]="  2. Altered source versions must be plainly marked as such, and must not be";
  z[lc++]="     misrepresented as being the original software.";
  z[lc++]="  3. This notice may not be removed or altered from any source distribution.";
  z[lc++]="";
  z[lc++]="  L. Peter Deutsch";
  z[lc++]="  ghost@aladdin.com";
  z[lc++]="";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               macros, typedefs, and global variables            */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="#define NSYS_ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32 - (n))))";
  z[lc++]="";
  z[lc++]="#define NSYS_FUNCT_F(x, y, z) (((x) & (y)) | (~(x) & (z)))";
  z[lc++]="#define NSYS_FUNCT_G(x, y, z) (((x) & (z)) | ((y) & ~(z)))";
  z[lc++]="#define NSYS_FUNCT_H(x, y, z) ((x) ^ (y) ^ (z))";
  z[lc++]="#define NSYS_FUNCT_I(x, y, z) ((y) ^ ((x) | ~(z)))";
  z[lc++]="";
  z[lc++]="#define NSYS_SETF(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_F(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="#define NSYS_SETG(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_G(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="#define NSYS_SETH(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_H(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="#define NSYS_SETI(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_I(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="";
  z[lc++]="/* holds state for an MD5 computation */";
  z[lc++]="";
  z[lc++]="typedef struct nsys_md5_state_s {";
  z[lc++]="  unsigned int count[2];           /* message length in bits, lsw first */";
  z[lc++]="  unsigned int abcd[4];	           /* digest buffer */";
  z[lc++]="  unsigned char buf[64];           /* accumulate block */";
  z[lc++]="} nsys_md5_state_t;";
  z[lc++]="";
  z[lc++]="/* MD5 padding array */";
  z[lc++]="";
  z[lc++]="static unsigned char nsys_md5_pad[64] = {";
  z[lc++]="  0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,";
  z[lc++]="  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,";
  z[lc++]="  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,";
  z[lc++]="  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0";
  z[lc++]="};";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               initializes MD5 computation                       */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_init(nsys_md5_state_t * pms)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  pms->count[0] = pms->count[1] = 0;";
  z[lc++]="  pms->abcd[0] = 0x67452301;";
  z[lc++]="  pms->abcd[1] = 0xefcdab89;";
  z[lc++]="  pms->abcd[2] = 0x98badcfe;";
  z[lc++]="  pms->abcd[3] = 0x10325476;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************************/";
  z[lc++]="/*  process a block -- used in nsys_md5_append() and nsys_md5_finish() */";
  z[lc++]="/***********************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_process(nsys_md5_state_t * pms, unsigned char *data)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned int a, b, c, d, t, X[16], i;";
  z[lc++]="  unsigned char *xp = data;";
  z[lc++]="";
  z[lc++]="  a = pms->abcd[0]; ";
  z[lc++]="  b = pms->abcd[1];";
  z[lc++]="  c = pms->abcd[2]; ";
  z[lc++]="  d = pms->abcd[3];";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < 16; ++i, xp += 4)";
  z[lc++]="    X[i] = xp[0] + (xp[1] << 8) + (xp[2] << 16) + (xp[3] << 24);";
  z[lc++]="";
  z[lc++]="  NSYS_SETF(a, b, c, d,  0,  7,  0xd76aa478);";
  z[lc++]="  NSYS_SETF(d, a, b, c,  1, 12,  0xe8c7b756);";
  z[lc++]="  NSYS_SETF(c, d, a, b,  2, 17,  0x242070db);";
  z[lc++]="  NSYS_SETF(b, c, d, a,  3, 22,  0xc1bdceee);";
  z[lc++]="  NSYS_SETF(a, b, c, d,  4,  7,  0xf57c0faf);";
  z[lc++]="  NSYS_SETF(d, a, b, c,  5, 12,  0x4787c62a);";
  z[lc++]="  NSYS_SETF(c, d, a, b,  6, 17,  0xa8304613);";
  z[lc++]="  NSYS_SETF(b, c, d, a,  7, 22,  0xfd469501);";
  z[lc++]="  NSYS_SETF(a, b, c, d,  8,  7,  0x698098d8);";
  z[lc++]="  NSYS_SETF(d, a, b, c,  9, 12,  0x8b44f7af);";
  z[lc++]="  NSYS_SETF(c, d, a, b, 10, 17,  0xffff5bb1);";
  z[lc++]="  NSYS_SETF(b, c, d, a, 11, 22,  0x895cd7be);";
  z[lc++]="  NSYS_SETF(a, b, c, d, 12,  7,  0x6b901122);";
  z[lc++]="  NSYS_SETF(d, a, b, c, 13, 12,  0xfd987193);";
  z[lc++]="  NSYS_SETF(c, d, a, b, 14, 17,  0xa679438e);";
  z[lc++]="  NSYS_SETF(b, c, d, a, 15, 22,  0x49b40821);";
  z[lc++]="";
  z[lc++]="  NSYS_SETG(a, b, c, d,  1,  5, 0xf61e2562);";
  z[lc++]="  NSYS_SETG(d, a, b, c,  6,  9, 0xc040b340);";
  z[lc++]="  NSYS_SETG(c, d, a, b, 11, 14, 0x265e5a51);";
  z[lc++]="  NSYS_SETG(b, c, d, a,  0, 20, 0xe9b6c7aa);";
  z[lc++]="  NSYS_SETG(a, b, c, d,  5,  5, 0xd62f105d);";
  z[lc++]="  NSYS_SETG(d, a, b, c, 10,  9, 0x02441453);";
  z[lc++]="  NSYS_SETG(c, d, a, b, 15, 14, 0xd8a1e681);";
  z[lc++]="  NSYS_SETG(b, c, d, a,  4, 20, 0xe7d3fbc8);";
  z[lc++]="  NSYS_SETG(a, b, c, d,  9,  5, 0x21e1cde6);";
  z[lc++]="  NSYS_SETG(d, a, b, c, 14,  9, 0xc33707d6);";
  z[lc++]="  NSYS_SETG(c, d, a, b,  3, 14, 0xf4d50d87);";
  z[lc++]="  NSYS_SETG(b, c, d, a,  8, 20, 0x455a14ed);";
  z[lc++]="  NSYS_SETG(a, b, c, d, 13,  5, 0xa9e3e905);";
  z[lc++]="  NSYS_SETG(d, a, b, c,  2,  9, 0xfcefa3f8);";
  z[lc++]="  NSYS_SETG(c, d, a, b,  7, 14, 0x676f02d9);";
  z[lc++]="  NSYS_SETG(b, c, d, a, 12, 20, 0x8d2a4c8a);";
  z[lc++]="";
  z[lc++]="  NSYS_SETH(a, b, c, d,  5,  4, 0xfffa3942);";
  z[lc++]="  NSYS_SETH(d, a, b, c,  8, 11, 0x8771f681);";
  z[lc++]="  NSYS_SETH(c, d, a, b, 11, 16, 0x6d9d6122);";
  z[lc++]="  NSYS_SETH(b, c, d, a, 14, 23, 0xfde5380c);";
  z[lc++]="  NSYS_SETH(a, b, c, d,  1,  4, 0xa4beea44);";
  z[lc++]="  NSYS_SETH(d, a, b, c,  4, 11, 0x4bdecfa9);";
  z[lc++]="  NSYS_SETH(c, d, a, b,  7, 16, 0xf6bb4b60);";
  z[lc++]="  NSYS_SETH(b, c, d, a, 10, 23, 0xbebfbc70);";
  z[lc++]="  NSYS_SETH(a, b, c, d, 13,  4, 0x289b7ec6);";
  z[lc++]="  NSYS_SETH(d, a, b, c,  0, 11, 0xeaa127fa);";
  z[lc++]="  NSYS_SETH(c, d, a, b,  3, 16, 0xd4ef3085);";
  z[lc++]="  NSYS_SETH(b, c, d, a,  6, 23, 0x04881d05);";
  z[lc++]="  NSYS_SETH(a, b, c, d,  9,  4, 0xd9d4d039);";
  z[lc++]="  NSYS_SETH(d, a, b, c, 12, 11, 0xe6db99e5);";
  z[lc++]="  NSYS_SETH(c, d, a, b, 15, 16, 0x1fa27cf8);";
  z[lc++]="  NSYS_SETH(b, c, d, a,  2, 23, 0xc4ac5665);";
  z[lc++]="";
  z[lc++]="  NSYS_SETI(a, b, c, d,  0,  6, 0xf4292244);";
  z[lc++]="  NSYS_SETI(d, a, b, c,  7, 10, 0x432aff97);";
  z[lc++]="  NSYS_SETI(c, d, a, b, 14, 15, 0xab9423a7);";
  z[lc++]="  NSYS_SETI(b, c, d, a,  5, 21, 0xfc93a039);";
  z[lc++]="  NSYS_SETI(a, b, c, d, 12,  6, 0x655b59c3);";
  z[lc++]="  NSYS_SETI(d, a, b, c,  3, 10, 0x8f0ccc92);";
  z[lc++]="  NSYS_SETI(c, d, a, b, 10, 15, 0xffeff47d);";
  z[lc++]="  NSYS_SETI(b, c, d, a,  1, 21, 0x85845dd1);";
  z[lc++]="  NSYS_SETI(a, b, c, d,  8,  6, 0x6fa87e4f);";
  z[lc++]="  NSYS_SETI(d, a, b, c, 15, 10, 0xfe2ce6e0);";
  z[lc++]="  NSYS_SETI(c, d, a, b,  6, 15, 0xa3014314);";
  z[lc++]="  NSYS_SETI(b, c, d, a, 13, 21, 0x4e0811a1);";
  z[lc++]="  NSYS_SETI(a, b, c, d,  4,  6, 0xf7537e82);";
  z[lc++]="  NSYS_SETI(d, a, b, c, 11, 10, 0xbd3af235);";
  z[lc++]="  NSYS_SETI(c, d, a, b,  2, 15, 0x2ad7d2bb);";
  z[lc++]="  NSYS_SETI(b, c, d, a,  9, 21, 0xeb86d391);";
  z[lc++]="";
  z[lc++]="  pms->abcd[0] += a;";
  z[lc++]="  pms->abcd[1] += b;";
  z[lc++]="  pms->abcd[2] += c;";
  z[lc++]="  pms->abcd[3] += d;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#undef NSYS_ROTATE_LEFT";
  z[lc++]="#undef NSYS_FUNCT_F";
  z[lc++]="#undef NSYS_FUNCT_G";
  z[lc++]="#undef NSYS_FUNCT_H";
  z[lc++]="#undef NSYS_FUNCT_I";
  z[lc++]="#undef NSYS_SETF";
  z[lc++]="#undef NSYS_SETG";
  z[lc++]="#undef NSYS_SETH";
  z[lc++]="#undef NSYS_SETI";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               append phase of MD5 computation                   */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_append(nsys_md5_state_t * pms, unsigned char * data, int nbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char *p;";
  z[lc++]="  int left, offset, copy;";
  z[lc++]="  unsigned int nbits;";
  z[lc++]="";
  z[lc++]="  if (nbytes <= 0)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  p = data;";
  z[lc++]="  left = nbytes;";
  z[lc++]="  offset = (pms->count[0] >> 3) & 63;";
  z[lc++]="  nbits  = (unsigned int)(nbytes << 3);";
  z[lc++]="";
  z[lc++]="  /* Update the message length. */";
  z[lc++]="";
  z[lc++]="  pms->count[1] += nbytes >> 29;";
  z[lc++]="  pms->count[0] += nbits;";
  z[lc++]="";
  z[lc++]="  if (pms->count[0] < nbits)";
  z[lc++]="    pms->count[1]++;";
  z[lc++]="";
  z[lc++]="  /* Process an initial partial block. */";
  z[lc++]="  ";
  z[lc++]="  if (offset) ";
  z[lc++]="    {";
  z[lc++]="      copy = (offset + nbytes > 64 ? 64 - offset : nbytes);";
  z[lc++]="      ";
  z[lc++]="      memcpy(pms->buf + offset, p, copy);";
  z[lc++]="      if (offset + copy < 64)";
  z[lc++]="	return;";
  z[lc++]="";
  z[lc++]="      p += copy;";
  z[lc++]="      left -= copy;";
  z[lc++]="      nsys_md5_process(pms, pms->buf);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* Process full blocks. */";
  z[lc++]="  ";
  z[lc++]="  for (; left >= 64; p += 64, left -= 64)";
  z[lc++]="    nsys_md5_process(pms, p);";
  z[lc++]="  ";
  z[lc++]="  /* Process a final partial block. */";
  z[lc++]="  ";
  z[lc++]="  if (left)";
  z[lc++]="    memcpy(pms->buf, p, left);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               final phase of MD5 computation                   */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_finish(nsys_md5_state_t * pms, unsigned char digest[16])";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char data[8];";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /* Save the length before padding. */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < 8; ++i)";
  z[lc++]="    data[i] = (unsigned char)(pms->count[i >> 2] >> ((i & 3) << 3));";
  z[lc++]="";
  z[lc++]="  /* Pad to 56 bytes mod 64. */";
  z[lc++]="";
  z[lc++]="  nsys_md5_append(pms, nsys_md5_pad, ((55 - (pms->count[0] >> 3)) & 63) + 1);";
  z[lc++]="";
  z[lc++]="  /* Append the length. */";
  z[lc++]="";
  z[lc++]="  nsys_md5_append(pms, data, 8);";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < 16; ++i)";
  z[lc++]="    digest[i] = (unsigned char)(pms->abcd[i >> 2] >> ((i & 3) << 3));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*           end of code covered by Alladin Copyright              */";
  z[lc++]="/*_________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               function call to compute MD5                      */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_md5(unsigned char * digest, unsigned char * text, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_md5_state_t state;";
  z[lc++]="";
  z[lc++]="  nsys_md5_init(&state);	";
  z[lc++]="  nsys_md5_append(&state, text, len);";
  z[lc++]="  nsys_md5_finish(&state, digest);";
  z[lc++]="  return digest;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*   computes hmac-md5, key is always a 16-byte digest   */";
  z[lc++]="/*                modified code from RFC2104             */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="char * nsys_hmac_md5(unsigned char* text, int text_len, ";
  z[lc++]="		     unsigned char * keydigest, unsigned char * digest)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_md5_state_t context;";
  z[lc++]="  unsigned char k_ipad[64], k_opad[64];";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  memcpy(k_ipad, keydigest, 16);";
  z[lc++]="  memset(&(k_ipad[16]), 0, 48);";
  z[lc++]="  memcpy(k_opad, keydigest, 16);";
  z[lc++]="  memset(&(k_opad[16]), 0, 48);";
  z[lc++]="";
  z[lc++]="  for (i=0; i<64; i++) ";
  z[lc++]="    {";
  z[lc++]="      k_ipad[i] ^= 0x36;";
  z[lc++]="      k_opad[i] ^= 0x5c;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_md5_init(&context);";
  z[lc++]="  nsys_md5_append(&context, k_ipad, 64); ";
  z[lc++]="  nsys_md5_append(&context, text, text_len);";
  z[lc++]="  nsys_md5_finish(&context, digest);  ";
  z[lc++]="";
  z[lc++]="  nsys_md5_init(&context);";
  z[lc++]="  nsys_md5_append(&context, k_opad, 64);";
  z[lc++]="  nsys_md5_append(&context, digest, 16);";
  z[lc++]="  nsys_md5_finish(&context, digest);";
  z[lc++]="  return (char *) digest;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*          constant array for base64 translation                 */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_b64map[64] = {";
  z[lc++]="  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', ";
  z[lc++]="  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',";
  z[lc++]="  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', ";
  z[lc++]="  'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',";
  z[lc++]="  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'";
  z[lc++]="}; ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/* converts 16-byte hash function to 25-byte output string */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_digest_base64(unsigned char * output, ";
  z[lc++]="				   unsigned char * input)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = 0;";
  z[lc++]="  for (i = 0; i <= 12; i += 3)";
  z[lc++]="    {";
  z[lc++]="      output[j++] = nsys_b64map[input[i] >> 2];";
  z[lc++]="      output[j++] = nsys_b64map[((input[i] & 3) << 4) | (input[i+1] >> 4)];";
  z[lc++]="      output[j++] = nsys_b64map[((input[i+1] & 15) << 2) | (input[i+2] >> 6)];";
  z[lc++]="      output[j++] = nsys_b64map[input[i+2] & 63];";
  z[lc++]="    }";
  z[lc++]="  output[j++] = nsys_b64map[input[i] >> 2];";
  z[lc++]="  output[j++] = nsys_b64map[(input[i] & 3) << 4];";
  z[lc++]="  output[j++] = '=';";
  z[lc++]="  output[j++] = '=';";
  z[lc++]="  output[j++] = '\\0';";
  z[lc++]="  return output;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           checks string for Base64 MD5 Digest format         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_digest_syntaxcheck(char * s)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret = 1;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((strlen(s) == 24) && (s[23] == '=') && (s[22] == '=') && ";
  z[lc++]="	  ((s[21] == 'A') || (s[21] == 'Q') || (s[21] == 'g') || ";
  z[lc++]="	   (s[21] == 'w')))";
  z[lc++]="    {";
  z[lc++]="      for (i=0; i < 21; i++)";
  z[lc++]="	ret &= (isalnum((int)s[i]) || (s[i] == '+') || (s[i] == '/')); ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = 0;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*                end of crypto network library                    */";
  z[lc++]="/*******************************************************************/";
  printlib(lc);
}


