/***************************************************************************
                          alsa_client.h  -  description
                             -------------------
    begin                : Mon Feb 4 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef ALSA_ENABLED

#ifndef ALSA_CLIENT_H
#define ALSA_CLIENT_H

#include <alsa/asoundlib.h>
#include "midi_client.h"
#include <list>
/**
  *@author Juan Linietsky
  */

class Alsa_Client : public Midi_Client {

public:

private:

	struct Note_Event {

		char note,velocity;
		bool note_off;
	};

        list<Note_Event> note_list;
	
	snd_seq_t *handle;	/* The snd_seq handle to /dev/snd/seq */
	int client;		/* The client associated with this context */
	int port_index;	/* created sequencer ports */
	int fd;			/* The file descriptor */
	int used;		/* number of current connection */
	bool active;		/* */


	int get_file_descriptor();
	
	void dispatch_events();
		
public:

	bool are_notes_pending(); //return true if notes are pending
	bool get_note(char &p_note,char &p_velocity, bool &p_is_noteoff); //return note stuff, but false if no note was retrieved
	
	bool create_port();
	void close_port();


	Alsa_Client();
	~Alsa_Client();
};

#endif
#endif