 /***************************************************************************
                          editor.cpp  -  description
                             -------------------
    begin                : Sat Sep 30 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editor.h"


char noteincr_qwerty[29] = {'Z','S','X','D','C','V','G','B','H','N','J','M','Q','2','W','3','E','R','5','T','6','Y','7','U','I','9','O','0','P'};

Pattern_Editor::Pattern_Editor(){

	song=NULL;

	noteincr=noteincr_qwerty;
	cursor_spacing=1;
	default_octave=4;

	last_note=0;
	last_volume=65;
	last_command=0;
	last_parameter=0;
	last_controller_set=0;
	last_controller_value=0;

	previous_cursor_y=0;
	previous_cursor_x=0;
	clear_redraw_flags();

	volume_mask=true;
	selection_active=false;

	clipboard=new Pattern;

	playing=false;
	playing_row_old=-1;

	show_global_row=false;
	locked_to_pattern=true;
	follow_song=false;

	last_volume_scale=100;
}

void Pattern_Editor::adjust_view_to_cursor() {


	if (cursor_x>song->get_abs_width()-1) cursor_x=song->get_abs_width()-1;

	if (column_offset>cursor_x) {

		//FIXME: SCROLLING!
		column_offset=cursor_x;
		set_flag_redraw_all();
        }
	
	if (column_offset+(get_visible_columns()-1)<cursor_x) {

		//FIXME: SCROLLING!
		column_offset=cursor_x-(get_visible_columns()-1);
		set_flag_redraw_all();
	}

	if (row_offset>cursor_y) {


		//FIXME: SCROLLING!
		row_offset=cursor_y;
		set_flag_redraw_all();
	}

	if (row_offset+(get_visible_rows()-1)<cursor_y) {

		//FIXME: SCROLLING!
		row_offset=cursor_y-(get_visible_rows()-1);
		set_flag_redraw_all();
	}

}


int Pattern_Editor::get_visible_columns() {
	
	int tmpint;

	tmpint=((window_width-left_numbers_width())-get_font_width()*3)/get_column_width();

	if (column_offset+tmpint>=song->get_abs_width()) tmpint-=((column_offset+tmpint)-song->get_abs_width());

	return tmpint;
}

int Pattern_Editor::get_visible_rows() {
	
	int tmpint;

	tmpint=(window_height-top_data_height())/get_row_height();

	if (row_offset+tmpint>=song->get_abs_height()) tmpint-=song->get_abs_height()-(row_offset+tmpint);

	return tmpint;
}

string Pattern_Editor::get_number_string(int row) {

	//must do it in a better way.. uh?
        int finalrow,realrow;
	char buf[10];
	finalrow=row+row_offset;
	realrow=song->get_abs_row(finalrow);	
		
	if (!show_global_row) {

		buf[0]='0'+(realrow / 100) % 10;
		buf[1]='0'+(realrow / 10) % 10;
		buf[2]='0'+(realrow) % 10;
		buf[3]=0;

	} else {

		buf[0]='0'+(finalrow / 10000) % 10;
		buf[1]='0'+(finalrow / 1000) % 10;
		buf[2]='0'+(finalrow / 100) % 10;
		buf[3]='0'+(finalrow / 10) % 10;
		buf[4]='0'+(finalrow) % 10;
		buf[5]='-';
		buf[6]='0'+(realrow / 100) % 10;
		buf[7]='0'+(realrow / 10) % 10;
		buf[8]='0'+(realrow) % 10;
		buf[9]=0;

	}

	return buf;
}

string Pattern_Editor::get_note_string(int column,int row) {

	Note note;


	static const char* notes[128] = {

		"C-0", "C#0", "D-0", "D#0", "E-0", "F-0", "F#0", "G-0", "G#0", "A-0", "A#0", "B-0",
		"C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "B-1",
		"C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "B-2",
		"C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "B-3",
		"C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "B-4",
		"C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "B-5",
		"C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "B-6",
		"C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "B-7",
		"C-8", "C#8", "D-8", "D#8", "E-8", "F-8", "F#8", "G-8", "G#8", "A-8", "A#8", "B-8",
		"C-9", "C#9", "D-9", "D#9", "E-9", "F-9", "F#9", "G-9", "G#9", "A-9", "A#9", "B-9",
		"C-A", "C#A", "D-A", "D#A", "E-A", "F-A", "F#A", "G-A"
	};

	static const char hexn[] = {
        	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
	};

	const char *notestring;
      	unsigned char tmpvol;
	char buf[18];
	//get note from editor;

	note=song->abs_note(column,row);

	/* the note */


	if (note.note==Note::CLEAR) {

		notestring = "...";

	} else if (note.note<128) {

	       	notestring = notes[note.note];
	} else if (note.note==Note::OFF) {

		notestring = "==="; // note off!
	} else {

		notestring = "???"; // wuzdis?

	}


	buf[0] = notestring[0];
	buf[1] = notestring[1];
	buf[2] = notestring[2];


	/* note off */


	tmpvol=note.volume;

	if (tmpvol & 128) {

		buf[3] = '=';
		tmpvol &= 127;

	} else {

		buf[3] = ' ';
	}

	/* volume */

	if (tmpvol>64) {

		buf[4] = '.';
		buf[5] = '.';

	} else {

		buf[4] = '0'+tmpvol/10; //no hex for the volumes pleez, hex sux0rs :P
		buf[5] = '0'+tmpvol % 10;

	}

	/* Command */

	buf[6] = ' ';

	if (note.command!=Note::CLEAR) {

		buf[7] ='A'+note.command;

	} else {

		buf[7] = '.';

	}

	/* Parameter */


	buf[8] = hexn[note.parameter/0x10];
	buf[9] = hexn[note.parameter&0xF];

	/* Controller Change */

	buf[10] = ' ';

	if (note.controller_set==Note::CLEAR) {

		buf[11] = '.';
		buf[12] = '.';
		buf[13] = '.';

	} else if (note.controller_set<128 ) {

		buf[11]  = '0' + (note.controller_set) /100; //no hex for the controller.. NO!
		buf[12] = '0' + ((note.controller_set)/10) % 10;
		buf[13] = '0' + (note.controller_set) % 10;
	} else {

		buf[11] = 'f';
		buf[12] = 'x';
		buf[13] = 'A'+note.controller_set-128;
	}

	buf[14] = '-';
	buf[15] = hexn[note.controller_value/0x10];
	buf[16] = hexn[note.controller_value&0xF];
	buf[17] = 0; // string ends here

	return buf;
}

Note Pattern_Editor::get_note_from_string(string p_note_str) {

}

void Pattern_Editor::add_column_to_current_track() {

	song->add_track_column(song->get_abs_track(cursor_x));

}

int Pattern_Editor::remove_column_to_current_track() {

	int tmptrack;

	tmptrack=song->get_abs_track(cursor_x);
	if ((song->get_track_width(tmptrack)>1) && (song->get_abs_column(cursor_x)==(song->get_track_width(tmptrack)-1))) cursor_move_left(1);
	song->remove_track_column(tmptrack);

		
	return 0; // -1 is normal - 0+ means the track was deleted by the editor (0 columns)	
}

void Pattern_Editor::validate_track_midi_instruments() {

	int i,track;

	for (i=0;i<song->get_tracks();i++) {		
	
		track = i;
	
		if (song->get_instrument(track)->midi.device.get()>=song->user_devices.get_device_count()) {
	
			song->get_instrument(track)->midi.device=song->user_devices.get_device_count()-1;
		}

		if (song->get_instrument(track)->midi.device.get()>=0) {

			if (song->get_instrument(track)->midi.bank.get()>=song->user_devices.get_device(song->get_instrument(track)->midi.device.get())->instrument_map.get_banks_count()) {
	
				song->get_instrument(track)->midi.bank=song->user_devices.get_device(song->get_instrument(track)->midi.device.get())->instrument_map.get_banks_count()-1;
			}
		}
	
	}
	
}

void Pattern_Editor::validate_devices_midiout() {

	int i,j,auxdev;

	for (i=0;i<song->user_devices.get_device_count();i++) {


		if ((song->user_devices.get_device(i)->hardware_device_index<0) || (!midiout->is_device_enabled(song->user_devices.get_device(i)->hardware_device_index))) {

			auxdev=-1;

			for (j=midiout->GetDevicesCount()-1;j>=0;j--) {

				if (midiout->is_device_enabled(j)) auxdev=j;

			}

			song->user_devices.get_device(i)->hardware_device_index=auxdev;			

		}
		
	}


}


void Pattern_Editor::set_pattern_properties(int pattern,int hlmaj,int hlmin,int hlrepeat,int patlength,int patrepeat) {

	int i;

	for (i=0;i<patrepeat+1;i++) {

		song->set_pattern_length(pattern+i,patlength);
	}

	for (i=0;i<hlrepeat+1;i++) {

		song->set_pattern_hl_major(pattern+i,hlmaj);
		song->set_pattern_hl_minor(pattern+i,hlmin);
	}

}

int Pattern_Editor::get_cursor_pattern() {

	return song->get_abs_pattern(cursor_y);

}
int Pattern_Editor::get_cursor_track() {

	return song->get_abs_track(cursor_x);

}
int Pattern_Editor::get_cursor_column() {

	return song->get_abs_column(cursor_x);
}
int Pattern_Editor::get_cursor_row() {

	return song->get_abs_row(cursor_y);
}

void Pattern_Editor::notify_set_playing_row(int p_row) {

	if (p_row==playing_row) {
		
		playing_new_row=false;
		return;
	};

	set_flag_redraw_playing_row();
	playing_row_old=playing_row;
	playing_row=p_row;
	playing_new_row=true;

	if ((p_row>0) && follow_song) {
         	/*
		if (playing_row>cursor_y) {

                 	cursor_step_down(playing_row-cursor_y);
		}

		if (playing_row<cursor_y) {

                 	cursor_step_up(cursor_y-playing_row);
		} */
		cursor_y=playing_row;
		set_flag_redraw_row();
	}

}
char Pattern_Editor::get_note_from_key(int key) {

        int tmpinc=GiveNoteIncrement(key);
        int tmpnote;

        if (tmpinc!=99) {

                tmpnote=(12*default_octave+tmpinc);
                tmpnote=BOUND(tmpnote,0,Note::NOTES);
        } else {

                tmpnote=-1;
        }

        return tmpnote;
}

void Pattern_Editor::pattern_expand() {

	int i,j,pattern,length;

	pattern=get_cursor_pattern();
	length=song->get_pattern_length(pattern);
	if (length>128) return;
	song->set_pattern_length(pattern,length*2);
	for (i=0;i<song->get_abs_width();i++) {

		for (j=length-1;j>=0;j--) {
	
			song->abs_note_ref(i,song->get_global_row(j*2,pattern))=song->abs_note(i,song->get_global_row(j,pattern));
	
			if (j%2==1) song->abs_note_ref(i,song->get_global_row(j,pattern)).clear();
		}
	}
}

void Pattern_Editor::pattern_shrink() {

	int i,j,pattern,length;

	pattern=get_cursor_pattern();
	length=song->get_pattern_length(pattern);

	if (length<=32) return;

	for (i=0;i<song->get_abs_width();i++) {

		for (j=0;j<length;j++) {
	
			song->abs_note_ref(i,song->get_global_row(j,pattern))=song->abs_note(i,song->get_global_row(j*2,pattern));
		}
	}

	song->set_pattern_length(pattern,length/2);
	normalize_selection();
}

Pattern_Editor::~Pattern_Editor(){

}
