/***************************************************************************
                          instrument.cpp  -  description
                             -------------------
    begin                : Sun Sep 17 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "instrument.h"

Instrument::Instrument() : def_volume(0,64),glb_volume(0,127),PNVA_type(0,4),VCB(0,1),PNVA_controller(0,127) {

        Initial_Value new_values;

	clear();

	new_values.type=Initial_Value::CONTROLLER;
	new_values.controller=7;
	new_values.value=127;
	initial_value.push_back(new_values);
	new_values.controller=10;
	new_values.value=64;
	initial_value.push_back(new_values);
	new_values.controller=91;	
	new_values.value=24;
	initial_value.push_back(new_values);
	new_values.controller=93;
	new_values.value=10;	
	initial_value.push_back(new_values);
	new_values.controller=11;
	new_values.value=127;	
	initial_value.push_back(new_values);

}
Instrument::~Instrument(){

	clear();
}


void Instrument::clear() {

	// name to be assigned. need a string class
	
      int i;

	
      name = "New Instrument";

	mute=false;
	midi.device=0;
	midi.bank=0;
	midi.patch=0;
	midi.channel=0;
	midi.PBS=12;

	for (i=0;i<128;i++) {

		linear_volume_forcing_table[i]=0;
	}

	def_volume=64;
	glb_volume=127;

	PNVA_type = PNVA_CONTROLLER;
	PNVA_controller = 11;
	VCB = VCB_NORMAL;

	force_linear_volume=false;
}

