/* $Id: libc.h,v 1.9 2003/05/30 00:42:39 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Library routines for handling stuff typically handled by libc and
 * other standard libraries 
 */

#ifndef _LIB_H
#define _LIB_H

#include <stdarg.h>
#include "port.h"

/*
 * This is the only thing here that is special.  Since
 * we don't have the analog of __libc_init called for us,
 * this function must be called before any other library
 * functions can be used 
 */
void lib_init(void *backend_data);


void *lib_malloc(unsigned int size);
void  lib_free(void *alloc);
void  lib_vprintf(char *fmt, va_list ap);
void  lib_printf(char *fmt, ...);
void *lib_memset(void *s, int c, unsigned int n);
void  lib_bzero(void *s, unsigned int n);
void *lib_memcpy(void *dest, void *src, unsigned int n);
int   lib_memcmp(void *s1, void *s2, unsigned int n);
char *lib_strncpy(char *dest, char *src, unsigned int n);
char *lib_strcpy(char *dest, char *src);
char *lib_strdup(char *src);
char *lib_strchr(char *src,char c);
int   lib_strlen(char *str);
int   lib_strncmp(char *s1, char *s2, unsigned long n);
int   lib_strcmp(char *s1, char *s2);
char *lib_strcat(char *s1, char *s2);
int   lib_strnlen(char *str, unsigned int maxlen);
void  lib_usleep(unsigned long usec);
void  lib_putc(char c);
void  lib_exit(void);
uint64_t lib_get_time(void);
int   lib_isspace(char);
int   lib_isdigit(char);
int   lib_isalpha(char c);
int   lib_poll_input (char *);
uint64_t lib_strtou64(char *, char **, int base);
uint64_t lib_strtomacaddr(char *str);
int   lib_ultostr(char *, unsigned long);
char  lib_toupper(char);
char  lib_tolower(char);
char *lib_strtok(char *str, char *delim);
uint32_t lib_parse_ip(char *str);
void  lib_print_ip(uint32_t ip);
void  lib_print_mac_addr(uint64_t mac_addr);
int lib_atoi(char *str);

void lib_die(char *msg, ...);



#endif
