#include <SimpleDB/SimpleDB.h>
#include <unistd.h>
#include <memory>

int main (int argc, char* argv[])
{
  std::cerr << "START" << std::endl ;
 std::cerr << "Process Id : " << getpid() << std::endl ;
  sleep (6) ;
  // memory leak check
  long int i = 0 ;
  while (i < 1000) {
    try {
      SimpleDB::SimpleDBFactory* factory  = SimpleDB::SimpleDBFactory::Instance() ;
      std::auto_ptr<SimpleDB::Database> db = factory->getDBHandle("nightowl") ;
      
      SimpleDB::Query query = db->newQuery();
      SimpleDB::LongColumn longCol = SimpleDB::LongColumn();
      SimpleDB::Column * columns[1] = {&longCol};
      query.bind(columns, 1);
      query.execute("SELECT count(moduleId) FROM Modules");
      query.fetchRow();
      //cerr << "I: " << i << endl ;
      i++ ;
      //std::cout << "Number: " << longCol << std::endl;
      factory->Kill() ;
    }
    catch (SimpleDB::Database::Exception &exc ){
      std::cerr << exc << std::endl ;
    }
  }
  std::cerr << "FINISH" << std::endl ;
  return 0 ;
}
