=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DB_select
  class Case
    def initialize(opt,conn='',sql_type='pg')
      @opt,@conn,@sql_type=opt,conn,sql_type
      #@sdb=Create.new(@conn)
      @sdb=SiSU_DB_DBI::Create.new(@opt,@conn,@sql_type)
      @index=SiSU_DB_DBI::Index.new(@opt,@conn,@sql_type)
      @sdb_no=SiSU_DB_DBI::Drop.new(@opt,@conn,@sql_type)
      @sdb_import=SiSU_DB_DBI::Import.new(@opt,@conn,@sql_type) if @opt.mod.inspect =~/update|import/
      @remove=SiSU_DB_DBI::Remove.new(@opt,@conn) if @opt.mod.inspect =~/update|remove/
      @db=SiSU_Env::Info_db.new
    end
    def cases
      @opt.mod.each do |mod|
        case mod
        when /^--createdb$/
          @sdb.output_dir?
          begin
          @sdb.create_db
          rescue; @sdb.output_dir?
          end
        when /^--(?:init(?:ialize)?|create(?:all)?)$/
          @sdb.output_dir?
          #@sdb.create_db
          begin
          @sdb.create_table.metadata
          @sdb.create_table.documents
          @sdb.create_table.endnotes
          @sdb.create_table.endnotes_asterisk
          @sdb.create_table.endnotes_plus
          @sdb.create_table.urls
          @index.create_indexes
          rescue;  SiSU_Errors::Info_error.new($!,$@,'-D').error; @sdb.output_dir?
          end
        when /^--createtable(s)?$/
          @sdb.output_dir?
          begin
          @sdb.create_table.metadata
          @sdb.create_table.documents
          @sdb.create_table.endnotes
          @sdb.create_table.endnotes_asterisk
          @sdb.create_table.endnotes_plus
          @sdb.create_table.urls
          @index.create_indexes
          rescue; @sdb.output_dir?
          end
        when /^--recreate$/
          @sdb.output_dir?
          begin
          @sdb_no.drop.tables
          @sdb.create_table.metadata
          @sdb.create_table.documents
          @sdb.create_table.endnotes
          @sdb.create_table.endnotes_asterisk
          @sdb.create_table.endnotes_plus
          @sdb.create_table.urls
          @index.create_indexes
          rescue; @sdb.output_dir?
          end
        when /^--cr(eate)?lex$/
          @sdb.output_dir?
          begin
          @sdb.create_table.documents
          rescue; @sdb.output_dir?
          end
        when /^--cr(eate)?metadata$/
          @sdb.output_dir?
          begin
          @sdb.create_table.metadata
          rescue; @sdb.output_dir?
          end
        when /^--import$/
          @sdb_import.marshal_load
          tell=case @sql_type
          when /sqlite/; SiSU_Screen::Ansi.new(@opt.cmd,"sqlite #{@db.sqlite.db} database?")
          when /pg/;     SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.psql.db} database?")
          else '???'
          end
          tell.puts_grey if @opt.cmd =~/v/
        when /^--remove$/
          @remove.remove
        when /^--update$/
          @remove.remove
          @sdb_import.marshal_load
          tell=SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.psql.db} database?")
          tell.puts_grey if @opt.cmd =~/v/
        when /^--index$/
          @index.create_indexes
        when /^droptable(s)?$/
          @sdb_no.drop.tables
        when /^--dropindex(es)?$/
          @sdb_no.drop.indexes
        when /^--(?:dropall|drop)$/
          @sdb_no.drop.tables
          #@sdb_no.drop.indexes
        when /^--(?:db=)?(?:(?:sq)?lite|pg(?:sql)?|my(?:sql)?)$/
        else
          help=SiSU_Help::Help.new
          help.summary
          help.commands
        end
      end
      begin
      @conn.commit if @sql_type =~/sqlite/
      rescue; @sdb.output_dir?
      end
    end
  end
end
__END__
