# Sketch - A Python-based interactive drawing program
# Copyright (C) 1998, 1999, 2000 by Bernhard Herzog
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


###Sketch Config
#type = PluginCompound
#class_name = 'SymbolGroup'
#factory = 'CreateSymbolGroup'
#menu_text = 'Symbol Group'
#uses_selection = 1
###End

from Sketch import PluginCompound, Point, CreateMultiUndo, NullPoint
import Sketch

class SymbolGroup(PluginCompound):

    is_Group = 1 # this, together with the Ungroup method lets the user
                 # ungroup symbol groups just like an ordinary
                 # group
    class_name = 'SymbolGroup'

    def __init__(self, objects = None, duplicate = None, loading = 0,
                 name = '', layout_point = (0, 0)):
	PluginCompound.__init__(self, objects, duplicate = duplicate)
        if duplicate is not None:
            self.name = duplicate.name
            self.layout_point = duplicate.layout_point
        else:
            self.name = name
            self.layout_point = apply(Point, layout_point)

    def SaveToFile(self, file):
	PluginCompound.SaveToFile(self, file, name = self.name,
                                  layout_point = tuple(self.LayoutPoint()))

    def SetLayoutPoint(self, layout_point):
        undo = self.SetLayoutPoint, self.layout_point
        self.layout_point = layout_point
        return undo

    def Transform(self, trafo):
        return CreateMultiUndo(PluginCompound.Transform(self, trafo),
                               self.SetLayoutPoint(trafo(self.layout_point)))

    def Translate(self, offset):
        PluginCompound.Translate(self, offset)
        self.layout_point = self.layout_point + offset
        return self.Translate, -offset

    def Info(self):
	return _("Symbol Group '%(name)s'") % self.__dict__

    def LayoutPoint(self):
        return self.layout_point

    Ungroup = PluginCompound.GetObjects


def CreateSymbolGroup(objects):
    # XXX relying on the GetName function in the layerdlg module is not
    # really a good idea. That function may be removed or otherwise
    # changed in the future. The same applies to accessing main_window's
    # root attribute
    from Sketch.UI.layerdlg import GetName
    name = GetName(Sketch.main.application.main_window.root, '')
    return SymbolGroup(objects, name = name)
