#/*
** Copyright (C) 2000 Rene Puls <rpuls@gmx.net>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef SMARTCARD_H
#define SMARTCARD_H

#define SMARTCARD_SELECT_FID 0x00 /* File ID */
#define SMARTCARD_SELECT_AID 0x04 /* Application ID */

#define SMARTCARD_FID_ALL 0x3F00 /* select complete card */
#define SMARTCARD_FID_DIR 0x2F00 /* select DIR */
#define SMARTCARD_FID_ATR 0x2F01 /* select ATR */

char const * smartcard_ctapi_error_msg(int errnum);
int smartcard_init_terminal(unsigned short int const cnr, 
			    unsigned short int const port);
int smartcard_close_terminal(unsigned short int const cnr);
int smartcard_activate_card(unsigned short int const cnr);
int smartcard_read_data(unsigned short int const cnr, 
			char * const buf, 
			unsigned short int const size,
			unsigned short int const pos);
int smartcard_write_data(unsigned short int const cnr, 
			 char const * const buf, 
			 unsigned short int const size,
			 unsigned short int const pos);
int smartcard_display_info(unsigned short int const cnr, 
			   int const force_read_atr);

#endif /* #ifdef SMARTCARD_H */
