/***************************************************************************
    smb4kscanner_p  -  This is a private helper class for Smb4KScanner.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// application specific includes
#include "smb4kscanner_p.h"


Smb4KScannerPrivate::Smb4KScannerPrivate()
{
  retry = false;
  clearData();
}


Smb4KScannerPrivate::~Smb4KScannerPrivate()
{
}


void Smb4KScannerPrivate::clearData()
{
  m_workgroup = QString::null;
  m_host = QString::null;
  m_ip = QString::null;
  m_share = QString::null;
}


void Smb4KScannerPrivate::setWorkgroup( const QString &w )
{
  m_workgroup = w;
}


void Smb4KScannerPrivate::setHost( const QString &h )
{
  m_host = h;
}


void Smb4KScannerPrivate::setIP( const QString &i )
{
  m_ip = i;
}


void Smb4KScannerPrivate::setShare( const QString &s )
{
  m_share = s;
}


const QString &Smb4KScannerPrivate::workgroup()
{
  return m_workgroup;
}


const QString &Smb4KScannerPrivate::host()
{
  return m_host;
}


const QString &Smb4KScannerPrivate::ip()
{
  return m_ip;
}


const QString &Smb4KScannerPrivate::share()
{
  return m_share;
}
