/*
 * BufferWriter.h -- Buffered Output
 * Copyright (C) 2003 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_BUFFER_WRITER_
#define _KINO_BUFFER_WRITER_

#include <stdint.h>

class BufferWriter
{
	private:
		int size;
		uint8_t *buffer;
		int used;
	
	public:
		BufferWriter( int size );
		virtual ~BufferWriter( );
		virtual int Write( uint8_t *data, int size ) = 0;
		int FlushBuffer( );
		int PutBuffer( uint8_t *data, int length );
		int PutBuffer( uint8_t byte );
		int PutBuffer( uint32_t value );
		int PutBuffer( int16_t value );
		int PutBuffer( int16_t values[], int );
};

#endif
