/*
 * dvencoder.h -- DV Encoder Classes
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_DV_ENCODE_
#define _KINO_DV_ENCODE_

#include "DVEncoderParams.h"
#include "AudioImporter.h"

#include <libdv/dv.h>
#include <time.h>

class Frame;

/** DV Encoder class.
*/

class DVEncoder : virtual public DVEncoderParams
{
	private:
		dv_encoder_t *encoder;
		int frame_count;
		int audio_count;
		time_t datetime;
		int16_t *audio_buffers[ 4 ];
		AudioImporter *import;
		bool fixed_audio_samples;
		uint8_t *temp_image;
	public:
		DVEncoder( );
		DVEncoder( DVEncoderParams & );
		~DVEncoder( );
		void EncodeRGB( uint8_t *data, uint8_t *image );
		void EncodeRGB( Frame &frame, uint8_t *image );
		void EncodeAudio( Frame &frame );
		void SetFixedAudioSamples( bool fixed_audio_samples );
		void EncodeMetaData( Frame &frame );
		void SetNewRecording( );
	protected:
		dv_encoder_t *GetEncoder( );
		void DestroyEncoder( );
		int GetAudioSamplesPerFrame( Frame & );
};

#endif
