/*
 * DVEncoderImageParams.h -- DV Encoder Classes
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_DV_ENCODER_IMAGE_PARAMS_
#define _KINO_DV_ENCODER_IMAGE_PARAMS_

/** Parameters associated to dv image encoding.
*/

class DVEncoderImageParams
{
	private:
		bool pal;
		int encode_passes;
		int static_qno;
		bool wide;
		bool two_pass_encoding;

	public:
		DVEncoderImageParams( ) : 
			pal( true ), 
			encode_passes( 3 ), 
			static_qno( 0 ),
			wide( false ),
			two_pass_encoding( false )
		{
		}

		void SetPAL( bool _pal ) { pal = _pal; }
		void SetEncodePasses( int _encode_passes ) { encode_passes = _encode_passes; }
		void SetStaticQno( int _static_qno ) { static_qno = _static_qno; }
		void SetWide( bool _wide ) { wide = _wide; }
		void SetTwoPassEncoding( bool _two_pass_encoding ) { two_pass_encoding = _two_pass_encoding; }
		bool GetPAL( ) { return pal; }
		int GetEncodePasses( ) { return encode_passes; }
		int GetStaticQno( ) { return static_qno; }
		int GetWide( ) { return wide; }
		int GetWidth( ) { return 720; }
		int GetHeight( ) { return pal ? 576 : 480; }
		bool GetTwoPassEncoding( ) { return two_pass_encoding; }
};

#endif
