/*
 * ExtendedFramePool.h -- General collection of kino legacy class extensions
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_EXTENDED_FRAME_POOL_
#define _KINO_EXTENDED_FRAME_POOL_

#include "playlist.h"
#include "frame.h"

/** Got fed up with the frame pool being pointer oriented - this interface 
	provides a reference oriented interface.
*/

class ExtendedFramePool
{
	public:
		static ExtendedFramePool &Get( );
		virtual Frame &GetFrame( ) = 0;
		virtual void DoneWithFrame( Frame & ) = 0;
};

#endif
