
#ifndef NEED_GNOME_SUPPORT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-stubs.h"

extern "C" {

void gnome_config_push_prefix( const char *path )
{
	// Do nothing
}

void gnome_config_pop_prefix( void )
{
	// Do nothing
}

char *gnome_config_get_string( const char *path )
{
	char *ptr = strchr( path, '=' );
	if ( ptr != NULL )
		return strdup( ptr + 1 );
	else
		return NULL;
}

char *gnome_config_get_safe( const char *path )
{
	char *ptr = strchr( path, '=' );
	if ( ptr != NULL )
		return ptr + 1;
	else
		return "";
}

gint gnome_config_get_int( const char *path )
{
	return atoi( gnome_config_get_safe( path ) );
}

gboolean gnome_config_get_bool( const char *path )
{
	return !strcmp( gnome_config_get_safe( path ), "true" ) ? TRUE : FALSE;
}

gfloat gnome_config_get_float( const char *path )
{
	return atof( gnome_config_get_safe( path ) );
}

}

#endif

